/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.ui.internal.wizards;

import com.ibm.propertygroup.ui.internal.messages.PropertyUIMessages;
import com.ibm.propertygroup.ui.internal.utilities.IPropertyUIWidgetFactory;
import com.ibm.propertygroup.ui.internal.utilities.ProjectWizardInfo;
import com.ibm.propertygroup.ui.internal.wizards.NewProjectWizard;
import com.ibm.propertygroup.ui.internal.wizards.PropertyUIWizardNode;
import com.ibm.propertygroup.ui.internal.wizards.PropertyUIWizardSelectionPage;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class NewProjectWizard_ProjectTypePage
extends PropertyUIWizardSelectionPage {
    private HashMap nodes_;
    private String projectName_;
    ProjectWizardInfo[] projectInfo_;
    ProjectWizardInfo selectedProject_;

    public NewProjectWizard_ProjectTypePage(String name) {
        super(name);
        this.setTitle(PropertyUIMessages.PROPERTY_UI_WIZARDS_TITLE_NEW_SPROJECT);
        this.setDescription(PropertyUIMessages.PROPERTY_UI_WIZARDS_TITLE_NEW_SPROJECT_DESC);
        this.nodes_ = new HashMap();
    }

    @Override
    public Composite createContents(IPropertyUIWidgetFactory factory, Composite parent) {
        Composite composite = factory.createComposite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 8;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        ArrayList<ProjectWizardInfo> projects = ((NewProjectWizard)this.getWizard()).extInfo_.getProjectsInfo();
        this.projectInfo_ = new ProjectWizardInfo[projects.size()];
        projects.toArray(this.projectInfo_);
        if (projects.size() < 7) {
            int i = 0;
            while (i < this.projectInfo_.length) {
                final ProjectWizardInfo info = this.projectInfo_[i];
                Button button = factory.createButton(composite, 16);
                button.setText(info.getDisplayName());
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        NewProjectWizard_ProjectTypePage.this.selectedProject_ = info;
                        NewProjectWizard_ProjectTypePage.this.selectWizard(NewProjectWizard_ProjectTypePage.this.selectedProject_);
                    }
                });
                if (i == 0) {
                    button.setSelection(true);
                    this.selectedProject_ = info;
                    this.selectWizard(this.selectedProject_);
                }
                ++i;
            }
        } else {
            factory.createLabel(composite, PropertyUIMessages.PROPERTY_UI_WIZARDS_LABEL_PROJECTS, 64);
            final List list = factory.createList(composite, 4 | factory.getBorderStyle() | 0x100 | 0x200);
            GridData gd = new GridData(1808);
            list.setLayoutData((Object)gd);
            int i = 0;
            while (i < this.projectInfo_.length) {
                list.add(this.projectInfo_[i].getDisplayName());
                if (i == 0) {
                    list.select(i);
                    this.selectedProject_ = this.projectInfo_[i];
                    this.selectWizard(this.selectedProject_);
                }
                ++i;
            }
            list.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    NewProjectWizard_ProjectTypePage.this.selectedProject_ = NewProjectWizard_ProjectTypePage.this.projectInfo_[list.getSelectionIndex()];
                    NewProjectWizard_ProjectTypePage.this.selectWizard(NewProjectWizard_ProjectTypePage.this.selectedProject_);
                }
            });
        }
        NewProjectWizard wizard = (NewProjectWizard)this.getWizard();
        if (wizard.extInfo_ != null) {
            String infoPopHelpContextid = wizard.extInfo_.getHelpContextID();
            IWorkbenchHelpSystem whs = PlatformUI.getWorkbench().getHelpSystem();
            whs.setHelp((Control)composite, infoPopHelpContextid);
            whs.setHelp((Control)parent, infoPopHelpContextid);
        }
        return composite;
    }

    private void selectWizard(ProjectWizardInfo projectInfo) {
        String name = projectInfo.getWizardClass();
        IWizardNode node = (IWizardNode)this.nodes_.get(name);
        if (node == null) {
            node = new PropertyUIWizardNode(this.getShell(), projectInfo);
            this.nodes_.put(name, node);
        }
        this.setSelectedNode(node);
    }

    public void setProjectName(String projectName) {
        this.projectName_ = projectName;
    }

    public IWizardPage getNextPage() {
        IWizardNode selectedNode = this.getSelectedNode();
        if (selectedNode == null) {
            return null;
        }
        boolean isCreated = selectedNode.isContentCreated();
        IWizard wizard = selectedNode.getWizard();
        if (wizard == null) {
            this.setSelectedNode(null);
            return null;
        }
        if (!isCreated) {
            wizard.addPages();
        }
        return wizard.getStartingPage();
    }

    public void setVisible(boolean visible) {
        IWizardNode selectedNode;
        super.setVisible(visible);
        if (!visible && (selectedNode = this.getSelectedNode()) != null && this.projectName_ != null && this.projectName_.length() > 0) {
            IWizard wizard = selectedNode.getWizard();
            int temp = 1;
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IProject project = root.getProject(this.projectName_);
            StringBuffer newProjectName = new StringBuffer(this.projectName_);
            while (project.exists()) {
                newProjectName = new StringBuffer(this.projectName_);
                newProjectName.append(temp);
                ++temp;
                project = root.getProject(newProjectName.toString());
            }
            this.selectedProject_.getAccessor().setProject(wizard, this.getShell(), newProjectName.toString());
        }
    }
}

