/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.ui.internal.widgets;

import com.ibm.propertygroup.ICustomProperty;
import com.ibm.propertygroup.IProperty;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.PropertyHelper;
import com.ibm.propertygroup.spi.common.CustomPropertyHelper;
import com.ibm.propertygroup.spi.common.FileProperty;
import com.ibm.propertygroup.spi.common.JavaPackageProperty;
import com.ibm.propertygroup.ui.internal.messages.PropertyUIMessages;
import com.ibm.propertygroup.ui.internal.utilities.IPropertyUIWidgetFactory;
import com.ibm.propertygroup.ui.internal.utilities.NewProjectExtensionPointInfo;
import com.ibm.propertygroup.ui.internal.utilities.PropertyInputExtensionPointInfo;
import com.ibm.propertygroup.ui.internal.utilities.PropertyUIExtensionRegistry;
import com.ibm.propertygroup.ui.internal.utilities.PropertyUIHelper;
import com.ibm.propertygroup.ui.internal.utilities.PropertyUIWidgetInfo;
import com.ibm.propertygroup.ui.internal.widgets.PropertyUIWidgetText_Base;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PropertyUIWidgetText
extends PropertyUIWidgetText_Base {
    public static final int BUTTON_CUSTOMIZED = 0;
    public static final int BUTTON_BROWSE_FILE = 1;
    public static final int BUTTON_BROWSE_FOLDER = 2;
    public static final int BUTTON_BROWSE_PROJECT = 3;
    public static final int BUTTON_BROWSE_PACKAGE = 4;
    public static final int BUTTON_BROWSE_FILE_PLATFORM = 5;
    public static final int BUTTON2_CREATE_PROJECT = 1;
    public static final int BUTTON2_CREATE_PACKAGE = 2;
    public static final int BUTTON2_CREATE_PLATFORM_FILE = 3;
    protected Button button_;
    protected Button button2_;
    protected int buttonType_;
    protected int button2Type_;
    protected String buttonLabel_ = null;
    protected String button2Label_ = null;
    protected PropertyInputExtensionPointInfo piExtInfo_;
    protected NewProjectExtensionPointInfo extInfo_;

    public PropertyUIWidgetText(IProperty property, IPropertyUIWidgetFactory factory) {
        super(property, factory);
    }

    public PropertyUIWidgetText(IProperty property, IPropertyUIWidgetFactory factory, int columnNo) {
        super(property, factory, columnNo);
    }

    public PropertyUIWidgetText(IProperty property, IPropertyUIWidgetFactory factory, int columnNo, PropertyUIWidgetInfo info) {
        super(property, factory, columnNo, info);
    }

    @Override
    protected void createUIControls(Composite parent) {
        super.createUIControls(parent);
        this.createUIButtons(parent);
    }

    protected void createUIButtons(Composite parent) {
        String id;
        GridData gd;
        if (this.buttonLabel_ != null && this.buttonLabel_.length() > 1) {
            this.button_ = this.factory_.createButton(parent, this.buttonLabel_, 8);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            this.button_.setLayoutData((Object)gd);
            this.button_.addListener(13, (Listener)this);
            if (this.buttonType_ == 0 && (id = this.property_.getID()) != null) {
                this.piExtInfo_ = PropertyUIExtensionRegistry.instance().getPropertyInputExtension(id);
                if (this.piExtInfo_ == null) {
                    this.button_.setEnabled(false);
                } else {
                    this.addHoverManager((Control)this.button_, this.piExtInfo_.getButtonToolTip());
                }
            }
        }
        if (this.button2Label_ != null && this.button2Label_.length() > 1) {
            this.button2_ = this.factory_.createButton(parent, this.button2Label_, 8);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            this.button2_.setLayoutData((Object)gd);
            this.button2_.addListener(13, (Listener)this);
            if (this.button2Type_ == 1) {
                id = this.property_.getID();
                if (id == null || id.length() < 1) {
                    id = "DEFAULT_PROPERTY_IDENTIFIER";
                }
                this.extInfo_ = PropertyUIExtensionRegistry.instance().getNewProjectExtension(id);
                if (this.extInfo_ == null) {
                    this.button2_.setEnabled(false);
                }
            } else if (this.button2Type_ == 0 && (id = this.property_.getID()) != null) {
                this.piExtInfo_ = PropertyUIExtensionRegistry.instance().getPropertyInputExtension(id);
                if (this.piExtInfo_ == null || this.piExtInfo_.getNumberOfContributor() != 2) {
                    this.button2_.setEnabled(false);
                } else {
                    this.addHoverManager((Control)this.button2_, this.piExtInfo_.getButtonToolTip(1));
                }
            }
        }
    }

    @Override
    protected void addModificationListner() {
        super.addModificationListner();
        if (this.listenerType_ == 1) {
            if (this.button_ != null) {
                this.button_.addFocusListener((FocusListener)this);
            }
            if (this.button2_ != null) {
                this.button2_.addFocusListener((FocusListener)this);
            }
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.editingProperty_) {
            return;
        }
        if (this.button_ != null && !e.widget.equals(this.button_) && this.button_.isFocusControl()) {
            return;
        }
        if (this.button2_ != null && !e.widget.equals(this.button2_) && this.button2_.isFocusControl()) {
            return;
        }
        super.focusLost(e);
    }

    @Override
    public void handleEvent(Event event) {
        block17: {
            block19: {
                block18: {
                    block16: {
                        if (event.widget != this.text_) break block16;
                        super.handleEvent(event);
                        break block17;
                    }
                    this.editingProperty_ = true;
                    if (event.widget != this.button_) break block18;
                    switch (this.buttonType_) {
                        case 0: {
                            if (this.piExtInfo_ != null) {
                                this.performPressCustomizedButton(0);
                                break;
                            }
                            break block19;
                        }
                        case 1: {
                            this.performBrowseFile();
                            break;
                        }
                        case 5: {
                            this.performBrowsePlatformFile();
                            break;
                        }
                        case 2: {
                            this.performBrowseFolder();
                            break;
                        }
                        case 3: {
                            this.performBrowseProject();
                            break;
                        }
                        case 4: {
                            this.performBrowsePackage();
                            break;
                        }
                        default: {
                            this.performPressButton1();
                            break;
                        }
                    }
                    break block19;
                }
                if (event.widget == this.button2_) {
                    switch (this.button2Type_) {
                        case 0: {
                            if (this.piExtInfo_ == null) break;
                            this.performPressCustomizedButton(1);
                            break;
                        }
                        case 1: {
                            if (this.extInfo_ == null) break;
                            this.performCreateProject();
                            break;
                        }
                        case 2: {
                            this.performCreatePackage();
                            break;
                        }
                        case 3: {
                            this.performCreatePlatformFile();
                            break;
                        }
                        default: {
                            this.performPressButton2();
                        }
                    }
                }
            }
            this.editingProperty_ = false;
        }
    }

    protected void performPressCustomizedButton() {
        this.performPressCustomizedButton(0);
    }

    protected void performPressCustomizedButton(int index) {
        try {
            String value = PropertyUIHelper.instance().getPropertyInputValue((Control)this.text_, this.piExtInfo_, this.property_, index);
            if (value != null) {
                this.setStringToSWTControl(value);
            }
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg == null || msg.length() < 1) {
                msg = e.toString();
            }
            MessageDialog.openError((Shell)this.shell_, (String)PropertyUIMessages.ERROR_WIZARDS_NEW_WIZARD, (String)msg);
            this.button_.setEnabled(false);
        }
    }

    protected void performBrowseFile() {
        String value;
        String[] exts = null;
        boolean mustExist = true;
        if (PropertyHelper.isCustomProperty((IPropertyDescriptor)this.property_) && CustomPropertyHelper.isSingleFileProperty((ICustomProperty)((ICustomProperty)this.property_))) {
            exts = ((FileProperty)this.property_).getFileExtensions();
            mustExist = ((FileProperty)this.property_).isMustExist();
        }
        if ((value = PropertyUIHelper.instance().browseFile(this.shell_, exts, mustExist)) != null && value.length() > 0) {
            this.setStringToSWTControl(value);
        }
    }

    protected void performBrowsePlatformFile() {
        String value;
        String[] exts = null;
        if (PropertyHelper.isCustomProperty((IPropertyDescriptor)this.property_) && CustomPropertyHelper.isSingleFileProperty((ICustomProperty)((ICustomProperty)this.property_))) {
            exts = ((FileProperty)this.property_).getFileExtensions();
        }
        if ((value = PropertyUIHelper.instance().browsePlatformFileAsString(this.shell_, this.text_.getText().trim(), exts)) != null && value.length() > 0) {
            this.setStringToSWTControl(value);
        }
    }

    protected void performBrowseFolder() {
        PropertyUIHelper helper = PropertyUIHelper.instance();
        String value = helper.browseFolder(this.shell_, helper.getDefaultFolderLocation(), this.property_.getDescription());
        if (value != null && value.length() > 0) {
            helper.setDefaultFolderLocation(value);
            this.setStringToSWTControl(value);
        }
    }

    protected void performBrowseProject() {
        String value = PropertyUIHelper.instance().browseProject(this.shell_);
        if (value != null && value.length() > 0) {
            this.setStringToSWTControl(value);
        }
    }

    protected void performBrowsePackage() {
        String value;
        IJavaProject jproject;
        String sourceFolder = null;
        if (PropertyHelper.isCustomProperty((IPropertyDescriptor)this.property_) && CustomPropertyHelper.isJavaPackageNameProperty((ICustomProperty)((ICustomProperty)this.property_)) && (jproject = ((JavaPackageProperty)this.property_).getJavaProject()) != null && jproject.exists()) {
            sourceFolder = jproject.getPackageFragmentRoot((IResource)jproject.getProject()).getPath().toString();
        }
        if (sourceFolder != null && (value = PropertyUIHelper.instance().browsePackage(this.shell_, sourceFolder)) != null && value.length() > 0) {
            this.setStringToSWTControl(value);
        }
    }

    protected void performPressButton1() {
    }

    protected void performCreateProject() {
        String name = PropertyUIHelper.instance().createProject(this.shell_, this.text_.getText().trim(), this.extInfo_);
        if (name != null && name.length() > 0) {
            this.setStringToSWTControl(name);
        }
    }

    protected void performCreatePackage() {
        String name;
        JavaPackageProperty jpp = (JavaPackageProperty)this.property_;
        IJavaProject project = jpp.getJavaProject();
        if (project != null && (name = PropertyUIHelper.instance().createPackage(this.shell_, project, this.text_.getText().trim())) != null && name.length() > 0) {
            this.setStringToSWTControl(name);
        }
    }

    protected void performCreatePlatformFile() {
        String name;
        String[] exts = null;
        if (PropertyHelper.isCustomProperty((IPropertyDescriptor)this.property_) && CustomPropertyHelper.isSingleFileProperty((ICustomProperty)((ICustomProperty)this.property_))) {
            exts = ((FileProperty)this.property_).getFileExtensions();
        }
        if ((name = PropertyUIHelper.instance().createPlatformFileString(this.shell_, this.text_.getText().trim(), exts)) != null && name.length() > 0) {
            this.setStringToSWTControl(name);
        }
    }

    protected void performPressButton2() {
    }

    public Button getButton() {
        return this.button_;
    }

    public void setButtonType(int newValue) {
        this.buttonType_ = newValue;
    }

    public void setButton2Type(int newValue) {
        this.button2Type_ = newValue;
    }

    public void setButtonLabel(String newValue) {
        this.buttonLabel_ = newValue;
    }

    public void setButton2Label(String newValue) {
        this.button2Label_ = newValue;
    }

    @Override
    protected ArrayList<Control> getUIControlList() {
        ArrayList<Control> controls = super.getUIControlList();
        if (this.button_ != null) {
            controls.add((Control)this.button_);
        }
        if (this.button2_ != null) {
            controls.add((Control)this.button2_);
        }
        return controls;
    }

    @Override
    public void changeColumnNumber(int newNumber) {
        if (newNumber - 1 != this.columnNo_) {
            this.columnNo_ = newNumber - 1;
            int colNo = this.getTextHorizontalSpan();
            if (colNo > 1) {
                if (this.filler_ != null) {
                    GridData gd = (GridData)this.filler_.getLayoutData();
                    gd.horizontalSpan = this.columnNo_ - 1;
                } else {
                    this.addFillers(this.text_.getParent(), colNo - 1);
                    Text control = this.text_;
                    if (this.button2_ != null) {
                        control = this.button2_;
                    } else if (this.button_ != null) {
                        control = this.button_;
                    }
                    this.filler_.moveBelow((Control)control);
                }
            } else if (this.filler_ != null) {
                this.filler_.dispose();
                this.filler_ = null;
            }
        }
    }

    @Override
    protected int getTextHorizontalSpan() {
        int span = super.getTextHorizontalSpan();
        if (this.button_ != null) {
            --span;
        }
        if (this.button2_ != null) {
            --span;
        }
        return span;
    }
}

