/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.ui.internal.widgets;

import com.ibm.propertygroup.IMultiValuedProperty;
import com.ibm.propertygroup.IProperty;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.ISingleValuedProperty;
import com.ibm.propertygroup.PropertyHelper;
import com.ibm.propertygroup.ui.internal.messages.PropertyUIMessages;
import com.ibm.propertygroup.ui.internal.utilities.IPropertyUIWidgetFactory;
import com.ibm.propertygroup.ui.internal.utilities.PropertyUIWidgetInfo;
import com.ibm.propertygroup.ui.utilities.PropertyUIWidget;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public abstract class PropertyUIWidgetProperty
extends PropertyUIWidget {
    protected Button filler_;

    public PropertyUIWidgetProperty(IProperty pro, IPropertyUIWidgetFactory factory) {
        this(pro, factory, null);
    }

    public PropertyUIWidgetProperty(IPropertyDescriptor pro, IPropertyUIWidgetFactory factory) {
        super(pro, factory);
    }

    public PropertyUIWidgetProperty(IProperty pro, IPropertyUIWidgetFactory factory, PropertyUIWidgetInfo info) {
        super((IPropertyDescriptor)pro, factory, -1, info);
    }

    public PropertyUIWidgetProperty(IPropertyDescriptor pro, IPropertyUIWidgetFactory factory, PropertyUIWidgetInfo info) {
        super(pro, factory, -1, info);
    }

    public abstract void initDefaultValue();

    @Override
    public void setProperty(IPropertyDescriptor pro) {
        super.setProperty(pro);
        Control[] controls = this.getUIControls();
        if (controls != null && controls.length > 0) {
            this.initDefaultValue();
            this.update(1);
        }
    }

    @Override
    public Object getValue() {
        if (PropertyHelper.isSingleValuedProperty((IPropertyDescriptor)this.property_)) {
            return ((ISingleValuedProperty)this.property_).getValue();
        }
        if (PropertyHelper.isMultiValuedProperty((IPropertyDescriptor)this.property_)) {
            return ((IMultiValuedProperty)this.property_).getValues();
        }
        return null;
    }

    @Override
    public String getValueAsString() {
        ISingleValuedProperty prop;
        if (PropertyHelper.isSingleValuedProperty((IPropertyDescriptor)this.property_) && (prop = (ISingleValuedProperty)this.property_).getValue() != null) {
            return prop.getValueAsString();
        }
        return null;
    }

    @Override
    public Object[] getValues() {
        if (PropertyHelper.isSingleValuedProperty((IPropertyDescriptor)this.property_)) {
            return new Object[]{((ISingleValuedProperty)this.property_).getValue()};
        }
        if (PropertyHelper.isMultiValuedProperty((IPropertyDescriptor)this.property_)) {
            return ((IMultiValuedProperty)this.property_).getValues();
        }
        return null;
    }

    @Override
    public void setValue(Object newValue) {
        if (!this.isEnabled()) {
            return;
        }
        if (newValue instanceof String) {
            this.setValue((String)newValue);
        } else {
            try {
                if (PropertyHelper.isSingleValuedProperty((IPropertyDescriptor)this.property_)) {
                    ((ISingleValuedProperty)this.property_).setValue(newValue);
                } else if (PropertyHelper.isMultiValuedProperty((IPropertyDescriptor)this.property_)) {
                    ((IMultiValuedProperty)this.property_).addValue(newValue);
                }
                this.errorMessage_ = null;
                this.status_ = 0;
            }
            catch (CoreException e) {
                IStatus status = e.getStatus();
                this.errorMessage_ = status.getMessage();
                this.status_ = status.getSeverity();
            }
        }
    }

    @Override
    public void setValue(String newValue) {
        if (!this.isEnabled()) {
            return;
        }
        try {
            if (PropertyHelper.isSingleValuedProperty((IPropertyDescriptor)this.property_)) {
                ((ISingleValuedProperty)this.property_).setValueAsString(newValue);
            } else if (PropertyHelper.isMultiValuedProperty((IPropertyDescriptor)this.property_)) {
                ((IMultiValuedProperty)this.property_).addValueAsString(newValue);
            }
            this.errorMessage_ = null;
            this.status_ = 0;
        }
        catch (CoreException e) {
            IStatus status = e.getStatus();
            this.errorMessage_ = status.getMessage();
            this.status_ = status.getSeverity();
        }
    }

    @Override
    public void setValues(ArrayList<Object> newValues) {
        if (newValues == null || !this.isEnabled()) {
            return;
        }
        try {
            if (PropertyHelper.isSingleValuedProperty((IPropertyDescriptor)this.property_)) {
                ((ISingleValuedProperty)this.property_).setValue(newValues.get(0));
            } else if (PropertyHelper.isMultiValuedProperty((IPropertyDescriptor)this.property_)) {
                int i = 0;
                while (i < newValues.size()) {
                    ((IMultiValuedProperty)this.property_).addValue(newValues.get(i));
                    ++i;
                }
            }
            this.errorMessage_ = null;
            this.status_ = 0;
        }
        catch (CoreException e) {
            IStatus status = e.getStatus();
            this.errorMessage_ = status.getMessage();
            this.status_ = status.getSeverity();
        }
    }

    @Override
    protected String getWidgetLabel(IPropertyDescriptor ipd, boolean isForRequired) {
        return this.getWidgetLabel(super.getWidgetLabel(ipd, isForRequired), isForRequired);
    }

    protected String getWidgetLabel(String name, boolean isForRequired) {
        StringBuffer label = new StringBuffer(name);
        return this.getWidgetLabel(label, isForRequired).toString();
    }

    protected StringBuffer getWidgetLabel(StringBuffer label, boolean isForRequired) {
        char lastChar = label.charAt(label.length() - 1);
        if (lastChar != ':' && lastChar != '\uff1a') {
            label.append(PropertyUIMessages.PROPERTY_UI_WIZARDS_LABEL_COLON);
            if (this.isRequired() && isForRequired) {
                label.append("*");
            }
        } else if (this.isRequired() && isForRequired) {
            label.append("*");
        }
        return label;
    }

    @Override
    public int getStatus() {
        if (!this.isEnabled()) {
            return 0;
        }
        if (this.status_ == 4) {
            return this.status_;
        }
        if (this.isRequired() && this.isEmptyProperty()) {
            this.errorMessage_ = PropertyUIMessages.ERROR_WIZARDS_VALUE_CANNOT_BE_EMPTY;
            this.status_ = 4;
        }
        if (this.status_ != 4 && PropertyHelper.isProperty((IPropertyDescriptor)this.property_) && !((IProperty)this.property_).isValid() && ((IProperty)this.property_).getValidationMessage() != null) {
            return 4;
        }
        return this.status_;
    }

    @Override
    public boolean setFocus() {
        Control control = this.getDefaultFocusControl();
        if (control == null) {
            return false;
        }
        Object value = this.getValue();
        if (PropertyHelper.isSingleValuedProperty((IPropertyDescriptor)this.property_)) {
            if (value != null || this.isReadOnly() || !this.isEnabled()) {
                return false;
            }
            control.setFocus();
        } else if (PropertyHelper.isMultiValuedProperty((IPropertyDescriptor)this.property_)) {
            if (!(value == null || value instanceof Object[] && ((Object[])value).length <= 0)) {
                return false;
            }
            control.setFocus();
        } else {
            control.setFocus();
        }
        return true;
    }

    protected Object getDefaultValue() {
        if (this.propertyType_ != null) {
            return this.propertyType_.getDefaultValue();
        }
        return null;
    }

    protected Object[] getValidValues() {
        if (this.propertyType_ != null) {
            return this.propertyType_.getValidValues();
        }
        return null;
    }

    String[] getValidValuesAsStrings() {
        if (this.propertyType_ != null) {
            return this.propertyType_.getValidValuesAsStrings();
        }
        return null;
    }

    Class<? extends Object> getClassType() {
        if (this.propertyType_ != null) {
            return this.propertyType_.getClass();
        }
        return null;
    }

    boolean isHidden() {
        if (this.propertyType_ != null) {
            return this.propertyType_.isHidden();
        }
        return false;
    }

    boolean isReadOnly() {
        if (this.propertyType_ != null) {
            return this.propertyType_.isReadOnly();
        }
        return false;
    }

    boolean isExpert() {
        if (this.propertyType_ != null) {
            return this.propertyType_.isExpert();
        }
        return false;
    }

    boolean isPrimitive() {
        if (this.propertyType_ != null) {
            return this.propertyType_.isPrimitive();
        }
        return false;
    }

    boolean isSensitive() {
        if (this.propertyType_ != null) {
            return this.propertyType_.isSensitive();
        }
        return false;
    }

    boolean isRequired() {
        if (this.propertyType_ != null) {
            return this.propertyType_.isRequired();
        }
        return false;
    }

    boolean isValueSyn() {
        String newValue = this.getValueAsString();
        String widgetValue = this.getWidgetValue();
        if (newValue == null && widgetValue == null) {
            return true;
        }
        if (widgetValue.length() < 1 && newValue == null) {
            return true;
        }
        return newValue != null && newValue.equals(widgetValue) || widgetValue != null && widgetValue.equals(newValue);
    }

    boolean isValidValuesEditable() {
        if (this.propertyType_ != null) {
            return this.propertyType_.isValidValuesEditable();
        }
        return false;
    }

    void addFillers(Composite parent, int columnNo) {
        this.addFillers(parent, columnNo, 0);
    }

    void addFillers(Composite parent, int columnNo, int rowNo) {
        if (columnNo > 0) {
            this.filler_ = this.factory_.createButton(parent, "", 8);
            GridData gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.horizontalSpan = columnNo;
            if (rowNo > 1) {
                gd.verticalSpan = rowNo;
            }
            this.filler_.setLayoutData((Object)gd);
            this.filler_.setVisible(false);
        }
    }

    protected boolean isEmptyProperty() {
        if (PropertyHelper.isSingleValuedProperty((IPropertyDescriptor)this.property_)) {
            return ((ISingleValuedProperty)this.property_).getValue() == null;
        }
        if (PropertyHelper.isMultiValuedProperty((IPropertyDescriptor)this.property_)) {
            Object[] values = ((IMultiValuedProperty)this.property_).getValues();
            return values == null || values.length < 1;
        }
        return false;
    }

    protected Control createWidgetLabel(Composite parent) {
        return this.createWidgetLabel(parent, false);
    }

    protected Control createWidgetLabel(Composite parent, boolean isForRequired) {
        if (this.widgetInfo_ == null || this.widgetInfo_.labelAdapter_ == null || !this.widgetInfo_.labelAdapter_.generateHyperlinkLabel(this)) {
            return this.factory_.createLabel(parent, this.getWidgetLabel(isForRequired), 64);
        }
        return this.createHyperlinkLabel(parent, this.getWidgetLabel(isForRequired));
    }

    protected Hyperlink createHyperlinkLabel(Composite parent, String text) {
        Hyperlink link = this.factory_.createUnderlinedHyperlink(parent, text, 64);
        link.setForeground(parent.getDisplay().getSystemColor(10));
        final PropertyUIWidgetProperty widget = this;
        link.addHyperlinkListener(new IHyperlinkListener(){

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                ((PropertyUIWidgetProperty)PropertyUIWidgetProperty.this).widgetInfo_.labelAdapter_.performClick(widget);
            }
        });
        link.setToolTipText(this.widgetInfo_.labelAdapter_.getHoverHelp(widget));
        return link;
    }
}

