/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.ui.internal.utilities;

import org.eclipse.jface.text.AbstractHoverInformationControlManager;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PropertyUIWidgetHoverManager
extends AbstractHoverInformationControlManager {
    private Control uiControl_;
    private String message_;
    private static final int MAX_CHARACTERS_PER_ROW = 70;
    private static final int MAX_NUMBER_OF_ROW = 10;

    public PropertyUIWidgetHoverManager(Control control, String msg) {
        super(new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent);
            }
        });
        this.uiControl_ = control;
        this.message_ = this.wrapMessage(new StringBuffer(msg));
        this.install(control);
        this.setSizeConstraints(70, 10, false, false);
    }

    protected void computeInformation() {
        if (this.uiControl_ != null) {
            Point p = this.getHoverEventLocation();
            Rectangle subjectArea = this.uiControl_.getBounds();
            subjectArea.x = p.x;
            subjectArea.y = p.y;
            if (this.uiControl_ instanceof Text) {
                this.setMargins(5, -subjectArea.height / 2);
            }
            this.setInformation(this.message_, subjectArea);
        }
    }

    private String wrapMessage(StringBuffer message) {
        int count = 0;
        int i = 0;
        while (i < message.length()) {
            count = message.charAt(i) == ' ' || message.charAt(i) == '\n' ? 0 : ++count;
            if (count > 68) {
                message.insert(i, ' ');
                count = 0;
            }
            ++i;
        }
        return message.toString().trim();
    }
}

