/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.ui.internal.utilities;

import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.ISingleTypedProperty;
import com.ibm.propertygroup.ITableProperty;
import com.ibm.propertygroup.ITreeProperty;
import com.ibm.propertygroup.PropertyHelper;
import com.ibm.propertygroup.ui.api.IAbstractPropertyInputExtension;
import com.ibm.propertygroup.ui.api.IPropertyInputExtension;
import com.ibm.propertygroup.ui.api.IPropertyValueContributor;
import com.ibm.propertygroup.ui.dialogs.XSDTypeSearchDialog;
import com.ibm.propertygroup.ui.internal.messages.PropertyUIMessages;
import com.ibm.propertygroup.ui.internal.utilities.NewProjectExtensionPointInfo;
import com.ibm.propertygroup.ui.internal.utilities.PropertyInputExtensionPointInfo;
import com.ibm.propertygroup.ui.internal.utilities.PropertyUIExtensionRegistry;
import com.ibm.propertygroup.ui.internal.utilities.PropertyUIJavaDataTypeHierarchyScope;
import com.ibm.propertygroup.ui.internal.wizards.NewPlatformFileWizard;
import com.ibm.propertygroup.ui.internal.wizards.NewProjectWizard;
import com.ibm.propertygroup.ui.utilities.PropertyUIFactory;
import com.ibm.propertygroup.ui.utilities.PropertyUtil;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.ui.wizards.NewPackageCreationWizard;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaElementSorter;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jdt.ui.wizards.NewPackageWizardPage;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class PropertyUIHelper {
    private static PropertyUIHelper helper_;
    private String defaultFolderLocation_;

    public static PropertyUIHelper instance() {
        if (helper_ == null) {
            helper_ = new PropertyUIHelper();
        }
        return helper_;
    }

    public String[] getFileExtensions(String[] exts) {
        String[] extensions = null;
        if (exts != null && exts.length > 0) {
            extensions = new String[1];
            StringBuffer tmp = new StringBuffer("*." + exts[0]);
            int i = 1;
            while (i < exts.length) {
                tmp.append(";*.");
                tmp.append(exts[i]);
                ++i;
            }
            extensions[0] = tmp.toString();
        }
        return extensions;
    }

    public ElementTreeSelectionDialog getProjectSelectionDialog(Shell shell, IResource rootResource) {
        StandardJavaElementContentProvider provider = new StandardJavaElementContentProvider();
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(18);
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)labelProvider, (ITreeContentProvider)provider);
        dialog.setSorter((ViewerSorter)new JavaElementSorter());
        dialog.setTitle(PropertyUIMessages.PROPERTY_UI_WIZARDS_TITLE_PROJECT_FSELECTION);
        dialog.setMessage(PropertyUIMessages.PROPERTY_UI_WIZARDS_LABEL_SPROJECT);
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parent, Object element) {
                return element instanceof IJavaProject;
            }
        });
        if (rootResource == null) {
            dialog.setInput((Object)JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()));
        } else {
            dialog.setInput((Object)JavaCore.create((IResource)rootResource));
        }
        return dialog;
    }

    public SelectionDialog getPackageSelectionDialog(Shell shell, IPackageFragmentRoot pkgRoot) {
        Object[] packages = null;
        try {
            if (pkgRoot != null) {
                packages = pkgRoot.getChildren();
            }
        }
        catch (JavaModelException javaModelException) {}
        if (packages == null) {
            packages = new IJavaElement[]{};
        }
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new JavaElementLabelProvider(18));
        dialog.setIgnoreCase(false);
        dialog.setTitle(PropertyUIMessages.PROPERTY_UI_WIZARDS_TITLE_PSELECTION);
        dialog.setMessage(PropertyUIMessages.PROPERTY_UI_WIZARDS_LABEL_STPACKAGE);
        dialog.setEmptyListMessage("");
        dialog.setElements(packages);
        return dialog;
    }

    public IPackageFragmentRoot getPackageRootFromString(String sourceFolder) {
        Object resource = null;
        Path sourceFolderPath = new Path(sourceFolder);
        resource = sourceFolderPath.segmentCount() == 1 ? ResourcesPlugin.getWorkspace().getRoot().getProject(sourceFolder) : ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)sourceFolderPath);
        Object[] containerInfo = this.getContainerInfo(resource);
        return (IPackageFragmentRoot)containerInfo[0];
    }

    public Object[] getContainerInfo(Object sel) {
        Object[] result = new Object[3];
        IJavaElement elem = null;
        if (sel instanceof IStructuredSelection) {
            elem = this.getInitialJavaElement((IStructuredSelection)sel);
        } else if (sel instanceof IResource) {
            elem = this.getInitialJavaElement((IResource)sel);
        }
        IPackageFragmentRoot initRoot = null;
        IPackageFragment initPackage = null;
        if (elem != null) {
            initRoot = (IPackageFragmentRoot)elem.getAncestor(3);
            if (initRoot == null || initRoot.isArchive()) {
                IJavaProject jproject = elem.getJavaProject();
                try {
                    initRoot = null;
                    IPackageFragmentRoot[] roots = jproject.getPackageFragmentRoots();
                    int i = 0;
                    while (i < roots.length) {
                        if (roots[i].getKind() == 1) {
                            initRoot = roots[i];
                            break;
                        }
                        ++i;
                    }
                }
                catch (JavaModelException javaModelException) {}
                if (initRoot == null) {
                    initRoot = jproject.getPackageFragmentRoot("");
                }
            }
            initPackage = (IPackageFragment)elem.getAncestor(4);
        }
        result[0] = initRoot;
        result[1] = initRoot != null ? initRoot.getPath().makeAbsolute().toString() : null;
        result[2] = initPackage != null ? initPackage.getElementName() : null;
        return result;
    }

    protected IJavaElement getInitialJavaElement(IStructuredSelection selection) {
        IJavaElement jelem = null;
        return jelem;
    }

    protected IJavaElement getInitialJavaElement(IResource resource) {
        IProject[] projects;
        IResource res;
        IEditorInput input;
        IJavaElement jelem = this.getJavaElementFromResource(resource);
        if (jelem == null && (input = this.getEditorInputBasedOnActiveWorkbenchPart()) != null && (res = (IResource)input.getAdapter(IResource.class)) != null) {
            jelem = this.getJavaElementFromResource(res);
        }
        if (jelem == null && (projects = ResourcesPlugin.getWorkspace().getRoot().getProjects()).length == 1) {
            jelem = JavaCore.create((IProject)projects[0]);
        }
        return jelem;
    }

    protected IJavaElement getJavaElementFromResource(IResource resource) {
        IJavaElement jelem = null;
        if (resource != null && resource.getType() != 8) {
            while (jelem == null && resource.getType() != 4) {
                if ((resource = resource.getParent()) == null) continue;
                jelem = (IJavaElement)resource.getAdapter(IJavaElement.class);
            }
            if (jelem == null) {
                jelem = JavaCore.create((IResource)resource);
            }
        }
        return jelem;
    }

    protected IEditorInput getEditorInputBasedOnActiveWorkbenchPart() {
        IEditorInput input = null;
        return input;
    }

    public int getNumberOfProperties(IPropertyGroup properties, boolean showExpert, int no) {
        IPropertyDescriptor[] props = properties.getProperties();
        return no += this.getNumberOfProperties(props, showExpert);
    }

    public int getNumberOfProperties(IPropertyDescriptor ipd, boolean showExpert) {
        if (PropertyHelper.isPropertyGroup((IPropertyDescriptor)ipd)) {
            return this.getNumberOfProperties((IPropertyGroup)ipd, showExpert, 0);
        }
        if (PropertyUIFactory.instance(false).isUISupportedProperty(ipd) && !PropertyUtil.isHidden(ipd)) {
            if (showExpert) {
                return 1;
            }
            if (!PropertyUtil.isExpert(ipd)) {
                return 1;
            }
        }
        return 0;
    }

    public int getNumberOfProperties(IPropertyDescriptor[] ipds, boolean showExpert) {
        int no = 0;
        int i = 0;
        while (i < ipds.length) {
            no += this.getNumberOfProperties(ipds[i], showExpert);
            ++i;
        }
        return no;
    }

    public boolean[] checkExpertInPropertyGroup(IPropertyGroup propertyGroup, boolean isSubGroup) {
        boolean[] status = new boolean[2];
        IPropertyDescriptor[] properties = propertyGroup.getProperties();
        int i = 0;
        while (i < properties.length) {
            int size;
            IPropertyGroup bpg;
            IPropertyDescriptor ipd = properties[i];
            if (PropertyHelper.isSingleTypedProperty((IPropertyDescriptor)ipd)) {
                if (((ISingleTypedProperty)ipd).getPropertyType().isExpert()) {
                    status[0] = true;
                }
            } else if (PropertyHelper.isTreeProperty((IPropertyDescriptor)ipd)) {
                if (((ITreeProperty)ipd).isExpert()) {
                    status[0] = true;
                }
            } else if (PropertyHelper.isTableProperty((IPropertyDescriptor)ipd)) {
                if (((ITableProperty)ipd).isExpert()) {
                    status[0] = true;
                }
            } else if (PropertyHelper.isPropertyGroup((IPropertyDescriptor)ipd) && !"com.ibm.propertygroup.ui.PropertyUINestedLayoutID".equals((bpg = (IPropertyGroup)ipd).getID()) && bpg.getProperties() != null && bpg.getProperties().length >= 1 && (size = this.getNumberOfProperties(bpg, true, 0)) != 0) {
                boolean[] subStatus;
                int no = this.getNumberOfProperties(bpg, false, 0);
                if (no < 1) {
                    status[0] = true;
                } else if (no != size && (subStatus = this.checkExpertInPropertyGroup(bpg, true))[0]) {
                    status[1] = true;
                    status[0] = true;
                    return status;
                }
            }
            ++i;
        }
        return status;
    }

    public String browseFile(Shell shell, String[] exts, boolean mustExist) {
        int style = 32772;
        style = mustExist ? (style |= 0x1000) : (style |= 0x2000);
        FileDialog fDialog = new FileDialog(shell, style);
        if (exts != null && exts.length > 0) {
            fDialog.setFilterExtensions(this.getFileExtensions(exts));
        }
        String res = fDialog.open();
        return res;
    }

    public IFile browsePlatformFile(Shell shell, String defaultPath, final String[] exts) {
        Object result;
        IFile file;
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
        dialog.setTitle(PropertyUIMessages.PROPERTY_UI_WIZARDS_TITLE_FILE_SELECTION);
        dialog.setMessage(PropertyUIMessages.PROPERTY_UI_WIZARDS_DESC_SELECT_FILE);
        if (defaultPath != null && defaultPath.length() > 0 && (file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(defaultPath))) != null) {
            dialog.setInitialSelection((Object)file);
        }
        dialog.setAllowMultiple(false);
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parent, Object element) {
                if (element instanceof IFile) {
                    IFile file = (IFile)element;
                    int i = 0;
                    while (i < exts.length) {
                        if (file.getFileExtension().equalsIgnoreCase(exts[i])) {
                            return true;
                        }
                        ++i;
                    }
                    return false;
                }
                return true;
            }
        });
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        if (dialog.open() == 0 && (result = dialog.getFirstResult()) instanceof IFile) {
            return (IFile)result;
        }
        return null;
    }

    public String browsePlatformFileAsString(Shell shell, String defaultPath, String[] exts) {
        IFile file = this.browsePlatformFile(shell, defaultPath, exts);
        if (file != null) {
            return file.getFullPath().toString();
        }
        return null;
    }

    public String browseFolder(Shell shell, String lastSelection, String desc) {
        String selectedDirectory;
        String value = null;
        DirectoryDialog dialog = new DirectoryDialog(shell);
        dialog.setMessage(desc);
        if (lastSelection != null && lastSelection.length() > 0) {
            dialog.setFilterPath(lastSelection);
        }
        if ((selectedDirectory = dialog.open()) != null && selectedDirectory.length() > 0) {
            value = selectedDirectory;
        }
        return value;
    }

    public String browseProject(Shell shell) {
        String value = null;
        ElementTreeSelectionDialog dialog = this.getProjectSelectionDialog(shell, null);
        if (dialog != null && dialog.open() == 0) {
            Object element = dialog.getFirstResult();
            if (element instanceof IJavaProject) {
                IJavaProject jproject = (IJavaProject)element;
                IPackageFragmentRoot root = jproject.getPackageFragmentRoot((IResource)jproject.getProject());
                value = root.getPath().toString();
            } else if (element instanceof IPackageFragmentRoot) {
                value = ((IPackageFragmentRoot)element).getPath().toString();
            }
        }
        return value;
    }

    public String browsePackage(Shell shell, String sourceFolder) {
        Object[] result;
        String value = null;
        IPackageFragmentRoot root = this.getPackageRootFromString(sourceFolder);
        SelectionDialog dialog = this.getPackageSelectionDialog(shell, root);
        if (dialog.open() == 0 && (result = dialog.getResult()) != null && result.length != 0) {
            IPackageFragment pkg = (IPackageFragment)result[0];
            value = pkg.getElementName();
        }
        return value;
    }

    public QName[] browseSchemaType(Shell shell, boolean multiSelect) {
        XSDTypeSearchDialog dialog = new XSDTypeSearchDialog(shell, multiSelect);
        if (dialog.open() == 0) {
            return dialog.getXSDTypeQNames();
        }
        return null;
    }

    public String[] browseSchemaTypeAsString(Shell shell, boolean multiSelect) {
        XSDTypeSearchDialog dialog = new XSDTypeSearchDialog(shell, multiSelect);
        if (dialog.open() == 0) {
            return dialog.getXSDTypeQNamesAsStrings();
        }
        return null;
    }

    public IType[] browseJavaType(String[] types, Shell parentShell, String title, String message, boolean multipleSelection) {
        return this.browseJavaType(types, (IResource[])ResourcesPlugin.getWorkspace().getRoot().getProjects(), parentShell, title, message, multipleSelection);
    }

    public String[] browseJavaTypeAsString(String[] types, Shell parentShell, String title, String message, boolean multipleSelection) {
        String[] results = null;
        IType[] javaTypes = this.browseJavaType(types, (IResource[])ResourcesPlugin.getWorkspace().getRoot().getProjects(), parentShell, title, message, multipleSelection);
        if (javaTypes != null && javaTypes.length > 0) {
            results = new String[javaTypes.length];
            int i = 0;
            while (i < javaTypes.length) {
                results[i] = javaTypes[i].getFullyQualifiedName();
                ++i;
            }
        }
        return results;
    }

    public IType[] browseJavaType(String[] types, IResource[] resources, Shell parentShell, String title, String message, boolean multipleSelection) {
        ArrayList<IType> searchTypes = new ArrayList<IType>();
        ArrayList<IResource> resourceList = new ArrayList<IResource>(resources.length);
        IType type = null;
        int i = 0;
        while (i < resources.length) {
            IJavaElement javaElement = JavaCore.create((IResource)resources[i]);
            if (javaElement != null) {
                int j = 0;
                while (j < types.length) {
                    if (javaElement instanceof IJavaProject) {
                        try {
                            type = ((IJavaProject)javaElement).findType(types[j]);
                        }
                        catch (JavaModelException javaModelException) {
                            type = null;
                        }
                    }
                    if (type != null) {
                        resourceList.add(resources[i]);
                        if (searchTypes.indexOf(type) == -1) {
                            searchTypes.add(type);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        IType[] itypes = new IType[searchTypes.size()];
        searchTypes.toArray(itypes);
        IResource[] newResources = new IResource[resourceList.size()];
        resourceList.toArray(newResources);
        return this.browseJavaTypeDialog(itypes, newResources, parentShell, title, message, multipleSelection);
    }

    public IType[] browseJavaTypeDialog(IType[] searchTypes, IResource[] resources, Shell parentShell, String title, String message, boolean multipleSelection) {
        ArrayList<IType> types = new ArrayList<IType>();
        try {
            PropertyUIJavaDataTypeHierarchyScope scope = new PropertyUIJavaDataTypeHierarchyScope(searchTypes, null, resources);
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)parentShell, (IRunnableContext)new ProgressMonitorDialog(parentShell), (IJavaSearchScope)scope, (int)2, (boolean)multipleSelection);
            if (title != null) {
                dialog.setTitle(title);
            }
            if (message != null) {
                dialog.setMessage(message);
            }
            dialog.open();
            Object[] results = dialog.getResult();
            if (results != null && results.length > 0) {
                int i = 0;
                while (i < results.length) {
                    if (results[i] instanceof IType) {
                        types.add((IType)results[i]);
                    }
                    ++i;
                }
            }
        }
        catch (JavaModelException javaModelException) {}
        IType[] returnTypes = new IType[types.size()];
        types.toArray(returnTypes);
        return returnTypes;
    }

    public String createProject(Shell shell, String defaultName, String id) {
        NewProjectExtensionPointInfo info = PropertyUIExtensionRegistry.instance().getNewProjectExtension(id);
        if (info != null) {
            return this.createProject(shell, defaultName, info);
        }
        return null;
    }

    public String createProject(Shell shell, String defaultName, NewProjectExtensionPointInfo info) {
        NewProjectWizard newProjectWizard = new NewProjectWizard(info);
        newProjectWizard.setProjectName(defaultName);
        StructuredSelection selection = new StructuredSelection();
        newProjectWizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)selection);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)newProjectWizard);
        dialog.create();
        if (dialog.open() == 0 && newProjectWizard.getProjectName() != null) {
            return newProjectWizard.getProjectName();
        }
        return null;
    }

    public String createPackage(Shell shell, IJavaProject project, String defaultName) {
        NewPackageCreationWizard packageCreationWizard = new NewPackageCreationWizard();
        packageCreationWizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)project));
        WizardDialog dialog = new WizardDialog(shell, (IWizard)packageCreationWizard);
        dialog.create();
        IWizardPage[] pages = packageCreationWizard.getPages();
        if (pages.length > 0 && pages[0] instanceof NewPackageWizardPage) {
            NewPackageWizardPage page = (NewPackageWizardPage)pages[0];
            page.setPackageText(defaultName, true);
            page.setPackageFragmentRoot(page.getPackageFragmentRoot(), false);
            if (dialog.open() == 0) {
                return page.getPackageText();
            }
        }
        return null;
    }

    public IFile createPlatformFile(Shell shell, String defaultPath, String[] exts) {
        NewPlatformFileWizard wizard = new NewPlatformFileWizard(defaultPath, exts);
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        dialog.create();
        if (dialog.open() == 0) {
            return wizard.getFile();
        }
        return null;
    }

    public String createPlatformFileString(Shell shell, String defaultPath, String[] exts) {
        IFile file = this.createPlatformFile(shell, defaultPath, exts);
        if (file != null) {
            return file.getFullPath().toString();
        }
        return null;
    }

    public String getPropertyInputValue(Control control, PropertyInputExtensionPointInfo piExtInfo, IPropertyDescriptor ipd) throws CoreException {
        return this.getPropertyInputValue(control, piExtInfo, ipd, 0);
    }

    public String getPropertyInputValue(final Control control, PropertyInputExtensionPointInfo piExtInfo, final IPropertyDescriptor ipd, int index) throws CoreException {
        final String[] value = new String[1];
        if (piExtInfo == null) {
            return value[0];
        }
        Object ee = piExtInfo.getExecutableExtension(index);
        if (ee instanceof IAbstractPropertyInputExtension) {
            final IAbstractPropertyInputExtension apie = (IAbstractPropertyInputExtension)ee;
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                @Override
                public void run() {
                    apie.initialize(control, ipd);
                    apie.run();
                }
            });
            value[0] = apie.getValueAsString();
        } else if (ee instanceof IPropertyValueContributor) {
            final IPropertyValueContributor ipvc = (IPropertyValueContributor)ee;
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                @Override
                public void run() {
                    ipvc.initialize(control, ipd);
                    String[] values = ipvc.performAddValue();
                    if (values != null && values.length > 0) {
                        value[0] = values[0];
                    }
                }
            });
        } else if (ee instanceof IPropertyInputExtension) {
            IPropertyInputExtension pie = (IPropertyInputExtension)ee;
            pie.initialize(ipd);
            WizardDialog dialog = new WizardDialog(control instanceof Shell ? (Shell)control : control.getShell(), (IWizard)pie);
            dialog.create();
            if (dialog.open() == 0) {
                value[0] = pie.getValueAsString();
            }
        }
        return value[0];
    }

    public boolean validateRequiredProperty(IPropertyDescriptor ipd) {
        Object value = PropertyUtil.getValue(ipd);
        if (value instanceof Object[] && ((Object[])value).length < 1) {
            value = null;
        }
        return value != null || !PropertyUtil.isEnabled(ipd) || PropertyUtil.getDefaultValue(ipd) != null;
    }

    public String getDefaultFolderLocation() {
        return this.defaultFolderLocation_;
    }

    public void setDefaultFolderLocation(String newLocation) {
        this.defaultFolderLocation_ = newLocation;
    }

    public String[] getDisplayString(String msg) {
        String[] rv = new String[1];
        StringBuffer str = new StringBuffer(msg.trim());
        int i = 0;
        while (i < str.length()) {
            if (str.charAt(i) == '&') {
                str.deleteCharAt(i);
                break;
            }
            ++i;
        }
        if (str.length() > 0 && str.charAt(str.length() - 1) == ':') {
            str.deleteCharAt(str.length() - 1);
        }
        StringBuffer str1 = new StringBuffer("'");
        str1.append(str);
        str1.append("'");
        rv[0] = str1.toString();
        return rv;
    }

    public IPropertyDescriptor[] getPropertyDescriptorNeighbours(IPropertyGroup pg, IPropertyDescriptor ipd) {
        IPropertyDescriptor[] neighbours = new IPropertyDescriptor[3];
        IPropertyDescriptor[] properties = pg.getProperties();
        int i = 0;
        while (i < properties.length) {
            if (ipd.equals(properties[i])) {
                if (i > 0) {
                    neighbours[0] = properties[i - 1];
                }
                if (i < properties.length - 1) {
                    neighbours[1] = properties[i + 1];
                }
                neighbours[2] = pg;
                return neighbours;
            }
            if (PropertyHelper.isPropertyGroup((IPropertyDescriptor)properties[i]) && (neighbours = this.getPropertyDescriptorNeighbours((IPropertyGroup)properties[i], ipd))[2] != null) {
                if (neighbours[0] == null && i > 0) {
                    neighbours[0] = properties[i - 1];
                }
                if (neighbours[1] == null && i < properties.length - 1) {
                    neighbours[1] = properties[i + 1];
                }
                return neighbours;
            }
            ++i;
        }
        return neighbours;
    }

    public int getPropertyNestedLevel(IPropertyDescriptor ipds, IPropertyDescriptor ipdt, int defaultLevel) {
        int level = defaultLevel;
        if (ipds.equals(ipdt)) {
            return level;
        }
        if (PropertyHelper.isPropertyGroup((IPropertyDescriptor)ipds)) {
            IPropertyDescriptor[] properties = ((IPropertyGroup)ipds).getProperties();
            int i = 0;
            while (i < properties.length) {
                level = this.getPropertyNestedLevel(properties[i], ipdt, defaultLevel + 1);
                if (level > -1) {
                    return level;
                }
                ++i;
            }
        }
        return -1;
    }

    public boolean containsExpandableProperties(IPropertyGroup pg, boolean checkSubGroup) {
        IPropertyDescriptor[] ipds = pg.getProperties();
        int i = 0;
        while (i < ipds.length) {
            if (checkSubGroup && PropertyHelper.isPropertyGroup((IPropertyDescriptor)ipds[i])) {
                boolean yes = this.containsExpandableProperties((IPropertyGroup)ipds[i], checkSubGroup);
                if (yes) {
                    return true;
                }
            } else {
                if (PropertyHelper.isTreeProperty((IPropertyDescriptor)ipds[i]) && !((ITreeProperty)ipds[i]).isExpert()) {
                    return true;
                }
                if (PropertyHelper.isTableProperty((IPropertyDescriptor)ipds[i]) && !((ITableProperty)ipds[i]).isExpert()) {
                    return true;
                }
                if (PropertyHelper.isMultiValuedProperty((IPropertyDescriptor)ipds[i]) && !PropertyUtil.isExpert(ipds[i])) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public boolean containsExpandableExpertProperties(IPropertyGroup pg, boolean checkSubGroup) {
        IPropertyDescriptor[] ipds = pg.getProperties();
        int i = 0;
        while (i < ipds.length) {
            if (checkSubGroup && PropertyHelper.isPropertyGroup((IPropertyDescriptor)ipds[i])) {
                boolean yes;
                IPropertyGroup bpg = (IPropertyGroup)ipds[i];
                if (!"com.ibm.propertygroup.ui.PropertyUINestedLayoutID".equals(bpg.getID()) && bpg.getProperties() != null && bpg.getProperties().length >= 1 && this.getNumberOfProperties(bpg, false, 0) <= 0 && (yes = this.containsExpandableExpertProperties(bpg, checkSubGroup))) {
                    return true;
                }
            } else {
                if (PropertyHelper.isTreeProperty((IPropertyDescriptor)ipds[i]) && ((ITreeProperty)ipds[i]).isExpert()) {
                    return true;
                }
                if (PropertyHelper.isTableProperty((IPropertyDescriptor)ipds[i]) && ((ITableProperty)ipds[i]).isExpert()) {
                    return true;
                }
                if (PropertyHelper.isMultiValuedProperty((IPropertyDescriptor)ipds[i]) && PropertyUtil.isExpert(ipds[i])) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public void cleanScrollableAreaFromWizardPage(IWizardPage page) {
        Control content;
        Control pageControl = page.getControl();
        if (pageControl instanceof ScrolledComposite && (content = ((ScrolledComposite)pageControl).getContent()) != null) {
            if (content instanceof Composite && !content.isDisposed()) {
                this.cleanScrolledCompositeContent((Composite)content);
            }
            ((ScrolledComposite)pageControl).setContent(null);
        }
    }

    public void cleanScrolledCompositeContent(Composite container) {
        Control[] children = container.getChildren();
        if (children != null) {
            Control[] controlArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                if (child != null && !child.isDisposed()) {
                    if (child instanceof ScrolledComposite) {
                        Control content = ((ScrolledComposite)child).getContent();
                        if (content != null) {
                            if (content instanceof Composite && !content.isDisposed()) {
                                this.cleanScrolledCompositeContent((Composite)content);
                            }
                            ((ScrolledComposite)child).setContent(null);
                        }
                    } else if (child instanceof Composite && !child.isDisposed()) {
                        this.cleanScrolledCompositeContent((Composite)child);
                    }
                }
                ++n2;
            }
        }
    }
}

