/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.ui.internal.jobs;

import java.io.IOException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.util.XSDResourceImpl;

public class FetchTypesFromXSDJob
extends Job {
    private String fullPath;
    private List listOfXSDTypes;

    public FetchTypesFromXSDJob(String jobName, String fullPath) {
        super(jobName);
        this.fullPath = fullPath;
    }

    public IStatus run(IProgressMonitor monitor) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI uri = URI.createFileURI((String)this.fullPath);
        resourceSet.createResource(uri);
        Resource resource = resourceSet.getResource(uri, false);
        XSDResourceImpl xsdResource = (XSDResourceImpl)resource;
        try {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            xsdResource.load(resourceSet.getLoadOptions());
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            XSDSchema schema = xsdResource.getSchema();
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            this.listOfXSDTypes = schema.getTypeDefinitions();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Status.OK_STATUS;
    }

    public Object[] getXSDTypes() {
        if (this.listOfXSDTypes != null) {
            return this.listOfXSDTypes.toArray();
        }
        return null;
    }
}

