/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.pli.importer;

import com.ibm.ccl.pli.importer.ErrorMessageInfo;
import com.ibm.ccl.pli.importer.ParseSyntaxErrors;
import com.ibm.ccl.pli.importer.PliException;
import com.ibm.ccl.pli.plugin.PliPlugin;
import com.ibm.ccl.pli.plugin.PliResources;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ParseSyntaxErrorsFromAdata
extends ParseSyntaxErrors {
    public static final String copyright = "Licensed Materials - Property of IBM\ncom.ibm.ccl.pli\nCopyright IBM Corporation 2004, 2007. All Rights Reserved.\nNote to U.S. Government Users Restricted Rights:  Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. ";
    private static final String EX_DESC_REACH_TO_END_OF_FILE = PliResources.EX_DESC_REACH_TO_END_OF_FILE;
    private static final String EX_DESC_RECORD_TYPE_IS_NOT_MESSAGE = PliResources.EX_DESC_RECORD_TYPE_IS_NOT_MESSAGE;
    private static final String EX_DESC_RECORD_TYPE_IS_NOT_FILE = PliResources.EX_DESC_RECORD_TYPE_IS_NOT_FILE;
    private static final String EX_DESC_RECORD_TYPE_IS_NOT_LITERAL = PliResources.EX_DESC_RECORD_TYPE_IS_NOT_LITERAL;
    File fileAdata;
    private List resourceVector = new Vector();
    private boolean postErrorsToProblemsView;

    private static String getCanonicalPath(String fileName) throws IOException {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(fileName));
        if (file != null && file.exists()) {
            return fileName;
        }
        return new File(fileName).getCanonicalPath();
    }

    public ParseSyntaxErrorsFromAdata(File f, boolean postErrorsToProblemsView) {
        this.fileAdata = f;
        this.postErrorsToProblemsView = postErrorsToProblemsView;
    }

    @Override
    protected void doParse() throws Exception {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(this.fileAdata));
        this.readAdata(is);
        ((InputStream)is).close();
    }

    private void readAdata(InputStream is) throws IOException {
        AdataRecord record;
        Vector<PliMessageRecord> messages = new Vector<PliMessageRecord>();
        Hashtable<Long, PliFileRecord> files = new Hashtable<Long, PliFileRecord>();
        Hashtable<Long, PliLiteralRecord> literals = new Hashtable<Long, PliLiteralRecord>();
        while ((record = this.readRecord(is)) != null) {
            if (record.isPliMessageRecord()) {
                PliMessageRecord msg = new PliMessageRecord(record);
                messages.add(msg);
                continue;
            }
            if (record.isPliFileRecord()) {
                PliFileRecord fi = new PliFileRecord(record);
                files.put(new Long(fi.id), fi);
                continue;
            }
            if (!record.isPliLiteralRecord()) continue;
            PliLiteralRecord li = new PliLiteralRecord(record);
            literals.put(new Long(li.id), li);
        }
        HashMap<String, IFile> allResources = new HashMap<String, IFile>(files.values().size());
        for (PliFileRecord rec : files.values()) {
            PliLiteralRecord li = (PliLiteralRecord)literals.get(new Long(rec.getFileNameID()));
            if (li == null) continue;
            String fileLocation = ParseSyntaxErrorsFromAdata.getCanonicalPath(li.getValue());
            this.resourceVector.add(fileLocation);
            IFile f = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(fileLocation));
            if (f == null) continue;
            allResources.put(fileLocation, f);
        }
        if (this.postErrorsToProblemsView) {
            PliPlugin.getDefault().writeMsg(Level.FINE, "*** ParseSyntaxErrorsFromAdata.readRecord(...): Posting error messages to problems view");
            for (IFile f : allResources.values()) {
                try {
                    f.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 0);
                }
                catch (CoreException e) {
                    PliPlugin.getDefault().writeMsg(Level.SEVERE, "*** ParseSyntaxErrorsFromAdata.readRecord(...): Deleting marker causes CoreException", e);
                }
            }
        }
        for (PliMessageRecord msg : messages) {
            PliLiteralRecord li;
            char sevChar = msg.getSeverityCharacter();
            String messageText = String.valueOf(msg.getMessageId().trim()) + " " + msg.getMessageText();
            int lineNumber = (int)msg.getLineNumber();
            String fileLocation = "";
            PliFileRecord fi = (PliFileRecord)files.get(new Long(msg.getFileId()));
            if (fi != null && (li = (PliLiteralRecord)literals.get(new Long(fi.getFileNameID()))) != null) {
                fileLocation = ParseSyntaxErrorsFromAdata.getCanonicalPath(li.getValue());
            }
            if (fileLocation.length() <= 0) continue;
            this.addError(new ErrorMessageInfo(sevChar, messageText, lineNumber, fileLocation));
            if (!this.postErrorsToProblemsView) continue;
            PliPlugin.getDefault().writeMsg(Level.FINE, "----------------------------------------");
            PliPlugin.getDefault().writeMsg(Level.FINE, "    FILE:" + fileLocation);
            PliPlugin.getDefault().writeMsg(Level.FINE, "    LINE:" + lineNumber);
            PliPlugin.getDefault().writeMsg(Level.FINE, "    SEV :" + sevChar);
            PliPlugin.getDefault().writeMsg(Level.FINE, "    MSG :" + messageText);
            PliPlugin.getDefault().writeMsg(Level.FINE, "----------------------------------------");
            IFile f = (IFile)allResources.get(fileLocation);
            if (f == null) continue;
            try {
                IMarker marker = ((IFile)allResources.get(fileLocation)).createMarker("org.eclipse.core.resources.problemmarker");
                marker.setAttribute("message", (Object)messageText);
                marker.setAttribute("lineNumber", lineNumber);
                if (sevChar == 'I') {
                    marker.setAttribute("severity", 0);
                    continue;
                }
                if (sevChar == 'W') {
                    marker.setAttribute("severity", 1);
                    continue;
                }
                marker.setAttribute("severity", 2);
            }
            catch (CoreException e) {
                PliPlugin.getDefault().writeMsg(Level.SEVERE, "*** ParseSyntaxErrorsFromAdata.readRecord(...): Adding marker causes CoreException", e);
            }
        }
    }

    private AdataRecord readRecord(InputStream is) throws IOException {
        AdataRecord result = null;
        AdataRecord temp = new AdataRecord();
        temp.langCode = is.read();
        if (temp.langCode >= 0) {
            int rt1 = is.read();
            int rt2 = is.read();
            is.read();
            int flag = is.read();
            temp.flagLittleEndian = (flag & 2) != 0;
            is.read();
            is.read();
            is.read();
            is.read();
            is.read();
            int ad1 = is.read();
            int ad2 = is.read();
            int len = 0;
            if (ad1 < 0 || ad2 < 0) {
                PliPlugin.getDefault().writeMsg(Level.SEVERE, "*** ParseSyntaxErrorsFromAdata.readRecord(...): Invalid data, Reach to end of adata file.");
                throw new PliException(EX_DESC_REACH_TO_END_OF_FILE);
            }
            if (temp.flagLittleEndian) {
                len = ad2 << 8 | ad1;
                temp.recordType = rt2 << 8 | rt1;
            } else {
                len = ad1 << 8 | ad2;
                temp.recordType = rt1 << 8 | rt2;
            }
            temp.data = new int[len];
            int i = 0;
            while (i < len) {
                temp.data[i] = is.read();
                if (temp.data[i] < 0) {
                    PliPlugin.getDefault().writeMsg(Level.SEVERE, "*** ParseSyntaxErrorsFromAdata.readRecord(...): Invalid data, Reach to end of adata file.");
                    throw new PliException(EX_DESC_REACH_TO_END_OF_FILE);
                }
                ++i;
            }
            result = temp;
        }
        return result;
    }

    @Override
    protected List getResourceVector() {
        return this.resourceVector;
    }

    protected class AdataRecord {
        protected final int LANG_TYPE_ASM = 16;
        protected final int LANG_TYPE_COBOL = 17;
        protected final int LANG_TYPE_PLI = 40;
        protected final int RECORD_TYPE_PLI_MESSAGE = 50;
        protected final int RECORD_TYPE_PLI_FILE = 57;
        protected final int RECORD_TYPE_PLI_LITERAL = 67;
        int langCode;
        int recordType;
        boolean flagLittleEndian;
        int[] data;

        protected AdataRecord() {
        }

        protected boolean isPliAdata() {
            return this.langCode == 40;
        }

        protected boolean isPliMessageRecord() {
            return this.isPliAdata() && this.recordType == 50;
        }

        protected boolean isPliFileRecord() {
            return this.isPliAdata() && this.recordType == 57;
        }

        protected boolean isPliLiteralRecord() {
            return this.isPliAdata() && this.recordType == 67;
        }

        protected long getDoubleWordValue(int pos) {
            long result = 0L;
            long d1 = this.data[pos];
            long d2 = this.data[pos + 1];
            long d3 = this.data[pos + 2];
            long d4 = this.data[pos + 3];
            result = this.flagLittleEndian ? d4 << 24 | d3 << 16 | d2 << 8 | d1 : d1 << 24 | d2 << 16 | d3 << 8 | d4;
            return result;
        }

        protected int getWordValue(int pos) {
            int result = 0;
            int d1 = this.data[pos];
            int d2 = this.data[pos + 1];
            result = this.flagLittleEndian ? d2 << 8 | d1 : d1 << 8 | d2;
            return result;
        }

        protected String getString(int pos, int len) {
            String result = null;
            if (len == 0) {
                result = "";
            } else if (len > 0) {
                byte[] buf = new byte[len];
                int i = 0;
                while (i < len) {
                    byte v = 0;
                    int d = this.data[pos + i] & 0xFF;
                    v = d < 128 ? (byte)d : (byte)(d - 256);
                    buf[i] = v;
                    ++i;
                }
                result = new String(buf);
            }
            if (result == null) {
                result = "";
            }
            return result;
        }
    }

    protected class PliFileRecord {
        private long id;
        private long parentFileId;
        private long lineNumber;
        private long fileNameID;

        protected PliFileRecord(AdataRecord r) throws PliException {
            if (!r.isPliFileRecord()) {
                PliPlugin.getDefault().writeMsg(Level.SEVERE, "*** ParseSyntaxErrorsFromAdata.PliFileRecord(...): Record type is not FILE.");
                throw new PliException(EX_DESC_RECORD_TYPE_IS_NOT_FILE);
            }
            this.parentFileId = r.getDoubleWordValue(0);
            this.lineNumber = r.getDoubleWordValue(4);
            this.id = r.getDoubleWordValue(8);
            this.fileNameID = r.getDoubleWordValue(12);
        }

        protected long getFileNameID() {
            return this.fileNameID;
        }

        protected long getId() {
            return this.id;
        }

        protected long getLineNumber() {
            return this.lineNumber;
        }

        protected long getParentFileId() {
            return this.parentFileId;
        }
    }

    protected class PliLiteralRecord {
        private long id;
        private String value;

        protected PliLiteralRecord(AdataRecord r) throws PliException {
            if (!r.isPliLiteralRecord()) {
                PliPlugin.getDefault().writeMsg(Level.SEVERE, "*** ParseSyntaxErrorsFromAdata.PliLiteralRecord(...): Record type is not LITERAL.");
                throw new PliException(EX_DESC_RECORD_TYPE_IS_NOT_LITERAL);
            }
            this.id = r.getDoubleWordValue(0);
            int txtlen = (int)r.getDoubleWordValue(4);
            this.value = r.getString(8, txtlen);
        }

        protected long getId() {
            return this.id;
        }

        protected String getValue() {
            return this.value;
        }
    }

    protected class PliMessageRecord {
        private long fileId;
        private long lineNumber;
        private String messageId;
        private int severity;
        private String messageText;

        protected PliMessageRecord(AdataRecord r) throws PliException {
            if (!r.isPliMessageRecord()) {
                PliPlugin.getDefault().writeMsg(Level.SEVERE, "*** ParseSyntaxErrorsFromAdata.PliMessageRecord(...): Record type is not MESSAGE.");
                throw new PliException(EX_DESC_RECORD_TYPE_IS_NOT_MESSAGE);
            }
            this.fileId = r.getDoubleWordValue(0);
            this.lineNumber = r.getDoubleWordValue(4);
            this.messageId = r.getString(8, 16);
            this.severity = r.getWordValue(24);
            int msglen = r.getWordValue(26);
            this.messageText = r.getString(28, msglen);
        }

        protected char getSeverityCharacter() {
            char sevChar = 'E';
            String sevMsg = this.messageId.trim();
            if (sevMsg.length() > 1) {
                sevChar = sevMsg.charAt(sevMsg.length() - 1);
            }
            return sevChar;
        }

        protected long getFileId() {
            return this.fileId;
        }

        protected long getLineNumber() {
            return this.lineNumber;
        }

        protected String getMessageId() {
            return this.messageId;
        }

        protected String getMessageText() {
            return this.messageText;
        }

        protected int getSeverity() {
            return this.severity;
        }
    }
}

