/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.pli.importer;

import com.ibm.ccl.pli.importer.ErrorMessageInfo;
import com.ibm.ccl.pli.plugin.PliPlugin;
import java.util.AbstractList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;

public abstract class ParseSyntaxErrors {
    public static final String copyright = "Licensed Materials - Property of IBM\ncom.ibm.ccl.pli\nCopyright IBM Corporation 2004, 2007. All Rights Reserved.\nNote to U.S. Government Users Restricted Rights:  Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. ";
    private Vector errorMessagesVector = new Vector();
    private boolean parsed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseSyntaxErrors() {
        Vector vector = this.errorMessagesVector;
        synchronized (vector) {
            this.errorMessagesVector.clear();
            try {
                this.doParse();
                this.parsed = true;
            }
            catch (Exception ex) {
                PliPlugin.getDefault().writeMsg(Level.SEVERE, "*** ParseSyntaxErrors.parseSyntaxErrors(...): Fail to parse.", ex);
            }
        }
    }

    protected abstract void doParse() throws Exception;

    protected abstract List getResourceVector();

    protected void addError(ErrorMessageInfo emi) {
        if (emi != null) {
            this.errorMessagesVector.add(emi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasErrors() {
        boolean errorsFlag = false;
        Vector vector = this.errorMessagesVector;
        synchronized (vector) {
            if (!this.parsed) {
                this.parseSyntaxErrors();
            }
            for (Object obj : this.errorMessagesVector) {
                ErrorMessageInfo emi;
                if (!(obj instanceof ErrorMessageInfo) || !(emi = (ErrorMessageInfo)obj).isSevereError()) continue;
                PliPlugin.getDefault().writeMsg(Level.FINE, "*** ParseSyntaxErrors.hasErrors(): Found severe error = " + emi.getMessageString());
                errorsFlag = true;
                break;
            }
        }
        return errorsFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractList getErrorMessagesVector() {
        Vector vector = this.errorMessagesVector;
        synchronized (vector) {
            if (!this.parsed) {
                this.parseSyntaxErrors();
            }
        }
        return this.errorMessagesVector;
    }
}

