/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ctc.c2xsd.typesimport;

import com.ibm.etools.c.CArray;
import com.ibm.etools.c.CClassifier;
import com.ibm.etools.c.CDatatype;
import com.ibm.etools.c.CDerivableType;
import com.ibm.etools.c.CPointer;
import com.ibm.etools.c.CStruct;
import com.ibm.etools.c.CUnion;
import com.ibm.etools.c.datatypes.CChar;
import com.ibm.etools.c.datatypes.CSignedChar;
import com.ibm.etools.c.datatypes.CUnsignedChar;
import com.ibm.etools.c.datatypes.CUnsignedShort;
import com.ibm.etools.c.importer.CPreferenceStore;
import com.ibm.etools.c.importer.CTypeDescriptorBuilder;
import com.ibm.etools.ctc.c2xsd.typesimport.BaseURI;
import com.ibm.etools.ctc.c2xsd.typesimport.CTypeHelper;
import com.ibm.etools.ctc.c2xsd.typesimport.GeneralUtil;
import com.ibm.etools.typedescriptor.StringTD;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDContentTypeCategory;
import org.eclipse.xsd.XSDDerivationMethod;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDLengthFacet;
import org.eclipse.xsd.XSDMaxLengthFacet;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaContent;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.impl.XSDFactoryImpl;
import org.eclipse.xsd.impl.XSDSchemaImpl;

public class XsdHelper {
    private static final String copyright = "Licensed Material - Property of IBM <<PART NUMBER - 5724-D15>> (C) Copyright IBM Corp. 2001, 2004 - All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure " + "restricted by GSA ADP Schedule Contract with IBM Corp.".intern();
    private static XsdHelper thisInstance;
    public static final String XSD_NAMESPACE_SOAPENCODING = "http://schemas.xmlsoap.org/soap/encoding/";
    public static final String NS_URI_WSDL = "http://schemas.xmlsoap.org/wsdl";
    private XSDFactory xsdFactory = XSDFactoryImpl.eINSTANCE;
    private XSDSchema fieldSOAPSchema = XSDFactoryImpl.eINSTANCE.createXSDSchema();
    private XSDAttributeDeclaration fieldSOAPArrayTypeAttribute;
    private XSDComplexTypeDefinition fieldSOAPArrayType;

    public XsdHelper() {
        this.fieldSOAPSchema.getQNamePrefixToNamespaceMap().put(this.fieldSOAPSchema.getSchemaForSchemaQNamePrefix(), "http://www.w3.org/2001/XMLSchema");
        this.fieldSOAPSchema.setTargetNamespace(XSD_NAMESPACE_SOAPENCODING);
        this.fieldSOAPArrayTypeAttribute = XSDFactoryImpl.eINSTANCE.createXSDAttributeDeclaration();
        this.fieldSOAPArrayTypeAttribute.setName("arrayType");
        this.fieldSOAPArrayTypeAttribute.setTypeDefinition(XSDSchemaImpl.getSchemaForSchema((String)"http://www.w3.org/2001/XMLSchema").resolveSimpleTypeDefinition("string"));
        this.fieldSOAPArrayTypeAttribute.setTargetNamespace(XSD_NAMESPACE_SOAPENCODING);
        this.fieldSOAPSchema.getContents().add((Object)this.fieldSOAPArrayTypeAttribute);
        this.fieldSOAPArrayType = XSDFactoryImpl.eINSTANCE.createXSDComplexTypeDefinition();
        this.fieldSOAPArrayType.setName("Array");
        this.fieldSOAPArrayType.setTargetNamespace(XSD_NAMESPACE_SOAPENCODING);
        this.fieldSOAPSchema.getContents().add((Object)this.fieldSOAPArrayType);
    }

    public static synchronized XsdHelper getInstance() {
        if (thisInstance == null) {
            thisInstance = new XsdHelper();
        }
        return thisInstance;
    }

    public void initializeSchema(XSDSchema schema, IFile xsdFile, String targetNS) {
        Map prefixNSMap;
        if (targetNS == null) {
            String xsdName = xsdFile.getName();
            xsdName = xsdName.substring(0, xsdName.lastIndexOf("."));
            targetNS = "http://www." + xsdName + ".com/schemas/" + xsdName + "Interface";
        }
        if (schema.getTargetNamespace() == null) {
            schema.setTargetNamespace(targetNS);
        }
        if (!(prefixNSMap = schema.getQNamePrefixToNamespaceMap()).containsValue("http://www.w3.org/2001/XMLSchema")) {
            prefixNSMap.put(schema.getSchemaForSchemaQNamePrefix(), "http://www.w3.org/2001/XMLSchema");
        }
        if (!prefixNSMap.containsValue(schema.getTargetNamespace())) {
            prefixNSMap.put("xsd1", schema.getTargetNamespace());
        }
    }

    public int indexInContentsList(List list, Object newEle) {
        int index;
        block4: {
            block5: {
                index = -1;
                if (!(newEle instanceof XSDModelGroupDefinition)) break block5;
                XSDModelGroupDefinition newGroup = (XSDModelGroupDefinition)newEle;
                int i = 0;
                while (i < list.size()) {
                    XSDModelGroupDefinition group;
                    Object obj = list.get(i);
                    if (obj instanceof XSDModelGroupDefinition && (group = (XSDModelGroupDefinition)obj).getName().equals(newGroup.getName())) {
                        index = i;
                        break block4;
                    }
                    ++i;
                }
                break block4;
            }
            if (!(newEle instanceof XSDComplexTypeDefinition)) break block4;
            XSDComplexTypeDefinition newCT = (XSDComplexTypeDefinition)newEle;
            int i = 0;
            while (i < list.size()) {
                XSDComplexTypeDefinition ct;
                Object obj = list.get(i);
                if (obj instanceof XSDComplexTypeDefinition && (ct = (XSDComplexTypeDefinition)obj).getName().equals(newCT.getName())) {
                    index = i;
                    break;
                }
                ++i;
            }
        }
        return index;
    }

    public XSDModelGroupDefinition createModelGroupDefinition(CClassifier item) {
        XSDModelGroup modelGroup = this.xsdFactory.createXSDModelGroup();
        XSDModelGroupDefinition modelGroupDefinition = this.xsdFactory.createXSDModelGroupDefinition();
        if (item instanceof CUnion) {
            modelGroup.setCompositor(XSDCompositor.CHOICE_LITERAL);
        } else {
            modelGroup.setCompositor(XSDCompositor.SEQUENCE_LITERAL);
        }
        modelGroupDefinition.setModelGroup(modelGroup);
        return modelGroupDefinition;
    }

    public XSDComplexTypeDefinition createComplexTypeDefFromGroupDef(XSDSchema xsdSchema, XSDModelGroupDefinition modelGroupDef, String name) {
        XSDComplexTypeDefinition complexTypeDef = this.xsdFactory.createXSDComplexTypeDefinition();
        XSDParticle modelGroupParticle = this.xsdFactory.createXSDParticle();
        XSDModelGroupDefinition modelGroupDefRef = this.xsdFactory.createXSDModelGroupDefinition();
        modelGroupDefRef.setResolvedModelGroupDefinition(modelGroupDef);
        modelGroupParticle.setContent((XSDParticleContent)modelGroupDefRef);
        complexTypeDef.setName(name);
        complexTypeDef.setContent((XSDComplexTypeContent)modelGroupParticle);
        return complexTypeDef;
    }

    public XSDModelGroupDefinition createGroupRefForGroup(XSDModelGroupDefinition modelGroupDef) {
        XSDModelGroupDefinition modelGroupDefRef = this.xsdFactory.createXSDModelGroupDefinition();
        modelGroupDefRef.setResolvedModelGroupDefinition(modelGroupDef);
        return modelGroupDefRef;
    }

    protected XSDModelGroupDefinition findModelGroupParent(String refId, XSDComplexTypeDefinition startCT) {
        String parentName = refId;
        XSDSchemaContent xsdContent = this.findContent(parentName, (XSDSchemaContent)startCT);
        if (xsdContent instanceof XSDComplexTypeDefinition) {
            return this.getModelGroupDefForComplexType((XSDComplexTypeDefinition)xsdContent);
        }
        if (xsdContent instanceof XSDModelGroupDefinition) {
            return (XSDModelGroupDefinition)xsdContent;
        }
        return null;
    }

    protected XSDSchemaContent findContent(String name, XSDSchemaContent content) {
        block8: {
            List eleList;
            block7: {
                eleList = null;
                if (!(content instanceof XSDComplexTypeDefinition)) break block7;
                XSDComplexTypeDefinition startCT = (XSDComplexTypeDefinition)content;
                if (startCT.getName().equals(name)) {
                    return content;
                }
                eleList = this.getModelGroupContentsForComplexType(startCT);
                int i = 0;
                while (i < eleList.size()) {
                    XSDParticle elePart = (XSDParticle)eleList.get(i);
                    XSDElementDeclaration ele = (XSDElementDeclaration)elePart.getContent();
                    XSDSchemaContent result = this.findContent(name, (XSDSchemaContent)ele);
                    if (result != null) {
                        return result;
                    }
                    ++i;
                }
                break block8;
            }
            if (!(content instanceof XSDElementDeclaration)) break block8;
            XSDElementDeclaration curEle = (XSDElementDeclaration)content;
            if (curEle.getName().equals(name)) {
                return content;
            }
            XSDTypeDefinition curType = curEle.getAnonymousTypeDefinition();
            if (curType instanceof XSDComplexTypeDefinition) {
                eleList = this.getModelGroupContentsForComplexType((XSDComplexTypeDefinition)curType);
                int i = 0;
                while (i < eleList.size()) {
                    XSDParticle elePart = (XSDParticle)eleList.get(i);
                    XSDElementDeclaration ele = (XSDElementDeclaration)elePart.getContent();
                    XSDSchemaContent result = this.findContent(name, (XSDSchemaContent)ele);
                    if (result != null) {
                        return result;
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    public List getModelGroupContentsForComplexType(XSDComplexTypeDefinition ct) {
        if (ct == null) {
            return null;
        }
        XSDParticleContent obj = ((XSDParticle)ct.getContent()).getContent();
        if (obj instanceof XSDModelGroupDefinition) {
            XSDModelGroupDefinition modelGrpDef = (XSDModelGroupDefinition)obj;
            return modelGrpDef.getResolvedModelGroupDefinition().getModelGroup().getContents();
        }
        if (obj instanceof XSDModelGroup) {
            return ((XSDModelGroup)obj).getContents();
        }
        return null;
    }

    public XSDModelGroupDefinition getModelGroupDefForComplexType(XSDComplexTypeDefinition ct) {
        if (ct == null) {
            return null;
        }
        XSDParticleContent obj = ((XSDParticle)ct.getContent()).getContent();
        if (obj instanceof XSDModelGroupDefinition) {
            return (XSDModelGroupDefinition)obj;
        }
        return null;
    }

    public List getModelGroupContentsForGroupDef(XSDModelGroupDefinition modelGrpDef) {
        if (modelGrpDef == null || modelGrpDef.getModelGroup() == null) {
            return null;
        }
        return modelGrpDef.getModelGroup().getContents();
    }

    public XSDSimpleTypeDefinition getXSDSimpleType(CDatatype cSimType, XSDSchema schema) {
        XSDSimpleTypeDefinition simType;
        if (cSimType instanceof CChar && !(cSimType instanceof CSignedChar) && !(cSimType instanceof CUnsignedChar)) {
            simType = this.xsdFactory.createXSDSimpleTypeDefinition();
            this.setStringRestrictionAndLengthFacet(schema, simType, 1);
        } else {
            String base = CTypeHelper.getInstance().getBaseTypeString(cSimType);
            simType = XSDSchemaImpl.getSchemaForSchema((String)"http://www.w3.org/2001/XMLSchema").resolveSimpleTypeDefinition("http://www.w3.org/2001/XMLSchema", base);
            simType.setTargetNamespace("http://www.w3.org/2001/XMLSchema");
        }
        return simType;
    }

    public XSDSimpleTypeDefinition getXSDPointerType(CPointer cPtrType, XSDSchema schema, String length) {
        XSDSimpleTypeDefinition mainSimType = this.xsdFactory.createXSDSimpleTypeDefinition();
        String base = CTypeHelper.getInstance().getBaseTypeString(cPtrType);
        XSDLengthFacet lenFacet = this.xsdFactory.createXSDLengthFacet();
        lenFacet.setLexicalValue(length);
        mainSimType.getFacetContents().add((Object)lenFacet);
        XSDSimpleTypeDefinition simType = XSDSchemaImpl.getSchemaForSchema((String)schema.getSchemaForSchemaNamespace()).resolveSimpleTypeDefinition("http://www.w3.org/2001/XMLSchema", base);
        simType.setTargetNamespace("http://www.w3.org/2001/XMLSchema");
        mainSimType.setBaseTypeDefinition(simType);
        return mainSimType;
    }

    public XSDSimpleTypeDefinition getXSDStructType(XSDSchema schema, String itemName) {
        String base = itemName;
        XSDSimpleTypeDefinition simType = XSDSchemaImpl.getSchemaForSchema((String)"http://www.w3.org/2001/XMLSchema").resolveSimpleTypeDefinition("http://www.w3.org/2001/XMLSchema", base);
        simType.setTargetNamespace(schema.getTargetNamespace());
        return simType;
    }

    public XSDSimpleTypeDefinition getXSDArrayType(CArray cArrayType, XSDSchema schema, String parentName, String itemName) {
        XSDSimpleTypeDefinition simType;
        Object derivedType = CTypeHelper.getInstance().getSimplestArrayDerivedType(cArrayType);
        if (derivedType instanceof CChar && !(derivedType instanceof CSignedChar) && !(derivedType instanceof CUnsignedChar) || derivedType instanceof CUnsignedShort && CPreferenceStore.isTreatUShortArrayAsDBCS()) {
            int originalDimension;
            simType = this.xsdFactory.createXSDSimpleTypeDefinition();
            StringTD baseType = null;
            int lengthEncodingValue = 0;
            try {
                if (CTypeDescriptorBuilder.getTDType((CClassifier)cArrayType) instanceof StringTD) {
                    baseType = (StringTD)CTypeDescriptorBuilder.getTDType((CClassifier)cArrayType);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (baseType != null && baseType.getLengthEncoding().getValue() == 2) {
                lengthEncodingValue = 1;
            }
            int computedDimension = (originalDimension = this.getLowestArrayType(cArrayType).getDimension().intValue()) == 0 ? originalDimension : originalDimension - lengthEncodingValue;
            this.setStringRestrictionAndLengthFacet(schema, simType, computedDimension);
        } else {
            String base = derivedType instanceof CStruct ? GeneralUtil.getInstance().getJavaNameFromXMLName(String.valueOf(parentName) + (parentName.equals("") ? "" : "_") + itemName) : CTypeHelper.getInstance().getBaseTypeString(derivedType);
            simType = XSDSchemaImpl.getSchemaForSchema((String)"http://www.w3.org/2001/XMLSchema").resolveSimpleTypeDefinition("http://www.w3.org/2001/XMLSchema", base);
            if (derivedType instanceof CStruct) {
                simType.setTargetNamespace(schema.getTargetNamespace());
            }
        }
        return simType;
    }

    private void setStringRestrictionAndLengthFacet(XSDSchema schema, XSDSimpleTypeDefinition xsdSimType, int length) {
        String base = "string";
        XSDMaxLengthFacet lenFacet = this.xsdFactory.createXSDMaxLengthFacet();
        lenFacet.setLexicalValue(new Integer(length).toString());
        xsdSimType.getFacetContents().add((Object)lenFacet);
        XSDSimpleTypeDefinition simType = XSDSchemaImpl.getSchemaForSchema((String)schema.getSchemaForSchemaNamespace()).resolveSimpleTypeDefinition("http://www.w3.org/2001/XMLSchema", base);
        xsdSimType.setBaseTypeDefinition(simType);
    }

    public void addXSDNamespace(XSDSchema xsdSchema, String prefix, String namespaceURI) {
        Map namespaces = xsdSchema.getQNamePrefixToNamespaceMap();
        if (namespaces.containsValue(namespaceURI)) {
            return;
        }
        String existingNamespace = (String)namespaces.get(prefix);
        if (existingNamespace == null) {
            namespaces.put(prefix, namespaceURI);
            return;
        }
        if (prefix.endsWith("1")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        int i = 2;
        while (true) {
            String newPrefix;
            if (!namespaces.containsKey(newPrefix = String.valueOf(prefix) + i)) {
                namespaces.put(newPrefix, namespaceURI);
                return;
            }
            ++i;
        }
    }

    public void addXSDImport(XSDSchema xsdSchema, String namespaceURI, Resource importedResource) {
        if (importedResource == null || importedResource.getResourceSet() != xsdSchema.eResource().getResourceSet()) {
            return;
        }
        if (importedResource == xsdSchema.eResource()) {
            importedResource = null;
        }
        if (importedResource == null && namespaceURI.equals(xsdSchema.getTargetNamespace())) {
            return;
        }
        if (!namespaceURI.equals(xsdSchema.getTargetNamespace())) {
            String importedLocation = importedResource != null ? importedResource.getURI().toString() : null;
            for (Object content : xsdSchema.getContents()) {
                String location;
                XSDImport xsdImport;
                if (!(content instanceof XSDImport) || !namespaceURI.equals((xsdImport = (XSDImport)content).getNamespace())) continue;
                if (importedResource == null) {
                    return;
                }
                if (xsdImport.getSchemaLocation() == null || !(location = new BaseURI(xsdSchema.eResource().getURI()).getAbsoluteURI(xsdImport.getSchemaLocation())).equals(importedLocation)) continue;
                return;
            }
        } else {
            String includedLocation = importedResource.getURI().toString();
            for (Object content : xsdSchema.getContents()) {
                String location;
                XSDInclude xsdInclude;
                if (!(content instanceof XSDInclude) || (xsdInclude = (XSDInclude)content).getSchemaLocation() == null || !(location = new BaseURI(xsdSchema.eResource().getURI()).getAbsoluteURI(xsdInclude.getSchemaLocation())).equals(includedLocation)) continue;
                return;
            }
        }
        if (!namespaceURI.equals(xsdSchema.getTargetNamespace())) {
            XSDImport xsdImport = XSDFactoryImpl.eINSTANCE.createXSDImport();
            xsdImport.setNamespace(namespaceURI);
            if (importedResource != null) {
                xsdImport.setSchemaLocation(new BaseURI(xsdSchema.eResource().getURI()).getRelativeURI(importedResource.getURI()));
            }
            xsdSchema.getContents().add(0, (Object)xsdImport);
        } else {
            XSDInclude xsdInclude = XSDFactoryImpl.eINSTANCE.createXSDInclude();
            xsdInclude.setSchemaLocation(new BaseURI(xsdSchema.eResource().getURI()).getRelativeURI(importedResource.getURI()));
            xsdSchema.getContents().add(0, (Object)xsdInclude);
        }
    }

    public XSDComplexTypeDefinition createComplexTypeDefForArray(XSDSchema xsdSchema, String name) {
        this.addXSDNamespace(xsdSchema, "soapenc", XSD_NAMESPACE_SOAPENCODING);
        this.addXSDImport(xsdSchema, XSD_NAMESPACE_SOAPENCODING, null);
        this.addXSDNamespace(xsdSchema, "wsdl", NS_URI_WSDL);
        this.addXSDImport(xsdSchema, NS_URI_WSDL, null);
        XSDComplexTypeDefinition complexType = this.xsdFactory.createXSDComplexTypeDefinition();
        complexType.setName(name);
        complexType.setTargetNamespace(xsdSchema.getTargetNamespace());
        complexType.setBaseTypeDefinition((XSDTypeDefinition)XsdHelper.getInstance().getSOAPArrayType());
        complexType.setDerivationMethod(XSDDerivationMethod.RESTRICTION_LITERAL);
        XSDParticle particle = this.xsdFactory.createXSDParticle();
        XSDModelGroup modelGroup = this.xsdFactory.createXSDModelGroup();
        particle.setContent((XSDParticleContent)modelGroup);
        complexType.setContent((XSDComplexTypeContent)particle);
        complexType.setContentTypeCategory(XSDContentTypeCategory.EMPTY_LITERAL);
        return complexType;
    }

    public XSDAttributeUse createXSDAttributeForArrayType() {
        XSDAttributeDeclaration attrRef = this.xsdFactory.createXSDAttributeDeclaration();
        attrRef.setResolvedAttributeDeclaration(XsdHelper.getInstance().getSOAPArrayTypeAttribute());
        XSDAttributeUse attrUse = this.xsdFactory.createXSDAttributeUse();
        attrUse.setContent(attrRef);
        return attrUse;
    }

    public void setAttributeForArrayElement(CArray cArrayType, XSDSchema xsdSchema, XSDAttributeUse attrUse) {
        String ns = "http://www.w3.org/2001/XMLSchema";
        String prefix = null;
        this.addXSDNamespace(xsdSchema, "xsd1", ns);
        this.addXSDImport(xsdSchema, ns, null);
        for (Map.Entry e : xsdSchema.getQNamePrefixToNamespaceMap().entrySet()) {
            if (!ns.equals(e.getValue())) continue;
            prefix = (String)e.getKey();
            break;
        }
        CDerivableType derivedType = cArrayType.getDerives();
        if (derivedType instanceof CArray) {
            String qname;
            CTypeHelper cHelper = CTypeHelper.getInstance();
            Object secDerivedType = cHelper.getSimplestArrayDerivedType((CArray)derivedType);
            String base = cHelper.getBaseTypeString(secDerivedType);
            String dimens = this.getDimensions(cArrayType);
            String string = qname = prefix != null ? String.valueOf(prefix) + ':' + base : base;
            if (attrUse.getElement() != null) {
                attrUse.getElement().setAttribute("wsdl:arrayType", String.valueOf(qname) + "[" + dimens + "]");
            }
        }
    }

    private String getDimensions(CArray type) {
        StringBuffer dimens = new StringBuffer();
        dimens.append(Integer.toString(type.getDimension()));
        CDerivableType derivedType = type.getDerives();
        while (derivedType instanceof CArray) {
            dimens.append("," + Integer.toString(((CArray)derivedType).getDimension()));
            derivedType = ((CArray)derivedType).getDerives();
        }
        return dimens.toString();
    }

    public int getProductOfArrayDimensions(CArray type) {
        int dimenTot = type.getDimension();
        CDerivableType derivedType = type.getDerives();
        while (derivedType instanceof CArray) {
            int dimen = ((CArray)derivedType).getDimension();
            CDerivableType nextDerived = ((CArray)derivedType).getDerives();
            boolean isString = false;
            if (nextDerived instanceof CChar && !(nextDerived instanceof CSignedChar) && !(nextDerived instanceof CUnsignedChar) || nextDerived instanceof CUnsignedShort && CPreferenceStore.isTreatUShortArrayAsDBCS()) {
                isString = true;
            }
            if (dimen > 0 && !isString) {
                dimenTot *= dimen;
            }
            derivedType = nextDerived;
        }
        return dimenTot;
    }

    public CArray getLowestArrayType(CArray type) {
        CArray lowestArray = type;
        CDerivableType nextDerived = type.getDerives();
        while (nextDerived instanceof CArray) {
            lowestArray = (CArray)nextDerived;
            nextDerived = ((CArray)nextDerived).getDerives();
        }
        return lowestArray;
    }

    public XSDComplexTypeDefinition getSOAPArrayType() {
        return this.fieldSOAPArrayType;
    }

    public XSDAttributeDeclaration getSOAPArrayTypeAttribute() {
        return this.fieldSOAPArrayTypeAttribute;
    }
}

