/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ctc.c2xsd.typesimport;

import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.typesimport.impl.GroupReferenceInliner;
import com.ibm.adapter.typesimport.impl.TypesImportCommand;
import com.ibm.etools.c.CClassifier;
import com.ibm.etools.ctc.c2xsd.C2xsdPlugin;
import com.ibm.etools.ctc.c2xsd.typesimport.CElementVisitor;
import com.ibm.etools.ctc.c2xsd.typesimport.XsdHelper;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.impl.XSDFactoryImpl;

public class CTypes2XSDCommand
extends TypesImportCommand {
    private static final String copyright = "Licensed Material - Property of IBM <<PART NUMBER - 5724-D15>> (C) Copyright IBM Corp. 2001, 2004 - All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure " + "restricted by GSA ADP Schedule Contract with IBM Corp.".intern();
    protected XSDFactory xsdFactory = null;
    protected Map xsdTypesTdBasePair;
    protected XSDSchema xsdSchema = null;
    protected XsdHelper xsdHelper;
    private CElementVisitor visitor = null;

    public CTypes2XSDCommand() {
        this.fieldPreserveCase = false;
        this.xsdFactory = XSDFactoryImpl.eINSTANCE;
        this.xsdTypesTdBasePair = new HashMap();
        this.xsdHelper = new XsdHelper();
    }

    public IFile getCFile() {
        return this.fieldTypesFile;
    }

    public XSDSchema getSchema() {
        return this.xsdSchema;
    }

    public void importTypes(IProgressMonitor monitor) throws BaseException {
        if (this.xsdSchema == null) {
            URI scheamURI = URI.createFileURI((String)this.fieldSchemaFile.getLocation().toOSString());
            if (this.fieldResourceSet == null) {
                this.fieldResourceSet = new ResourceSetImpl();
            }
            this.fieldSchemaResource = this.fieldResourceSet.createResource(scheamURI);
            this.fieldResourceSet.getResources().add((Object)this.fieldSchemaResource);
            if (this.fieldSchemaFile.exists()) {
                try {
                    this.fieldSchemaResource.load(Collections.EMPTY_MAP);
                }
                catch (IOException exc) {
                    Status s = new Status(4, C2xsdPlugin.getPluginID(), 0, exc.getLocalizedMessage(), (Throwable)exc);
                    throw new BaseException((IStatus)s);
                }
            }
            this.xsdSchema = this.loadOrCreateInitializedSchemaForSchemaResource(this.fieldSchemaResource);
        }
        this.visitTypes(this.xsdSchema);
        if (!this.fieldGenerateGroupRefs) {
            GroupReferenceInliner.inlineModelGroupsInSchema((XSDSchema)this.xsdSchema);
        }
        if (!this.xsdSchema.isIncrementalUpdate()) {
            this.xsdSchema.setIncrementalUpdate(true);
        }
    }

    protected XSDSchema loadOrCreateInitializedSchemaForSchemaResource(Resource schemaModelResource) {
        XSDSchema schema = null;
        EList ext = schemaModelResource.getContents();
        if (ext != null) {
            int i = 0;
            while (i < ext.size()) {
                Object candidate = ext.get(i);
                if (candidate instanceof XSDSchema) {
                    schema = (XSDSchema)candidate;
                }
                ++i;
            }
            if (schema == null) {
                schema = this.xsdFactory.createXSDSchema();
                ext.add(schema);
            } else if (this.fieldClearXSD) {
                ext.remove(schema);
                schema = this.xsdFactory.createXSDSchema();
                ext.add(schema);
            }
        } else {
            schema = this.xsdFactory.createXSDSchema();
            schemaModelResource.getContents().add((Object)schema);
        }
        this.xsdHelper.initializeSchema(schema, this.fieldSchemaFile, this.schemaTargetNS);
        schema.updateElement();
        if (schema.isIncrementalUpdate()) {
            schema.setIncrementalUpdate(false);
        }
        return schema;
    }

    public void setSchema(XSDSchema newSchema) {
        this.xsdSchema = newSchema;
    }

    private void visitTypes(XSDSchema xsdSchema) throws BaseException {
        if (this.fieldXSDTypes == null) {
            this.fieldXSDTypes = new HashMap();
        }
        Iterator i = this.fieldTypes.iterator();
        while (i.hasNext()) {
            this.visitor = new CElementVisitor();
            this.visitor.setXsdSchema(xsdSchema);
            this.visitor.setXsdTypesTdBasePair(this.xsdTypesTdBasePair);
            this.visitor.setOverwriteTypes(this.fieldOverwriteTypes);
            this.visitor.setXsdTypePrefix(this.fieldXSDTypePrefix);
            this.visitor.setGenerateFlat(this.fieldGenerateFlat);
            this.visitor.setPreserveCase(this.fieldPreserveCase);
            CClassifier cElem = (CClassifier)i.next();
            if (this.fieldTypes.size() > 1) {
                this.visitor.setXsdTypeName(cElem.getName());
            } else if (this.fieldXSDTypeName != null && this.fieldXSDTypeName.length() != 0) {
                this.visitor.setXsdTypeName(this.fieldXSDTypeName);
            } else {
                this.visitor.setXsdTypeName(cElem.getName());
            }
            this.visitor.acceptItemVisitor(cElem, 1);
            XSDTypeDefinition returnedType = this.visitor.getXSDType();
            this.fieldXSDTypes.put(returnedType.getName(), returnedType);
        }
    }

    public Map getXSDTypesTdBasePair() {
        return this.xsdTypesTdBasePair;
    }
}

