/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.j2ca.spi.util;

import com.ibm.adapter.j2ca.internal.LogFacility;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServer;

public class WASRuntimeUtil {
    protected static final String RUNTIME_TYPE_ID = "com.ibm.etools.websphere.runtime";
    public static final String NEW_RUNTIME_TYPE_ID = "com.ibm.ws.ast.st.runtime";
    public static final String WAS61_WEBSERVICES_FEATUREPACK = "WEBSERVICES";
    public static final String WAS61_EJB30_FEATUREPACK = "EJB3";
    private static List<InstalledFeatureEntry> installedFeatures = null;

    public static boolean isFeaturePackInstalled(IRuntime rt, String fpID) {
        if (rt == null) {
            return false;
        }
        try {
            Object runtimeFeature = WASRuntimeUtil.getInstalledFeature(rt.getRuntimeType().getId());
            if (runtimeFeature != null) {
                Method meth = runtimeFeature.getClass().getMethod("isFeatureSupported", IRuntime.class, String.class);
                Boolean result = (Boolean)meth.invoke(runtimeFeature, rt, fpID);
                return result;
            }
        }
        catch (Throwable t) {
            LogFacility.logErrorMessage((String)(String.valueOf(rt.getId()) + ":" + fpID), (Throwable)t);
        }
        return false;
    }

    public static boolean isWASRuntime(IRuntime runtime) {
        return runtime != null && runtime.getRuntimeType() != null && (runtime.getRuntimeType().getId().startsWith(RUNTIME_TYPE_ID) || runtime.getRuntimeType().getId().startsWith(NEW_RUNTIME_TYPE_ID));
    }

    public static boolean isWASv70Server(IServer server) {
        return server != null && WASRuntimeUtil.isWASv70Runtime(server.getRuntime());
    }

    public static boolean isWASv70Runtime(IRuntime runtime) {
        return runtime != null && WASRuntimeUtil.isWASv70RuntimeType(runtime.getRuntimeType());
    }

    public static boolean isWASv70OrLaterRuntime(IRuntime runtime) {
        return WASRuntimeUtil.isWASv70Runtime(runtime) || WASRuntimeUtil.isWASv80OrLaterRuntime(runtime);
    }

    public static boolean isWASv70RuntimeType(IRuntimeType runtimeType) {
        return runtimeType != null && runtimeType.getId().startsWith("com.ibm.ws.ast.st.runtime.v7");
    }

    public static boolean isWASv70RuntimeTypeID(String runtimeTypeId) {
        return runtimeTypeId != null && runtimeTypeId.startsWith("com.ibm.ws.ast.st.runtime.v7");
    }

    public static boolean isWASv80Server(IServer server) {
        return server != null && WASRuntimeUtil.isWASv80Runtime(server.getRuntime());
    }

    public static boolean isWASv80Runtime(IRuntime runtime) {
        return runtime != null && WASRuntimeUtil.isWASv80RuntimeType(runtime.getRuntimeType());
    }

    public static boolean isWASv80OrLaterRuntime(IRuntime runtime) {
        return WASRuntimeUtil.isWASv80Runtime(runtime) || WASRuntimeUtil.isWASv85OrLaterRuntime(runtime) || WASRuntimeUtil.isWASv90OrLaterRuntime(runtime);
    }

    public static boolean isWASv80RuntimeType(IRuntimeType runtimeType) {
        return runtimeType != null && runtimeType.getId().startsWith("com.ibm.ws.ast.st.runtime.v8") && !runtimeType.getId().startsWith("com.ibm.ws.ast.st.runtime.v85") && !runtimeType.getId().startsWith("com.ibm.ws.ast.st.runtime.v9");
    }

    public static boolean isWASv85Server(IServer server) {
        return server != null && WASRuntimeUtil.isWASv85Runtime(server.getRuntime());
    }

    public static boolean isWASv85Runtime(IRuntime runtime) {
        return runtime != null && WASRuntimeUtil.isWASv85RuntimeType(runtime.getRuntimeType());
    }

    public static boolean isWASv85OrLaterRuntime(IRuntime runtime) {
        return WASRuntimeUtil.isWASv85Runtime(runtime);
    }

    public static boolean isWASv85RuntimeType(IRuntimeType runtimeType) {
        return runtimeType != null && runtimeType.getId().startsWith("com.ibm.ws.ast.st.runtime.v85");
    }

    public static boolean isWASv90Server(IServer server) {
        return server != null && WASRuntimeUtil.isWASv90Runtime(server.getRuntime());
    }

    public static boolean isWASv90Runtime(IRuntime runtime) {
        return runtime != null && WASRuntimeUtil.isWASv90RuntimeType(runtime.getRuntimeType());
    }

    public static boolean isWASv90OrLaterRuntime(IRuntime runtime) {
        return WASRuntimeUtil.isWASv90Runtime(runtime);
    }

    public static boolean isWASv90RuntimeType(IRuntimeType runtimeType) {
        return runtimeType != null && runtimeType.getId().startsWith("com.ibm.ws.ast.st.runtime.v9");
    }

    public static void updateRuntimeClasspath(IProject project) {
        if (project != null) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            try {
                IClasspathEntry[] ce = javaProject.getRawClasspath();
                int j = 0;
                while (j < ce.length) {
                    IPath containerPath;
                    if (ce[j].getEntryKind() == 5 && (containerPath = ce[j].getPath()) != null && containerPath.isPrefixOf(ce[j].getPath())) {
                        javaProject.setRawClasspath(javaProject.readRawClasspath(), null);
                    }
                    ++j;
                }
            }
            catch (Exception exception) {}
        }
    }

    public static Object getInstalledFeature(String curRuntimeTypeId) {
        if (curRuntimeTypeId == null) {
            return null;
        }
        if (installedFeatures == null) {
            installedFeatures = WASRuntimeUtil.loadInstalledFeatures();
        }
        Object matchedRuntimeFeature = null;
        if (installedFeatures != null) {
            for (InstalledFeatureEntry curInstalledFeatureEntry : installedFeatures) {
                String featureRTId = curInstalledFeatureEntry.getRuntimeTypeId();
                if (!curRuntimeTypeId.equals(featureRTId) ? curRuntimeTypeId.length() > featureRTId.length() && curRuntimeTypeId.charAt(featureRTId.length()) == '.' && curRuntimeTypeId.startsWith(featureRTId) && (matchedRuntimeFeature = curInstalledFeatureEntry.getRuntimeFeature()) != null : (matchedRuntimeFeature = curInstalledFeatureEntry.getRuntimeFeature()) != null) break;
            }
        }
        return matchedRuntimeFeature;
    }

    private static List<InstalledFeatureEntry> loadInstalledFeatures() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] configElements = registry.getConfigurationElementsFor("com.ibm.ws.ast.st.core", "installedFeature");
        int size = configElements.length;
        ArrayList<InstalledFeatureEntry> configElementList = new ArrayList<InstalledFeatureEntry>(size);
        int i = 0;
        while (i < size) {
            try {
                InstalledFeatureEntry curInstalledFeatureEntry = new InstalledFeatureEntry(configElements[i]);
                configElementList.add(curInstalledFeatureEntry);
            }
            catch (Throwable throwable) {}
            ++i;
        }
        return configElementList;
    }

    private static class InstalledFeatureEntry {
        private Object runtimeFeature;
        private IConfigurationElement configElement;

        InstalledFeatureEntry(IConfigurationElement curConfigElement) {
            this.configElement = curConfigElement;
        }

        Object getRuntimeFeature() {
            if (this.runtimeFeature == null && this.configElement != null) {
                try {
                    this.runtimeFeature = this.configElement.createExecutableExtension("class");
                }
                catch (Throwable throwable) {}
            }
            return this.runtimeFeature;
        }

        String getRuntimeTypeId() {
            return this.configElement != null ? this.configElement.getAttribute("runtimeTypeId") : null;
        }
    }
}

