/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.j2ca.spi.util;

import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.j2ca.Connector;
import com.ibm.adapter.j2ca.IResourceAdapterDescriptor;
import com.ibm.adapter.j2ca.internal.LogFacility;
import com.ibm.adapter.j2ca.internal.MessageResource;
import com.ibm.adapter.j2ca.internal.ResourceAdapterRegistry;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UTF16;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import com.ibm.propertygroup.spi.BaseSingleValuedProperty;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jst.j2ee.jca.modulecore.util.ConnectorArtifactEdit;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.javaee.core.Description;
import org.eclipse.jst.javaee.core.DisplayName;
import org.eclipse.jst.javaee.core.JavaeeFactory;
import org.eclipse.jst.javaee.core.TransactionSupport;
import org.eclipse.jst.javaee.jca.ActivationSpec;
import org.eclipse.jst.javaee.jca.AdminObject;
import org.eclipse.jst.javaee.jca.AuthenticationMechanism;
import org.eclipse.jst.javaee.jca.ConfigProperty;
import org.eclipse.jst.javaee.jca.ConfigPropertyTypeType;
import org.eclipse.jst.javaee.jca.ConnectionDefinition;
import org.eclipse.jst.javaee.jca.CredentialInterfaceType;
import org.eclipse.jst.javaee.jca.InboundResourceAdapter;
import org.eclipse.jst.javaee.jca.JcaFactory;
import org.eclipse.jst.javaee.jca.License;
import org.eclipse.jst.javaee.jca.MessageAdapter;
import org.eclipse.jst.javaee.jca.MessageListener;
import org.eclipse.jst.javaee.jca.OutboundResourceAdapter;
import org.eclipse.jst.javaee.jca.ResourceAdapter;
import org.eclipse.jst.javaee.jca.SecurityPermission;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.UnresolveableURIException;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class ConnectorProjectHelper {
    public static final String CONNECTION_SPEC_INTERFACE = "jakarta.resource.cci.ConnectionSpec";
    public static final String FILE_URL_PROTOCOL = "file";
    public static final String INTERACTION_SPEC_INTERFACE = "jakarta.resource.cci.InteractionSpec";

    public static IPropertyGroup createPropertyGroupFromConfigElements(String propertyGroupName, List<org.eclipse.jst.j2ee.jca.ConfigProperty> configProperties, ClassLoader classLoader) {
        BasePropertyGroup propertyGroup;
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            propertyGroup = new BasePropertyGroup(propertyGroupName, null, propertyGroupName);
        }
        catch (CoreException e1) {
            LogFacility.logErrorMessage((String)MessageResource.MSG_ERROR__RA_PROPS, (Throwable)e1);
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            return null;
        }
        if (configProperties != null) {
            ArrayList<BaseSingleValuedProperty> propertyDescriptors = new ArrayList<BaseSingleValuedProperty>(configProperties.size());
            for (org.eclipse.jst.j2ee.jca.ConfigProperty property : configProperties) {
                try {
                    Class<?> propertyTypeClass = classLoader.loadClass(property.getType());
                    BaseSingleValuedProperty propertyDescriptor = new BaseSingleValuedProperty(property.getName(), null, property.getDescription(), propertyTypeClass, propertyGroup);
                    String defaultValue = property.getValue();
                    if (defaultValue != null && defaultValue.length() > 0) {
                        if (propertyTypeClass.equals(String.class)) {
                            propertyDescriptor.setDefaultValue((Object)defaultValue);
                        } else if (propertyTypeClass.equals(Integer.class)) {
                            propertyDescriptor.setDefaultValue((Object)new Integer(defaultValue));
                        } else if (propertyTypeClass.equals(Boolean.class)) {
                            propertyDescriptor.setDefaultValue((Object)new Boolean(defaultValue));
                        } else if (propertyTypeClass.equals(Byte.class)) {
                            propertyDescriptor.setDefaultValue((Object)new Byte(defaultValue));
                        } else if (propertyTypeClass.equals(Character.class)) {
                            int ch = UTF16.charAt((String)defaultValue, (int)0);
                            propertyDescriptor.setDefaultValue((Object)new Character(UCharacter.toChars((int)ch)[0]));
                        } else if (propertyTypeClass.equals(Double.class)) {
                            propertyDescriptor.setDefaultValue((Object)new Double(defaultValue));
                        } else if (propertyTypeClass.equals(Float.class)) {
                            propertyDescriptor.setDefaultValue((Object)new Float(defaultValue));
                        } else if (propertyTypeClass.equals(Long.class)) {
                            propertyDescriptor.setDefaultValue((Object)new Long(defaultValue));
                        } else if (propertyTypeClass.equals(Short.class)) {
                            propertyDescriptor.setDefaultValue((Object)new Short(defaultValue));
                        }
                    }
                    propertyDescriptors.add(propertyDescriptor);
                }
                catch (ClassNotFoundException e) {
                    LogFacility.logErrorMessage((String)MessageResource.MSG_ERROR__RA_PROPS, (Throwable)e);
                }
                catch (CoreException e2) {
                    LogFacility.logErrorMessage((String)MessageResource.MSG_ERROR__RA_PROPS, (Throwable)e2);
                }
            }
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            return propertyGroup;
        }
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
        return null;
    }

    public static Class<?>[] findClassesForType(IProject aConnectorProject, String type, ClassLoader classLoader) throws BaseException {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        ArrayList classes = new ArrayList();
        try {
            IJavaProject javaProject = JavaCore.create((IProject)aConnectorProject);
            IType javaType = javaProject.findType(type);
            if (javaType == null) {
                String message = MessageResource.bind((String)MessageResource.MSG_ERROR__RA_TYPE_NOT_FOUND, (Object)type, (Object)aConnectorProject.getName());
                LogFacility.logErrorMessage((String)message, null);
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
                throw BaseException.createException((String)message, null);
            }
            Connector connector = ConnectorProjectHelper.getConnector(aConnectorProject);
            if ("WOLA".equals(connector.getEisType())) {
                ConnectorProjectHelper.findWOLAClassesForType(javaProject, javaType, classLoader, classes);
            } else {
                ITypeHierarchy typeHierarchy = javaType.newTypeHierarchy(javaProject, (IProgressMonitor)new NullProgressMonitor());
                IType[] subTypes = typeHierarchy.getAllSubtypes(javaType);
                IPath containerPath = javaProject.getProject().getFullPath();
                int i = subTypes.length;
                while (--i >= 0) {
                    if (Flags.isAbstract((int)subTypes[i].getFlags())) continue;
                    try {
                        IPath typePath = subTypes[i].getPath();
                        if (typePath == null || typePath.matchingFirstSegments(containerPath) != containerPath.segmentCount()) continue;
                        Class<?> clazz = classLoader.loadClass(subTypes[i].getFullyQualifiedName());
                        classes.add(clazz);
                    }
                    catch (ClassNotFoundException e) {
                        String message = MessageResource.bind((String)MessageResource.MSG_ERROR__RA_TYPE_NOT_FOUND, (Object)subTypes[i].getFullyQualifiedName(), (Object)aConnectorProject.getName());
                        LogFacility.logErrorMessage((String)message, (Throwable)e);
                    }
                }
            }
            Class[] returnValues = new Class[classes.size()];
            returnValues = classes.toArray(returnValues);
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            Class[] classArray = returnValues;
            return classArray;
        }
        catch (CoreException e) {
            String message = MessageResource.bind((String)MessageResource.MSG_ERROR__RA_TYPE_NOT_FOUND, (Object)type, (Object)aConnectorProject.getName());
            LogFacility.logErrorMessage((String)message, (Throwable)e);
            return null;
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    public static void findWOLAClassesForType(IJavaProject javaProject, IType javaType, ClassLoader classLoader, ArrayList<Class<?>> classes) throws CoreException {
        IClasspathEntry[] classpath;
        ArrayList<IPackageFragmentRoot> closureCollection = new ArrayList<IPackageFragmentRoot>();
        IClasspathEntry[] iClasspathEntryArray = classpath = javaProject.getRawClasspath();
        int n = classpath.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
            if (classpathEntry.getEntryKind() == 1 || classpathEntry.getEntryKind() == 3) {
                IPackageFragmentRoot[] roots = javaProject.findPackageFragmentRoots(classpathEntry);
                closureCollection.addAll(Arrays.asList(roots));
            }
            ++n2;
        }
        IJavaElement[] resources = closureCollection.toArray(new IJavaElement[closureCollection.size()]);
        SearchPattern ifacePattern = SearchPattern.createPattern((IJavaElement)javaType, (int)1);
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])resources);
        SearchEngine searchEngine = new SearchEngine();
        final ArrayList results = new ArrayList();
        searchEngine.search(ifacePattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                results.add(match);
            }
        }, null);
        for (SearchMatch match : results) {
            IType aType;
            Object obj = match.getElement();
            if (!(obj instanceof IType) || Flags.isAbstract((int)(aType = (IType)obj).getFlags())) continue;
            try {
                Class<?> clazz = classLoader.loadClass(aType.getFullyQualifiedName());
                classes.add(clazz);
            }
            catch (ClassNotFoundException e) {
                String message = MessageResource.bind((String)MessageResource.MSG_ERROR__RA_TYPE_NOT_FOUND, (Object)aType.getFullyQualifiedName(), (Object)javaProject.getProject().getName());
                LogFacility.logErrorMessage((String)message, (Throwable)e);
            }
        }
    }

    public static Class<?>[] findConnectionSpecs(IProject aConnectorProject, ClassLoader classLoader) throws BaseException {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        Class<?>[] classes = ConnectorProjectHelper.findClassesForType(aConnectorProject, CONNECTION_SPEC_INTERFACE, classLoader);
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
        return classes;
    }

    public static Class<?>[] findInteractionSpecs(IProject aConnectorProject, ClassLoader classLoader) throws BaseException {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        Class<?>[] classes = ConnectorProjectHelper.findClassesForType(aConnectorProject, INTERACTION_SPEC_INTERFACE, classLoader);
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
        return classes;
    }

    public static IProject[] getAllConnectorProjects() {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> connectorProjects = new ArrayList<IProject>(projects.length);
        int i = projects.length;
        while (--i >= 0) {
            if (ConnectorProjectHelper.isConnectorProject(projects[i]) == null) continue;
            connectorProjects.add(projects[i]);
        }
        IProject[] returnedProjects = new IProject[connectorProjects.size()];
        connectorProjects.toArray(returnedProjects);
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
        return returnedProjects;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean projectHasRaXMLFile(IProject aConnectorProject) {
        IJavaProject javaConnectorProject = JavaCore.create((IProject)aConnectorProject);
        try {
            IClasspathEntry[] iClasspathEntryArray = javaConnectorProject.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
                if (classpathEntry.getEntryKind() == 3 && !classpathEntry.getPath().toString().contains(".apt_generated") && aConnectorProject.getFile(classpathEntry.getPath().removeFirstSegments(1).append("META-INF/ra.xml")).exists()) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
        return false;
    }

    public static Connector getConnector(IProject aConnectorProject) {
        IResourceAdapterDescriptor descriptor;
        IVirtualComponent component = ConnectorProjectHelper.isConnectorProject(aConnectorProject);
        if (component != null && (descriptor = ResourceAdapterRegistry.getRegistry().getResourceAdapterForProject(aConnectorProject)) != null) {
            return descriptor.getConnector();
        }
        return null;
    }

    public static Connector getConnector(IProject aConnectorProject, boolean readAnnotations) {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            IVirtualComponent component = ConnectorProjectHelper.isConnectorProject(aConnectorProject);
            if (component != null) {
                IModelProvider provider = ModelProviderManager.getModelProvider((IVirtualComponent)component);
                if (provider == null) {
                    return null;
                }
                Object modelObj = provider.getModelObject();
                if (modelObj == null) {
                    return null;
                }
                if (modelObj instanceof org.eclipse.jst.javaee.jca.Connector) {
                    org.eclipse.jst.javaee.jca.Connector conn16 = (org.eclipse.jst.javaee.jca.Connector)modelObj;
                    if (!conn16.isMetadataComplete() && readAnnotations) {
                        boolean overwrite;
                        boolean bl = overwrite = !ConnectorProjectHelper.projectHasRaXMLFile(aConnectorProject);
                        if (conn16 instanceof EObjectImpl) {
                            EObjectImpl eObj = (EObjectImpl)conn16;
                            conn16 = (org.eclipse.jst.javaee.jca.Connector)EcoreUtil.copy((EObject)eObj);
                        }
                        ConnectorProjectHelper.populateFromAnnotations(aConnectorProject, conn16, overwrite);
                    }
                    Connector connector = new Connector(conn16);
                    return connector;
                }
                if (modelObj instanceof org.eclipse.jst.j2ee.jca.Connector) {
                    Connector connector = new Connector((org.eclipse.jst.j2ee.jca.Connector)modelObj);
                    return connector;
                }
            }
            return null;
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    private static URL[] getURLsFromClasspathEntries(IClasspathEntry[] entries, IProject project, List<Object> visitedProjects) throws JavaModelException, MalformedURLException, CoreException {
        return ConnectorProjectHelper.getURLsFromClasspathEntries(entries, project, visitedProjects, false);
    }

    private static URL[] getURLsFromClasspathEntries(IClasspathEntry[] entries, IProject project, List<Object> visitedProjects, boolean ignoreJREJars) throws JavaModelException, MalformedURLException, CoreException {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            ArrayList<URL> resourceURLs = new ArrayList<URL>();
            int i = entries.length;
            block15: while (--i >= 0) {
                URL url = null;
                IClasspathEntry entry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entries[i]);
                IPath path = entry.getPath();
                switch (entry.getEntryKind()) {
                    case 1: {
                        File f = path.toFile();
                        if (f.exists()) {
                            url = f.toURI().toURL();
                        } else {
                            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
                            if (resource != null && resource.exists()) {
                                path = resource.getRawLocation();
                            }
                            if (path == null) {
                                path = resource.getLocation();
                            }
                            String pathStr = path.toOSString();
                            if (resource != null && resource instanceof IFolder) {
                                pathStr = String.valueOf(pathStr) + '/';
                            }
                            url = new URL(FILE_URL_PROTOCOL, null, -1, pathStr);
                        }
                        resourceURLs.add(url);
                        break;
                    }
                    case 3: {
                        IProject referencedProject;
                        IPath outputLocation;
                        IProject referencedProject2;
                        Object srcContainer = null;
                        if (path.segmentCount() > 0 && (srcContainer = (referencedProject2 = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0))) != null && referencedProject2.exists() && path.segmentCount() > 1 ? referencedProject2.getFolder(path.removeFirstSegments(1)) : referencedProject2) != null && srcContainer.exists()) {
                            url = new URL(FILE_URL_PROTOCOL, null, -1, String.valueOf(srcContainer.getLocation().toOSString()) + '/');
                            resourceURLs.add(url);
                        }
                        if ((outputLocation = entry.getOutputLocation()) == null) break;
                        Object outputContainer = null;
                        if (outputLocation.segmentCount() <= 0 || (outputContainer = (referencedProject = ResourcesPlugin.getWorkspace().getRoot().getProject(outputLocation.segment(0))) != null && referencedProject.exists() && outputLocation.segmentCount() > 1 ? referencedProject.getFolder(outputLocation.removeFirstSegments(1)) : referencedProject) == null || !outputContainer.exists()) continue block15;
                        url = new URL(FILE_URL_PROTOCOL, null, -1, String.valueOf(outputContainer.getLocation().toOSString()) + '/');
                        resourceURLs.add(url);
                        break;
                    }
                    case 2: {
                        IProject javaProject = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
                        if (!javaProject.exists()) break;
                        if (visitedProjects != null && visitedProjects.contains(javaProject.getProject())) {
                            Status status = new Status(4, "com.ibm.adapter.j2ca", 4, MessageResource.MSG_ERROR_CYCLE_IN_CLASSPATH, null);
                            throw new CoreException((IStatus)status);
                        }
                        URL[] urls = ConnectorProjectHelper.getProjectClasspath(javaProject, visitedProjects, ignoreJREJars);
                        List<URL> newURLs = Arrays.asList(urls);
                        resourceURLs.addAll(newURLs);
                        break;
                    }
                    case 5: {
                        IPath containerPath;
                        IClasspathContainer container;
                        if (ignoreJREJars && entry.getPath().segment(0).equals("org.eclipse.jdt.launching.JRE_CONTAINER") || (container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)JavaCore.create((IProject)project))) == null || visitedProjects.contains(containerPath = container.getPath())) continue block15;
                        visitedProjects.add(containerPath);
                        URL[] urls = ConnectorProjectHelper.getURLsFromClasspathEntries(container.getClasspathEntries(), project, visitedProjects);
                        List<URL> newURLs = Arrays.asList(urls);
                        resourceURLs.addAll(newURLs);
                        break;
                    }
                    case 4: {
                        url = new URL(FILE_URL_PROTOCOL, null, -1, path.toOSString());
                        resourceURLs.add(url);
                    }
                }
            }
            URL[] urls = new URL[resourceURLs.size()];
            resourceURLs.toArray(urls);
            URL[] uRLArray = urls;
            return uRLArray;
        }
        catch (MalformedURLException e) {
            String message = MessageResource.bind((String)MessageResource.MSG_ERROR__RA_CLASSPATH, (Object)project.getName());
            LogFacility.logErrorMessage((String)message, (Throwable)e);
            throw e;
        }
        catch (JavaModelException e) {
            String message = MessageResource.bind((String)MessageResource.MSG_ERROR__RA_CLASSPATH, (Object)project.getName());
            LogFacility.logErrorMessage((String)message, (Throwable)e);
            throw e;
        }
        catch (CoreException e) {
            String message = MessageResource.bind((String)MessageResource.MSG_ERROR__RA_CLASSPATH, (Object)project.getName());
            LogFacility.logErrorMessage((String)message, (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            String message = MessageResource.bind((String)MessageResource.MSG_ERROR__RA_CLASSPATH, (Object)project.getName());
            LogFacility.logErrorMessage((String)message, (Throwable)e);
            throw e;
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    public static URL[] getURLsFromProject(IProject connectorProject) throws JavaModelException, MalformedURLException, CoreException {
        return ConnectorProjectHelper.getProjectClasspath(connectorProject, new ArrayList<Object>());
    }

    private static URL[] getProjectClasspath(IProject connectorProject, List<Object> visitedProjects) throws JavaModelException, MalformedURLException, CoreException {
        return ConnectorProjectHelper.getProjectClasspath(connectorProject, visitedProjects, false);
    }

    private static URL[] getProjectClasspath(IProject connectorProject, List<Object> visitedProjects, boolean ignoreJREJars) throws JavaModelException, MalformedURLException, CoreException {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            ArrayList<URL> resourceURLs = new ArrayList<URL>();
            IJavaProject connectorJavaProject = JavaCore.create((IProject)connectorProject);
            if (connectorJavaProject.exists()) {
                IProject referencedProject;
                if (visitedProjects == null) {
                    visitedProjects = new ArrayList<Object>();
                }
                if (visitedProjects.contains(connectorProject)) {
                    Status status = new Status(4, "com.ibm.adapter.j2ca", 4, MessageResource.MSG_ERROR_CYCLE_IN_CLASSPATH, null);
                    throw new CoreException((IStatus)status);
                }
                visitedProjects.add(connectorJavaProject);
                IClasspathEntry[] entries = connectorJavaProject.getRawClasspath();
                URL[] projectUrls = ConnectorProjectHelper.getURLsFromClasspathEntries(entries, connectorProject, visitedProjects, ignoreJREJars);
                List<URL> newURLs = Arrays.asList(projectUrls);
                resourceURLs.addAll(newURLs);
                IPath outputPath = connectorJavaProject.getOutputLocation();
                Object outputContainer = null;
                if (outputPath.segmentCount() > 0 && (outputContainer = (referencedProject = ResourcesPlugin.getWorkspace().getRoot().getProject(outputPath.segment(0))) != null && referencedProject.exists() && outputPath.segmentCount() > 1 ? referencedProject.getFolder(outputPath.removeFirstSegments(1)) : referencedProject) != null && outputContainer.exists()) {
                    URL outputURL = new URL(FILE_URL_PROTOCOL, null, -1, String.valueOf(outputContainer.getLocation().toOSString()) + '/');
                    resourceURLs.add(outputURL);
                }
                URL outputURL = new URL(FILE_URL_PROTOCOL, null, -1, String.valueOf(connectorJavaProject.getProject().getLocation().toOSString()) + '/');
                resourceURLs.add(outputURL);
            }
            URL[] urls = new URL[resourceURLs.size()];
            urls = resourceURLs.toArray(urls);
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            URL[] uRLArray = urls;
            return uRLArray;
        }
        catch (JavaModelException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            throw e;
        }
        catch (MalformedURLException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            throw e;
        }
        catch (CoreException e) {
            LogFacility.logErrorMessage((IStatus)e.getStatus());
            throw e;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            Status status = new Status(4, "com.ibm.adapter.j2ca", 4, e.getLocalizedMessage() == null ? "" : e.getLocalizedMessage(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    public static final IVirtualComponent isConnectorProject(IProject project) {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            IVirtualComponent component = ComponentCore.createComponent((IProject)project);
            if (ConnectorArtifactEdit.isValidConnectorModule((IVirtualComponent)component)) {
                IVirtualComponent iVirtualComponent = component;
                return iVirtualComponent;
            }
            return null;
        }
        catch (UnresolveableURIException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    public static URL[] getURLsFromProject(IProject connectorProject, boolean ignoreJREJars) throws JavaModelException, MalformedURLException, CoreException {
        return ConnectorProjectHelper.getProjectClasspath(connectorProject, new ArrayList<Object>(), ignoreJREJars);
    }

    public static void populateFromAnnotations(IProject aConnectorProject, org.eclipse.jst.javaee.jca.Connector conn16, boolean overwrite) {
        try {
            IPackageFragmentRoot[] packageFragmentRoots;
            HashMap<String, Object> annotElemMap = new HashMap<String, Object>();
            HashMap<String, List<ConfigProperty>> configPropMap = new HashMap<String, List<ConfigProperty>>();
            HashMap<String, List<String>> activationSpecMap = new HashMap<String, List<String>>();
            HashMap<String, String> adminObjectMap = new HashMap<String, String>();
            String resourceAdapterClassName = null;
            String mcfClassName = null;
            IJavaProject project = JavaCore.create((IProject)aConnectorProject);
            ArrayList<String> srcClasspathEntries = new ArrayList<String>();
            IClasspathEntry[] iClasspathEntryArray = project.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
                if (classpathEntry.getEntryKind() == 3 && !classpathEntry.getPath().toString().contains(".apt_generated")) {
                    srcClasspathEntries.add(classpathEntry.getPath().toString());
                }
                ++n2;
            }
            IPackageFragmentRoot[] iPackageFragmentRootArray = packageFragmentRoots = project.getPackageFragmentRoots();
            int n3 = packageFragmentRoots.length;
            n = 0;
            while (n < n3) {
                int kind;
                IResource resource;
                IPackageFragmentRoot pkgFragmentRoot = iPackageFragmentRootArray[n];
                String pkgFragmentPath = pkgFragmentRoot.getPath().removeLastSegments(1).toString();
                if (srcClasspathEntries.contains(pkgFragmentPath) && "jar".equals((resource = pkgFragmentRoot.getResource()).getProjectRelativePath().getFileExtension()) && (kind = pkgFragmentRoot.getKind()) == 2) {
                    IJavaElement[] children;
                    IJavaElement[] iJavaElementArray = children = pkgFragmentRoot.getChildren();
                    int n4 = children.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        IJavaElement javaElement = iJavaElementArray[n5];
                        if (javaElement.getElementType() == 4) {
                            IJavaElement[] javaElements;
                            IPackageFragment fragment = (IPackageFragment)javaElement;
                            IJavaElement[] iJavaElementArray2 = javaElements = fragment.getChildren();
                            int n6 = javaElements.length;
                            int n7 = 0;
                            while (n7 < n6) {
                                IJavaElement iJavaElement = iJavaElementArray2[n7];
                                int type = iJavaElement.getElementType();
                                if (type == 6) {
                                    IAnnotation[] annotations;
                                    IClassFile classFile = (IClassFile)iJavaElement;
                                    IType iType = classFile.getType();
                                    IAnnotation[] iAnnotationArray = annotations = iType.getAnnotations();
                                    int n8 = annotations.length;
                                    int n9 = 0;
                                    while (n9 < n8) {
                                        Object[] valueArray;
                                        Object value;
                                        String memberName;
                                        int n10;
                                        IMemberValuePair[] iMemberValuePairArray;
                                        IMemberValuePair memberValuePair;
                                        IMemberValuePair[] valuePairs;
                                        IAnnotation iAnnotation = iAnnotationArray[n9];
                                        if ("javax.resource.spi.Connector".equals(iAnnotation.getElementName())) {
                                            resourceAdapterClassName = iType.getFullyQualifiedName('.');
                                            IMemberValuePair[] iMemberValuePairArray2 = valuePairs = iAnnotation.getMemberValuePairs();
                                            int n11 = valuePairs.length;
                                            int n12 = 0;
                                            while (n12 < n11) {
                                                memberValuePair = iMemberValuePairArray2[n12];
                                                annotElemMap.put(memberValuePair.getMemberName(), memberValuePair.getValue());
                                                ++n12;
                                            }
                                            configPropMap.put(resourceAdapterClassName, ConnectorProjectHelper.getConfigPropsForClass(iType, "javax.resource.spi.ConfigProperty"));
                                        } else if ("javax.resource.spi.ConnectionDefinition".equals(iAnnotation.getElementName())) {
                                            mcfClassName = iType.getFullyQualifiedName('.');
                                            IMemberValuePair[] iMemberValuePairArray3 = valuePairs = iAnnotation.getMemberValuePairs();
                                            int n13 = valuePairs.length;
                                            int n14 = 0;
                                            while (n14 < n13) {
                                                memberValuePair = iMemberValuePairArray3[n14];
                                                annotElemMap.put(memberValuePair.getMemberName(), memberValuePair.getValue());
                                                ++n14;
                                            }
                                            configPropMap.put(mcfClassName, ConnectorProjectHelper.getConfigPropsForClass(iType, "javax.resource.spi.ConfigProperty"));
                                        } else if ("javax.resource.spi.Activation".equals(iAnnotation.getElementName())) {
                                            IMemberValuePair[] valuePairs2;
                                            String asClassName = iType.getFullyQualifiedName('.');
                                            ArrayList<String> msgListeners = new ArrayList<String>();
                                            activationSpecMap.put(asClassName, msgListeners);
                                            iMemberValuePairArray = valuePairs2 = iAnnotation.getMemberValuePairs();
                                            n10 = valuePairs2.length;
                                            int n15 = 0;
                                            while (n15 < n10) {
                                                IMemberValuePair memberValuePair2 = iMemberValuePairArray[n15];
                                                memberName = memberValuePair2.getMemberName();
                                                value = memberValuePair2.getValue();
                                                if ("messageListeners".equals(memberName)) {
                                                    Object[] objectArray = valueArray = ConnectorProjectHelper.getValueArray(value);
                                                    int n16 = valueArray.length;
                                                    int n17 = 0;
                                                    while (n17 < n16) {
                                                        Object object = objectArray[n17];
                                                        msgListeners.add((String)object);
                                                        ++n17;
                                                    }
                                                }
                                                ++n15;
                                            }
                                            configPropMap.put(asClassName, ConnectorProjectHelper.getConfigPropsForClass(iType, "javax.resource.spi.ConfigProperty"));
                                        } else if ("javax.resource.spi.AdministeredObject".equals(iAnnotation.getElementName())) {
                                            String adminObjClassName = iType.getFullyQualifiedName('.');
                                            IMemberValuePair[] valuePairs3 = iAnnotation.getMemberValuePairs();
                                            String interfaceName = null;
                                            iMemberValuePairArray = valuePairs3;
                                            n10 = valuePairs3.length;
                                            int n18 = 0;
                                            while (n18 < n10) {
                                                IMemberValuePair memberValuePair3 = iMemberValuePairArray[n18];
                                                memberName = memberValuePair3.getMemberName();
                                                value = memberValuePair3.getValue();
                                                if ("adminObjectInterfaces".equals(memberName)) {
                                                    valueArray = ConnectorProjectHelper.getValueArray(value);
                                                    interfaceName = (String)valueArray[0];
                                                    break;
                                                }
                                                ++n18;
                                            }
                                            if (interfaceName == null) {
                                                String[] superInterfaceNames;
                                                String[] stringArray = superInterfaceNames = iType.getSuperInterfaceNames();
                                                int n19 = superInterfaceNames.length;
                                                n10 = 0;
                                                while (n10 < n19) {
                                                    String ifName = stringArray[n10];
                                                    if (!"java.io.Serializable".equals(ifName) && !"java.io.Externalizable".equals(ifName)) {
                                                        interfaceName = ifName;
                                                        break;
                                                    }
                                                    ++n10;
                                                }
                                            }
                                            if (interfaceName != null) {
                                                adminObjectMap.put(adminObjClassName, interfaceName);
                                                configPropMap.put(adminObjClassName, ConnectorProjectHelper.getConfigPropsForClass(iType, "javax.resource.spi.ConfigProperty"));
                                            }
                                        }
                                        ++n9;
                                    }
                                }
                                ++n7;
                            }
                        }
                        ++n5;
                    }
                }
                ++n;
            }
            if (resourceAdapterClassName == null || mcfClassName == null) {
                return;
            }
            ConnectorProjectHelper.populateConnectorObjectFromAnnotations(conn16, resourceAdapterClassName, mcfClassName, annotElemMap, configPropMap, activationSpecMap, adminObjectMap, overwrite);
        }
        catch (Exception exc) {
            LogFacility.logErrorMessage((String)MessageResource.MSG_ERROR__RA_PROPS, (Throwable)exc);
        }
    }

    public static Object[] getValueArray(Object value) {
        Object[] valueArray = value.getClass().isArray() ? (Object[])value : new Object[]{value};
        return valueArray;
    }

    /*
     * WARNING - void declaration
     */
    public static void populateConnectorObjectFromAnnotations(org.eclipse.jst.javaee.jca.Connector conn16, String resourceAdapterClassName, String mcfClassName, Map<String, Object> annotElemMap, Map<String, List<ConfigProperty>> configPropMap, Map<String, List<String>> activationSpecMap, Map<String, String> adminObjectMap, boolean overwrite) throws JavaModelException {
        Object workContexts;
        Object secPerm;
        Object secPermissions;
        int n;
        int n2;
        Object authMechanisms;
        String qualifiedTxValue;
        List<ConfigProperty> cpList;
        Boolean reauthSupport;
        Object licenceDesc;
        Boolean licReq;
        String raVersion;
        String vendorName;
        Object displayName;
        Description desc;
        int n4;
        Object description;
        String eisType;
        OutboundResourceAdapter outboundResourceAdapter;
        ResourceAdapter resourceAdapter = conn16.getResourceadapter();
        if (resourceAdapter == null) {
            resourceAdapter = JcaFactory.eINSTANCE.createResourceAdapter();
            conn16.setResourceadapter(resourceAdapter);
        }
        if ((outboundResourceAdapter = resourceAdapter.getOutboundResourceadapter()) == null) {
            outboundResourceAdapter = JcaFactory.eINSTANCE.createOutboundResourceAdapter();
            resourceAdapter.setOutboundResourceadapter(outboundResourceAdapter);
        }
        if ((eisType = (String)annotElemMap.get("eisType")) != null && (overwrite || conn16.getEisType() == null)) {
            conn16.setEisType(eisType);
        }
        if ((description = annotElemMap.get("description")) != null) {
            List descriptions = conn16.getDescriptions();
            if (overwrite || descriptions.isEmpty()) {
                Object[] valueArray;
                descriptions.clear();
                Object[] objectArray = valueArray = ConnectorProjectHelper.getValueArray(description);
                n4 = valueArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    Object object = objectArray[n5];
                    desc = JavaeeFactory.eINSTANCE.createDescription();
                    String theText = (String)object;
                    desc.setValue(theText);
                    desc.setLang("en");
                    descriptions.add(desc);
                    ++n5;
                }
            }
        }
        if ((displayName = annotElemMap.get("displayName")) != null) {
            List displayNames = conn16.getDisplayNames();
            if (overwrite || displayNames.isEmpty()) {
                Description valueArray;
                displayNames.clear();
                desc = valueArray = ConnectorProjectHelper.getValueArray(displayName);
                int n6 = ((Object[])desc).length;
                n4 = 0;
                while (n4 < n6) {
                    Description object = desc[n4];
                    DisplayName dispName = JavaeeFactory.eINSTANCE.createDisplayName();
                    String theText = (String)object;
                    dispName.setValue(theText);
                    dispName.setLang("en");
                    displayNames.add(dispName);
                    ++n4;
                }
            }
        }
        if ((vendorName = (String)annotElemMap.get("vendorName")) != null && (overwrite || conn16.getVendorName() == null)) {
            conn16.setVendorName(vendorName);
        }
        if ((raVersion = (String)annotElemMap.get("version")) != null && (overwrite || conn16.getResourceadapterVersion() == null)) {
            conn16.setResourceadapterVersion(raVersion);
        }
        if ((licReq = (Boolean)annotElemMap.get("licenseRequired")) != null) {
            License license = conn16.getLicense();
            if (overwrite || license == null) {
                if (license == null) {
                    license = JcaFactory.eINSTANCE.createLicense();
                    conn16.setLicense(license);
                }
                license.setLicenseRequired(licReq.booleanValue());
            }
        }
        if ((licenceDesc = annotElemMap.get("licenseDescription")) != null || licReq != null) {
            License license;
            if (licenceDesc == null) {
                licenceDesc = "";
            }
            if ((license = conn16.getLicense()) == null) {
                license = JcaFactory.eINSTANCE.createLicense();
                conn16.setLicense(license);
            }
            List descriptions = license.getDescription();
            if (overwrite || descriptions.isEmpty()) {
                Object[] valueArray;
                descriptions.clear();
                Object[] objectArray = valueArray = ConnectorProjectHelper.getValueArray(licenceDesc);
                int n7 = valueArray.length;
                int n8 = 0;
                while (n8 < n7) {
                    Object object = objectArray[n8];
                    Description desc2 = JavaeeFactory.eINSTANCE.createDescription();
                    String theText = (String)object;
                    desc2.setValue(theText);
                    desc2.setLang("en");
                    descriptions.add(desc2);
                    ++n8;
                }
            }
        }
        if ((reauthSupport = (Boolean)annotElemMap.get("reauthenticationSupport")) != null && (overwrite || !outboundResourceAdapter.isSetReauthenticationSupport())) {
            outboundResourceAdapter.setReauthenticationSupport(reauthSupport.booleanValue());
        }
        if (overwrite || resourceAdapter.getResourceadapterClass() == null) {
            resourceAdapter.setResourceadapterClass(resourceAdapterClassName);
        }
        if ((cpList = configPropMap.get(resourceAdapterClassName)) != null && !cpList.isEmpty()) {
            List configPropertyList = resourceAdapter.getConfigProperty();
            if (overwrite || configPropertyList.isEmpty()) {
                configPropertyList.clear();
                configPropertyList.addAll(cpList);
            }
        }
        if ((qualifiedTxValue = (String)annotElemMap.get("transactionSupport")) != null && (overwrite || !outboundResourceAdapter.isSetTransactionSupport())) {
            int index = qualifiedTxValue.lastIndexOf(46);
            if (index != -1) {
                qualifiedTxValue = qualifiedTxValue.substring(index + 1);
            }
            TransactionSupport transactionSupportType = TransactionSupport.get((String)qualifiedTxValue);
            outboundResourceAdapter.setTransactionSupport(transactionSupportType);
        } else if (overwrite || !outboundResourceAdapter.isSetTransactionSupport()) {
            outboundResourceAdapter.setTransactionSupport(TransactionSupport.NO_TRANSACTION);
        }
        List definitions = outboundResourceAdapter.getConnectionDefinition();
        if (overwrite || definitions.isEmpty()) {
            definitions.clear();
            ConnectionDefinition connDef = JcaFactory.eINSTANCE.createConnectionDefinition();
            connDef.setManagedconnectionfactoryClass(mcfClassName);
            connDef.setConnectionfactoryImplClass((String)annotElemMap.get("connectionFactoryImpl"));
            connDef.setConnectionfactoryInterface((String)annotElemMap.get("connectionFactory"));
            connDef.setConnectionImplClass((String)annotElemMap.get("connectionImpl"));
            connDef.setConnectionInterface((String)annotElemMap.get("connection"));
            cpList = configPropMap.get(mcfClassName);
            if (cpList != null && !cpList.isEmpty()) {
                connDef.getConfigProperty().addAll(cpList);
            }
            definitions.add(connDef);
        }
        if ((authMechanisms = annotElemMap.get("authMechanisms")) != null) {
            List authenticationMechanismList = outboundResourceAdapter.getAuthenticationMechanism();
            if (overwrite || authenticationMechanismList.isEmpty()) {
                authenticationMechanismList.clear();
                Object[] valueArray = ConnectorProjectHelper.getValueArray(authMechanisms);
                Object[] objectArray = valueArray;
                int n3 = valueArray.length;
                int theText = 0;
                while (theText < n3) {
                    IMemberValuePair[] valuePairs;
                    Object object = objectArray[theText];
                    AuthenticationMechanism authenticationMechanism = JcaFactory.eINSTANCE.createAuthenticationMechanism();
                    authenticationMechanism.setCredentialInterface(CredentialInterfaceType.JAVAX_RESOURCE_SPI_SECURITY_PASSWORD_CREDENTIAL);
                    authenticationMechanism.setAuthenticationMechanismType("BasicPassword");
                    authenticationMechanismList.add(authenticationMechanism);
                    IAnnotation annotation = (IAnnotation)object;
                    IMemberValuePair[] iMemberValuePairArray = valuePairs = annotation.getMemberValuePairs();
                    n2 = valuePairs.length;
                    int n5 = 0;
                    while (n5 < n2) {
                        IMemberValuePair valuePair = iMemberValuePairArray[n5];
                        String memberName = valuePair.getMemberName();
                        Object value = valuePair.getValue();
                        if ("authMechanism".equals(memberName)) {
                            authenticationMechanism.setAuthenticationMechanismType((String)value);
                        } else if ("credentialInterface".equals(memberName)) {
                            authenticationMechanism.setCredentialInterface(CredentialInterfaceType.get((String)((String)value)));
                        } else if ("description".equals(memberName)) {
                            Object[] descValueArray;
                            List authDesc = authenticationMechanism.getDescription();
                            Object[] objectArray2 = descValueArray = ConnectorProjectHelper.getValueArray(value);
                            n = descValueArray.length;
                            int n6 = 0;
                            while (n6 < n) {
                                Object descObject = objectArray2[n6];
                                Description desc3 = JavaeeFactory.eINSTANCE.createDescription();
                                String theText2 = (String)descObject;
                                desc3.setValue(theText2);
                                desc3.setLang("en");
                                authDesc.add(desc3);
                                ++n6;
                            }
                        }
                        ++n5;
                    }
                    ++theText;
                }
            }
        }
        if ((secPermissions = annotElemMap.get("securityPermissions")) != null) {
            List securityPermissionList = resourceAdapter.getSecurityPermission();
            if (overwrite || securityPermissionList.isEmpty()) {
                void var26_44;
                Object[] valueArray;
                securityPermissionList.clear();
                Object[] objectArray = valueArray = ConnectorProjectHelper.getValueArray(secPermissions);
                int n11 = valueArray.length;
                boolean bl = false;
                while (var26_44 < n11) {
                    Object object = objectArray[var26_44];
                    secPerm = JcaFactory.eINSTANCE.createSecurityPermission();
                    securityPermissionList.add(secPerm);
                    IAnnotation annotation = (IAnnotation)object;
                    IMemberValuePair[] valuePairs = annotation.getMemberValuePairs();
                    IMemberValuePair[] iMemberValuePairArray = valuePairs;
                    int n7 = valuePairs.length;
                    n2 = 0;
                    while (n2 < n7) {
                        IMemberValuePair valuePair = iMemberValuePairArray[n2];
                        String memberName = valuePair.getMemberName();
                        Object value = valuePair.getValue();
                        if ("permissionSpec".equals(memberName)) {
                            secPerm.setSecurityPermissionSpec((String)value);
                        } else if ("description".equals(memberName)) {
                            Object[] descValueArray;
                            List secDesc = secPerm.getDescription();
                            Object[] objectArray3 = descValueArray = ConnectorProjectHelper.getValueArray(value);
                            int n8 = descValueArray.length;
                            n = 0;
                            while (n < n8) {
                                Object descObject = objectArray3[n];
                                Description desc4 = JavaeeFactory.eINSTANCE.createDescription();
                                String theText = (String)descObject;
                                desc4.setValue(theText);
                                desc4.setLang("en");
                                secDesc.add(desc4);
                                ++n;
                            }
                        }
                        ++n2;
                    }
                    ++var26_44;
                }
            }
        }
        if ((workContexts = annotElemMap.get("requiredWorkContexts")) != null) {
            List requiredWorkContextList = conn16.getRequiredWorkContext();
            if (overwrite || requiredWorkContextList.isEmpty()) {
                requiredWorkContextList.clear();
                SecurityPermission valueArray = ConnectorProjectHelper.getValueArray(workContexts);
                secPerm = valueArray;
                int n9 = ((Object[])secPerm).length;
                int n14 = 0;
                while (n14 < n9) {
                    SecurityPermission securityPermission = secPerm[n14];
                    requiredWorkContextList.add((String)securityPermission);
                    ++n14;
                }
            }
        }
        if (!activationSpecMap.isEmpty()) {
            MessageAdapter messageadapter;
            InboundResourceAdapter inboundResourceadapter = resourceAdapter.getInboundResourceadapter();
            if (inboundResourceadapter == null) {
                inboundResourceadapter = JcaFactory.eINSTANCE.createInboundResourceAdapter();
                resourceAdapter.setInboundResourceadapter(inboundResourceadapter);
            }
            if ((messageadapter = inboundResourceadapter.getMessageadapter()) == null) {
                messageadapter = JcaFactory.eINSTANCE.createMessageAdapter();
                inboundResourceadapter.setMessageadapter(messageadapter);
            }
            List list = messageadapter.getMessagelistener();
            if (overwrite || list.isEmpty()) {
                list.clear();
                Set<Map.Entry<String, List<String>>> entrySet = activationSpecMap.entrySet();
                for (Map.Entry entry : entrySet) {
                    String asClassName = (String)entry.getKey();
                    ActivationSpec as = JcaFactory.eINSTANCE.createActivationSpec();
                    as.setActivationspecClass(asClassName);
                    List<ConfigProperty> asCpList = configPropMap.get(asClassName);
                    if (asCpList != null && !asCpList.isEmpty()) {
                        List configPropertyList = as.getConfigProperty();
                        if (overwrite || configPropertyList.isEmpty()) {
                            configPropertyList.clear();
                            configPropertyList.addAll(asCpList);
                        }
                    }
                    List listenerTypeList = (List)entry.getValue();
                    for (String listenerClassName : listenerTypeList) {
                        MessageListener listener = JcaFactory.eINSTANCE.createMessageListener();
                        list.add(listener);
                        listener.setActivationspec(as);
                        listener.setMessagelistenerType(listenerClassName);
                    }
                }
            }
        }
        if (!adminObjectMap.isEmpty()) {
            List adminObjectList = conn16.getResourceadapter().getAdminobject();
            if (overwrite || adminObjectList.isEmpty()) {
                adminObjectList.clear();
                Set<Map.Entry<String, String>> entrySet = adminObjectMap.entrySet();
                for (Map.Entry entry : entrySet) {
                    String string = (String)entry.getKey();
                    String interfaceName = (String)entry.getValue();
                    AdminObject adminObj = JcaFactory.eINSTANCE.createAdminObject();
                    adminObjectList.add(adminObj);
                    adminObj.setAdminobjectClass(string);
                    adminObj.setAdminobjectInterface(interfaceName);
                    List<ConfigProperty> props = configPropMap.get(string);
                    if (props == null || props.isEmpty()) continue;
                    adminObj.getConfigProperty().addAll(props);
                }
            }
        }
    }

    public static List<ConfigProperty> getConfigPropsForClass(IType iType, String annotation) throws JavaModelException {
        IMethod[] methods;
        IField[] fields;
        ArrayList<ConfigProperty> configProps = new ArrayList<ConfigProperty>();
        IField[] iFieldArray = fields = iType.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            ConfigProperty configProp;
            IField iField = iFieldArray[n2];
            IAnnotation iAnnotation = iField.getAnnotation(annotation);
            if (!(!iAnnotation.exists() || (configProp = ConnectorProjectHelper.getConfigPropFromAnnotation(iAnnotation)).isSetConfigPropertyIgnore() && configProp.isConfigPropertyIgnore())) {
                configProps.add(configProp);
                if (!configProp.isSetConfigPropertyType()) {
                    String type = Signature.toString((String)iField.getTypeSignature());
                    configProp.setConfigPropertyType(ConfigPropertyTypeType.get((String)type));
                }
                if (configProp.getConfigPropertyName() == null) {
                    configProp.setConfigPropertyName(iField.getElementName());
                }
            }
            ++n2;
        }
        IMethod[] iMethodArray = methods = iType.getMethods();
        int n3 = methods.length;
        n = 0;
        while (n < n3) {
            ConfigProperty configProp;
            IMethod iMethod = iMethodArray[n];
            IAnnotation iAnnotation = iMethod.getAnnotation(annotation);
            if (!(!iAnnotation.exists() || (configProp = ConnectorProjectHelper.getConfigPropFromAnnotation(iAnnotation)).isSetConfigPropertyIgnore() && configProp.isConfigPropertyIgnore())) {
                configProps.add(configProp);
                if (!configProp.isSetConfigPropertyType()) {
                    String type = Signature.toString((String)iMethod.getParameterTypes()[0]);
                    configProp.setConfigPropertyType(ConfigPropertyTypeType.get((String)type));
                }
                if (configProp.getConfigPropertyName() == null) {
                    String name = iMethod.getElementName();
                    if (name.startsWith("set")) {
                        name = name.substring(3);
                    }
                    configProp.setConfigPropertyName(name);
                }
            }
            ++n;
        }
        return configProps;
    }

    public static ConfigProperty getConfigPropFromAnnotation(IAnnotation iAnnotation) throws JavaModelException {
        IMemberValuePair[] memberValuePairs;
        ConfigProperty configProp = JcaFactory.eINSTANCE.createConfigProperty();
        IMemberValuePair[] iMemberValuePairArray = memberValuePairs = iAnnotation.getMemberValuePairs();
        int n = memberValuePairs.length;
        int n2 = 0;
        while (n2 < n) {
            IMemberValuePair valuePair = iMemberValuePairArray[n2];
            String memberName = valuePair.getMemberName();
            Object value = valuePair.getValue();
            if ("confidential".equals(memberName)) {
                configProp.setConfigPropertyConfidential(((Boolean)value).booleanValue());
            } else if ("ignore".equals(memberName)) {
                configProp.setConfigPropertyIgnore(((Boolean)value).booleanValue());
            } else if ("supportsDynamicUpdates".equals(memberName)) {
                configProp.setConfigPropertySupportsDynamicUpdates(((Boolean)value).booleanValue());
            } else if ("defaultValue".equals(memberName)) {
                configProp.setConfigPropertyValue((String)value);
            } else if ("description".equals(memberName)) {
                Object[] valueArray = ConnectorProjectHelper.getValueArray(value);
                List descriptions = configProp.getDescription();
                Object[] objectArray = valueArray;
                int n3 = valueArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object object = objectArray[n4];
                    Description desc = JavaeeFactory.eINSTANCE.createDescription();
                    String theText = (String)object;
                    desc.setValue(theText);
                    desc.setLang("en");
                    descriptions.add(desc);
                    ++n4;
                }
            } else if ("type".equals(memberName)) {
                configProp.setConfigPropertyType(ConfigPropertyTypeType.get((String)((String)value)));
            }
            ++n2;
        }
        return configProp;
    }
}

