/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.j2ca.internal;

import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.IDiscoveryAgent;
import com.ibm.adapter.framework.internal.build.IBuildAgent;
import com.ibm.adapter.j2ca.Connector;
import com.ibm.adapter.j2ca.ConnectorProjectDescriptor;
import com.ibm.adapter.j2ca.IResourceAdapterDescriptor;
import com.ibm.adapter.j2ca.internal.J2caPlugin;
import com.ibm.adapter.j2ca.internal.LogFacility;
import com.ibm.adapter.j2ca.internal.ResourceAdapterDescriptorConstants;
import com.ibm.adapter.j2ca.spi.util.BundleClassLoader;
import com.ibm.adapter.j2ca.spi.util.ConnectorProjectHelper;
import com.ibm.adapter.j2ca.spi.util.InMemoryClassLoader;
import com.ibm.adapter.j2ca.spi.util.WASRuntimeLocator;
import com.ibm.adapter.j2ca.spi.util.WASRuntimeUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.resource.cci.ConnectionSpec;
import javax.resource.cci.InteractionSpec;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.j2ee.jca.AdminObject;
import org.eclipse.jst.j2ee.jca.ConnectionDefinition;
import org.eclipse.jst.j2ee.jca.InboundResourceAdapter;
import org.eclipse.jst.j2ee.jca.OutboundResourceAdapter;
import org.eclipse.jst.javaee.jca.MessageListener;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;
import org.osgi.framework.Bundle;

public class ResourceAdapterDescriptorImpl
implements IResourceAdapterDescriptor,
ResourceAdapterDescriptorConstants {
    private static Map<Byte, ArrayList<URL>> _extraAdapterJarURITable = new HashMap<Byte, ArrayList<URL>>(3);
    private List<IResourceAdapterDescriptor.IAdminObjectDescriptor> _adminObjects = Collections.synchronizedList(new ArrayList());
    private List<String> _connectionSpecNames = Collections.synchronizedList(new ArrayList());
    private Connector _connector;
    private IProject _connectorProject;
    private IDiscoveryAgent _discoveryAgent;
    private boolean _hasDiscoveryAgent = false;
    private IBuildAgent _buildAgent;
    private boolean _hasBuildAgent = false;
    private List<String> _interactionSpecNames = Collections.synchronizedList(new ArrayList());
    private boolean _isAdminObjectInitialized = false;
    private boolean _isClassLoaderInitialized = false;
    private boolean _isConnectionSpecInitialized = false;
    private boolean _isInboundResourceAdapter = false;
    private boolean _isInteractionSpecInitialized = false;
    private boolean _isMCFInitialized = false;
    private boolean _isMessageListenerInitialized = false;
    private boolean _isOutboundResourceAdapter = false;
    private boolean _isRABeanInitialized = false;
    private List<String> _managedConnectionFactoryNames = Collections.synchronizedList(new ArrayList());
    private List<IResourceAdapterDescriptor.IMessageListenerDescriptor> _messageListeners = Collections.synchronizedList(new ArrayList());
    private String _resourceAdapterBeanName;
    private Class<ResourceAdapter> _resourceAdapterBeanClass;
    private ClassLoader loader = null;
    private List<Thread> waitingListeners = Collections.synchronizedList(new ArrayList());
    private Map<String, Object> extendedData = Collections.synchronizedMap(new HashMap());
    private org.eclipse.jst.javaee.jca.Connector _javaEE16Connector;

    public ResourceAdapterDescriptorImpl(IDiscoveryAgent discoveryAgent, IProject connectorProject) {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        if (LogFacility.trace) {
            LogFacility.Trace((String)new StringBuffer("Creating Resource Adapter Descriptor for: ").append(connectorProject.getName()).toString(), (short)10);
        }
        try {
            this._connector = ConnectorProjectHelper.getConnector(connectorProject, true);
            if (this._connector == null) {
                return;
            }
            try {
                this._connectorProject = connectorProject;
                String specVer = this._connector.getSpecVersion();
                if ("1.0".equals(specVer)) {
                    this._isOutboundResourceAdapter = true;
                }
                if ("1.5".equals(specVer)) {
                    if (this._connector.getJca15Connector().getResourceAdapter().getOutboundResourceAdapter() != null) {
                        this._isOutboundResourceAdapter = true;
                    }
                    if (this._connector.getJca15Connector().getResourceAdapter().getInboundResourceAdapter() != null) {
                        this._isInboundResourceAdapter = true;
                    }
                } else if ("1.6".equals(specVer)) {
                    if (this._connector.getJca16Connector().getResourceadapter().getOutboundResourceadapter() != null) {
                        this._isOutboundResourceAdapter = true;
                    }
                    if (this._connector.getJca16Connector().getResourceadapter().getInboundResourceadapter() != null) {
                        this._isInboundResourceAdapter = true;
                    }
                }
                if (discoveryAgent != null) {
                    this._discoveryAgent = discoveryAgent;
                    this._hasDiscoveryAgent = true;
                }
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    public ResourceAdapterDescriptorImpl(IDiscoveryAgent discoveryAgent, IBuildAgent buildAgent, IProject connectorProject) {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        if (LogFacility.trace) {
            LogFacility.Trace((String)new StringBuffer("Creating Resource Adapter Descriptor for: ").append(connectorProject.getName()).toString(), (short)10);
        }
        try {
            try {
                this._connector = ConnectorProjectHelper.getConnector(connectorProject, true);
                this._connectorProject = connectorProject;
                String specVer = this._connector.getSpecVersion();
                if ("1.0".equals(specVer)) {
                    this._isOutboundResourceAdapter = true;
                }
                if ("1.5".equals(specVer)) {
                    if (this._connector.getJca15Connector().getResourceAdapter().getOutboundResourceAdapter() != null) {
                        this._isOutboundResourceAdapter = true;
                    }
                    if (this._connector.getJca15Connector().getResourceAdapter().getInboundResourceAdapter() != null) {
                        this._isInboundResourceAdapter = true;
                    }
                } else if ("1.6".equals(specVer)) {
                    if (this._connector.getJca16Connector().getResourceadapter().getOutboundResourceadapter() != null) {
                        this._isOutboundResourceAdapter = true;
                    }
                    if (this._connector.getJca16Connector().getResourceadapter().getInboundResourceadapter() != null) {
                        this._isInboundResourceAdapter = true;
                    }
                }
                if (discoveryAgent != null) {
                    this._discoveryAgent = discoveryAgent;
                    this._hasDiscoveryAgent = true;
                }
                if (buildAgent != null) {
                    this._buildAgent = buildAgent;
                    this._hasBuildAgent = true;
                }
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
            }
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    public void addAdminObject(String adminObjectInterface, String adminObjectImplClass) {
        block13: {
            if (LogFacility.trace) {
                LogFacility.TrcEntry();
            }
            try {
                if (!this._isInboundResourceAdapter) break block13;
                try {
                    this.initializeAdminObjects();
                }
                catch (BaseException e) {
                    LogFacility.logErrorMessage((IStatus)e.getStatus());
                    if (LogFacility.trace) {
                        LogFacility.TrcExit();
                    }
                    if (LogFacility.trace) {
                        LogFacility.TrcExit();
                    }
                    return;
                }
                try {
                    AdminObjectDescriptorImpl adminObject = new AdminObjectDescriptorImpl();
                    adminObject.setInterfaceName(adminObjectInterface);
                    adminObject.setImplClassName(adminObjectImplClass);
                    if (!this._adminObjects.contains(adminObject)) {
                        this._adminObjects.add(adminObject);
                    }
                }
                catch (RuntimeException e) {
                    LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            finally {
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
            }
        }
    }

    public void addConnectionSpec(String connectionSpecName) {
        block12: {
            if (LogFacility.trace) {
                LogFacility.TrcEntry();
            }
            try {
                if (!this._isOutboundResourceAdapter) break block12;
                try {
                    this.initializeConnectionSpecs();
                }
                catch (BaseException e) {
                    LogFacility.logErrorMessage((IStatus)e.getStatus());
                    if (LogFacility.trace) {
                        LogFacility.TrcExit();
                    }
                    return;
                }
                try {
                    if (!this._connectionSpecNames.contains(connectionSpecName)) {
                        this._connectionSpecNames.add(connectionSpecName);
                    }
                }
                catch (RuntimeException e) {
                    LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            finally {
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
            }
        }
    }

    public void addInteractionSpec(String interactionSpecName) {
        block12: {
            if (LogFacility.trace) {
                LogFacility.TrcEntry();
            }
            try {
                if (!this._isOutboundResourceAdapter) break block12;
                try {
                    this.initializeInteractionSpecs();
                }
                catch (BaseException e) {
                    LogFacility.logErrorMessage((IStatus)e.getStatus());
                    if (LogFacility.trace) {
                        LogFacility.TrcExit();
                    }
                    return;
                }
                try {
                    if (!this._interactionSpecNames.contains(interactionSpecName)) {
                        this._interactionSpecNames.add(interactionSpecName);
                    }
                }
                catch (RuntimeException e) {
                    LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            finally {
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
            }
        }
    }

    public void addManagedConnectionFactory(String managedConnectionFactory) {
        block12: {
            if (LogFacility.trace) {
                LogFacility.TrcEntry();
            }
            try {
                if (!this._isOutboundResourceAdapter) break block12;
                try {
                    this.initializeManagedConnectionFactories();
                }
                catch (BaseException e) {
                    LogFacility.logErrorMessage((IStatus)e.getStatus());
                    if (LogFacility.trace) {
                        LogFacility.TrcExit();
                    }
                    return;
                }
                try {
                    if (!this._managedConnectionFactoryNames.contains(managedConnectionFactory)) {
                        this._managedConnectionFactoryNames.add(managedConnectionFactory);
                    }
                }
                catch (RuntimeException e) {
                    LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            finally {
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
            }
        }
    }

    public void addWaitingListener(Thread listener) {
        this.waitingListeners.add(listener);
    }

    @Override
    public IResourceAdapterDescriptor.IAdminObjectDescriptor[] getAdminObjects() {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            if (this._isInboundResourceAdapter && this._adminObjects != null) {
                try {
                    this.initializeAdminObjects();
                }
                catch (BaseException e) {
                    LogFacility.logErrorMessage((IStatus)e.getStatus());
                }
                IResourceAdapterDescriptor.IAdminObjectDescriptor[] iAdminObjectDescriptorArray = this._adminObjects.toArray(new IResourceAdapterDescriptor.IAdminObjectDescriptor[0]);
                return iAdminObjectDescriptorArray;
            }
            return null;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    @Override
    public ClassLoader getClassLoader() {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            this.initializeClassLoader();
        }
        catch (BaseException e) {
            LogFacility.logErrorMessage((IStatus)e.getStatus());
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
        return this.loader;
    }

    @Override
    public Class<ConnectionSpec> getConnectionSpecClass(String connectionSpec) {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            this.initializeConnectionSpecs();
            if (this._connectionSpecNames.contains(connectionSpec)) {
                Class<ConnectionSpec> clazz = this.loadClass(connectionSpec);
                return clazz;
            }
            return null;
        }
        catch (BaseException e1) {
            LogFacility.logErrorMessage((IStatus)e1.getStatus());
            return null;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public String[] getConnectionSpecNames() {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            if (this._isOutboundResourceAdapter && this._connectionSpecNames != null) {
                try {
                    this.initializeConnectionSpecs();
                }
                catch (BaseException e) {
                    LogFacility.logErrorMessage((IStatus)e.getStatus());
                    if (LogFacility.trace) {
                        LogFacility.TrcExit();
                    }
                    return null;
                }
                catch (RuntimeException e) {
                    block12: {
                        LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                        if (!LogFacility.trace) break block12;
                        LogFacility.TrcExit();
                    }
                    return null;
                }
                String[] stringArray = this._connectionSpecNames.toArray(new String[0]);
                return stringArray;
            }
            return null;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    @Override
    public IType getConnectionSpecType(String connectionSpec) {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            try {
                this.initializeConnectionSpecs();
            }
            catch (BaseException e1) {
                LogFacility.logErrorMessage((IStatus)e1.getStatus());
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
                return null;
            }
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            return null;
        }
        if (this._connectionSpecNames.contains(connectionSpec)) {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            return this.getJavaType(connectionSpec);
        }
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
        return null;
    }

    @Override
    public Connector getConnector() {
        return this._connector;
    }

    @Override
    public IProject getConnectorProject() {
        return this._connectorProject;
    }

    @Override
    public IDiscoveryAgent getDiscoveryAgent() {
        if (this.hasDiscoveryAgent()) {
            return this._discoveryAgent;
        }
        return null;
    }

    @Override
    public IBuildAgent getBuildAgent() {
        if (this.hasBuildAgent()) {
            return this._buildAgent;
        }
        return null;
    }

    @Override
    public Class<InteractionSpec> getInteractionSpecClass(String interactionSpec) {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            try {
                this.initializeInteractionSpecs();
            }
            catch (BaseException e1) {
                LogFacility.logErrorMessage((IStatus)e1.getStatus());
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
                return null;
            }
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            return null;
        }
        if (this._interactionSpecNames.contains(interactionSpec)) {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            return this.loadClass(interactionSpec);
        }
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String[] getInteractionSpecNames() {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            if (this._isOutboundResourceAdapter && this._interactionSpecNames != null) {
                try {
                    this.initializeInteractionSpecs();
                }
                catch (BaseException e) {
                    LogFacility.logErrorMessage((IStatus)e.getStatus());
                    if (LogFacility.trace) {
                        LogFacility.TrcExit();
                    }
                    return null;
                }
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
                return this._interactionSpecNames.toArray(new String[0]);
            }
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            return null;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            return null;
        }
    }

    @Override
    public IType getInteractionSpecType(String interactionSpec) {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            try {
                this.initializeInteractionSpecs();
            }
            catch (BaseException e1) {
                LogFacility.logErrorMessage((IStatus)e1.getStatus());
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
                return null;
            }
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            return null;
        }
        if (this._interactionSpecNames.contains(interactionSpec)) {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            return this.getJavaType(interactionSpec);
        }
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
        return null;
    }

    @Override
    public Class<ManagedConnectionFactory> getManagedConnectionFactoryClass(String managedConnectionFactory) {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            try {
                this.initializeManagedConnectionFactories();
            }
            catch (BaseException e1) {
                LogFacility.logErrorMessage((IStatus)e1.getStatus());
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
                return null;
            }
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            return null;
        }
        if (this._managedConnectionFactoryNames.contains(managedConnectionFactory)) {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            return this.loadClass(managedConnectionFactory);
        }
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String[] getManagedConnectionFactoryNames() {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            if (this._isOutboundResourceAdapter && this._managedConnectionFactoryNames != null) {
                try {
                    this.initializeManagedConnectionFactories();
                }
                catch (BaseException e) {
                    LogFacility.logErrorMessage((IStatus)e.getStatus());
                    if (LogFacility.trace) {
                        LogFacility.TrcExit();
                    }
                    return null;
                }
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
                return this._managedConnectionFactoryNames.toArray(new String[0]);
            }
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            return null;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            return null;
        }
    }

    @Override
    public IType getManagedConnectionFactoryType(String managedConnectionFactory) {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            try {
                this.initializeManagedConnectionFactories();
            }
            catch (BaseException e1) {
                LogFacility.logErrorMessage((IStatus)e1.getStatus());
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
                return null;
            }
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            return null;
        }
        if (this._managedConnectionFactoryNames.contains(managedConnectionFactory)) {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            return this.getJavaType(managedConnectionFactory);
        }
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IResourceAdapterDescriptor.IMessageListenerDescriptor[] getMessageListeners() {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            if (this._isInboundResourceAdapter && this._messageListeners != null) {
                try {
                    this.initializeMessageListeners();
                }
                catch (BaseException e) {
                    LogFacility.logErrorMessage((IStatus)e.getStatus());
                    if (LogFacility.trace) {
                        LogFacility.TrcExit();
                    }
                    return null;
                }
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
                return this._messageListeners.toArray(new IResourceAdapterDescriptor.IMessageListenerDescriptor[0]);
            }
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            return null;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            return null;
        }
    }

    @Override
    public Class<ResourceAdapter> getResouceAdapterBeanClass() {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            this.initializeResourceAdapterBean();
        }
        catch (BaseException e) {
            LogFacility.logErrorMessage((IStatus)e.getStatus());
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
        return this._resourceAdapterBeanClass;
    }

    @Override
    public String getResouceAdapterBeanName() {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            this.initializeResourceAdapterBean();
        }
        catch (BaseException e) {
            LogFacility.logErrorMessage((IStatus)e.getStatus());
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
        return this._resourceAdapterBeanName;
    }

    @Override
    public String getSpecVersion() {
        return this._connector.getSpecVersion();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized boolean hasDiscoveryAgent() {
        if (!LogFacility.trace) ** GOTO lbl-1000
        LogFacility.TrcEntry();
        try lbl-1000:
        // 3 sources

        {
            while (!this.waitingListeners.isEmpty() && !this.waitingListeners.contains(Thread.currentThread())) {
                try {
                    this.wait(0L);
                }
                catch (InterruptedException e) {
                    LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
        return this._hasDiscoveryAgent;
    }

    public void refreshClassLoader() throws BaseException {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            try {
                if (this.loader != null && this.loader instanceof InMemoryClassLoader) {
                    ((InMemoryClassLoader)this.loader).closeOpenJars();
                }
                this._isClassLoaderInitialized = false;
                this.initializeClassLoader();
                if (this._isInteractionSpecInitialized) {
                    this._isInteractionSpecInitialized = false;
                }
                if (this._isConnectionSpecInitialized) {
                    this._isConnectionSpecInitialized = false;
                }
                if (this._isMCFInitialized) {
                    this._isMCFInitialized = false;
                }
                if (this._isRABeanInitialized) {
                    this._isRABeanInitialized = false;
                }
                if (this._isAdminObjectInitialized) {
                    this._isAdminObjectInitialized = false;
                }
                if (this._isMessageListenerInitialized) {
                    this._isMessageListenerInitialized = false;
                }
            }
            catch (BaseException e) {
                LogFacility.logErrorMessage((IStatus)e.getStatus());
                throw e;
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    public void refreshDeploymentDescriptor() throws BaseException {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            try {
                this._connector = ConnectorProjectHelper.getConnector(this._connectorProject, true);
                if (this._isMCFInitialized) {
                    this._isMCFInitialized = false;
                }
                if (this._isRABeanInitialized) {
                    this._isRABeanInitialized = false;
                }
                if (this._isAdminObjectInitialized) {
                    this._isAdminObjectInitialized = false;
                }
                if (this._isMessageListenerInitialized) {
                    this._isMessageListenerInitialized = false;
                }
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    public void removeConnectionSpec(String specName) {
        block10: {
            if (LogFacility.trace) {
                LogFacility.TrcEntry();
            }
            try {
                try {
                    if (!this._isOutboundResourceAdapter) break block10;
                    try {
                        this.initializeConnectionSpecs();
                    }
                    catch (BaseException e) {
                        LogFacility.logErrorMessage((IStatus)e.getStatus());
                    }
                    this._connectionSpecNames.remove(specName);
                }
                catch (RuntimeException e) {
                    LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                    if (LogFacility.trace) {
                        LogFacility.TrcExit();
                    }
                }
            }
            finally {
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
            }
        }
    }

    public void removeInteractionSpec(String specName) {
        block10: {
            if (LogFacility.trace) {
                LogFacility.TrcEntry();
            }
            try {
                try {
                    if (!this._isOutboundResourceAdapter) break block10;
                    try {
                        this.initializeInteractionSpecs();
                    }
                    catch (BaseException e) {
                        LogFacility.logErrorMessage((IStatus)e.getStatus());
                    }
                    this._interactionSpecNames.remove(specName);
                }
                catch (RuntimeException e) {
                    LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                    if (LogFacility.trace) {
                        LogFacility.TrcExit();
                    }
                }
            }
            finally {
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
            }
        }
    }

    public void removeManagedConnectionFactory(String factoryName) {
        block10: {
            if (LogFacility.trace) {
                LogFacility.TrcEntry();
            }
            try {
                try {
                    if (!this._isOutboundResourceAdapter) break block10;
                    try {
                        this.initializeManagedConnectionFactories();
                    }
                    catch (BaseException e) {
                        LogFacility.logErrorMessage((IStatus)e.getStatus());
                    }
                    this._managedConnectionFactoryNames.remove(factoryName);
                }
                catch (RuntimeException e) {
                    LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                    if (LogFacility.trace) {
                        LogFacility.TrcExit();
                    }
                }
            }
            finally {
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
            }
        }
    }

    public void removeWaitingListener(Thread listener) {
        this.waitingListeners.remove(listener);
    }

    public synchronized void setDiscoveryAgent(IDiscoveryAgent newAgent) {
        this._discoveryAgent = newAgent;
        this._hasDiscoveryAgent = newAgent != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IType getJavaType(String typeName) {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            if (typeName == null) return null;
            try {
                IJavaProject javaProject = JavaCore.create((IProject)this._connectorProject);
                IType iType = javaProject.findType(typeName);
                return iType;
            }
            catch (JavaModelException e) {
                try {
                    LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                    if (!LogFacility.trace) return null;
                }
                catch (RuntimeException e2) {
                    LogFacility.logErrorMessage((String)e2.getLocalizedMessage(), (Throwable)e2);
                    return null;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                LogFacility.TrcExit();
                return null;
            }
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    private void initializeAdminObjects() throws BaseException {
        block25: {
            if (LogFacility.trace) {
                LogFacility.TrcEntry();
            }
            try {
                try {
                    if (this._isAdminObjectInitialized || !this._isInboundResourceAdapter) break block25;
                    this.initializeClassLoader();
                    ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(this.getClassLoader());
                    if (this._connector.is15Connector()) {
                        try {
                            EList adminObjects = this._connector.getJca15Connector().getResourceAdapter().getAdminObjects();
                            if (adminObjects != null) {
                                Iterator iter = adminObjects.iterator();
                                while (iter.hasNext()) {
                                    try {
                                        AdminObject adminObj = (AdminObject)iter.next();
                                        String adminObjInterface = adminObj.getAdminObjectInterface();
                                        String adminObjClass = adminObj.getAdminObjectClass();
                                        AdminObjectDescriptorImpl adminObjectDescriptor = new AdminObjectDescriptorImpl();
                                        adminObjectDescriptor.setAdminObject(adminObj);
                                        adminObjectDescriptor.setInterfaceName(adminObjInterface);
                                        adminObjectDescriptor.setImplClassName(adminObjClass);
                                        this._adminObjects.add(adminObjectDescriptor);
                                    }
                                    catch (RuntimeException e) {
                                        LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                                    }
                                }
                            }
                            this._isAdminObjectInitialized = true;
                            break block25;
                        }
                        finally {
                            Thread.currentThread().setContextClassLoader(oldLoader);
                        }
                    }
                    try {
                        List adminObjects = this._connector.getJca16Connector().getResourceadapter().getAdminobject();
                        if (adminObjects != null) {
                            Iterator iter = adminObjects.iterator();
                            while (iter.hasNext()) {
                                try {
                                    org.eclipse.jst.javaee.jca.AdminObject adminObj = (org.eclipse.jst.javaee.jca.AdminObject)iter.next();
                                    String adminObjInterface = adminObj.getAdminobjectInterface();
                                    String adminObjClass = adminObj.getAdminobjectClass();
                                    AdminObjectDescriptorImpl adminObjectDescriptor = new AdminObjectDescriptorImpl();
                                    adminObjectDescriptor.setJca16AdminObject(adminObj);
                                    adminObjectDescriptor.setInterfaceName(adminObjInterface);
                                    adminObjectDescriptor.setImplClassName(adminObjClass);
                                    this._adminObjects.add(adminObjectDescriptor);
                                }
                                catch (RuntimeException e) {
                                    LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                                }
                            }
                        }
                        this._isAdminObjectInitialized = true;
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(oldLoader);
                    }
                }
                catch (BaseException e) {
                    LogFacility.logErrorMessage((IStatus)e.getStatus());
                    if (LogFacility.trace) {
                        LogFacility.TrcExit();
                    }
                    throw e;
                }
                catch (RuntimeException e) {
                    LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                    if (LogFacility.trace) {
                        LogFacility.TrcExit();
                    }
                    throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            finally {
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeClassLoader() throws BaseException {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        if (!this._isClassLoaderInitialized) {
            IProject iProject = this._connectorProject;
            synchronized (iProject) {
                if (this._isClassLoaderInitialized) {
                    return;
                }
                try {
                    if (this.loader != null && this.loader instanceof InMemoryClassLoader) {
                        ((InMemoryClassLoader)this.loader).closeOpenJars();
                    }
                    URL[] projectURLs = ConnectorProjectHelper.getURLsFromProject(this._connectorProject, true);
                    projectURLs = this.addExtraAdapterJars(projectURLs);
                    projectURLs = this.addExtraFolders(projectURLs);
                    Bundle bundle = Platform.getBundle((String)"com.ibm.adapter.emd");
                    if (bundle == null) {
                        bundle = J2caPlugin.getDefault().getBundle();
                    }
                    this.loader = new BundleClassLoader(bundle, projectURLs);
                    ((BundleClassLoader)this.loader).setCacheJarsMode(true);
                    this._isClassLoaderInitialized = true;
                }
                catch (CoreException e) {
                    LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                    if (LogFacility.trace) {
                        LogFacility.TrcExit();
                    }
                    throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
                }
                catch (MalformedURLException e) {
                    LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                    if (LogFacility.trace) {
                        LogFacility.TrcExit();
                    }
                    throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
                }
                catch (RuntimeException e) {
                    LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                    if (LogFacility.trace) {
                        LogFacility.TrcExit();
                    }
                    throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URL[] addExtraAdapterJars(URL[] projectURLs) throws CoreException {
        IRuntime serverRuntime;
        IFacetedProject facetProj = ProjectFacetsManager.create((IProject)this._connectorProject);
        org.eclipse.wst.common.project.facet.core.runtime.IRuntime facetRuntime = facetProj.getPrimaryRuntime();
        if (facetRuntime != null && WASRuntimeUtil.isWASv70OrLaterRuntime(serverRuntime = FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)facetRuntime))) {
            byte locatorStubType;
            ArrayList<URL> extraAdapterJarURLs = null;
            if (serverRuntime.isStub()) {
                locatorStubType = WASRuntimeLocator.convertGenericToLocatorRuntimeType(serverRuntime);
            } else {
                byte locatorServerType = WASRuntimeLocator.convertGenericToLocatorRuntimeType(serverRuntime);
                locatorStubType = WASRuntimeLocator.getStubServerType(locatorServerType);
            }
            Map<Byte, ArrayList<URL>> locatorServerType = _extraAdapterJarURITable;
            synchronized (locatorServerType) {
                extraAdapterJarURLs = _extraAdapterJarURITable.get(locatorStubType);
                if (extraAdapterJarURLs == null) {
                    File[] jarsToAdd;
                    IPath runtimeStubPath = null;
                    runtimeStubPath = serverRuntime.isStub() ? serverRuntime.getLocation() : WASRuntimeLocator.getRuntimeStubLocation(locatorStubType);
                    if (runtimeStubPath == null) {
                        return projectURLs;
                    }
                    extraAdapterJarURLs = new ArrayList();
                    IPath jarPath = runtimeStubPath.append("adapterJars");
                    File jarDir = new File(jarPath.toOSString());
                    if (jarDir.exists() && (jarsToAdd = jarDir.listFiles()).length != 0) {
                        int i = 0;
                        while (i < jarsToAdd.length) {
                            try {
                                extraAdapterJarURLs.add(jarsToAdd[i].toURI().toURL());
                            }
                            catch (MalformedURLException malformedURLException) {}
                            ++i;
                        }
                    }
                    _extraAdapterJarURITable.put(locatorStubType, extraAdapterJarURLs);
                }
            }
            if (extraAdapterJarURLs != null && !extraAdapterJarURLs.isEmpty()) {
                ArrayList<URL> urlList = new ArrayList<URL>(Arrays.asList(projectURLs));
                urlList.addAll(extraAdapterJarURLs);
                projectURLs = urlList.toArray(new URL[urlList.size()]);
            }
        }
        return projectURLs;
    }

    private void initializeConnectionSpecs() throws BaseException {
        block14: {
            if (LogFacility.trace) {
                LogFacility.TrcEntry();
            }
            try {
                try {
                    if (this._isConnectionSpecInitialized || !this._isOutboundResourceAdapter) break block14;
                    this.initializeClassLoader();
                    ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(this.getClassLoader());
                    try {
                        Class<?>[] connectionSpecs = ConnectorProjectHelper.findConnectionSpecs(this._connectorProject, this.loader);
                        if (connectionSpecs != null) {
                            int i = 0;
                            while (i < connectionSpecs.length) {
                                String connectionSpecName = connectionSpecs[i].getName();
                                if (!this._connectionSpecNames.contains(connectionSpecName)) {
                                    this._connectionSpecNames.add(connectionSpecName);
                                }
                                ++i;
                            }
                        }
                        this._isConnectionSpecInitialized = true;
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(oldLoader);
                    }
                }
                catch (BaseException e) {
                    LogFacility.logErrorMessage((IStatus)e.getStatus());
                    throw e;
                }
                catch (RuntimeException e) {
                    LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                    throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            finally {
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
            }
        }
    }

    private void initializeInteractionSpecs() throws BaseException {
        block14: {
            if (LogFacility.trace) {
                LogFacility.TrcEntry();
            }
            try {
                try {
                    if (this._isInteractionSpecInitialized || !this._isOutboundResourceAdapter) break block14;
                    this.initializeClassLoader();
                    ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(this.getClassLoader());
                    try {
                        Class<?>[] interactionSpecs = ConnectorProjectHelper.findInteractionSpecs(this._connectorProject, this.loader);
                        if (interactionSpecs != null) {
                            int i = 0;
                            while (i < interactionSpecs.length) {
                                String interactionSpecName = interactionSpecs[i].getName();
                                if (!this._interactionSpecNames.contains(interactionSpecName)) {
                                    this._interactionSpecNames.add(interactionSpecName);
                                }
                                ++i;
                            }
                        }
                        this._isInteractionSpecInitialized = true;
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(oldLoader);
                    }
                }
                catch (BaseException e) {
                    LogFacility.logErrorMessage((IStatus)e.getStatus());
                    throw e;
                }
                catch (RuntimeException e) {
                    LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                    throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            finally {
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
            }
        }
    }

    private void initializeManagedConnectionFactories() throws BaseException {
        block20: {
            if (LogFacility.trace) {
                LogFacility.TrcEntry();
            }
            try {
                try {
                    if (this._isMCFInitialized || !this._isOutboundResourceAdapter) break block20;
                    this.initializeClassLoader();
                    ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(this.getClassLoader());
                    try {
                        List connectionDefinitions;
                        org.eclipse.jst.javaee.jca.OutboundResourceAdapter outboundAdapter;
                        if ("1.0".equals(this.getSpecVersion())) {
                            String mcf = this._connector.getJca15Connector().getResourceAdapter().getManagedConnectionFactoryClass();
                            if (!this._managedConnectionFactoryNames.contains(mcf)) {
                                this._managedConnectionFactoryNames.add(mcf);
                            }
                        } else if ("1.5".equals(this.getSpecVersion())) {
                            EList connectionDefinitions2;
                            OutboundResourceAdapter outboundAdapter2 = this._connector.getJca15Connector().getResourceAdapter().getOutboundResourceAdapter();
                            if (outboundAdapter2 != null && (connectionDefinitions2 = outboundAdapter2.getConnectionDefinitions()) != null) {
                                for (ConnectionDefinition def : connectionDefinitions2) {
                                    String mcf = def.getManagedConnectionFactoryClass();
                                    if (this._managedConnectionFactoryNames.contains(mcf)) continue;
                                    this._managedConnectionFactoryNames.add(mcf);
                                }
                            }
                        } else if ("1.6".equals(this.getSpecVersion()) && (outboundAdapter = this._connector.getJca16Connector().getResourceadapter().getOutboundResourceadapter()) != null && (connectionDefinitions = outboundAdapter.getConnectionDefinition()) != null) {
                            for (org.eclipse.jst.javaee.jca.ConnectionDefinition def : connectionDefinitions) {
                                String mcf = def.getManagedconnectionfactoryClass();
                                if (this._managedConnectionFactoryNames.contains(mcf)) continue;
                                this._managedConnectionFactoryNames.add(mcf);
                            }
                        }
                        this._isMCFInitialized = true;
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(oldLoader);
                    }
                }
                catch (BaseException e) {
                    LogFacility.logErrorMessage((IStatus)e.getStatus());
                    throw e;
                }
                catch (RuntimeException e) {
                    LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                    throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            finally {
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
            }
        }
    }

    private void initializeMessageListeners() throws BaseException {
        block25: {
            if (LogFacility.trace) {
                LogFacility.TrcEntry();
            }
            try {
                try {
                    if (this._isMessageListenerInitialized || !this._isInboundResourceAdapter) break block25;
                    this.initializeClassLoader();
                    ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(this.getClassLoader());
                    if (this._connector.is15Connector()) {
                        try {
                            InboundResourceAdapter inboundAdapter = this._connector.getJca15Connector().getResourceAdapter().getInboundResourceAdapter();
                            if (inboundAdapter == null) break block25;
                            EList messageListeners = inboundAdapter.getMessageAdapter().getMessageListeners();
                            if (messageListeners != null) {
                                Iterator iter = messageListeners.iterator();
                                while (iter.hasNext()) {
                                    MessageListenerDescriptorImpl messageListenerDescriptor = new MessageListenerDescriptorImpl();
                                    org.eclipse.jst.j2ee.jca.MessageListener listener = (org.eclipse.jst.j2ee.jca.MessageListener)iter.next();
                                    String listenerType = listener.getMessageListenerType();
                                    messageListenerDescriptor.setMessageListenerType(listenerType);
                                    org.eclipse.jst.j2ee.jca.ActivationSpec activationSpec = listener.getActivationSpec();
                                    if (activationSpec != null) {
                                        messageListenerDescriptor.setActivationSpec(activationSpec);
                                        String activationSpecName = activationSpec.getActivationSpecClass();
                                        messageListenerDescriptor.setActivationSpecName(activationSpecName);
                                        try {
                                            this.loader.loadClass(activationSpecName);
                                        }
                                        catch (ClassNotFoundException x) {
                                            throw BaseException.createException((String)x.getLocalizedMessage(), (Throwable)x);
                                        }
                                    }
                                    this._messageListeners.add(messageListenerDescriptor);
                                }
                            }
                            this._isMessageListenerInitialized = true;
                            break block25;
                        }
                        finally {
                            Thread.currentThread().setContextClassLoader(oldLoader);
                        }
                    }
                    try {
                        org.eclipse.jst.javaee.jca.InboundResourceAdapter inboundAdapter = this._connector.getJca16Connector().getResourceadapter().getInboundResourceadapter();
                        if (inboundAdapter == null) break block25;
                        List messageListeners = inboundAdapter.getMessageadapter().getMessagelistener();
                        if (messageListeners != null) {
                            Iterator iter = messageListeners.iterator();
                            while (iter.hasNext()) {
                                MessageListenerDescriptorImpl messageListenerDescriptor = new MessageListenerDescriptorImpl();
                                MessageListener listener = (MessageListener)iter.next();
                                String listenerType = listener.getMessagelistenerType();
                                messageListenerDescriptor.setMessageListenerType(listenerType);
                                org.eclipse.jst.javaee.jca.ActivationSpec activationSpec = listener.getActivationspec();
                                if (activationSpec != null) {
                                    messageListenerDescriptor.setJca16ActivationSpec(activationSpec);
                                    String activationSpecName = activationSpec.getActivationspecClass();
                                    messageListenerDescriptor.setActivationSpecName(activationSpecName);
                                    try {
                                        this.loader.loadClass(activationSpecName);
                                    }
                                    catch (ClassNotFoundException x) {
                                        throw BaseException.createException((String)x.getLocalizedMessage(), (Throwable)x);
                                    }
                                }
                                this._messageListeners.add(messageListenerDescriptor);
                            }
                        }
                        this._isMessageListenerInitialized = true;
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(oldLoader);
                    }
                }
                catch (BaseException e) {
                    LogFacility.logErrorMessage((IStatus)e.getStatus());
                    throw e;
                }
                catch (RuntimeException e) {
                    LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                    throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            finally {
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
            }
        }
    }

    private void initializeResourceAdapterBean() throws BaseException {
        block15: {
            if (LogFacility.trace) {
                LogFacility.TrcEntry();
            }
            try {
                try {
                    if (this._isRABeanInitialized) break block15;
                    if ("1.5".equals(this.getSpecVersion())) {
                        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
                        Thread.currentThread().setContextClassLoader(this.getClassLoader());
                        try {
                            this.initializeClassLoader();
                            this._resourceAdapterBeanName = this._connector.getJca15Connector().getResourceAdapter().getResourceAdapterClass();
                            this._resourceAdapterBeanClass = this.loadClass(this._resourceAdapterBeanName);
                            this._isRABeanInitialized = true;
                            break block15;
                        }
                        finally {
                            Thread.currentThread().setContextClassLoader(oldLoader);
                        }
                    }
                    if (!"1.6".equals(this.getSpecVersion())) break block15;
                    ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(this.getClassLoader());
                    try {
                        this.initializeClassLoader();
                        this._resourceAdapterBeanName = this._connector.getJca16Connector().getResourceadapter().getResourceadapterClass();
                        this._resourceAdapterBeanClass = this.loadClass(this._resourceAdapterBeanName);
                        this._isRABeanInitialized = true;
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(oldLoader);
                    }
                }
                catch (BaseException e) {
                    LogFacility.logErrorMessage((IStatus)e.getStatus());
                    throw e;
                }
                catch (RuntimeException e) {
                    LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                    throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            finally {
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
            }
        }
    }

    private Class<?> loadClass(String className) {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            if (this.loader != null && className != null) {
                Class<?> clazz;
                Class<?> clazz2 = clazz = this.loader.loadClass(className);
                return clazz2;
            }
            return null;
        }
        catch (ClassNotFoundException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    @Override
    public Map<String, Object> getExtendedData() {
        return this.extendedData;
    }

    public boolean equals(Object obj) {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ResourceAdapterDescriptorImpl)) {
                return false;
            }
            ResourceAdapterDescriptorImpl descriptor = (ResourceAdapterDescriptorImpl)obj;
            if (this._connectorProject == null ^ descriptor._connectorProject == null) {
                return false;
            }
            if (this._connectorProject != null && !this._connectorProject.equals((Object)descriptor._connectorProject)) {
                return false;
            }
            if (this._isClassLoaderInitialized ^ descriptor._isClassLoaderInitialized) {
                return false;
            }
            if (this._isClassLoaderInitialized) {
                if (this.loader == null ^ descriptor.loader == null) {
                    return false;
                }
                if (this.loader != null && this.loader != descriptor.loader) {
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    public int hashCode() {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            if (this._connectorProject != null) {
                int ret;
                int n = ret = this._connectorProject.hashCode();
                return n;
            }
            return -1;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            return -1;
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    @Override
    public ConnectorProjectDescriptor getConnectorProjectDescriptor() {
        return new ConnectorProjectDescriptor(this._connectorProject);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized boolean hasBuildAgent() {
        if (!LogFacility.trace) ** GOTO lbl-1000
        LogFacility.TrcEntry();
        try lbl-1000:
        // 3 sources

        {
            while (!this.waitingListeners.isEmpty() && !this.waitingListeners.contains(Thread.currentThread())) {
                try {
                    this.wait(0L);
                }
                catch (InterruptedException e) {
                    LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
        return this._hasBuildAgent;
    }

    public synchronized void setBuildAgent(IBuildAgent buildAgent) {
        this._buildAgent = buildAgent;
        this._hasBuildAgent = buildAgent != null;
    }

    private URL[] addExtraFolders(URL[] origUrls) {
        java.net.URI[] urs = this.getConnectorProjectDescriptor().getCopiedClasspathEntries();
        ArrayList<URL> arL = new ArrayList<URL>();
        HashSet<IPath> directoriesToAdd = new HashSet<IPath>();
        int n = 0;
        while (n < urs.length) {
            java.net.URI ur = urs[n];
            String sPa = ur.getPath();
            if (!sPa.endsWith(".jar") && !sPa.endsWith(".zip")) {
                try {
                    File jFile = new File(ur);
                    IPath libaryPath = Path.fromOSString((String)jFile.getParent());
                    if (!directoriesToAdd.contains(libaryPath)) {
                        directoriesToAdd.add(libaryPath);
                        try {
                            String str = libaryPath.toOSString();
                            String uriString = URI.createFileURI((String)str).toString();
                            java.net.URI aURI = new java.net.URI(uriString);
                            URL url1 = aURI.toURL();
                            arL.add(url1);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (Exception exception) {}
            }
            ++n;
        }
        if (arL.size() > 0) {
            ArrayList<URL> urlList = new ArrayList<URL>(Arrays.asList(origUrls));
            urlList.addAll(arL);
            URL[] res = urlList.toArray(new URL[urlList.size()]);
            return res;
        }
        return origUrls;
    }

    public class AdminObjectDescriptorImpl
    implements IResourceAdapterDescriptor.IAdminObjectDescriptor {
        private AdminObject adminObject;
        private String implClassName;
        private String interfaceName;
        private org.eclipse.jst.javaee.jca.AdminObject jca16AdminObject;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean equals(Object obj) {
            try {
                if (obj == null) {
                    return false;
                }
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof IResourceAdapterDescriptor.IAdminObjectDescriptor)) {
                    return false;
                }
                IResourceAdapterDescriptor.IAdminObjectDescriptor desc = (IResourceAdapterDescriptor.IAdminObjectDescriptor)obj;
                if (this.getInterfaceName() == desc.getInterfaceName() && this.getImplClassName() == desc.getImplClassName()) {
                    return true;
                }
                try {
                    return this.getInterfaceName().equals(desc.getInterfaceName()) && this.getImplClassName().equals(desc.getImplClassName());
                }
                catch (NullPointerException nullPointerException) {
                    return false;
                }
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                return false;
            }
        }

        @Override
        public AdminObject getAdminObject() {
            return this.adminObject;
        }

        @Override
        public org.eclipse.jst.javaee.jca.AdminObject getJca16AdminObject() {
            return this.jca16AdminObject;
        }

        @Override
        public Class<?> getImplClass() {
            return ResourceAdapterDescriptorImpl.this.loadClass(this.getImplClassName());
        }

        @Override
        public String getImplClassName() {
            return this.implClassName;
        }

        @Override
        public IType getImplClassType() {
            return ResourceAdapterDescriptorImpl.this.getJavaType(this.getImplClassName());
        }

        @Override
        public Class<?> getInterfaceClass() {
            return ResourceAdapterDescriptorImpl.this.loadClass(this.getInterfaceName());
        }

        @Override
        public String getInterfaceName() {
            return this.interfaceName;
        }

        @Override
        public IType getInterfaceType() {
            return ResourceAdapterDescriptorImpl.this.getJavaType(this.getInterfaceName());
        }

        public void setAdminObject(AdminObject adminObject) {
            this.adminObject = adminObject;
        }

        public void setJca16AdminObject(org.eclipse.jst.javaee.jca.AdminObject adminObject) {
            this.jca16AdminObject = adminObject;
        }

        protected void setImplClassName(String implClassName) {
            this.implClassName = implClassName;
        }

        protected void setInterfaceName(String interfaceName) {
            this.interfaceName = interfaceName;
        }
    }

    public class MessageListenerDescriptorImpl
    implements IResourceAdapterDescriptor.IMessageListenerDescriptor {
        private org.eclipse.jst.j2ee.jca.ActivationSpec activationSpec;
        private String activationSpecName;
        private String messageListenerType;
        private org.eclipse.jst.javaee.jca.ActivationSpec jca16ActivationSpec;

        @Override
        public org.eclipse.jst.j2ee.jca.ActivationSpec getActivationSpec() {
            return this.activationSpec;
        }

        @Override
        public Class<ActivationSpec> getActivationSpecClass() {
            return ResourceAdapterDescriptorImpl.this.loadClass(this.getActivationSpecName());
        }

        @Override
        public String getActivationSpecName() {
            return this.activationSpecName;
        }

        @Override
        public IType getActivationSpecType() {
            return ResourceAdapterDescriptorImpl.this.getJavaType(this.getActivationSpecName());
        }

        @Override
        public String getMessageListenerType() {
            return this.messageListenerType;
        }

        public void setActivationSpec(org.eclipse.jst.j2ee.jca.ActivationSpec activationSpec) {
            this.activationSpec = activationSpec;
        }

        protected void setActivationSpecName(String activationSpecName) {
            this.activationSpecName = activationSpecName;
        }

        protected void setMessageListenerType(String messageListenerType) {
            this.messageListenerType = messageListenerType;
        }

        @Override
        public org.eclipse.jst.javaee.jca.ActivationSpec getJca16ActivationSpec() {
            return this.jca16ActivationSpec;
        }

        public void setJca16ActivationSpec(org.eclipse.jst.javaee.jca.ActivationSpec activationSpec) {
            this.jca16ActivationSpec = activationSpec;
        }
    }
}

