/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.marshall.codegen;

import com.ibm.etools.marshall.MarshallParms;
import com.ibm.etools.marshall.codegen.CodeGenExternalDecimalUtils;
import com.ibm.etools.marshall.codegen.CodeGenFloatUtils;
import com.ibm.etools.marshall.codegen.CodeGenIntegerUtils;
import com.ibm.etools.marshall.codegen.CodeGenPackedDecimalUtils;
import com.ibm.etools.marshall.codegen.CodeGenStringUtils;
import com.ibm.etools.marshall.codegen.CodeGenUnicodeExternalDecimalUtils;
import com.ibm.etools.marshall.util.MarshallResource;
import com.ibm.etools.typedescriptor.AddressTD;
import com.ibm.etools.typedescriptor.BaseTDType;
import com.ibm.etools.typedescriptor.BinaryTD;
import com.ibm.etools.typedescriptor.ExternalDecimalTD;
import com.ibm.etools.typedescriptor.FloatTD;
import com.ibm.etools.typedescriptor.InstanceTDBase;
import com.ibm.etools.typedescriptor.IntegerTD;
import com.ibm.etools.typedescriptor.PackedDecimalTD;
import com.ibm.etools.typedescriptor.SimpleInstanceTD;
import com.ibm.etools.typedescriptor.StringTD;
import com.ibm.etools.typedescriptor.UnicodeExternalDecimalTD;
import java.util.Vector;

public class CodeGenUtils {
    private static final String copyright = "Licensed Material - Property of IBM <<PART NUMBER - 5724-D15>> Copyright IBM Corp. 2001, 2003 - All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.".intern();

    public static String uppercaseFirstLetterInSring(String str) {
        String returnString = String.valueOf(str.substring(0, 1).toUpperCase()) + str.substring(1);
        return returnString;
    }

    protected static boolean addVirtualDecimalPoint(String javaType) {
        boolean addVirtDec = false;
        if (javaType.equals("float") || javaType.equals("double") || javaType.equals("BigDecimal")) {
            addVirtDec = true;
        }
        return addVirtDec;
    }

    public static int getMaximumStringSize(SimpleInstanceTD instanceTD) {
        int maxSize = 0;
        maxSize = MarshallParms.isArray((InstanceTDBase)instanceTD) ? MarshallParms.getStride((InstanceTDBase)instanceTD) : MarshallParms.getSize(instanceTD);
        if (instanceTD.getSharedType() instanceof StringTD) {
            StringTD typeDescriptor = (StringTD)instanceTD.getSharedType();
            int encodingStyle = MarshallParms.getEncodingStyle(typeDescriptor);
            int physSpace = 0;
            switch (encodingStyle) {
                case 0: {
                    break;
                }
                case 1: {
                    physSpace = MarshallParms.getPrefixLength(typeDescriptor);
                    break;
                }
                case 2: {
                    boolean DBCSOnly = MarshallParms.getDBCSOnly(typeDescriptor);
                    if (DBCSOnly) {
                        physSpace = 2;
                        break;
                    }
                    physSpace = 1;
                    break;
                }
            }
            String codePage = MarshallParms.getCodePage(typeDescriptor, instanceTD);
            if (codePage.equalsIgnoreCase("UTF-16")) {
                physSpace += 2;
            }
            maxSize -= physSpace;
        }
        return maxSize;
    }

    public static String[] generateMarshallMethod(String valueName, String byteArrayName, String offsetString, SimpleInstanceTD instanceTD, String javaType) throws IllegalArgumentException {
        String[] result = null;
        BaseTDType baseTD = instanceTD.getSharedType();
        if (baseTD instanceof StringTD) {
            result = CodeGenStringUtils.generateStringMarshallMethod(valueName, byteArrayName, offsetString, instanceTD, javaType, (StringTD)baseTD);
        } else if (baseTD instanceof ExternalDecimalTD) {
            result = CodeGenExternalDecimalUtils.generateExternalDecimalMarshallMethod(valueName, byteArrayName, offsetString, instanceTD, javaType, (ExternalDecimalTD)baseTD);
        } else if (baseTD instanceof UnicodeExternalDecimalTD) {
            result = CodeGenUnicodeExternalDecimalUtils.generateUnicodeExternalDecimalMarshallMethod(valueName, byteArrayName, offsetString, instanceTD, javaType, (UnicodeExternalDecimalTD)baseTD);
        } else if (baseTD instanceof PackedDecimalTD) {
            result = CodeGenPackedDecimalUtils.generatePackedDecimalMarshallMethod(valueName, byteArrayName, offsetString, instanceTD, javaType, (PackedDecimalTD)baseTD);
        } else if (baseTD instanceof IntegerTD) {
            result = CodeGenIntegerUtils.generateIntegerMarshallMethod(valueName, byteArrayName, offsetString, instanceTD, javaType, (IntegerTD)baseTD);
        } else if (baseTD instanceof FloatTD) {
            result = CodeGenFloatUtils.generateFloatMarshallMethod(valueName, byteArrayName, offsetString, instanceTD, javaType, (FloatTD)baseTD);
        } else if (baseTD instanceof AddressTD) {
            result = CodeGenUtils.generateAddressTDMarshallMethod(valueName, byteArrayName, offsetString, instanceTD, javaType, (AddressTD)baseTD);
        } else if (baseTD instanceof BinaryTD) {
            result = CodeGenUtils.generateBinaryTDMarshallMethod(valueName, byteArrayName, offsetString, instanceTD, javaType, (BinaryTD)baseTD);
        } else {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_TYPEDESC_CLASS_NOT_VALID", baseTD.getClass().getName()));
        }
        return result;
    }

    public static String[] generateUnmarshallMethod(String valueName, String byteArrayName, String offsetString, SimpleInstanceTD instanceTD, String javaType) throws IllegalArgumentException {
        String[] result = null;
        BaseTDType baseTD = instanceTD.getSharedType();
        if (baseTD instanceof StringTD) {
            result = CodeGenStringUtils.generateStringUnmarshallMethod(valueName, byteArrayName, offsetString, instanceTD, javaType, (StringTD)baseTD);
        } else if (baseTD instanceof ExternalDecimalTD) {
            result = CodeGenExternalDecimalUtils.generateExternalDecimalUnmarshallMethod(valueName, byteArrayName, offsetString, instanceTD, javaType, (ExternalDecimalTD)baseTD);
        } else if (baseTD instanceof UnicodeExternalDecimalTD) {
            result = CodeGenUnicodeExternalDecimalUtils.generateUnicodeExternalDecimalUnmarshallMethod(valueName, byteArrayName, offsetString, instanceTD, javaType, (UnicodeExternalDecimalTD)baseTD);
        } else if (baseTD instanceof PackedDecimalTD) {
            result = CodeGenPackedDecimalUtils.generatePackedDecimalUnmarshallMethod(valueName, byteArrayName, offsetString, instanceTD, javaType, (PackedDecimalTD)baseTD);
        } else if (baseTD instanceof IntegerTD) {
            result = CodeGenIntegerUtils.generateIntegerUnmarshallMethod(valueName, byteArrayName, offsetString, instanceTD, javaType, (IntegerTD)baseTD);
        } else if (baseTD instanceof FloatTD) {
            result = CodeGenFloatUtils.generateFloatUnmarshallMethod(valueName, byteArrayName, offsetString, instanceTD, javaType, (FloatTD)baseTD);
        } else if (baseTD instanceof AddressTD) {
            result = CodeGenUtils.generateAddressTDUnmarshallMethod(valueName, byteArrayName, offsetString, instanceTD, javaType, (AddressTD)baseTD);
        } else if (baseTD instanceof BinaryTD) {
            result = CodeGenUtils.generateBinaryTDUnmarshallMethod(valueName, byteArrayName, offsetString, instanceTD, javaType, (BinaryTD)baseTD);
        } else {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_TYPEDESC_CLASS_NOT_VALID", baseTD.getClass().getName()));
        }
        return result;
    }

    public static boolean isFormula(String formula) {
        boolean result = true;
        int index = formula.indexOf("(");
        if (index == -1) {
            result = false;
        }
        return result;
    }

    private static String[] generateArrayCopyMarshallMethod(String valueName, String byteArrayName, String offsetString, SimpleInstanceTD instanceTD) {
        Object[] result = null;
        Vector<String> genMethods = new Vector<String>();
        StringBuffer sb = new StringBuffer("System.arraycopy (" + valueName + ", 0, " + byteArrayName + ", ");
        int size = 0;
        size = MarshallParms.isArray((InstanceTDBase)instanceTD) ? MarshallParms.getStride((InstanceTDBase)instanceTD) : MarshallParms.getSize(instanceTD);
        if (offsetString == null) {
            int offset = MarshallParms.getOffset(instanceTD);
            offsetString = Integer.toString(offset);
        }
        sb.append(offsetString);
        sb.append(", ");
        String lenStr = "Math.min(" + Integer.toString(size) + "," + valueName + ".length)";
        sb.append(lenStr);
        sb.append(");");
        genMethods.add(sb.toString());
        result = new String[genMethods.size()];
        genMethods.copyInto(result);
        return result;
    }

    private static String[] generateArrayCopyUnmarshallMethod(String valueName, String byteArrayName, String offsetString, SimpleInstanceTD instanceTD) {
        Object[] result = null;
        Vector<String> genMethods = new Vector<String>();
        int size = 0;
        size = MarshallParms.isArray((InstanceTDBase)instanceTD) ? MarshallParms.getStride((InstanceTDBase)instanceTD) : MarshallParms.getSize(instanceTD);
        if (offsetString == null) {
            int offset = MarshallParms.getOffset(instanceTD);
            offsetString = Integer.toString(offset);
        }
        StringBuffer sb = new StringBuffer("System.arraycopy (" + byteArrayName + ", " + offsetString + ", " + valueName + ", 0, " + Integer.toString(size));
        sb.append(");");
        String createStr = String.valueOf(valueName) + " = new byte[" + Integer.toString(size) + "];";
        genMethods.add(createStr);
        genMethods.add(sb.toString());
        result = new String[genMethods.size()];
        genMethods.copyInto(result);
        return result;
    }

    public static String[] generateAddressTDMarshallMethod(String valueName, String byteArrayName, String offsetString, SimpleInstanceTD instanceTD, String javaType, AddressTD typeDescriptor) throws IllegalArgumentException {
        return CodeGenUtils.generateArrayCopyMarshallMethod(valueName, byteArrayName, offsetString, instanceTD);
    }

    public static String[] generateBinaryTDMarshallMethod(String valueName, String byteArrayName, String offsetString, SimpleInstanceTD instanceTD, String javaType, BinaryTD typeDescriptor) throws IllegalArgumentException {
        return CodeGenUtils.generateArrayCopyMarshallMethod(valueName, byteArrayName, offsetString, instanceTD);
    }

    public static String[] generateAddressTDUnmarshallMethod(String valueName, String byteArrayName, String offsetString, SimpleInstanceTD instanceTD, String javaType, AddressTD typeDescriptor) throws IllegalArgumentException {
        return CodeGenUtils.generateArrayCopyUnmarshallMethod(valueName, byteArrayName, offsetString, instanceTD);
    }

    public static String[] generateBinaryTDUnmarshallMethod(String valueName, String byteArrayName, String offsetString, SimpleInstanceTD instanceTD, String javaType, BinaryTD typeDescriptor) throws IllegalArgumentException {
        return CodeGenUtils.generateArrayCopyUnmarshallMethod(valueName, byteArrayName, offsetString, instanceTD);
    }
}

