/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.marshall.codegen;

import com.ibm.etools.marshall.MarshallParms;
import com.ibm.etools.marshall.codegen.CodeGenExternalDecimalUtils;
import com.ibm.etools.marshall.codegen.CodeGenUtils;
import com.ibm.etools.typedescriptor.BaseTDType;
import com.ibm.etools.typedescriptor.InstanceTDBase;
import com.ibm.etools.typedescriptor.NumberTD;
import com.ibm.etools.typedescriptor.SimpleInstanceTD;
import com.ibm.etools.typedescriptor.UnicodeExternalDecimalTD;
import java.util.Vector;

public class CodeGenUnicodeExternalDecimalUtils {
    private static final String copyright = "Licensed Material - Property of IBM <<PART NUMBER - 5724-D15>> Copyright IBM Corp. 2006 - All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.".intern();

    public static String[] generateUnicodeExternalDecimalMarshallMethod(String valueName, String byteArrayName, String offsetString, SimpleInstanceTD instanceTD, String javaType, UnicodeExternalDecimalTD typeDescriptor) throws IllegalArgumentException {
        Object[] result = null;
        Vector<String> genMethods = new Vector<String>();
        StringBuffer sb = new StringBuffer("MarshallExternalDecimalUtils.marshallExternalDecimalIntoBuffer (");
        sb.append(valueName);
        sb.append(", ");
        sb.append(byteArrayName);
        sb.append(", ");
        int size = 0;
        size = MarshallParms.isArray((InstanceTDBase)instanceTD) ? MarshallParms.getStride((InstanceTDBase)instanceTD) : MarshallParms.getSize(instanceTD);
        if (offsetString == null) {
            int offset = MarshallParms.getOffset(instanceTD);
            offsetString = Integer.toString(offset);
        }
        int virtualDecimalPoint = MarshallParms.getVirtualDecimalPoint((NumberTD)typeDescriptor);
        boolean signed = MarshallParms.isSigned((NumberTD)typeDescriptor);
        int signFormat = -1;
        if (signed) {
            signFormat = MarshallParms.getSignFormat(typeDescriptor);
        }
        int externalDecimalSign = 3;
        sb.append(offsetString);
        sb.append(", ");
        sb.append(Integer.toString(size));
        sb.append(", ");
        sb.append(new Boolean(signed).toString());
        sb.append(", ");
        if (CodeGenUtils.addVirtualDecimalPoint(javaType)) {
            sb.append(Integer.toString(virtualDecimalPoint));
            sb.append(", ");
        }
        String strSignFormat = CodeGenExternalDecimalUtils.getStringSignFormat(signFormat);
        sb.append(strSignFormat);
        sb.append(", ");
        String strExtDecSign = CodeGenExternalDecimalUtils.getStringExternalDecimalSign(externalDecimalSign);
        sb.append(strExtDecSign);
        sb.append(",\"");
        sb.append(CodeGenUnicodeExternalDecimalUtils.getEncoding(typeDescriptor, instanceTD));
        sb.append("\"");
        sb.append(");");
        genMethods.add(sb.toString());
        result = new String[genMethods.size()];
        genMethods.copyInto(result);
        return result;
    }

    public static String[] generateUnicodeExternalDecimalUnmarshallMethod(String valueName, String byteArrayName, String offsetString, SimpleInstanceTD instanceTD, String javaType, UnicodeExternalDecimalTD typeDescriptor) throws IllegalArgumentException {
        Object[] result = null;
        Vector<String> genMethods = new Vector<String>();
        StringBuffer sb = new StringBuffer(String.valueOf(valueName) + " = MarshallExternalDecimalUtils.unmarshall");
        String typeName = CodeGenUtils.uppercaseFirstLetterInSring(javaType);
        sb.append(String.valueOf(typeName) + "FromBuffer (");
        sb.append(byteArrayName);
        sb.append(", ");
        int size = 0;
        size = MarshallParms.isArray((InstanceTDBase)instanceTD) ? MarshallParms.getStride((InstanceTDBase)instanceTD) : MarshallParms.getSize(instanceTD);
        if (offsetString == null) {
            int offset = MarshallParms.getOffset(instanceTD);
            offsetString = Integer.toString(offset);
        }
        int virtualDecimalPoint = MarshallParms.getVirtualDecimalPoint((NumberTD)typeDescriptor);
        boolean signed = MarshallParms.isSigned((NumberTD)typeDescriptor);
        int signFormat = -1;
        if (signed) {
            signFormat = MarshallParms.getSignFormat(typeDescriptor);
        }
        int externalDecimalSign = 3;
        sb.append(offsetString);
        sb.append(", ");
        sb.append(Integer.toString(size));
        sb.append(", ");
        sb.append(new Boolean(signed).toString());
        sb.append(", ");
        if (CodeGenUtils.addVirtualDecimalPoint(javaType)) {
            sb.append(Integer.toString(virtualDecimalPoint));
            sb.append(", ");
        }
        String strSignFormat = CodeGenExternalDecimalUtils.getStringSignFormat(signFormat);
        sb.append(strSignFormat);
        sb.append(", ");
        String strExtDecSign = CodeGenExternalDecimalUtils.getStringExternalDecimalSign(externalDecimalSign);
        sb.append(strExtDecSign);
        sb.append(",\"");
        sb.append(CodeGenUnicodeExternalDecimalUtils.getEncoding(typeDescriptor, instanceTD));
        sb.append("\"");
        sb.append(");");
        genMethods.add(sb.toString());
        result = new String[genMethods.size()];
        genMethods.copyInto(result);
        return result;
    }

    public static String getEncoding(UnicodeExternalDecimalTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        String encoding = "UTF-16BE";
        boolean isBigEndian = MarshallParms.isBigEndian((BaseTDType)typeDescriptor, instanceTD);
        if (typeDescriptor.isSetEncoding()) {
            int TDencoding = typeDescriptor.getEncoding().getValue();
            switch (TDencoding) {
                case 0: {
                    encoding = "UTF8";
                    break;
                }
                case 1: {
                    if (isBigEndian) {
                        encoding = "UTF-16BE";
                        break;
                    }
                    encoding = "UTF-16LE";
                    break;
                }
                case 2: {
                    encoding = "UTF-32";
                }
            }
        } else if (!isBigEndian) {
            encoding = "UTF-16LE";
        }
        return encoding;
    }
}

