/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.marshall;

import com.ibm.etools.marshall.MarshallParms;
import com.ibm.etools.marshall.util.MarshallFloatUtils;
import com.ibm.etools.typedescriptor.BaseTDType;
import com.ibm.etools.typedescriptor.FloatTD;
import com.ibm.etools.typedescriptor.SimpleInstanceTD;
import java.math.BigDecimal;

public class MarshallFloat {
    private static final String copyright = "Licensed Material - Property of IBM <<PART NUMBER - 5724-D15>> Copyright IBM Corp. 2001, 2003 - All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.".intern();

    public static void marshallFloatIntoBuffer(BigDecimal value, byte[] buffer, int startingOffset, FloatTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        boolean isBigEndian = MarshallParms.isBigEndian((BaseTDType)typeDescriptor, instanceTD);
        int floatType = MarshallParms.getFloatType(typeDescriptor, instanceTD);
        int size = MarshallParms.getSize(instanceTD);
        MarshallFloatUtils.marshallFloatIntoBuffer((BigDecimal)value, (byte[])buffer, (int)startingOffset, (boolean)isBigEndian, (int)floatType, (int)size);
    }

    public static void marshallFloatIntoBuffer(double value, byte[] buffer, int startingOffset, FloatTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        boolean isBigEndian = MarshallParms.isBigEndian((BaseTDType)typeDescriptor, instanceTD);
        int floatType = MarshallParms.getFloatType(typeDescriptor, instanceTD);
        int size = MarshallParms.getSize(instanceTD);
        MarshallFloatUtils.marshallFloatIntoBuffer((double)value, (byte[])buffer, (int)startingOffset, (boolean)isBigEndian, (int)floatType, (int)size);
    }

    public static void marshallFloatIntoBuffer(float value, byte[] buffer, int startingOffset, FloatTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        boolean isBigEndian = MarshallParms.isBigEndian((BaseTDType)typeDescriptor, instanceTD);
        int floatType = MarshallParms.getFloatType(typeDescriptor, instanceTD);
        int size = MarshallParms.getSize(instanceTD);
        MarshallFloatUtils.marshallFloatIntoBuffer((float)value, (byte[])buffer, (int)startingOffset, (boolean)isBigEndian, (int)floatType, (int)size);
    }

    public static BigDecimal unmarshallBigDecimalFromBuffer(byte[] buffer, int startingOffset, FloatTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        boolean isBigEndian = MarshallParms.isBigEndian((BaseTDType)typeDescriptor, instanceTD);
        int floatType = MarshallParms.getFloatType(typeDescriptor, instanceTD);
        int size = MarshallParms.getSize(instanceTD);
        BigDecimal result = MarshallFloatUtils.unmarshallBigDecimalFromBuffer((byte[])buffer, (int)startingOffset, (boolean)isBigEndian, (int)floatType, (int)size);
        return result;
    }

    public static double unmarshallDoubleFromBuffer(byte[] buffer, int startingOffset, FloatTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        boolean isBigEndian = MarshallParms.isBigEndian((BaseTDType)typeDescriptor, instanceTD);
        int floatType = MarshallParms.getFloatType(typeDescriptor, instanceTD);
        int size = MarshallParms.getSize(instanceTD);
        double result = MarshallFloatUtils.unmarshallDoubleFromBuffer((byte[])buffer, (int)startingOffset, (boolean)isBigEndian, (int)floatType, (int)size);
        return result;
    }

    public static float unmarshallFloatFromBuffer(byte[] buffer, int startingOffset, FloatTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        boolean isBigEndian = MarshallParms.isBigEndian((BaseTDType)typeDescriptor, instanceTD);
        int floatType = MarshallParms.getFloatType(typeDescriptor, instanceTD);
        int size = MarshallParms.getSize(instanceTD);
        float result = MarshallFloatUtils.unmarshallFloatFromBuffer((byte[])buffer, (int)startingOffset, (boolean)isBigEndian, (int)floatType, (int)size);
        return result;
    }
}

