/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.mapping.util.visitors;

import com.ibm.msl.mapping.Mapping;
import com.ibm.msl.mapping.MappingContainer;
import com.ibm.msl.mapping.MappingDesignator;
import com.ibm.msl.mapping.MappingRoot;
import com.ibm.msl.mapping.util.ModelUtils;
import com.ibm.msl.mapping.xml.node.XMLDataContentNode;
import com.ibm.zosconnect.ui.common.exceptions.ZosConnectStopWalkException;
import com.ibm.zosconnect.ui.common.util.ListUtilz;
import com.ibm.zosconnect.ui.common.util.xsd.ZosConnectXsdUtil;
import com.ibm.zosconnect.ui.common.util.xsd.walker.ZosConnectXsdVisitor;
import com.ibm.zosconnect.ui.common.util.xsd.walker.ZosConnectXsdXmlXPath;
import com.ibm.zosconnect.ui.mapping.util.ZCeeMappingUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSimpleTypeDefinition;

public class HasMappedDescendantVisitor
extends ZosConnectXsdVisitor {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private MappingDesignator designator;
    private MappingRoot mappingRoot;
    private List<Mapping> mappings;
    private List<XSDElementDeclaration> mappedXsdEle;
    private boolean hasMappedDescendant = false;

    public HasMappedDescendantVisitor(MappingDesignator designator) {
        this.designator = designator;
    }

    public void startOfWalk(XSDElementDeclaration xsdEle) throws Exception {
        if (ZosConnectXsdUtil.isSimpleElement((XSDElementDeclaration)xsdEle)) {
            throw new ZosConnectStopWalkException();
        }
        this.mappingRoot = ModelUtils.getMappingRoot((MappingDesignator)this.designator);
        this.mappings = ModelUtils.getAllNestedMappings((MappingContainer)this.mappingRoot);
        this.mappedXsdEle = new ArrayList<XSDElementDeclaration>();
        for (Mapping mapping : this.mappings) {
            if (!ListUtilz.notEmpty((List)mapping.getOutputs())) continue;
            for (MappingDesignator output : mapping.getOutputs()) {
                if (output == this.designator || !(output.getObject() instanceof XMLDataContentNode)) continue;
                XSDElementDeclaration outputXsdEle = ZCeeMappingUtil.getXSDElementDeclaration(output.getObject());
                this.mappedXsdEle.add(outputXsdEle);
            }
        }
    }

    public void visitLeafElement(ZosConnectXsdXmlXPath xmlXPath, XSDElementDeclaration xsdEle, XSDSimpleTypeDefinition simpleType, int minOccurs, int maxOccurs) throws Exception {
        if (this.mappedXsdEle.contains(xsdEle)) {
            this.hasMappedDescendant = true;
            throw new ZosConnectStopWalkException();
        }
    }

    public void visitLeafElement(ZosConnectXsdXmlXPath xmlXPath, XSDElementDeclaration xsdEle, XSDComplexTypeDefinition complexType, int minOccurs, int maxOccurs, ArrayList<XSDAttributeDeclaration> xsdAtts) throws Exception {
        if (this.mappedXsdEle.contains(xsdEle)) {
            this.hasMappedDescendant = true;
            throw new ZosConnectStopWalkException();
        }
    }

    public void visitCompositeElement(ZosConnectXsdXmlXPath xmlXPath, XSDElementDeclaration xsdEle, XSDComplexTypeDefinition complexType, int minOccurs, int maxOccurs, ArrayList<XSDAttributeDeclaration> xsdAtts) throws Exception {
        if (this.mappedXsdEle.contains(xsdEle)) {
            this.hasMappedDescendant = true;
            throw new ZosConnectStopWalkException();
        }
    }

    public void visitLeafElementAttribute(ZosConnectXsdXmlXPath xmlXPath, XSDElementDeclaration xsdEle, XSDAttributeDeclaration xsdAtt, XSDSimpleTypeDefinition simpleType) throws Exception {
    }

    public void visitCompositeElementAttribute(ZosConnectXsdXmlXPath xmlXPath, XSDElementDeclaration xsdEle, XSDAttributeDeclaration xsdAtt, XSDSimpleTypeDefinition simpleType) throws Exception {
    }

    public void endOfWalk(XSDElementDeclaration globalEle) throws Exception {
    }

    public boolean hasMappedDescendant() {
        return this.hasMappedDescendant;
    }
}

