/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.mapping.util.msl.walker;

import com.ibm.msl.mapping.Mapping;
import com.ibm.msl.mapping.MappingContainer;
import com.ibm.msl.mapping.MappingRoot;
import com.ibm.msl.mapping.util.ModelUtils;
import com.ibm.zosconnect.ui.mapping.util.ZCeeMappingUtil;
import com.ibm.zosconnect.ui.mapping.util.msl.walker.IMappingRootVisitor;
import com.ibm.zosconnect.ui.mapping.util.msl.walker.IMappingRootWalker;
import java.util.List;

public class MappingRootWalker
implements IMappingRootWalker {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2018. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public MappingRoot mappingRoot;

    private MappingRootWalker() {
    }

    public MappingRootWalker(MappingRoot mappingRoot) {
        this.mappingRoot = mappingRoot;
    }

    @Override
    public void accept(IMappingRootVisitor visitor) throws Exception {
        List allMappings = ModelUtils.getAllNestedMappings((MappingContainer)this.mappingRoot);
        visitor.startOfWalk(this.mappingRoot, allMappings);
        for (Mapping mapping : allMappings) {
            if (ModelUtils.hasMoveRefinement((Mapping)mapping)) {
                visitor.visitMoveMapping(mapping);
                continue;
            }
            if (ZCeeMappingUtil.hasRemoveRefinement(mapping)) {
                visitor.visitRemoveMapping(mapping);
                continue;
            }
            if (!ModelUtils.hasAssignRefinement((Mapping)mapping)) continue;
            visitor.visitAssignMapping(mapping);
        }
        visitor.endOfWalk(this.mappingRoot);
    }
}

