/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.mapping.util.msl.model;

import com.ibm.msl.mapping.Mapping;
import com.ibm.msl.mapping.MappingDesignator;
import com.ibm.msl.mapping.MappingRoot;
import com.ibm.zosconnect.ui.mapping.util.ZCeeMappingUtil;
import com.ibm.zosconnect.ui.mapping.util.msl.model.ZCeeMappingModel;
import io.swagger.models.properties.Property;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSimpleTypeDefinition;

public class ZCeeOutputMappingModel
extends ZCeeMappingModel {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2018. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private LinkedHashMap<String, Mapping> headerParamNameToMoveMapping = new LinkedHashMap();
    private LinkedHashMap<String, Mapping> headerParamNameToAssignMapping = new LinkedHashMap();
    private LinkedHashMap<String, Mapping> bodyPathToAssignMapping;
    private LinkedHashMap<String, Mapping> bodyPathToRemoveMapping = new LinkedHashMap();
    private LinkedHashMap<String, Property> headerParamNameToProperty;

    public ZCeeOutputMappingModel() {
        this.bodyPathToAssignMapping = new LinkedHashMap();
        this.headerParamNameToProperty = new LinkedHashMap();
    }

    @Override
    public void startOfWalk(MappingRoot mappingRoot, List<Mapping> allMappings) throws Exception {
        super.startOfWalk(mappingRoot, allMappings);
    }

    @Override
    public void visitMoveMapping(Mapping mapping) throws Exception {
        super.visitMoveMapping(mapping);
        MappingDesignator outputDesignator = ZCeeMappingUtil.getFirstOutputDesignator(mapping);
        switch (ZCeeMappingUtil.getDesignatorGroup(outputDesignator)) {
            case OUTPUT_HEADER: {
                String headerName = ZCeeMappingUtil.getDesignatorLocalName(outputDesignator);
                this.headerParamNameToMoveMapping.put(headerName, mapping);
                break;
            }
        }
    }

    @Override
    public void visitAssignMapping(Mapping mapping) throws Exception {
        super.visitAssignMapping(mapping);
        MappingDesignator outputDesignator = ZCeeMappingUtil.getFirstOutputDesignator(mapping);
        switch (ZCeeMappingUtil.getDesignatorGroup(outputDesignator)) {
            case OUTPUT_HEADER: {
                String headerName = ZCeeMappingUtil.getDesignatorLocalName(outputDesignator);
                this.headerParamNameToAssignMapping.put(headerName, mapping);
                break;
            }
            case OUTPUT_BODY: {
                String bodyPath = ZCeeMappingUtil.getDesignatorFullPath(outputDesignator, "/");
                this.bodyPathToAssignMapping.put(bodyPath, mapping);
                break;
            }
        }
    }

    @Override
    public void visitRemoveMapping(Mapping mapping) throws Exception {
        super.visitRemoveMapping(mapping);
        MappingDesignator outputDesignator = ZCeeMappingUtil.getFirstOutputDesignator(mapping);
        switch (ZCeeMappingUtil.getDesignatorGroup(outputDesignator)) {
            case OUTPUT_BODY: {
                String bodyPath = ZCeeMappingUtil.getDesignatorFullPath(outputDesignator, "/");
                this.bodyPathToRemoveMapping.put(bodyPath, mapping);
                break;
            }
        }
    }

    @Override
    public void endOfWalk(MappingRoot mappingRoot) throws Exception {
        super.endOfWalk(mappingRoot);
    }

    public Map<String, Mapping> getHeaderParamNameToMoveMapping() {
        return this.headerParamNameToMoveMapping;
    }

    public Map<String, Mapping> getBodyPathToAssignMapping() {
        return this.bodyPathToAssignMapping;
    }

    public Map<String, Mapping> getBodyPathToRemoveMapping() {
        return this.bodyPathToRemoveMapping;
    }

    public Map<String, Mapping> getHeaderParamNameToAssignMapping() {
        return this.headerParamNameToAssignMapping;
    }

    public Map<String, Property> getHeaderParamNameToProperty() {
        return this.headerParamNameToProperty;
    }

    public Property getHeaderProperty(String headerParamName) {
        return this.headerParamNameToProperty.get(headerParamName);
    }

    public List<Property> getHeaderPropertys() {
        ArrayList<Property> retVal = new ArrayList<Property>();
        retVal.addAll(this.headerParamNameToProperty.values());
        return retVal;
    }

    public void setHeaderProperty(Property headerProperty) {
        this.headerParamNameToProperty.put(headerProperty.getName(), headerProperty);
    }

    public MappingDesignator getHeaderPropertySourceDesignator(String headerParamName) {
        MappingDesignator designator = null;
        Mapping mapping = this.headerParamNameToMoveMapping.get(headerParamName);
        if (mapping != null && (designator = ZCeeMappingUtil.getFirstInputDesignator(mapping)).getObject() == null) {
            designator = null;
        }
        return designator;
    }

    public XSDElementDeclaration getHeaderParamSourceXsdElement(String headerParamName) {
        XSDElementDeclaration xsdEle = null;
        Mapping mapping = this.headerParamNameToMoveMapping.get(headerParamName);
        if (mapping != null) {
            MappingDesignator input = ZCeeMappingUtil.getFirstInputDesignator(mapping);
            xsdEle = ZCeeMappingUtil.getXSDElementDeclaration(input.getObject());
        }
        return xsdEle;
    }

    public XSDSimpleTypeDefinition getHeaderParamSourceXsdType(String headerParamName) {
        XSDSimpleTypeDefinition xsdType = null;
        Mapping mapping = this.headerParamNameToMoveMapping.get(headerParamName);
        if (mapping != null) {
            MappingDesignator input = ZCeeMappingUtil.getFirstInputDesignator(mapping);
            xsdType = ZCeeMappingUtil.getXsdSimpleType(input);
        }
        return xsdType;
    }
}

