/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.mapping.util.msl.model;

import com.ibm.msl.mapping.Mapping;
import com.ibm.msl.mapping.MappingDesignator;
import com.ibm.msl.mapping.MappingRoot;
import com.ibm.zosconnect.ui.mapping.util.ZCeeMappingUtil;
import com.ibm.zosconnect.ui.mapping.util.msl.model.ZCeeMappingModel;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSimpleTypeDefinition;

public class ZCeeInputMappingModel
extends ZCeeMappingModel {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2018. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private LinkedHashMap<String, Mapping> headerParamNameToMoveMapping = new LinkedHashMap();
    private LinkedHashMap<String, Mapping> pathParamNameToMoveMapping = new LinkedHashMap();
    private LinkedHashMap<String, Mapping> queryParamNameToMoveMapping = new LinkedHashMap();
    private LinkedHashMap<String, Mapping> bodyPathToAssignMapping;
    private LinkedHashMap<String, Mapping> bodyPathToRemoveMapping = new LinkedHashMap();
    private LinkedHashMap<String, HeaderParameter> headerParamNameToParameter;
    private LinkedHashMap<String, PathParameter> pathParamNameToParameter;
    private LinkedHashMap<String, QueryParameter> queryParamNameToParameter;

    public ZCeeInputMappingModel() {
        this.bodyPathToAssignMapping = new LinkedHashMap();
        this.headerParamNameToParameter = new LinkedHashMap();
        this.pathParamNameToParameter = new LinkedHashMap();
        this.queryParamNameToParameter = new LinkedHashMap();
    }

    @Override
    public void startOfWalk(MappingRoot mappingRoot, List<Mapping> allMappings) throws Exception {
        super.startOfWalk(mappingRoot, allMappings);
    }

    @Override
    public void visitMoveMapping(Mapping mapping) throws Exception {
        super.visitMoveMapping(mapping);
        MappingDesignator inputDesignator = ZCeeMappingUtil.getFirstInputDesignator(mapping);
        switch (ZCeeMappingUtil.getDesignatorGroup(inputDesignator)) {
            case INPUT_HEADER: {
                String headerName = ZCeeMappingUtil.getDesignatorLocalName(inputDesignator);
                this.headerParamNameToMoveMapping.put(headerName, mapping);
                break;
            }
            case INPUT_PATH_PARAMETER: {
                String pathParamName = ZCeeMappingUtil.getDesignatorLocalName(inputDesignator);
                this.pathParamNameToMoveMapping.put(pathParamName, mapping);
                break;
            }
            case INPUT_QUERY_PARAMETER: {
                String queryParamName = ZCeeMappingUtil.getDesignatorLocalName(inputDesignator);
                this.queryParamNameToMoveMapping.put(queryParamName, mapping);
                break;
            }
        }
    }

    @Override
    public void visitAssignMapping(Mapping mapping) throws Exception {
        super.visitAssignMapping(mapping);
        MappingDesignator outputDesignator = ZCeeMappingUtil.getFirstOutputDesignator(mapping);
        switch (ZCeeMappingUtil.getDesignatorGroup(outputDesignator)) {
            case INPUT_BODY: {
                String bodyPath = ZCeeMappingUtil.getDesignatorFullPath(outputDesignator, "/");
                this.bodyPathToAssignMapping.put(bodyPath, mapping);
                break;
            }
        }
    }

    @Override
    public void visitRemoveMapping(Mapping mapping) throws Exception {
        super.visitRemoveMapping(mapping);
        MappingDesignator outputDesignator = ZCeeMappingUtil.getFirstOutputDesignator(mapping);
        switch (ZCeeMappingUtil.getDesignatorGroup(outputDesignator)) {
            case INPUT_BODY: {
                String bodyPath = ZCeeMappingUtil.getDesignatorFullPath(outputDesignator, "/");
                this.bodyPathToRemoveMapping.put(bodyPath, mapping);
                break;
            }
        }
    }

    @Override
    public void endOfWalk(MappingRoot mappingRoot) throws Exception {
        super.endOfWalk(mappingRoot);
    }

    public Map<String, Mapping> getHeaderParamNameToMoveMapping() {
        return this.headerParamNameToMoveMapping;
    }

    public Map<String, Mapping> getPathParamNameToMoveMapping() {
        return this.pathParamNameToMoveMapping;
    }

    public Map<String, Mapping> getQueryParamNameToMoveMapping() {
        return this.queryParamNameToMoveMapping;
    }

    public Map<String, Mapping> getBodyPathToAssignMapping() {
        return this.bodyPathToAssignMapping;
    }

    public Map<String, Mapping> getBodyPathToRemoveMapping() {
        return this.bodyPathToRemoveMapping;
    }

    public Map<String, HeaderParameter> getHeaderParamNameToParameter() {
        return this.headerParamNameToParameter;
    }

    public Map<String, PathParameter> getPathParamNameToParameter() {
        return this.pathParamNameToParameter;
    }

    public Map<String, QueryParameter> getQueryParamNameToParameter() {
        return this.queryParamNameToParameter;
    }

    public HeaderParameter getHeaderParameter(String headerParamName) {
        return this.headerParamNameToParameter.get(headerParamName);
    }

    public PathParameter getPathParameter(String pathParamName) {
        return this.pathParamNameToParameter.get(pathParamName);
    }

    public QueryParameter getQueryParameter(String queryParamName) {
        return this.queryParamNameToParameter.get(queryParamName);
    }

    public void setHeaderParameter(HeaderParameter headerParameter) {
        this.headerParamNameToParameter.put(headerParameter.getName(), headerParameter);
    }

    public void setPathParameter(PathParameter pathParameter) {
        this.pathParamNameToParameter.put(pathParameter.getName(), pathParameter);
    }

    public void setQueryParameter(QueryParameter queryParameter) {
        this.queryParamNameToParameter.put(queryParameter.getName(), queryParameter);
    }

    public List<HeaderParameter> getHeaderParameters() {
        ArrayList<HeaderParameter> retVal = new ArrayList<HeaderParameter>();
        retVal.addAll(this.headerParamNameToParameter.values());
        return retVal;
    }

    public List<PathParameter> getPathParameters() {
        ArrayList<PathParameter> retVal = new ArrayList<PathParameter>();
        retVal.addAll(this.pathParamNameToParameter.values());
        return retVal;
    }

    public List<QueryParameter> getQueryParameters() {
        ArrayList<QueryParameter> retVal = new ArrayList<QueryParameter>();
        retVal.addAll(this.queryParamNameToParameter.values());
        return retVal;
    }

    public MappingDesignator getHeaderParameterTargetDesignator(String headerParamName) {
        MappingDesignator designator = null;
        Mapping mapping = this.headerParamNameToMoveMapping.get(headerParamName);
        if (mapping != null && (designator = ZCeeMappingUtil.getFirstOutputDesignator(mapping)).getObject() == null) {
            designator = null;
        }
        return designator;
    }

    public MappingDesignator getPathParameterTargetDesignator(String pathParamName) {
        MappingDesignator designator = null;
        Mapping mapping = this.pathParamNameToMoveMapping.get(pathParamName);
        if (mapping != null && (designator = ZCeeMappingUtil.getFirstOutputDesignator(mapping)).getObject() == null) {
            designator = null;
        }
        return designator;
    }

    public MappingDesignator getQueryParameterTargetDesignator(String queryParamName) {
        MappingDesignator designator = null;
        Mapping mapping = this.queryParamNameToMoveMapping.get(queryParamName);
        if (mapping != null && (designator = ZCeeMappingUtil.getFirstOutputDesignator(mapping)).getObject() == null) {
            designator = null;
        }
        return designator;
    }

    public XSDElementDeclaration getHeaderParamTargetXsdElement(String headerParamName) {
        XSDElementDeclaration xsdEle = null;
        Mapping mapping = this.headerParamNameToMoveMapping.get(headerParamName);
        if (mapping != null) {
            MappingDesignator output = ZCeeMappingUtil.getFirstOutputDesignator(mapping);
            xsdEle = ZCeeMappingUtil.getXSDElementDeclaration(output.getObject());
        }
        return xsdEle;
    }

    public XSDElementDeclaration getPathParamTargetXsdElement(String pathParamName) {
        XSDElementDeclaration xsdEle = null;
        Mapping mapping = this.pathParamNameToMoveMapping.get(pathParamName);
        if (mapping != null) {
            MappingDesignator output = ZCeeMappingUtil.getFirstOutputDesignator(mapping);
            xsdEle = ZCeeMappingUtil.getXSDElementDeclaration(output.getObject());
        }
        return xsdEle;
    }

    public XSDElementDeclaration getQueryParamTargetXsdElement(String queryParamName) {
        XSDElementDeclaration xsdEle = null;
        Mapping mapping = this.queryParamNameToMoveMapping.get(queryParamName);
        if (mapping != null) {
            MappingDesignator output = ZCeeMappingUtil.getFirstOutputDesignator(mapping);
            xsdEle = ZCeeMappingUtil.getXSDElementDeclaration(output.getObject());
        }
        return xsdEle;
    }

    public XSDSimpleTypeDefinition getHeaderParamTargetXsdType(String headerParamName) {
        XSDSimpleTypeDefinition xsdType = null;
        Mapping mapping = this.headerParamNameToMoveMapping.get(headerParamName);
        if (mapping != null) {
            MappingDesignator output = ZCeeMappingUtil.getFirstOutputDesignator(mapping);
            xsdType = ZCeeMappingUtil.getXsdSimpleType(output);
        }
        return xsdType;
    }

    public XSDSimpleTypeDefinition getPathParamTargetXsdType(String pathParamName) {
        XSDSimpleTypeDefinition xsdType = null;
        Mapping mapping = this.pathParamNameToMoveMapping.get(pathParamName);
        if (mapping != null) {
            MappingDesignator output = ZCeeMappingUtil.getFirstOutputDesignator(mapping);
            xsdType = ZCeeMappingUtil.getXsdSimpleType(output);
        }
        return xsdType;
    }

    public XSDSimpleTypeDefinition getQueryParamTargetXsdType(String queryParamName) {
        XSDSimpleTypeDefinition xsdType = null;
        Mapping mapping = this.queryParamNameToMoveMapping.get(queryParamName);
        if (mapping != null) {
            MappingDesignator output = ZCeeMappingUtil.getFirstOutputDesignator(mapping);
            xsdType = ZCeeMappingUtil.getXsdSimpleType(output);
        }
        return xsdType;
    }
}

