/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.mapping.util.jsd2xsd.node;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.ibm.zosconnect.ui.mapping.util.jsd2xsd.node.Jsd2XsdArrayNode;
import com.ibm.zosconnect.ui.mapping.util.jsd2xsd.node.Jsd2XsdBooleanNode;
import com.ibm.zosconnect.ui.mapping.util.jsd2xsd.node.Jsd2XsdIntegerNode;
import com.ibm.zosconnect.ui.mapping.util.jsd2xsd.node.Jsd2XsdNode;
import com.ibm.zosconnect.ui.mapping.util.jsd2xsd.node.Jsd2XsdNullNode;
import com.ibm.zosconnect.ui.mapping.util.jsd2xsd.node.Jsd2XsdNumberNode;
import com.ibm.zosconnect.ui.mapping.util.jsd2xsd.node.Jsd2XsdObjectArrayNode;
import com.ibm.zosconnect.ui.mapping.util.jsd2xsd.node.Jsd2XsdObjectNode;
import com.ibm.zosconnect.ui.mapping.util.jsd2xsd.node.Jsd2XsdStringNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class Jsd2XsdNodeUtil {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static List<Jsd2XsdNode> getJsd2XsdNodesPreOrder(String rootNodeName, JsonNode rootNode, boolean unwrap) {
        ArrayList<Jsd2XsdNode> jsd2XsdNodes = new ArrayList<Jsd2XsdNode>();
        Stack<Jsd2XsdNode> parentJsd2XsdNodes = new Stack<Jsd2XsdNode>();
        HashMap<String, List<Jsd2XsdNode>> jsd2XsdNodeNameLists = new HashMap<String, List<Jsd2XsdNode>>();
        if (unwrap) {
            Map.Entry wrapper = (Map.Entry)rootNode.get("properties").fields().next();
            rootNodeName = (String)wrapper.getKey();
            rootNode = (JsonNode)wrapper.getValue();
        }
        Jsd2XsdNode nextJsd2XsdNode = Jsd2XsdNodeUtil.createJsd2XsdNodeFromJsonNode(rootNodeName, rootNode);
        Jsd2XsdNodeUtil._getJsd2XsdNodesInStructOrder(nextJsd2XsdNode, parentJsd2XsdNodes, jsd2XsdNodes, jsd2XsdNodeNameLists);
        return jsd2XsdNodes;
    }

    /*
     * WARNING - void declaration
     */
    private static void _getJsd2XsdNodesInStructOrder(Jsd2XsdNode nextJsd2XsdNode, Stack<Jsd2XsdNode> parentJsd2XsdNodes, List<Jsd2XsdNode> jsd2XsdNodes, Map<String, List<Jsd2XsdNode>> jsd2XsdNodeNameLists) {
        while (!parentJsd2XsdNodes.isEmpty() && parentJsd2XsdNodes.peek() != nextJsd2XsdNode && !parentJsd2XsdNodes.peek().getContents().contains(nextJsd2XsdNode)) {
            parentJsd2XsdNodes.pop();
        }
        ArrayList<Jsd2XsdNode> childJsd2XsdNodes = new ArrayList<Jsd2XsdNode>();
        jsd2XsdNodes.add(nextJsd2XsdNode);
        if (!jsd2XsdNodeNameLists.containsKey(nextJsd2XsdNode.getName())) {
            nodeNameList = new ArrayList<Jsd2XsdNode>();
            nodeNameList.add(nextJsd2XsdNode);
            jsd2XsdNodeNameLists.put(nextJsd2XsdNode.getName(), nodeNameList);
            nextJsd2XsdNode.setNameUnique(true);
        } else {
            nodeNameList = jsd2XsdNodeNameLists.get(nextJsd2XsdNode.getName());
            nodeNameList.add(nextJsd2XsdNode);
            for (Jsd2XsdNode jsd2XsdNode : nodeNameList) {
                jsd2XsdNode.setNameUnique(false);
            }
        }
        if (nextJsd2XsdNode instanceof Jsd2XsdObjectNode || nextJsd2XsdNode instanceof Jsd2XsdObjectArrayNode) {
            void var6_11;
            parentJsd2XsdNodes.push(nextJsd2XsdNode);
            content = null;
            content = nextJsd2XsdNode instanceof Jsd2XsdObjectArrayNode ? nextJsd2XsdNode.get("items").get("properties") : nextJsd2XsdNode.get("properties");
            Object var6_8 = null;
            if (nextJsd2XsdNode instanceof Jsd2XsdObjectArrayNode) {
                JsonNode jsonNode = nextJsd2XsdNode.get("items").get("required");
            } else {
                JsonNode jsonNode = nextJsd2XsdNode.get("required");
            }
            HashMap<String, JsonNode> requiredNodes = new HashMap<String, JsonNode>();
            if (var6_11 instanceof ArrayNode) {
                Iterator requiredIt = var6_11.elements();
                while (requiredIt.hasNext()) {
                    JsonNode nextRequired = (JsonNode)requiredIt.next();
                    requiredNodes.put(nextRequired.asText(), nextRequired);
                }
            }
            Iterator fields = content != null ? content.fields() : Collections.emptyIterator();
            while (fields.hasNext()) {
                Map.Entry nextField = (Map.Entry)fields.next();
                Jsd2XsdNode nextNode = Jsd2XsdNodeUtil.createJsd2XsdNodeFromJsonNode((String)nextField.getKey(), (JsonNode)nextField.getValue());
                parentJsd2XsdNodes.peek().getContents().add(nextNode);
                nextNode.setParents(parentJsd2XsdNodes);
                if (requiredNodes.containsKey(nextField.getKey())) {
                    nextNode.setRequired(true);
                } else {
                    nextNode.setRequired(false);
                }
                childJsd2XsdNodes.add(nextNode);
            }
        } else if (nextJsd2XsdNode instanceof Jsd2XsdArrayNode) {
            content = nextJsd2XsdNode.get("items");
            Jsd2XsdNode jsd2XsdNode = Jsd2XsdNodeUtil.createJsd2XsdNodeFromJsonNode(nextJsd2XsdNode.getName(), content);
            nextJsd2XsdNode.getContents().add(jsd2XsdNode);
        }
        for (Jsd2XsdNode childJsd2XsdNode : childJsd2XsdNodes) {
            Jsd2XsdNodeUtil._getJsd2XsdNodesInStructOrder(childJsd2XsdNode, parentJsd2XsdNodes, jsd2XsdNodes, jsd2XsdNodeNameLists);
        }
    }

    public static Jsd2XsdNode createJsd2XsdNodeFromJsonNode(String name, JsonNode jsonNode) {
        Jsd2XsdNode zceeJsonNode = null;
        String nodeType = Jsd2XsdNodeUtil.getFirstTypeAsText(jsonNode);
        if ("object".equals(nodeType)) {
            zceeJsonNode = new Jsd2XsdObjectNode(name, jsonNode);
        } else if ("array".equals(nodeType) && jsonNode.get("items") != null && jsonNode.get("items").has("properties")) {
            zceeJsonNode = new Jsd2XsdObjectArrayNode(name, jsonNode);
        } else if ("array".equals(nodeType) && jsonNode.get("items") != null && jsonNode.get("items").has("type") && "object".equals(jsonNode.get("items").get("type").asText())) {
            zceeJsonNode = new Jsd2XsdObjectArrayNode(name, jsonNode);
        } else if ("array".equals(nodeType)) {
            zceeJsonNode = new Jsd2XsdArrayNode(name, jsonNode);
        } else if ("string".equals(nodeType)) {
            zceeJsonNode = new Jsd2XsdStringNode(name, jsonNode);
        } else if ("integer".equals(nodeType)) {
            zceeJsonNode = new Jsd2XsdIntegerNode(name, jsonNode);
        } else if ("number".equals(nodeType)) {
            zceeJsonNode = new Jsd2XsdNumberNode(name, jsonNode);
        } else if ("boolean".equals(nodeType)) {
            zceeJsonNode = new Jsd2XsdBooleanNode(name, jsonNode);
        } else if ("null".equals(nodeType)) {
            zceeJsonNode = new Jsd2XsdNullNode(name, jsonNode);
        }
        return zceeJsonNode;
    }

    public static String getFirstTypeAsText(JsonNode node) {
        if (node == null) {
            return null;
        }
        String typeAsText = null;
        JsonNode typeValueNode = node.get("type");
        if (typeValueNode instanceof ArrayNode) {
            ArrayNode typeArrayNode = (ArrayNode)typeValueNode;
            int i = 0;
            while (i < typeArrayNode.size() && typeAsText == null) {
                JsonNode typeNode = typeArrayNode.get(i);
                if (!"null".equals(typeNode.asText())) {
                    typeAsText = typeNode.asText();
                }
                ++i;
            }
        } else if (typeValueNode != null) {
            typeAsText = typeValueNode.asText();
        }
        return typeAsText;
    }
}

