/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.mapping.util.jsd2xsd.node;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.xsd.XSDTypeDefinition;

public class Jsd2XsdNode {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String name = null;
    private JsonNode node = null;
    private List<Jsd2XsdNode> parents = new ArrayList<Jsd2XsdNode>();
    private List<Jsd2XsdNode> contents = new ArrayList<Jsd2XsdNode>();
    private XSDTypeDefinition xsdTypeDef = null;
    private boolean isNameUnique = true;
    private boolean isRequired = false;

    public Jsd2XsdNode(String name, JsonNode node) {
        this.name = name;
        this.node = node;
    }

    public Jsd2XsdNode(String name, JsonNode node, List<Jsd2XsdNode> parents) {
        this(name, node);
        this.setParents(parents);
    }

    public Jsd2XsdNode(String name, JsonNode node, List<Jsd2XsdNode> parents, List<Jsd2XsdNode> contents) {
        this(name, node, parents);
        this.setContents(contents);
    }

    public JsonNode get(String fieldName) {
        return this.node.get(fieldName);
    }

    public JsonNode get(int i) {
        return this.node.get(i);
    }

    public JsonNodeType getNodeType() {
        return this.node.getNodeType();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPath() {
        return this.getPath(".");
    }

    public String getPath(String delim) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < this.parents.size()) {
            buf.append(this.parents.get((int)i).name);
            buf.append(delim);
            ++i;
        }
        buf.append(this.name);
        return buf.toString();
    }

    public JsonNode getNode() {
        return this.node;
    }

    public void setNode(JsonNode node) {
        this.node = node;
    }

    public List<Jsd2XsdNode> getParents() {
        return this.parents;
    }

    public void setParents(List<Jsd2XsdNode> parents) {
        this.parents.clear();
        this.parents.addAll(parents);
    }

    public List<Jsd2XsdNode> getContents() {
        return this.contents;
    }

    public void setContents(List<Jsd2XsdNode> contents) {
        this.contents.clear();
        this.contents.addAll(contents);
    }

    public String getFirstTypeAsText() {
        String typeAsText = null;
        JsonNode typeValueNode = this.node.get("type");
        if (typeValueNode instanceof ArrayNode) {
            ArrayNode typeArrayNode = (ArrayNode)typeValueNode;
            int i = 0;
            while (i < typeArrayNode.size() && typeAsText == null) {
                JsonNode typeNode = typeArrayNode.get(i);
                if (!"null".equals(typeNode.asText())) {
                    typeAsText = typeNode.asText();
                }
                ++i;
            }
        } else if (typeValueNode != null) {
            typeAsText = typeValueNode.asText();
        }
        return typeAsText;
    }

    public String toString() {
        return this.getPath();
    }

    public XSDTypeDefinition getXsdTypeDef() {
        return this.xsdTypeDef;
    }

    public void setXsdTypeDef(XSDTypeDefinition xsdTypeDef) {
        this.xsdTypeDef = xsdTypeDef;
    }

    public boolean isNameUnique() {
        return this.isNameUnique;
    }

    public void setNameUnique(boolean isNameUnique) {
        this.isNameUnique = isNameUnique;
    }

    public boolean isNullableType() {
        if (this.node == null) {
            return false;
        }
        JsonNode typeValueNode = this.node.get("type");
        if (typeValueNode instanceof ArrayNode) {
            ArrayNode typeArrayNode = (ArrayNode)typeValueNode;
            int i = 0;
            while (i < typeArrayNode.size()) {
                JsonNode typeNode = typeArrayNode.get(i);
                if ("null".equals(typeNode.asText())) {
                    return true;
                }
                ++i;
            }
        } else if (typeValueNode != null && "null".equals(typeValueNode.asText())) {
            return true;
        }
        return false;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public void setRequired(boolean isRequired) {
        this.isRequired = isRequired;
    }
}

