/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.mapping.util.jsd2xsd;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.ibm.zosconnect.ui.mapping.util.jsd2xsd.IJsd2XsdConverterVisitor;
import com.ibm.zosconnect.ui.mapping.util.jsd2xsd.Jsd2XsdConverter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import org.eclipse.emf.ecore.resource.Resource;

public class Jsd2XsdConverterFactory {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Object inputObject;
    private Object outputObject;
    private Jsd2XsdConverter.JsonInputFormat inputType;
    private Jsd2XsdConverter.XsdOutputFormat outputType;
    private String qNamePrefix;
    private String targetNamespace;
    private String targetNamespacePrefix;
    private String globalElementName;
    private IJsd2XsdConverterVisitor visitor;

    public Jsd2XsdConverter create() throws JsonProcessingException, IOException {
        Jsd2XsdConverter jsd2XsdConverter = new Jsd2XsdConverter();
        jsd2XsdConverter.setInput(this.inputType, this.inputObject);
        jsd2XsdConverter.setOutput(this.outputType, this.outputObject);
        jsd2XsdConverter.setGlobalElementName(this.globalElementName);
        jsd2XsdConverter.setQNamePrefix(this.qNamePrefix);
        jsd2XsdConverter.setTargetNamespace(this.targetNamespace);
        jsd2XsdConverter.setTargetNamespacePrefix(this.targetNamespacePrefix);
        jsd2XsdConverter.setVisitor(this.visitor);
        return jsd2XsdConverter;
    }

    public Jsd2XsdConverterFactory setJsonFromFilePath(String filePath) {
        this.inputType = Jsd2XsdConverter.JsonInputFormat.FILE_PATH;
        this.inputObject = filePath;
        return this;
    }

    public Jsd2XsdConverterFactory setJsonFromFile(File file) {
        this.inputType = Jsd2XsdConverter.JsonInputFormat.FILE;
        this.inputObject = file;
        return this;
    }

    public Jsd2XsdConverterFactory setJsonFromString(String json) {
        this.inputType = Jsd2XsdConverter.JsonInputFormat.TEXT;
        this.inputObject = json;
        return this;
    }

    private Jsd2XsdConverterFactory setJsonFromURL(String url) {
        this.inputType = Jsd2XsdConverter.JsonInputFormat.URL;
        this.inputObject = url;
        return this;
    }

    protected Jsd2XsdConverterFactory setOutputFileLocation(String filePath) {
        this.outputType = Jsd2XsdConverter.XsdOutputFormat.FILE_PATH;
        this.outputObject = filePath;
        return this;
    }

    public Jsd2XsdConverterFactory setOutputFile(File file) {
        this.outputType = Jsd2XsdConverter.XsdOutputFormat.FILE;
        this.outputObject = file;
        return this;
    }

    public Jsd2XsdConverterFactory setOutputStream(ByteArrayOutputStream outputStream) {
        this.outputType = Jsd2XsdConverter.XsdOutputFormat.OUTPUT_STREAM;
        this.outputObject = outputStream;
        return this;
    }

    public Jsd2XsdConverterFactory setOutputResource(Resource resource) {
        this.outputType = Jsd2XsdConverter.XsdOutputFormat.RESOURCE;
        this.outputObject = resource;
        return this;
    }

    public Jsd2XsdConverterFactory setTargetNamespacePrefix(String targetNamespacePrefix) {
        this.targetNamespacePrefix = targetNamespacePrefix;
        return this;
    }

    public Jsd2XsdConverterFactory setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
        return this;
    }

    public Jsd2XsdConverterFactory setQNamePrefix(String qNamePrefix) {
        this.qNamePrefix = qNamePrefix;
        return this;
    }

    public Jsd2XsdConverterFactory setGlobalElementName(String generatedRootName) {
        this.globalElementName = generatedRootName;
        return this;
    }

    public Jsd2XsdConverterFactory setVisitor(IJsd2XsdConverterVisitor visitor) {
        this.visitor = visitor;
        return this;
    }
}

