/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.mapping.util.jsd2xsd;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.ibm.zosconnect.api.mapping.jsd.JsonSchemaPrimitiveType;
import com.ibm.zosconnect.api.mapping.jsd.JsonSchemaPrimitiveTypeFormat;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.common.util.xsd.IZosConnectXsdSimpleTypes;
import com.ibm.zosconnect.ui.common.util.xsd.ZosConnectXsdSimpleTypes;
import com.ibm.zosconnect.ui.common.util.xsd.ZosConnectXsdUtil;
import com.ibm.zosconnect.ui.mapping.util.jsd2xsd.IJsd2XsdConverterVisitor;
import com.ibm.zosconnect.ui.mapping.util.jsd2xsd.Jsd2XsdException;
import com.ibm.zosconnect.ui.mapping.util.jsd2xsd.node.Jsd2XsdArrayNode;
import com.ibm.zosconnect.ui.mapping.util.jsd2xsd.node.Jsd2XsdNode;
import com.ibm.zosconnect.ui.mapping.util.jsd2xsd.node.Jsd2XsdNodeUtil;
import com.ibm.zosconnect.ui.mapping.util.jsd2xsd.node.Jsd2XsdObjectArrayNode;
import com.ibm.zosconnect.ui.mapping.util.jsd2xsd.node.Jsd2XsdObjectNode;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceFactoryImpl;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDConstraint;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDFractionDigitsFacet;
import org.eclipse.xsd.XSDMaxInclusiveFacet;
import org.eclipse.xsd.XSDMaxLengthFacet;
import org.eclipse.xsd.XSDMinInclusiveFacet;
import org.eclipse.xsd.XSDMinLengthFacet;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTerm;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.impl.XSDFactoryImpl;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.w3c.dom.Element;

public class Jsd2XsdConverter {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static ObjectMapper jsonMapper = new ObjectMapper(new JsonFactory());
    private static final IZosConnectXsdSimpleTypes xsdSimpleTypes;
    private XSDFactory xsdFactory;
    private FileOutputStream fileOutputStream;
    private ByteArrayOutputStream byteOutputStream;
    private String qNamePrefix = "xsd";
    private String globalElementName;
    private String targetNamespace;
    private String targetNamespacePrefix;
    private XSDSchema xsdSchema;
    private XSDSchema schema;
    private JsonNode jsonTreeHead;
    private List<Jsd2XsdNode> jsd2XsdNodes;
    private Resource resource;
    private JsonInputFormat inputType;
    private XsdOutputFormat outputType;
    private Object jsonInput;
    private Object output;
    private IJsd2XsdConverterVisitor visitor;
    private boolean globalElementGenerated = false;

    static {
        jsonMapper.enable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        jsonMapper.enable(DeserializationFeature.WRAP_EXCEPTIONS);
        jsonMapper.enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        jsonMapper.enable(DeserializationFeature.USE_BIG_INTEGER_FOR_INTS);
        xsdSimpleTypes = ZosConnectXsdSimpleTypes.getInstance();
    }

    protected void setInput(JsonInputFormat inputType, Object inputObject) {
        this.inputType = inputType;
        this.jsonInput = inputObject;
    }

    protected void setOutput(XsdOutputFormat outputType, Object outputObject) {
        this.outputType = outputType;
        this.output = outputObject;
    }

    private JsonNode initInputJsonTree() throws JsonProcessingException, IOException {
        switch (this.inputType) {
            case FILE_PATH: {
                FileInputStream jsonFile = new FileInputStream(new File((String)this.jsonInput));
                this.jsonTreeHead = jsonMapper.readTree((InputStream)jsonFile);
                break;
            }
            case FILE: {
                FileInputStream jsonFile = new FileInputStream((File)this.jsonInput);
                this.jsonTreeHead = jsonMapper.readTree((InputStream)jsonFile);
                break;
            }
            case TEXT: {
                this.jsonTreeHead = jsonMapper.readTree((String)this.jsonInput);
                break;
            }
            case URL: {
                break;
            }
        }
        return this.jsonTreeHead;
    }

    private Resource initOutputSource() throws IOException {
        switch (this.outputType) {
            case FILE_PATH: {
                File file = new File((String)this.output);
                this.fileOutputStream = new FileOutputStream(file);
                this.resource = this.createXSDResource(new File((String)this.output));
                break;
            }
            case FILE: {
                this.fileOutputStream = new FileOutputStream((File)this.output);
                this.resource = this.createXSDResource((File)this.output);
                break;
            }
            case OUTPUT_STREAM: {
                this.byteOutputStream = (ByteArrayOutputStream)this.output;
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMLResourceFactoryImpl());
                this.resource = resourceSet.createResource(URI.createURI((String)""), "");
                if (this.byteOutputStream != null) break;
                this.byteOutputStream = new ByteArrayOutputStream();
                break;
            }
            case RESOURCE: {
                this.fileOutputStream = null;
                this.resource = (Resource)this.output;
            }
        }
        return this.resource;
    }

    private void init() throws JsonProcessingException, IOException {
        this.jsonTreeHead = this.initInputJsonTree();
        this.resource = this.initOutputSource();
        this.xsdSchema = XSDFactory.eINSTANCE.createXSDSchema();
        this.schema = XSDSchemaImpl.getSchemaForSchema((String)"http://www.w3.org/2001/XMLSchema");
        this.xsdSchema.setSchemaForSchemaQNamePrefix(this.getQNamePrefix());
        Map qNamePrefixToNamespaceMap = this.xsdSchema.getQNamePrefixToNamespaceMap();
        this.xsdSchema.setTargetNamespace(this.getTargetNamespace());
        qNamePrefixToNamespaceMap.put(this.getTargetNamespacePrefix(), this.xsdSchema.getTargetNamespace());
        qNamePrefixToNamespaceMap.put(this.xsdSchema.getSchemaForSchemaQNamePrefix(), "http://www.w3.org/2001/XMLSchema");
        this.xsdSchema.updateElement();
        EList contents = this.resource.getContents();
        contents.add((Object)this.xsdSchema);
        if (this.outputType == XsdOutputFormat.FILE || this.outputType == XsdOutputFormat.FILE_PATH) {
            this.resource.save(Collections.EMPTY_MAP);
        }
        this.xsdFactory = XSDFactoryImpl.init();
    }

    public void run() throws ParserConfigurationException, FileNotFoundException, IOException, Jsd2XsdException {
        this.init();
        JsonNode topProperties = this.jsonTreeHead.get("properties");
        Iterator topFields = null;
        topFields = topProperties != null ? topProperties.fields() : new HashMap().entrySet().iterator();
        Map.Entry firstTopField = null;
        String firstTopFieldName = null;
        JsonNode firstTopFieldNode = null;
        String firstTopFieldType = null;
        int topFieldCount = 0;
        if (topFields.hasNext()) {
            firstTopField = topFields.next();
            firstTopFieldName = (String)firstTopField.getKey();
            firstTopFieldNode = (JsonNode)firstTopField.getValue();
            firstTopFieldType = Jsd2XsdConverter.getFirstTypeAsText(firstTopFieldNode);
            ++topFieldCount;
        }
        while (topFields.hasNext()) {
            ++topFieldCount;
            topFields.next();
        }
        if ("array".equals(firstTopFieldType)) {
            firstTopFieldType = Jsd2XsdConverter.getFirstTypeAsText(firstTopFieldNode.get("items"));
        }
        this.globalElementGenerated = false;
        if (!"object".equals(firstTopFieldType) || topFieldCount > 1) {
            ObjectNode newJsonTreeHead = jsonMapper.createObjectNode();
            newJsonTreeHead.put("type", "object");
            newJsonTreeHead.set("properties", topProperties);
            this.jsonTreeHead = newJsonTreeHead;
            this.globalElementGenerated = true;
        }
        if (StringUtils.isBlank((CharSequence)this.getGlobalElementName())) {
            if (this.globalElementGenerated && this.visitor != null) {
                this.setGlobalElementName(this.visitor.getWrapperObjectName());
            } else {
                this.setGlobalElementName(firstTopFieldName);
            }
        }
        if (StringUtils.isBlank((CharSequence)this.getGlobalElementName())) {
            throw new Jsd2XsdException(Xlat.error((String)"ERROR_JSD2XSD_ROOT_REQUIRED"));
        }
        try {
            this.jsd2XsdNodes = Jsd2XsdNodeUtil.getJsd2XsdNodesPreOrder(this.getGlobalElementName(), this.jsonTreeHead, !this.globalElementGenerated);
            this.createComplexTypeDefinitions();
            Jsd2XsdNode rootJsd2XsdNode = this.jsd2XsdNodes.get(0);
            if (rootJsd2XsdNode instanceof Jsd2XsdObjectNode) {
                this.createXSDRootElement((Jsd2XsdObjectNode)rootJsd2XsdNode);
            } else if (rootJsd2XsdNode instanceof Jsd2XsdObjectArrayNode) {
                this.createXSDRootElement((Jsd2XsdObjectArrayNode)rootJsd2XsdNode);
            }
            this.populateComplexTypes();
            if (this.outputType == XsdOutputFormat.FILE || this.outputType == XsdOutputFormat.FILE_PATH) {
                this.saveResource(this.resource);
            } else {
                this.saveResource(this.resource);
            }
        }
        catch (Exception exception) {
            throw new Jsd2XsdException(Xlat.error((String)"ERROR_JSD2XSD_PARSE_ERROR"));
        }
    }

    private void populateComplexTypes() throws Jsd2XsdException {
        for (Jsd2XsdNode jsd2XsdNode : this.jsd2XsdNodes) {
            if (!(jsd2XsdNode.getXsdTypeDef() instanceof XSDComplexTypeDefinition)) continue;
            XSDComplexTypeDefinition xsdComplexTypeDef = (XSDComplexTypeDefinition)jsd2XsdNode.getXsdTypeDef();
            if (!(jsd2XsdNode instanceof Jsd2XsdObjectNode) && !(jsd2XsdNode instanceof Jsd2XsdObjectArrayNode)) continue;
            XSDModelGroup xsdModelGroup = this.insertSequence(xsdComplexTypeDef);
            for (Jsd2XsdNode content : jsd2XsdNode.getContents()) {
                this.addObjectToSequence(this.resource, xsdModelGroup, content);
            }
        }
    }

    private void createComplexTypeDefinitions() throws Jsd2XsdException {
        for (Jsd2XsdNode jsd2XsdNode : this.jsd2XsdNodes) {
            String typeName = null;
            typeName = jsd2XsdNode.isNameUnique() ? jsd2XsdNode.getName() : jsd2XsdNode.getPath();
            if (jsd2XsdNode instanceof Jsd2XsdObjectNode || jsd2XsdNode instanceof Jsd2XsdObjectArrayNode) {
                XSDComplexTypeDefinition xsdTypeDef = this.xsdFactory.createXSDComplexTypeDefinition();
                xsdTypeDef.setName(typeName);
                xsdTypeDef.setTargetNamespace(this.xsdSchema.getTargetNamespace());
                ((XSDSchema)this.resource.getContents().get(0)).getContents().add((Object)xsdTypeDef);
                jsd2XsdNode.setXsdTypeDef((XSDTypeDefinition)xsdTypeDef);
                continue;
            }
            if (!(jsd2XsdNode instanceof Jsd2XsdArrayNode)) continue;
            XSDParticle xsdArrayParticle = this.createParticleFromJsonNode(jsd2XsdNode.getContents().get(0));
            XSDElementDeclaration xsdElemDec = (XSDElementDeclaration)xsdArrayParticle.getTerm();
            XSDTypeDefinition xsdBaseTypeDef = xsdElemDec.getAnonymousTypeDefinition();
            xsdBaseTypeDef.setName(typeName);
            ((XSDSchema)this.resource.getContents().get(0)).getContents().add((Object)xsdBaseTypeDef);
            jsd2XsdNode.setXsdTypeDef(xsdBaseTypeDef);
        }
    }

    private void createXSDRootElement(Jsd2XsdObjectNode rootJsd2XsdNode) throws Jsd2XsdException {
        XSDElementDeclaration rootElement = this.xsdFactory.createXSDElementDeclaration();
        rootElement.setName(this.globalElementName);
        XSDComplexTypeDefinition rootType = (XSDComplexTypeDefinition)rootJsd2XsdNode.getXsdTypeDef();
        rootElement.setTypeDefinition((XSDTypeDefinition)rootType);
        ((XSDSchema)this.resource.getContents().get(0)).getContents().add(0, (Object)rootElement);
    }

    private void createXSDRootElement(Jsd2XsdObjectArrayNode rootJsd2XsdNode) throws Jsd2XsdException {
        XSDElementDeclaration rootElement = this.xsdFactory.createXSDElementDeclaration();
        rootElement.setName(this.globalElementName);
        XSDComplexTypeDefinition rootXsdTypeDef = this.xsdFactory.createXSDComplexTypeDefinition();
        rootXsdTypeDef.setName(this.globalElementName);
        rootXsdTypeDef.setTargetNamespace(this.xsdSchema.getTargetNamespace());
        XSDModelGroup rootXsdSequence = this.insertSequence(rootXsdTypeDef);
        this.addObjectToSequence(this.resource, rootXsdSequence, rootJsd2XsdNode);
        rootElement.setTypeDefinition((XSDTypeDefinition)rootXsdTypeDef);
        ((XSDSchema)this.resource.getContents().get(0)).getContents().add(0, (Object)rootXsdTypeDef);
        ((XSDSchema)this.resource.getContents().get(0)).getContents().add(0, (Object)rootElement);
    }

    private Resource createXSDResource(File file) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMLResourceFactoryImpl());
        Resource resource = resourceSet.createResource(URI.createFileURI((String)file.getAbsolutePath()));
        return resource;
    }

    public String getTargetNamespacePrefix() {
        return this.targetNamespacePrefix;
    }

    protected void setTargetNamespacePrefix(String targetNamespacePrefix) {
        this.targetNamespacePrefix = targetNamespacePrefix;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    protected void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public String getQNamePrefix() {
        return this.qNamePrefix;
    }

    protected void setQNamePrefix(String qNamePrefix) {
        this.qNamePrefix = qNamePrefix;
    }

    public String getGlobalElementName() {
        return this.globalElementName;
    }

    public ByteArrayOutputStream getByteOutputStream() {
        return this.byteOutputStream;
    }

    public FileOutputStream getFileOutputStream() {
        return this.fileOutputStream;
    }

    protected void setGlobalElementName(String generatedRootName) {
        this.globalElementName = generatedRootName;
    }

    private void saveResource(Resource resource) throws IOException {
        block1: {
            block0: {
                if (this.outputType != XsdOutputFormat.FILE && this.outputType != XsdOutputFormat.FILE_PATH) break block0;
                XSDResourceImpl.serialize((OutputStream)this.fileOutputStream, (Element)((XSDSchema)resource.getContents().get(0)).getElement());
                break block1;
            }
            if (this.outputType != XsdOutputFormat.OUTPUT_STREAM) break block1;
            XSDResourceImpl.serialize((OutputStream)this.byteOutputStream, (Element)((XSDSchema)resource.getContents().get(0)).getElement());
        }
    }

    private XSDModelGroup insertSequence(XSDComplexTypeDefinition arrayTypeDefinition) {
        XSDParticle xsdParticle = this.xsdFactory.createXSDParticle();
        XSDModelGroup modelGroup = this.xsdFactory.createXSDModelGroup();
        modelGroup.setCompositor(XSDCompositor.SEQUENCE_LITERAL);
        xsdParticle.setContent((XSDParticleContent)modelGroup);
        arrayTypeDefinition.setContent((XSDComplexTypeContent)xsdParticle);
        return modelGroup;
    }

    private void addObjectToSequence(Resource resource, XSDModelGroup sequence, Jsd2XsdNode jsd2XsdNode) throws Jsd2XsdException {
        XSDParticle xsdParticle = this.createParticleFromJsonNode(jsd2XsdNode);
        EList sequenceContents = sequence.getContents();
        sequenceContents.add((Object)xsdParticle);
        this.annotateXSDParticle(xsdParticle, jsd2XsdNode);
    }

    private XSDParticle createParticleFromJsonNode(Jsd2XsdNode jsd2XsdNode) throws Jsd2XsdException {
        XSDParticle xsdParticle = this.xsdFactory.createXSDParticle();
        boolean required = jsd2XsdNode.isRequired();
        String type = jsd2XsdNode.getFirstTypeAsText();
        if (type.equals("object")) {
            XSDElementDeclaration element = this.createXSDElementFromJsonObject(jsd2XsdNode);
            xsdParticle.setContent((XSDParticleContent)element);
            if (!required) {
                xsdParticle.setMinOccurs(0);
            }
        } else if (type.equals("array")) {
            XSDElementDeclaration element = this.createXSDSequenceFromJsonArray(xsdParticle, jsd2XsdNode);
            xsdParticle.setContent((XSDParticleContent)element);
        } else if (type.equals("string")) {
            XSDElementDeclaration element = this.createXSDStringFromJsonString(jsd2XsdNode);
            xsdParticle.setContent((XSDParticleContent)element);
            if (!required) {
                xsdParticle.setMinOccurs(0);
            }
        } else if (type.equals("integer")) {
            XSDElementDeclaration element = this.createXSDIntegerFromJsonInteger(jsd2XsdNode);
            xsdParticle.setContent((XSDParticleContent)element);
            if (!required) {
                xsdParticle.setMinOccurs(0);
            }
        } else if (type.equals("number")) {
            XSDElementDeclaration element = this.createXSDNumberFromJsonNumber(jsd2XsdNode);
            xsdParticle.setContent((XSDParticleContent)element);
            if (!required) {
                xsdParticle.setMinOccurs(0);
            }
        } else if (type.equals("boolean")) {
            XSDElementDeclaration element = this.createXSDBooleanFromJsonBoolean(jsd2XsdNode);
            xsdParticle.setContent((XSDParticleContent)element);
            if (!required) {
                xsdParticle.setMinOccurs(0);
            }
        } else if (type.equals("null")) {
            throw new Jsd2XsdException(Xlat.error((String)"ERROR_JSD2XSD_MISSING_TYPE"));
        }
        return xsdParticle;
    }

    private XSDElementDeclaration createXSDIntegerFromJsonInteger(Jsd2XsdNode jsd2XsdNode) {
        XSDElementDeclaration element = this.xsdFactory.createXSDElementDeclaration();
        element.setName(jsd2XsdNode.getName());
        XSDSimpleTypeDefinition simpleTypeDefinition = this.xsdFactory.createXSDSimpleTypeDefinition();
        XSDSimpleTypeDefinition integerTypeDefinition = (XSDSimpleTypeDefinition)Jsd2XsdConverter.getNamedType(this.schema, "integer");
        simpleTypeDefinition.setBaseTypeDefinition(integerTypeDefinition);
        JsonNode minValue = jsd2XsdNode.get("minimum");
        JsonNode maxValue = jsd2XsdNode.get("maximum");
        JsonNode defaultValue = jsd2XsdNode.get("default");
        if (minValue != null) {
            String minVal = minValue.asText();
            XSDMinInclusiveFacet minInclusiveFacet = XSDFactory.eINSTANCE.createXSDMinInclusiveFacet();
            minInclusiveFacet.setLexicalValue(minVal);
            simpleTypeDefinition.getFacetContents().add((Object)minInclusiveFacet);
        }
        if (maxValue != null) {
            String maxVal = maxValue.asText();
            XSDMaxInclusiveFacet maxInclusiveFacet = XSDFactory.eINSTANCE.createXSDMaxInclusiveFacet();
            maxInclusiveFacet.setLexicalValue(maxVal);
            simpleTypeDefinition.getFacetContents().add((Object)maxInclusiveFacet);
        }
        if (defaultValue != null) {
            String defaultVal = defaultValue.asText();
            element.setConstraint(XSDConstraint.DEFAULT_LITERAL);
            element.setLexicalValue(defaultVal);
        }
        if (jsd2XsdNode.isNullableType()) {
            element.setNillable(true);
        }
        element.setAnonymousTypeDefinition((XSDTypeDefinition)simpleTypeDefinition);
        return element;
    }

    public static XSDTypeDefinition getNamedType(XSDSchema schema, String typeName) {
        if (schema == null || typeName == null) {
            return null;
        }
        EList contents = schema.getTypeDefinitions();
        for (Object item : contents) {
            if (!typeName.equals(((XSDTypeDefinition)item).getName())) continue;
            return (XSDTypeDefinition)item;
        }
        return null;
    }

    private XSDElementDeclaration createXSDBooleanFromJsonBoolean(Jsd2XsdNode jsd2XsdNode) {
        XSDElementDeclaration element = this.xsdFactory.createXSDElementDeclaration();
        element.setName(jsd2XsdNode.getName());
        XSDSimpleTypeDefinition simpleTypeDefinition = this.xsdFactory.createXSDSimpleTypeDefinition();
        XSDSimpleTypeDefinition booleanTypeDefinition = (XSDSimpleTypeDefinition)Jsd2XsdConverter.getNamedType(this.schema, "boolean");
        simpleTypeDefinition.setBaseTypeDefinition(booleanTypeDefinition);
        element.setAnonymousTypeDefinition((XSDTypeDefinition)simpleTypeDefinition);
        JsonNode defaultValue = jsd2XsdNode.get("default");
        if (defaultValue != null) {
            String defaultVal = defaultValue.asText();
            element.setConstraint(XSDConstraint.DEFAULT_LITERAL);
            element.setLexicalValue(defaultVal);
        }
        if (jsd2XsdNode.isNullableType()) {
            element.setNillable(true);
        }
        return element;
    }

    private XSDElementDeclaration createXSDNumberFromJsonNumber(Jsd2XsdNode jsd2XsdNode) {
        XSDElementDeclaration element = this.xsdFactory.createXSDElementDeclaration();
        element.setName(jsd2XsdNode.getName());
        XSDSimpleTypeDefinition simpleTypeDefinition = this.xsdFactory.createXSDSimpleTypeDefinition();
        JsonNode minValueNode = jsd2XsdNode.get("minimum");
        JsonNode maxValueNode = jsd2XsdNode.get("maximum");
        JsonNode mulValueNode = jsd2XsdNode.get("multipleOf");
        JsonNode fmtValueNode = jsd2XsdNode.get("format");
        JsonNode defaultValue = jsd2XsdNode.get("default");
        BigDecimal minValue = minValueNode != null ? minValueNode.decimalValue() : BigDecimal.ZERO;
        BigDecimal maxValue = maxValueNode != null ? maxValueNode.decimalValue() : BigDecimal.ZERO;
        BigDecimal mulValue = mulValueNode != null ? mulValueNode.decimalValue() : BigDecimal.ZERO;
        String fmtValue = fmtValueNode != null ? fmtValueNode.asText() : "";
        boolean isInteger = mulValueNode != null && mulValue.scale() == 0;
        boolean isFloat = !isInteger && "float".equals(fmtValue);
        boolean isDouble = !isInteger && "double".equals(fmtValue);
        XSDSimpleTypeDefinition numberTypeDefiniton = null;
        numberTypeDefiniton = isInteger ? (XSDSimpleTypeDefinition)Jsd2XsdConverter.getNamedType(this.schema, "integer") : (isFloat ? (XSDSimpleTypeDefinition)Jsd2XsdConverter.getNamedType(this.schema, "float") : (isDouble ? (XSDSimpleTypeDefinition)Jsd2XsdConverter.getNamedType(this.schema, "double") : (XSDSimpleTypeDefinition)Jsd2XsdConverter.getNamedType(this.schema, "decimal")));
        simpleTypeDefinition.setBaseTypeDefinition(numberTypeDefiniton);
        if (minValueNode != null) {
            XSDMinInclusiveFacet minInclusiveFacet = XSDFactory.eINSTANCE.createXSDMinInclusiveFacet();
            minInclusiveFacet.setLexicalValue(minValue.toPlainString());
            simpleTypeDefinition.getFacetContents().add((Object)minInclusiveFacet);
        }
        if (maxValueNode != null) {
            XSDMaxInclusiveFacet maxInclusiveFacet = XSDFactory.eINSTANCE.createXSDMaxInclusiveFacet();
            maxInclusiveFacet.setLexicalValue(maxValue.toPlainString());
            simpleTypeDefinition.getFacetContents().add((Object)maxInclusiveFacet);
        }
        if (mulValueNode != null && !isInteger) {
            Integer fractionDigits = mulValue.scale();
            XSDFractionDigitsFacet fractionalFacet = XSDFactory.eINSTANCE.createXSDFractionDigitsFacet();
            fractionalFacet.setLexicalValue(fractionDigits.toString());
            simpleTypeDefinition.getFacetContents().add((Object)fractionalFacet);
        }
        if (defaultValue != null) {
            String defaultVal = defaultValue.asText();
            element.setConstraint(XSDConstraint.DEFAULT_LITERAL);
            element.setLexicalValue(defaultVal);
        }
        if (jsd2XsdNode.isNullableType()) {
            element.setNillable(true);
        }
        element.setAnonymousTypeDefinition((XSDTypeDefinition)simpleTypeDefinition);
        return element;
    }

    private XSDElementDeclaration createXSDStringFromJsonString(Jsd2XsdNode jsd2XsdNode) {
        XSDElementDeclaration element = this.xsdFactory.createXSDElementDeclaration();
        element.setName(jsd2XsdNode.getName());
        XSDSimpleTypeDefinition simpleTypeDefinition = this.xsdFactory.createXSDSimpleTypeDefinition();
        XSDSimpleTypeDefinition stringTypeDefinition = (XSDSimpleTypeDefinition)Jsd2XsdConverter.getNamedType(this.schema, "string");
        this.setNamespace(stringTypeDefinition);
        simpleTypeDefinition.setBaseTypeDefinition(stringTypeDefinition);
        JsonNode minLength = jsd2XsdNode.get("minLength");
        JsonNode maxLength = jsd2XsdNode.get("maxLength");
        JsonNode defaultValue = jsd2XsdNode.get("default");
        if (minLength != null) {
            String minValue = minLength.asText();
            XSDMinLengthFacet minLengthFacet = XSDFactory.eINSTANCE.createXSDMinLengthFacet();
            minLengthFacet.setLexicalValue(minValue);
            simpleTypeDefinition.getFacetContents().add((Object)minLengthFacet);
        }
        if (maxLength != null) {
            String maxValue = maxLength.asText();
            XSDMaxLengthFacet maxLengthFacet = XSDFactory.eINSTANCE.createXSDMaxLengthFacet();
            maxLengthFacet.setLexicalValue(maxValue);
            simpleTypeDefinition.getFacetContents().add((Object)maxLengthFacet);
        }
        if (defaultValue != null) {
            String defaultVal = defaultValue.asText();
            element.setConstraint(XSDConstraint.DEFAULT_LITERAL);
            element.setLexicalValue(defaultVal);
        }
        if (jsd2XsdNode.isNullableType()) {
            element.setNillable(true);
        }
        element.setAnonymousTypeDefinition((XSDTypeDefinition)simpleTypeDefinition);
        return element;
    }

    private void setNamespace(XSDSimpleTypeDefinition simpleTypeDefinition) {
        String namespace = (String)this.xsdSchema.getQNamePrefixToNamespaceMap().get(this.xsdSchema.getSchemaForSchemaQNamePrefix());
        simpleTypeDefinition.setTargetNamespace(namespace);
    }

    private XSDElementDeclaration createXSDSequenceFromJsonArray(XSDParticle arrayParticle, Jsd2XsdNode jsd2XsdNode) {
        XSDElementDeclaration element = this.xsdFactory.createXSDElementDeclaration();
        arrayParticle.setContent((XSDParticleContent)element);
        element.setName(jsd2XsdNode.getName());
        XSDTypeDefinition typeDef = jsd2XsdNode.getXsdTypeDef();
        element.setTypeDefinition(typeDef);
        JsonNode maxOccurs = jsd2XsdNode.get("maxItems");
        JsonNode minOccurs = jsd2XsdNode.get("minItems");
        if (maxOccurs != null) {
            arrayParticle.setMaxOccurs(maxOccurs.asInt());
        } else {
            arrayParticle.setMaxOccurs(-1);
        }
        if (minOccurs != null) {
            arrayParticle.setMinOccurs(minOccurs.asInt());
        }
        if (jsd2XsdNode.isNullableType()) {
            element.setNillable(true);
        }
        return element;
    }

    private XSDElementDeclaration createXSDElementFromJsonObject(Jsd2XsdNode jsd2XsdNode) {
        XSDElementDeclaration element = this.xsdFactory.createXSDElementDeclaration();
        element.setName(jsd2XsdNode.getName());
        XSDComplexTypeDefinition typeDefinition = (XSDComplexTypeDefinition)jsd2XsdNode.getXsdTypeDef();
        element.setTypeDefinition((XSDTypeDefinition)typeDefinition);
        if (jsd2XsdNode.isNullableType()) {
            element.setNillable(true);
        }
        return element;
    }

    public void annotateXSDParticle(XSDParticle xsdParticle, Jsd2XsdNode jsd2XsdNode) {
        XSDTerm xsdTerm = xsdParticle.getTerm();
        if (xsdTerm instanceof XSDElementDeclaration) {
            this.annotateXSDElement((XSDElementDeclaration)xsdTerm, jsd2XsdNode);
        }
    }

    public void annotateXSDElement(XSDElementDeclaration element, Jsd2XsdNode jsd2XsdNode) {
        if (ZosConnectXsdUtil.isSimpleElement((XSDElementDeclaration)element)) {
            this.annotateXSDElement(element, jsd2XsdNode, (XSDSimpleTypeDefinition)element.getTypeDefinition());
        }
    }

    public void annotateXSDElement(XSDElementDeclaration element, Jsd2XsdNode jsd2XsdNode, XSDSimpleTypeDefinition simpleType) {
        if (xsdSimpleTypes.isStringType(simpleType) && Jsd2XsdConverter.fieldHasValue(jsd2XsdNode, "format", "date")) {
            ZosConnectXsdUtil.setJsonSchemaPrimitiveTypeAppInfo((XSDElementDeclaration)element, (JsonSchemaPrimitiveType)JsonSchemaPrimitiveType.STRING);
            ZosConnectXsdUtil.setJsonSchemaPrimitiveTypeFormatAppInfo((XSDElementDeclaration)element, (JsonSchemaPrimitiveTypeFormat)JsonSchemaPrimitiveTypeFormat.DATE);
        }
    }

    public static boolean fieldHasValue(Jsd2XsdNode jsd2XsdNode, String fieldName, String fieldValue) {
        String value;
        boolean retVal = false;
        JsonNode valueNode = jsd2XsdNode.get(fieldName);
        String string = value = valueNode != null ? valueNode.asText() : null;
        if (value != null && value.equals(fieldValue)) {
            retVal = true;
        }
        return retVal;
    }

    public static String getFirstTypeAsText(JsonNode node) {
        String typeAsText = null;
        JsonNode typeValueNode = node.get("type");
        if (typeValueNode instanceof ArrayNode) {
            ArrayNode typeArrayNode = (ArrayNode)typeValueNode;
            int i = 0;
            while (i < typeArrayNode.size() && typeAsText == null) {
                JsonNode typeNode = typeArrayNode.get(i);
                if (!"null".equals(typeNode.asText())) {
                    typeAsText = typeNode.asText();
                }
                ++i;
            }
        } else if (typeValueNode != null) {
            typeAsText = typeValueNode.asText();
        }
        return typeAsText;
    }

    public void setVisitor(IJsd2XsdConverterVisitor visitor) {
        this.visitor = visitor;
    }

    public boolean isGlobalElementGenerated() {
        return this.globalElementGenerated;
    }

    protected static enum JsonInputFormat {
        FILE_PATH,
        FILE,
        TEXT,
        URL;

    }

    protected static enum XsdOutputFormat {
        FILE_PATH,
        FILE,
        OUTPUT_STREAM,
        RESOURCE;

    }
}

