/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.mapping.util;

import com.ibm.zosconnect.api.mapping.jsd.JsonSchemaPrimitiveTypeFormat;
import com.ibm.zosconnect.ui.common.exceptions.ZosConnectMappingException;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.common.util.xsd.ZosConnectXsdUtil;
import com.ibm.zosconnect.ui.common.util.xsd.walker.IZosConnectXsdVisitor;
import com.ibm.zosconnect.ui.common.util.xsd.walker.ZosConnectXsdCompareVisitor;
import com.ibm.zosconnect.ui.common.util.xsd.walker.ZosConnectXsdWalker;
import com.ibm.zosconnect.ui.common.validation.IMappingProblemProvider;
import com.ibm.zosconnect.ui.common.validation.MappingProblemTypes;
import com.ibm.zosconnect.ui.common.validation.MappingValidationProblem2;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;

public class ZCeeXsdComparator
implements IMappingProblemProvider {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private XSDSchema oldSchema = null;
    private XSDSchema newSchema = null;
    private String filesTypeString;
    private HashSet<String> missingFields = null;
    private HashSet<String> addedFields = null;
    private List<MappingValidationProblem2> errorProblems = new ArrayList<MappingValidationProblem2>();
    private List<MappingValidationProblem2> warningProblems = new ArrayList<MappingValidationProblem2>();
    private List<MappingValidationProblem2> otherProblems = new ArrayList<MappingValidationProblem2>();

    public ZCeeXsdComparator(XSDSchema oldSchema, XSDSchema newSchema, String filesTypeString) throws FileNotFoundException, IOException, CoreException {
        this.oldSchema = oldSchema;
        this.newSchema = newSchema;
        this.filesTypeString = filesTypeString;
    }

    public void compare() throws Exception {
        if (this.oldSchema == null) {
            throw new ZosConnectMappingException(Xlat.error((String)"SCHEMA_NULL"));
        }
        if (this.newSchema == null) {
            throw new ZosConnectMappingException(Xlat.error((String)"SCHEMA_NULL"));
        }
        this.compareSchemas();
    }

    private void compareSchemas() throws Exception {
        ZosConnectXsdWalker walker = new ZosConnectXsdWalker((XSDElementDeclaration)this.oldSchema.getElementDeclarations().get(0));
        ZosConnectXsdCompareVisitor visitor = new ZosConnectXsdCompareVisitor();
        walker.accept((IZosConnectXsdVisitor)visitor);
        Map oldJsonSchemaEleMap = visitor.getXsdEleMap();
        Map oldJsonSchemaTypeMap = visitor.getXsdTypeMap();
        walker = new ZosConnectXsdWalker((XSDElementDeclaration)this.newSchema.getElementDeclarations().get(0));
        visitor = new ZosConnectXsdCompareVisitor();
        walker.accept((IZosConnectXsdVisitor)visitor);
        Map newJsonSchemaEleMap = visitor.getXsdEleMap();
        Map newJsonSchemaTypeMap = visitor.getXsdTypeMap();
        this.missingFields = new HashSet(oldJsonSchemaTypeMap.keySet());
        this.missingFields.removeAll(newJsonSchemaTypeMap.keySet());
        this.addedFields = new HashSet(newJsonSchemaTypeMap.keySet());
        this.addedFields.removeAll(oldJsonSchemaTypeMap.keySet());
        for (String field : this.missingFields) {
            this.warningProblems.add(new MappingValidationProblem2(1, Xlat.error((String)"IMPORT_EXISTING_SERVICE_FLD_REMOVED_MSG", (String[])new String[]{field}), MappingProblemTypes.FIELD_REMOVED, this.filesTypeString));
        }
        for (String field : this.addedFields) {
            this.warningProblems.add(new MappingValidationProblem2(1, Xlat.error((String)"IMPORT_EXISTING_SERVICE_FLD_ADDED_MSG", (String[])new String[]{field}), MappingProblemTypes.FIELD_ADDED, this.filesTypeString));
        }
        HashSet intersectFields = new HashSet(oldJsonSchemaTypeMap.keySet());
        intersectFields.retainAll(newJsonSchemaTypeMap.keySet());
        for (String fieldName : intersectFields) {
            String[] inputs;
            if (!(oldJsonSchemaTypeMap.get(fieldName) instanceof XSDSimpleTypeDefinition)) continue;
            XSDSimpleTypeDefinition oldSimpleType = (XSDSimpleTypeDefinition)oldJsonSchemaTypeMap.get(fieldName);
            XSDSimpleTypeDefinition newSimpleType = null;
            if (!(newJsonSchemaTypeMap.get(fieldName) instanceof XSDSimpleTypeDefinition)) {
                String[] inputs2 = new String[]{fieldName};
                throw new ZosConnectMappingException(Xlat.error((String)"IMPORT_EXISTING_SERVICE_FLD_XSDTYPE_CHANGED", (String[])inputs2));
            }
            newSimpleType = (XSDSimpleTypeDefinition)newJsonSchemaTypeMap.get(fieldName);
            String oldDataType = oldSimpleType.getBaseType().getName();
            String newDataType = newSimpleType.getBaseType().getName();
            if (!oldDataType.equalsIgnoreCase(newDataType)) {
                String[] inputs3 = new String[]{fieldName, oldDataType, newDataType};
                this.warningProblems.add(new MappingValidationProblem2(1, Xlat.error((String)"IMPORT_EXISTING_SERVICE_FLDTYPE_CHANGED_MSG", (String[])inputs3), MappingProblemTypes.FIELD_DATA_TYPE_CHANGED));
            }
            XSDElementDeclaration oldElement = (XSDElementDeclaration)oldJsonSchemaEleMap.get(fieldName);
            XSDElementDeclaration newElement = (XSDElementDeclaration)newJsonSchemaEleMap.get(fieldName);
            JsonSchemaPrimitiveTypeFormat oldTypeFormat = ZosConnectXsdUtil.getJsonSchemaPrimitiveTypeFormatAppInfo((XSDElementDeclaration)oldElement);
            JsonSchemaPrimitiveTypeFormat newTypeFormat = ZosConnectXsdUtil.getJsonSchemaPrimitiveTypeFormatAppInfo((XSDElementDeclaration)newElement);
            if (oldTypeFormat == null && newTypeFormat != null) {
                inputs = new String[]{newTypeFormat.value(), fieldName};
                this.warningProblems.add(new MappingValidationProblem2(1, Xlat.error((String)"IMPORT_EXISTING_SERVICE_FLDTYPEFMT_ADD", (String[])inputs), MappingProblemTypes.FIELD_DATA_TYPE_FORMAT_CHANGED));
                continue;
            }
            if (oldTypeFormat != null && newTypeFormat == null) {
                inputs = new String[]{oldTypeFormat.value(), fieldName};
                this.warningProblems.add(new MappingValidationProblem2(1, Xlat.error((String)"IMPORT_EXISTING_SERVICE_FLDTYPEFMT_REMOVE", (String[])inputs), MappingProblemTypes.FIELD_DATA_TYPE_FORMAT_CHANGED));
                continue;
            }
            if (oldTypeFormat == null || newTypeFormat == null || oldTypeFormat.equals((Object)newTypeFormat)) continue;
            inputs = new String[]{fieldName, oldTypeFormat.value(), newTypeFormat.value()};
            this.warningProblems.add(new MappingValidationProblem2(1, Xlat.error((String)"IMPORT_EXISTING_SERVICE_FLDTYPEFMT_CHANGED", (String[])inputs), MappingProblemTypes.FIELD_DATA_TYPE_FORMAT_CHANGED));
        }
    }

    public List<MappingValidationProblem2> getErrorProblems() {
        return this.errorProblems;
    }

    public List<MappingValidationProblem2> getWarningProblems() {
        return this.warningProblems;
    }

    public List<MappingValidationProblem2> getOtherProblems() {
        return this.otherProblems;
    }
}

