/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.mapping.util;

import com.ibm.msl.mapping.FunctionRefinement;
import com.ibm.msl.mapping.Mapping;
import com.ibm.msl.mapping.MappingContainer;
import com.ibm.msl.mapping.MappingDesignator;
import com.ibm.msl.mapping.MappingRoot;
import com.ibm.msl.mapping.SemanticRefinement;
import com.ibm.msl.mapping.api.validation.MappingValidator;
import com.ibm.msl.mapping.util.MappingResourceImpl;
import com.ibm.msl.mapping.util.ModelUtils;
import com.ibm.msl.mapping.util.PassthroughUtils;
import com.ibm.msl.mapping.validators.IValidationProblem;
import com.ibm.msl.mapping.xml.node.XMLDataContentNode;
import com.ibm.msl.mapping.xml.node.XMLTypeNode;
import com.ibm.zosconnect.api.mapping.jsd.JsonSchemaPrimitiveTypeFormat;
import com.ibm.zosconnect.ui.common.util.ListUtilz;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.common.util.swagger.OpenApi2xUtil;
import com.ibm.zosconnect.ui.common.util.xsd.IZosConnectXsdSimpleTypes;
import com.ibm.zosconnect.ui.common.util.xsd.ZosConnectXsdSimpleTypes;
import com.ibm.zosconnect.ui.common.util.xsd.ZosConnectXsdUtil;
import com.ibm.zosconnect.ui.common.validation.MappingProblemTypes;
import com.ibm.zosconnect.ui.common.validation.MappingValidationProblem2;
import com.ibm.zosconnect.ui.mapping.util.ZCeeMappingUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFractionDigitsFacet;
import org.eclipse.xsd.XSDMaxExclusiveFacet;
import org.eclipse.xsd.XSDMaxFacet;
import org.eclipse.xsd.XSDMaxInclusiveFacet;
import org.eclipse.xsd.XSDMaxLengthFacet;
import org.eclipse.xsd.XSDMinExclusiveFacet;
import org.eclipse.xsd.XSDMinFacet;
import org.eclipse.xsd.XSDMinInclusiveFacet;
import org.eclipse.xsd.XSDMinLengthFacet;
import org.eclipse.xsd.XSDSimpleTypeDefinition;

public class ZCeeMappingValidatorUtil {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static IZosConnectXsdSimpleTypes simpleTypes = ZosConnectXsdSimpleTypes.getInstance();

    public static void validateMoveMapping(Mapping mapping, IResource mappingFile, List<MappingValidationProblem2> problems, String mappingFileType) {
        mappingFileType = StringUtils.trimToEmpty((String)mappingFileType);
        MappingDesignator input = (MappingDesignator)ListUtilz.getFirstMember((List)mapping.getInputs());
        MappingDesignator output = (MappingDesignator)ListUtilz.getFirstMember((List)mapping.getOutputs());
        String inputRefName = ZCeeMappingUtil.getRefNameForMsgInsert(input);
        String outputRefName = ZCeeMappingUtil.getRefNameForMsgInsert(output);
        String inputTypeName = ZCeeMappingUtil.getTypeNameForMsgInsert(input);
        String outputTypeName = ZCeeMappingUtil.getTypeNameForMsgInsert(output);
        if (input == null) {
            problems.add(new MappingValidationProblem2(2, Xlat.error((String)"ERROR_MOVE_NO_INPUT"), MappingProblemTypes.INVALID_MAPPING, (EObject)mapping, mappingFile.getLocation(), mappingFileType));
        }
        if (output == null) {
            problems.add(new MappingValidationProblem2(2, Xlat.error((String)"ERROR_MOVE_NO_OUTPUT"), MappingProblemTypes.INVALID_MAPPING, (EObject)mapping, mappingFile.getLocation(), mappingFileType));
        }
        if (input != null && output != null) {
            if (input.getObject() != null && output.getObject() == null) {
                problems.add(new MappingValidationProblem2(2, Xlat.error((String)"IMPORT_EXISTING_SERVICE_UNABLE_MAP", (String[])new String[]{inputTypeName, inputRefName, outputTypeName, outputRefName, outputTypeName, outputRefName}), MappingProblemTypes.BROKEN_MAPPING, (EObject)mapping, mappingFile.getLocation(), mappingFileType));
            } else if (input.getObject() == null && output.getObject() != null) {
                problems.add(new MappingValidationProblem2(2, Xlat.error((String)"IMPORT_EXISTING_SERVICE_UNABLE_MAP", (String[])new String[]{inputTypeName, inputRefName, outputTypeName, outputRefName, inputTypeName, inputRefName}), MappingProblemTypes.BROKEN_MAPPING, (EObject)mapping, mappingFile.getLocation(), mappingFileType));
            } else if (input.getObject() == null && output.getObject() == null) {
                problems.add(new MappingValidationProblem2(2, Xlat.error((String)"IMPORT_EXISTING_SERVICE_UNABLE_MAP2", (String[])new String[]{inputTypeName, inputRefName, outputTypeName, outputRefName, inputRefName, outputRefName}), MappingProblemTypes.BROKEN_MAPPING, (EObject)mapping, mappingFile.getLocation(), mappingFileType));
            } else if (input.getObject() != null && output.getObject() != null) {
                int outputArrayDepth;
                int inputArrayDepth;
                if (ZCeeMappingValidatorUtil.isSimpleToComplex(input, output)) {
                    problems.add(new MappingValidationProblem2(2, Xlat.error((String)"IMPORT_EXISTING_SERVICE_UNABLE_MAP3", (String[])new String[]{inputTypeName, inputRefName, outputTypeName, outputRefName, inputRefName, outputRefName}), MappingProblemTypes.INVALID_MAPPING, (EObject)mapping, mappingFile.getLocation(), mappingFileType));
                }
                if (ZCeeMappingValidatorUtil.isComplexToSimple(input, output)) {
                    problems.add(new MappingValidationProblem2(2, Xlat.error((String)"IMPORT_EXISTING_SERVICE_UNABLE_MAP4", (String[])new String[]{inputTypeName, inputRefName, outputTypeName, outputRefName, inputRefName, outputRefName}), MappingProblemTypes.INVALID_MAPPING, (EObject)mapping, mappingFile.getLocation(), mappingFileType));
                }
                if (ZCeeMappingValidatorUtil.isComplexToComplex(input, output)) {
                    problems.add(new MappingValidationProblem2(2, Xlat.error((String)"IMPORT_EXISTING_SERVICE_UNABLE_MAP5", (String[])new String[]{inputTypeName, inputRefName, outputTypeName, outputRefName, inputRefName, outputRefName}), MappingProblemTypes.INVALID_MAPPING, (EObject)mapping, mappingFile.getLocation(), mappingFileType));
                }
                if ((inputArrayDepth = ZCeeMappingUtil.getArrayDepth(input)) != (outputArrayDepth = ZCeeMappingUtil.getArrayDepth(output))) {
                    problems.add(new MappingValidationProblem2(2, Xlat.error((String)"IMPORT_EXISTING_SERVICE_UNABLE_MAP6", (String[])new String[]{inputTypeName, inputRefName, outputTypeName, outputRefName, inputRefName, String.valueOf(inputArrayDepth), outputRefName, String.valueOf(outputArrayDepth)}), MappingProblemTypes.INVALID_MAPPING, (EObject)mapping, mappingFile.getLocation(), mappingFileType));
                }
            }
        }
    }

    public static void validateMoveMapping(Mapping mapping, IResource mappingFile, List<MappingValidationProblem2> problems) {
        ZCeeMappingValidatorUtil.validateMoveMapping(mapping, mappingFile, problems, "");
    }

    public static void validateAssignMapping(Mapping mapping, IResource mappingFile, List<MappingValidationProblem2> problems, String mappingFileType) {
        mappingFileType = StringUtils.trimToEmpty((String)mappingFileType);
        MappingDesignator output = (MappingDesignator)ListUtilz.getFirstMember((List)mapping.getOutputs());
        String outputRefName = ZCeeMappingUtil.getRefNameForMsgInsert(output);
        String outputTypeName = ZCeeMappingUtil.getTypeNameForMsgInsert(output);
        if (output == null) {
            problems.add(new MappingValidationProblem2(2, Xlat.error((String)"ERROR_ASSIGN_NO_OUTPUT"), MappingProblemTypes.INVALID_MAPPING, (EObject)mapping, mappingFile.getLocation(), mappingFileType));
        }
        if (output != null) {
            if (output.getObject() == null) {
                problems.add(new MappingValidationProblem2(2, Xlat.error((String)"IMPORT_EXISTING_SERVICE_UNABLE_ASSIGN", (String[])new String[]{outputTypeName, outputRefName, outputTypeName, outputRefName}), MappingProblemTypes.BROKEN_MAPPING, (EObject)mapping, mappingFile.getLocation(), mappingFileType));
            }
            if (output.getObject() != null) {
                if (ZCeeMappingUtil.isComplexNode(output)) {
                    problems.add(new MappingValidationProblem2(2, Xlat.error((String)"ERROR_ASSIGN_VALUE_COMPOSITE", (String[])new String[]{outputTypeName, outputRefName}), MappingProblemTypes.INVALID_MAPPING, (EObject)mapping, mappingFile.getLocation(), mappingFileType));
                } else {
                    SemanticRefinement refinement = (SemanticRefinement)ListUtilz.getFirstMember((List)mapping.getRefinements());
                    String assignValue = ModelUtils.getAssignValue((FunctionRefinement)((FunctionRefinement)refinement));
                    XMLDataContentNode xmlContentNode = (XMLDataContentNode)output.getObject();
                    XMLTypeNode xmlTypeNode = (XMLTypeNode)xmlContentNode.getType();
                    ZCeeMappingValidatorUtil.validateAssignValue(assignValue, xmlTypeNode, mapping, mappingFile, problems, mappingFileType);
                }
            }
        }
    }

    public static void validateAssignMapping(Mapping mapping, IResource mappingFile, List<MappingValidationProblem2> problems) {
        ZCeeMappingValidatorUtil.validateAssignMapping(mapping, mappingFile, problems, "");
    }

    public static void validateAssignValue(String fromString, XMLTypeNode toTypeNode, Mapping mapping, IResource mappingFile, List<MappingValidationProblem2> problems, String mappingFileType) {
        mappingFileType = StringUtils.trimToEmpty((String)mappingFileType);
        MappingDesignator toDesignator = (MappingDesignator)ListUtilz.getFirstMember((List)mapping.getOutputs());
        if (toTypeNode.isComplex()) {
            problems.add(new MappingValidationProblem2(2, Xlat.error((String)"ERROR_ASSIGN_VALUE_COMPOSITE", (String[])new String[]{ZCeeMappingUtil.getTypeNameForMsgInsert(toDesignator), ZCeeMappingUtil.getRefNameForMsgInsert(toDesignator), ZCeeMappingUtil.getRefNameForMsgInsert(toDesignator)}), MappingProblemTypes.INVALID_DEFAULT_VALUE, (EObject)mapping, mappingFile.getLocation(), mappingFileType));
            return;
        }
        fromString = fromString == null ? "" : fromString;
        XSDSimpleTypeDefinition toXsdType = ZCeeMappingUtil.getXsdSimpleType(toTypeNode);
        if (simpleTypes.isStringType(toXsdType)) {
            ZCeeMappingValidatorUtil.validateAssignValueToStringType(fromString, toXsdType, mapping, mappingFile, problems, mappingFileType);
        } else {
            int toXsdTypeID = simpleTypes.getBuiltInOrDerivedTypeID(toXsdType);
            switch (toXsdTypeID) {
                case 32: {
                    ZCeeMappingValidatorUtil.validateAssignValueToIntegerType(fromString, toXsdType, mapping, mappingFile, problems, mappingFileType);
                    break;
                }
                case 2: {
                    ZCeeMappingValidatorUtil.validateAssignValueToDecimalType(fromString, toXsdType, mapping, mappingFile, problems, mappingFileType);
                    break;
                }
                case 15: {
                    ZCeeMappingValidatorUtil.validateAssignValueToFloatType(fromString, toXsdType, mapping, mappingFile, problems, mappingFileType);
                    break;
                }
                case 16: {
                    ZCeeMappingValidatorUtil.validateAssignValueToDoubleType(fromString, toXsdType, mapping, mappingFile, problems, mappingFileType);
                }
            }
        }
    }

    public static void validateAssignValue(String fromString, XMLTypeNode toTypeNode, Mapping mapping, IResource mappingFile, List<MappingValidationProblem2> problems) {
        ZCeeMappingValidatorUtil.validateAssignValue(fromString, toTypeNode, mapping, mappingFile, problems, "");
    }

    private static void validateAssignValueToStringType(String fromString, XSDSimpleTypeDefinition toXsdType, Mapping mapping, IResource mappingFile, List<MappingValidationProblem2> problems, String mappingFileType) {
        JsonSchemaPrimitiveTypeFormat typeFormat;
        mappingFileType = StringUtils.trimToEmpty((String)mappingFileType);
        MappingDesignator toDesignator = (MappingDesignator)ListUtilz.getFirstMember((List)mapping.getOutputs());
        XSDElementDeclaration toElement = ZCeeMappingUtil.getXsdElementDeclaration(toDesignator);
        fromString = fromString == null ? "" : fromString;
        int fromStringLen = fromString.length();
        XSDMinLengthFacet minLengthFacet = toXsdType.getMinLengthFacet();
        XSDMaxLengthFacet maxLengthFacet = toXsdType.getMaxLengthFacet();
        Integer minLength = minLengthFacet != null ? minLengthFacet.getValue() : 0;
        Integer maxLength = maxLengthFacet != null ? maxLengthFacet.getValue() : -1;
        if (fromStringLen < minLength) {
            problems.add(new MappingValidationProblem2(2, Xlat.error((String)"ERROR_ASSIGN_VALUE_MIN_LENGTH", (String[])new String[]{ZCeeMappingUtil.getTypeNameForMsgInsert(toDesignator), ZCeeMappingUtil.getRefNameForMsgInsert(toDesignator), minLength.toString()}), MappingProblemTypes.INVALID_DEFAULT_VALUE, (EObject)mapping, mappingFile.getLocation(), mappingFileType));
        } else if (fromStringLen > maxLength && maxLength != -1) {
            problems.add(new MappingValidationProblem2(2, Xlat.error((String)"ERROR_ASSIGN_VALUE_MAX_LENGTH", (String[])new String[]{ZCeeMappingUtil.getTypeNameForMsgInsert(toDesignator), ZCeeMappingUtil.getRefNameForMsgInsert(toDesignator), maxLength.toString()}), MappingProblemTypes.INVALID_DEFAULT_VALUE, (EObject)mapping, mappingFile.getLocation(), mappingFileType));
        } else if (toElement != null && JsonSchemaPrimitiveTypeFormat.DATE.equals((Object)(typeFormat = ZosConnectXsdUtil.getJsonSchemaPrimitiveTypeFormatAppInfo((XSDElementDeclaration)toElement))) && !OpenApi2xUtil.isValidDateFormatValue((String)fromString)) {
            problems.add(new MappingValidationProblem2(2, Xlat.error((String)"ERROR_ASSIGN_VALUE_INVALID_DATE", (String[])new String[]{ZCeeMappingUtil.getTypeNameForMsgInsert(toDesignator), ZCeeMappingUtil.getRefNameForMsgInsert(toDesignator), fromString}), MappingProblemTypes.INVALID_DEFAULT_VALUE, (EObject)mapping, mappingFile.getLocation(), mappingFileType));
        }
    }

    private static void validateAssignValueToIntegerType(String fromString, XSDSimpleTypeDefinition toXsdType, Mapping mapping, IResource mappingFile, List<MappingValidationProblem2> problems, String mappingFileType) {
        mappingFileType = StringUtils.trimToEmpty((String)mappingFileType);
        MappingDesignator toDesignator = (MappingDesignator)ListUtilz.getFirstMember((List)mapping.getOutputs());
        fromString = fromString == null ? "" : fromString;
        BigDecimal fromValue = null;
        try {
            fromValue = new BigDecimal(fromString);
        }
        catch (NumberFormatException numberFormatException) {
            problems.add(new MappingValidationProblem2(2, Xlat.error((String)"ERROR_ASSIGN_VALUE_NOT_NUMERIC", (String[])new String[]{ZCeeMappingUtil.getTypeNameForMsgInsert(toDesignator), ZCeeMappingUtil.getRefNameForMsgInsert(toDesignator)}), MappingProblemTypes.INVALID_DEFAULT_VALUE, (EObject)mapping, mappingFile.getLocation(), mappingFileType));
            return;
        }
        XSDMinFacet minFacet = toXsdType.getMinFacet();
        XSDMaxFacet maxFacet = toXsdType.getMaxFacet();
        XSDMinInclusiveFacet minIFacet = toXsdType.getMinInclusiveFacet();
        XSDMaxInclusiveFacet maxIFacet = toXsdType.getMaxInclusiveFacet();
        XSDMinExclusiveFacet minEFacet = toXsdType.getMinExclusiveFacet();
        XSDMaxExclusiveFacet maxEFacet = toXsdType.getMaxExclusiveFacet();
        Object minimum = null;
        minimum = (BigDecimal)(minFacet != null ? minFacet.getValue() : minimum);
        minimum = (BigDecimal)(minIFacet != null ? minIFacet.getValue() : minimum);
        minimum = (BigDecimal)(minEFacet != null ? minIFacet.getValue() : minimum);
        Object maximum = null;
        maximum = (BigDecimal)(maxFacet != null ? maxFacet.getValue() : maximum);
        maximum = (BigDecimal)(maxIFacet != null ? maxIFacet.getValue() : maximum);
        maximum = (BigDecimal)(maxEFacet != null ? maxIFacet.getValue() : maximum);
        if (minimum != null && fromValue.compareTo((BigDecimal)minimum) < 0) {
            problems.add(new MappingValidationProblem2(2, Xlat.error((String)"ERROR_ASSIGN_VALUE_MIN_QUANTITY", (String[])new String[]{ZCeeMappingUtil.getTypeNameForMsgInsert(toDesignator), ZCeeMappingUtil.getRefNameForMsgInsert(toDesignator), ((BigDecimal)minimum).toString()}), MappingProblemTypes.INVALID_DEFAULT_VALUE, (EObject)mapping, mappingFile.getLocation(), mappingFileType));
        } else if (maximum != null && fromValue.compareTo((BigDecimal)maximum) > 0) {
            problems.add(new MappingValidationProblem2(2, Xlat.error((String)"ERROR_ASSIGN_VALUE_MAX_QUANTITY", (String[])new String[]{ZCeeMappingUtil.getTypeNameForMsgInsert(toDesignator), ZCeeMappingUtil.getRefNameForMsgInsert(toDesignator), ((BigDecimal)maximum).toString()}), MappingProblemTypes.INVALID_DEFAULT_VALUE, (EObject)mapping, mappingFile.getLocation(), mappingFileType));
        }
    }

    private static void validateAssignValueToDecimalType(String fromString, XSDSimpleTypeDefinition toXsdType, Mapping mapping, IResource mappingFile, List<MappingValidationProblem2> problems, String mappingFileType) {
        mappingFileType = StringUtils.trimToEmpty((String)mappingFileType);
        MappingDesignator toDesignator = (MappingDesignator)ListUtilz.getFirstMember((List)mapping.getOutputs());
        fromString = fromString == null ? "" : fromString;
        BigDecimal fromValue = null;
        try {
            fromValue = new BigDecimal(fromString);
        }
        catch (NumberFormatException numberFormatException) {
            problems.add(new MappingValidationProblem2(2, Xlat.error((String)"ERROR_ASSIGN_VALUE_NOT_NUMERIC", (String[])new String[]{ZCeeMappingUtil.getTypeNameForMsgInsert(toDesignator), ZCeeMappingUtil.getRefNameForMsgInsert(toDesignator)}), MappingProblemTypes.INVALID_DEFAULT_VALUE, (EObject)mapping, mappingFile.getLocation(), mappingFileType));
            return;
        }
        XSDMinFacet minFacet = toXsdType.getMinFacet();
        XSDMaxFacet maxFacet = toXsdType.getMaxFacet();
        XSDMinInclusiveFacet minIFacet = toXsdType.getMinInclusiveFacet();
        XSDMaxInclusiveFacet maxIFacet = toXsdType.getMaxInclusiveFacet();
        XSDMinExclusiveFacet minEFacet = toXsdType.getMinExclusiveFacet();
        XSDMaxExclusiveFacet maxEFacet = toXsdType.getMaxExclusiveFacet();
        XSDFractionDigitsFacet scaleFacet = toXsdType.getFractionDigitsFacet();
        Object minimum = null;
        minimum = (BigDecimal)(minFacet != null ? minFacet.getValue() : minimum);
        minimum = (BigDecimal)(minIFacet != null ? minIFacet.getValue() : minimum);
        minimum = (BigDecimal)(minEFacet != null ? minIFacet.getValue() : minimum);
        Object maximum = null;
        maximum = (BigDecimal)(maxFacet != null ? maxFacet.getValue() : maximum);
        maximum = (BigDecimal)(maxIFacet != null ? maxIFacet.getValue() : maximum);
        maximum = (BigDecimal)(maxEFacet != null ? maxIFacet.getValue() : maximum);
        Integer scale = null;
        Integer n = scale = scaleFacet != null ? Integer.valueOf(scaleFacet.getValue()) : null;
        if (minimum != null && fromValue.compareTo((BigDecimal)minimum) < 0) {
            problems.add(new MappingValidationProblem2(2, Xlat.error((String)"ERROR_ASSIGN_VALUE_MIN_QUANTITY", (String[])new String[]{ZCeeMappingUtil.getTypeNameForMsgInsert(toDesignator), ZCeeMappingUtil.getRefNameForMsgInsert(toDesignator), ((BigDecimal)minimum).toPlainString()}), MappingProblemTypes.INVALID_DEFAULT_VALUE, (EObject)mapping, mappingFile.getLocation(), mappingFileType));
        } else if (maximum != null && fromValue.compareTo((BigDecimal)maximum) > 0) {
            problems.add(new MappingValidationProblem2(2, Xlat.error((String)"ERROR_ASSIGN_VALUE_MAX_QUANTITY", (String[])new String[]{ZCeeMappingUtil.getTypeNameForMsgInsert(toDesignator), ZCeeMappingUtil.getRefNameForMsgInsert(toDesignator), ((BigDecimal)maximum).toString()}), MappingProblemTypes.INVALID_DEFAULT_VALUE, (EObject)mapping, mappingFile.getLocation(), mappingFileType));
        } else if (scale != null && fromValue.scale() > scale) {
            problems.add(new MappingValidationProblem2(2, Xlat.error((String)"ERROR_ASSIGN_VALUE_MAX_SCALE", (String[])new String[]{ZCeeMappingUtil.getTypeNameForMsgInsert(toDesignator), ZCeeMappingUtil.getRefNameForMsgInsert(toDesignator), scale.toString()}), MappingProblemTypes.INVALID_DEFAULT_VALUE, (EObject)mapping, mappingFile.getLocation(), mappingFileType));
        }
    }

    private static void validateAssignValueToDoubleType(String fromString, XSDSimpleTypeDefinition toXsdType, Mapping mapping, IResource mappingFile, List<MappingValidationProblem2> problems, String mappingFileType) {
        mappingFileType = StringUtils.trimToEmpty((String)mappingFileType);
        MappingDesignator toDesignator = (MappingDesignator)ListUtilz.getFirstMember((List)mapping.getOutputs());
        fromString = fromString == null ? "" : fromString;
        Double fromValue = null;
        try {
            fromValue = Double.parseDouble(fromString);
        }
        catch (NumberFormatException numberFormatException) {
            problems.add(new MappingValidationProblem2(2, Xlat.error((String)"ERROR_ASSIGN_VALUE_NOT_NUMERIC", (String[])new String[]{ZCeeMappingUtil.getTypeNameForMsgInsert(toDesignator), ZCeeMappingUtil.getRefNameForMsgInsert(toDesignator)}), MappingProblemTypes.INVALID_DEFAULT_VALUE, (EObject)mapping, mappingFile.getLocation(), mappingFileType));
            return;
        }
        XSDMinFacet minFacet = toXsdType.getMinFacet();
        XSDMaxFacet maxFacet = toXsdType.getMaxFacet();
        XSDMinInclusiveFacet minIFacet = toXsdType.getMinInclusiveFacet();
        XSDMaxInclusiveFacet maxIFacet = toXsdType.getMaxInclusiveFacet();
        XSDMinExclusiveFacet minEFacet = toXsdType.getMinExclusiveFacet();
        XSDMaxExclusiveFacet maxEFacet = toXsdType.getMaxExclusiveFacet();
        XSDFractionDigitsFacet scaleFacet = toXsdType.getFractionDigitsFacet();
        Object minimum = null;
        minimum = (Double)(minFacet != null ? minFacet.getValue() : minimum);
        minimum = (Double)(minIFacet != null ? minIFacet.getValue() : minimum);
        minimum = (Double)(minEFacet != null ? minIFacet.getValue() : minimum);
        Object maximum = null;
        maximum = (Double)(maxFacet != null ? maxFacet.getValue() : maximum);
        maximum = (Double)(maxIFacet != null ? maxIFacet.getValue() : maximum);
        maximum = (Double)(maxEFacet != null ? maxIFacet.getValue() : maximum);
        Integer scale = null;
        Integer n = scale = scaleFacet != null ? Integer.valueOf(scaleFacet.getValue()) : null;
        if (minimum != null && fromValue.compareTo((Double)minimum) < 0) {
            problems.add(new MappingValidationProblem2(2, Xlat.error((String)"ERROR_ASSIGN_VALUE_MIN_QUANTITY", (String[])new String[]{ZCeeMappingUtil.getTypeNameForMsgInsert(toDesignator), ZCeeMappingUtil.getRefNameForMsgInsert(toDesignator), ((Double)minimum).toString()}), MappingProblemTypes.INVALID_DEFAULT_VALUE, (EObject)mapping, mappingFile.getLocation(), mappingFileType));
        } else if (maximum != null && fromValue.compareTo((Double)maximum) > 0) {
            problems.add(new MappingValidationProblem2(2, Xlat.error((String)"ERROR_ASSIGN_VALUE_MAX_QUANTITY", (String[])new String[]{ZCeeMappingUtil.getTypeNameForMsgInsert(toDesignator), ZCeeMappingUtil.getRefNameForMsgInsert(toDesignator), ((Double)maximum).toString()}), MappingProblemTypes.INVALID_DEFAULT_VALUE, (EObject)mapping, mappingFile.getLocation(), mappingFileType));
        } else if (scale != null && new BigDecimal(String.valueOf(fromValue)).scale() > scale) {
            problems.add(new MappingValidationProblem2(2, Xlat.error((String)"ERROR_ASSIGN_VALUE_MAX_SCALE", (String[])new String[]{ZCeeMappingUtil.getTypeNameForMsgInsert(toDesignator), ZCeeMappingUtil.getRefNameForMsgInsert(toDesignator), scale.toString()}), MappingProblemTypes.INVALID_DEFAULT_VALUE, (EObject)mapping, mappingFile.getLocation(), mappingFileType));
        }
    }

    private static void validateAssignValueToFloatType(String fromString, XSDSimpleTypeDefinition toXsdType, Mapping mapping, IResource mappingFile, List<MappingValidationProblem2> problems, String mappingFileType) {
        mappingFileType = StringUtils.trimToEmpty((String)mappingFileType);
        MappingDesignator toDesignator = (MappingDesignator)ListUtilz.getFirstMember((List)mapping.getOutputs());
        fromString = fromString == null ? "" : fromString;
        Float fromValue = null;
        try {
            fromValue = Float.valueOf(Float.parseFloat(fromString));
        }
        catch (NumberFormatException numberFormatException) {
            problems.add(new MappingValidationProblem2(2, Xlat.error((String)"ERROR_ASSIGN_VALUE_NOT_NUMERIC", (String[])new String[]{ZCeeMappingUtil.getTypeNameForMsgInsert(toDesignator), ZCeeMappingUtil.getRefNameForMsgInsert(toDesignator)}), MappingProblemTypes.INVALID_DEFAULT_VALUE, (EObject)mapping, mappingFile.getLocation(), mappingFileType));
            return;
        }
        XSDMinFacet minFacet = toXsdType.getMinFacet();
        XSDMaxFacet maxFacet = toXsdType.getMaxFacet();
        XSDMinInclusiveFacet minIFacet = toXsdType.getMinInclusiveFacet();
        XSDMaxInclusiveFacet maxIFacet = toXsdType.getMaxInclusiveFacet();
        XSDMinExclusiveFacet minEFacet = toXsdType.getMinExclusiveFacet();
        XSDMaxExclusiveFacet maxEFacet = toXsdType.getMaxExclusiveFacet();
        XSDFractionDigitsFacet scaleFacet = toXsdType.getFractionDigitsFacet();
        Object minimum = null;
        minimum = (Float)(minFacet != null ? minFacet.getValue() : minimum);
        minimum = (Float)(minIFacet != null ? minIFacet.getValue() : minimum);
        minimum = (Float)(minEFacet != null ? minIFacet.getValue() : minimum);
        Object maximum = null;
        maximum = (Float)(maxFacet != null ? maxFacet.getValue() : maximum);
        maximum = (Float)(maxIFacet != null ? maxIFacet.getValue() : maximum);
        maximum = (Float)(maxEFacet != null ? maxIFacet.getValue() : maximum);
        Integer scale = null;
        Integer n = scale = scaleFacet != null ? Integer.valueOf(scaleFacet.getValue()) : null;
        if (minimum != null && fromValue.compareTo((Float)minimum) < 0) {
            problems.add(new MappingValidationProblem2(2, Xlat.error((String)"ERROR_ASSIGN_VALUE_MIN_QUANTITY", (String[])new String[]{ZCeeMappingUtil.getTypeNameForMsgInsert(toDesignator), ZCeeMappingUtil.getRefNameForMsgInsert(toDesignator), ((Float)minimum).toString()}), MappingProblemTypes.INVALID_DEFAULT_VALUE, (EObject)mapping, mappingFile.getLocation(), mappingFileType));
        } else if (maximum != null && fromValue.compareTo((Float)maximum) > 0) {
            problems.add(new MappingValidationProblem2(2, Xlat.error((String)"ERROR_ASSIGN_VALUE_MAX_QUANTITY", (String[])new String[]{ZCeeMappingUtil.getTypeNameForMsgInsert(toDesignator), ZCeeMappingUtil.getRefNameForMsgInsert(toDesignator), ((Float)maximum).toString()}), MappingProblemTypes.INVALID_DEFAULT_VALUE, (EObject)mapping, mappingFile.getLocation(), mappingFileType));
        } else if (scale != null && new BigDecimal(String.valueOf(fromValue)).scale() > scale) {
            problems.add(new MappingValidationProblem2(2, Xlat.error((String)"ERROR_ASSIGN_VALUE_MAX_SCALE", (String[])new String[]{ZCeeMappingUtil.getTypeNameForMsgInsert(toDesignator), ZCeeMappingUtil.getRefNameForMsgInsert(toDesignator), scale.toString()}), MappingProblemTypes.INVALID_DEFAULT_VALUE, (EObject)mapping, mappingFile.getLocation(), mappingFileType));
        }
    }

    public static void validateRemoveMapping(Mapping mapping, IResource mappingFile, List<MappingValidationProblem2> problems, String mappingFileType) {
        mappingFileType = StringUtils.trimToEmpty((String)mappingFileType);
        MappingDesignator output = (MappingDesignator)ListUtilz.getFirstMember((List)mapping.getOutputs());
        String outputRefName = ZCeeMappingUtil.getRefNameForMsgInsert(output);
        if (output == null) {
            problems.add(new MappingValidationProblem2(2, Xlat.error((String)"ERROR_REMOVE_NO_OUTPUT"), MappingProblemTypes.INVALID_MAPPING, (EObject)mapping, mappingFile.getLocation(), mappingFileType));
        } else if (output != null && output.getObject() == null) {
            problems.add(new MappingValidationProblem2(2, Xlat.error((String)"IMPORT_EXISTING_SERVICE_UNABLE_REMOVE", (String[])new String[]{outputRefName}), MappingProblemTypes.BROKEN_MAPPING, (EObject)mapping, mappingFile.getLocation(), mappingFileType));
        }
    }

    public static void validateRemoveMapping(Mapping mapping, IResource mappingFile, List<MappingValidationProblem2> problems) {
        ZCeeMappingValidatorUtil.validateRemoveMapping(mapping, mappingFile, problems, "");
    }

    public static boolean isComplexToSimple(MappingDesignator inputDesignator, MappingDesignator outputDesignator) {
        boolean retVal = false;
        if (inputDesignator != null && outputDesignator != null && ZCeeMappingUtil.isComplexNode(inputDesignator) && ZCeeMappingUtil.isSimpleNode(outputDesignator)) {
            retVal = true;
        }
        return retVal;
    }

    public static boolean isSimpleToComplex(MappingDesignator inputDesignator, MappingDesignator outputDesignator) {
        boolean retVal = false;
        if (inputDesignator != null && outputDesignator != null && ZCeeMappingUtil.isSimpleNode(inputDesignator) && ZCeeMappingUtil.isComplexNode(outputDesignator)) {
            retVal = true;
        }
        return retVal;
    }

    public static boolean isComplexToComplex(MappingDesignator inputDesignator, MappingDesignator outputDesignator) {
        boolean retVal = false;
        if (inputDesignator != null && outputDesignator != null && ZCeeMappingUtil.isComplexNode(inputDesignator) && ZCeeMappingUtil.isComplexNode(outputDesignator)) {
            retVal = true;
        }
        return retVal;
    }

    public static boolean isSimpleToSimple(MappingDesignator inputDesignator, MappingDesignator outputDesignator) {
        boolean retVal = false;
        if (inputDesignator != null && outputDesignator != null && ZCeeMappingUtil.isSimpleNode(inputDesignator) && ZCeeMappingUtil.isSimpleNode(outputDesignator)) {
            retVal = true;
        }
        return retVal;
    }

    public static boolean isDesignatorPassedThrough(MappingRoot mappingRoot, MappingDesignator designator) {
        boolean retVal = false;
        if (designator != null && PassthroughUtils.doesDesignatorSpecifyDataPassedThrough((MappingDesignator)designator, (MappingRoot)mappingRoot)) {
            retVal = true;
        }
        return retVal;
    }

    public static List<IValidationProblem> validateMappingFile(IFile mappingFile, IProgressMonitor monitor) throws Exception {
        ArrayList<IValidationProblem> allProblems = new ArrayList<IValidationProblem>();
        MappingResourceImpl mappingResource = ZCeeMappingUtil.loadMappingFile(mappingFile);
        MappingRoot mappingRoot = ModelUtils.getMappingRoot((Resource)mappingResource);
        MappingValidator mappingValidator = ModelUtils.getMappingDomain((MappingRoot)mappingRoot).getMappingDomainValidator();
        List allMappings = ModelUtils.getAllNestedMappings((MappingContainer)mappingRoot);
        for (Mapping mapping : allMappings) {
            allProblems.addAll(mappingValidator.validateMappingObject((EObject)mapping, null));
        }
        return allProblems;
    }

    public static List<IValidationProblem> validateMappingFile(IFile mappingFile) throws Exception {
        return ZCeeMappingValidatorUtil.validateMappingFile(mappingFile, (IProgressMonitor)new NullProgressMonitor());
    }
}

