/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.mapping.util;

import com.ibm.msl.mapping.InlinedXMLSchema;
import com.ibm.msl.mapping.Mapping;
import com.ibm.msl.mapping.MappingContainer;
import com.ibm.msl.mapping.MappingDesignator;
import com.ibm.msl.mapping.MappingGroup;
import com.ibm.msl.mapping.MappingRoot;
import com.ibm.msl.mapping.MappingSingleton;
import com.ibm.msl.mapping.RefinableComponent;
import com.ibm.msl.mapping.RemoveRefinement;
import com.ibm.msl.mapping.SemanticRefinement;
import com.ibm.msl.mapping.api.environment.MappingEnvironment;
import com.ibm.msl.mapping.api.validation.MappingValidationManager;
import com.ibm.msl.mapping.environment.MappingEnvironmentRegistry;
import com.ibm.msl.mapping.internal.ui.editpart.MappingIOEditPart;
import com.ibm.msl.mapping.internal.ui.model.MappingIOType;
import com.ibm.msl.mapping.node.ContentNode;
import com.ibm.msl.mapping.node.EObjectNode;
import com.ibm.msl.mapping.node.TypeNode;
import com.ibm.msl.mapping.util.MappingResourceImpl;
import com.ibm.msl.mapping.util.ModelUtils;
import com.ibm.msl.mapping.util.PassthroughUtils;
import com.ibm.msl.mapping.xml.node.XMLDataContentNode;
import com.ibm.msl.mapping.xml.node.XMLModelGroupNode;
import com.ibm.msl.mapping.xml.node.XMLNodeFactory;
import com.ibm.msl.mapping.xml.node.XMLRootNode;
import com.ibm.msl.mapping.xml.node.XMLTypeNode;
import com.ibm.msl.mapping.xml.util.XSDUtils;
import com.ibm.zosconnect.api.MethodValues;
import com.ibm.zosconnect.api.mapping.jsd.JsonSchemaPrimitiveType;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.ArrayUtilz;
import com.ibm.zosconnect.ui.common.util.ListUtilz;
import com.ibm.zosconnect.ui.common.util.URIUtilz;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.common.util.xsd.ZosConnectXsdUtil;
import com.ibm.zosconnect.ui.common.util.xsd.walker.IZosConnectXsdVisitor;
import com.ibm.zosconnect.ui.common.util.xsd.walker.ZosConnectXsdWalker;
import com.ibm.zosconnect.ui.mapping.util.ZCeeDesignatorGroup;
import com.ibm.zosconnect.ui.mapping.util.ZCeeMappingAnnotator;
import com.ibm.zosconnect.ui.mapping.util.ZCeeMappingLoad;
import com.ibm.zosconnect.ui.mapping.util.ZCeeMappingRootAnnotator;
import com.ibm.zosconnect.ui.mapping.util.ZCeeMappingSave;
import com.ibm.zosconnect.ui.mapping.util.visitors.HasMappedDescendantVisitor;
import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.Property;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.util.XSDUtil;

public class ZCeeMappingUtil {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static boolean isJsonInputFieldDesignator(MappingDesignator mappingDesignator) {
        XSDElementDeclaration xsdElement;
        boolean retVal = false;
        while (mappingDesignator != null && mappingDesignator.getObject() == null) {
            mappingDesignator = mappingDesignator.getParent();
        }
        if (mappingDesignator != null && mappingDesignator.getObject() != null && (xsdElement = ZCeeMappingUtil.getXSDElementDeclaration(mappingDesignator.getObject())) != null) {
            String tns = xsdElement.getTargetNamespace();
            if (StringUtils.isBlank((CharSequence)tns) && xsdElement.getTypeDefinition() != null) {
                XSDTypeDefinition xsdType = xsdElement.getTypeDefinition();
                tns = xsdType.getTargetNamespace();
            }
            if (ZosConnectXsdUtil.isJsonInputTns((String)tns)) {
                retVal = true;
            }
        }
        return retVal;
    }

    public static boolean isInJsonInputBody(EObject object) {
        boolean isInJsonInputBody = false;
        if (!(object instanceof XMLDataContentNode)) {
            return false;
        }
        XMLDataContentNode xmlNode = (XMLDataContentNode)object;
        XSDElementDeclaration xsdEle = ZCeeMappingUtil.getParentXSDElementDeclaration((EObject)xmlNode);
        isInJsonInputBody = ZosConnectXsdUtil.hasJsonInputTns((XSDElementDeclaration)xsdEle);
        return isInJsonInputBody;
    }

    public static boolean isInJsonOutputBody(EObject object) {
        boolean isInJsonOutputBody = false;
        if (!(object instanceof XMLDataContentNode)) {
            return false;
        }
        XMLDataContentNode xmlNode = (XMLDataContentNode)object;
        XSDElementDeclaration xsdEle = ZCeeMappingUtil.getParentXSDElementDeclaration((EObject)xmlNode);
        isInJsonOutputBody = ZosConnectXsdUtil.hasJsonOutputTns((XSDElementDeclaration)xsdEle);
        return isInJsonOutputBody;
    }

    public static String getJsonInputFieldRootElementName(MappingDesignator mappingDesignator) {
        XSDElementDeclaration xsdElement;
        String retVal = "";
        while (mappingDesignator != null && mappingDesignator.getParent() != null && !ZCeeMappingUtil.isJsonOutputBodyNode(mappingDesignator.getParent())) {
            mappingDesignator = mappingDesignator.getParent();
        }
        if (mappingDesignator != null && mappingDesignator.getObject() != null && (xsdElement = ZCeeMappingUtil.getXSDElementDeclaration(mappingDesignator.getObject())) != null) {
            retVal = StringUtils.trimToEmpty((String)xsdElement.getName());
        }
        return retVal;
    }

    public static boolean isJsonOutputFieldDesignator(MappingDesignator mappingDesignator) {
        XSDElementDeclaration xsdElement;
        boolean retVal = false;
        while (mappingDesignator != null && mappingDesignator.getObject() == null) {
            mappingDesignator = mappingDesignator.getParent();
        }
        if (mappingDesignator != null && mappingDesignator.getObject() != null && (xsdElement = ZCeeMappingUtil.getXSDElementDeclaration(mappingDesignator.getObject())) != null) {
            String tns = xsdElement.getTargetNamespace();
            if (StringUtils.isBlank((CharSequence)tns) && xsdElement.getTypeDefinition() != null) {
                XSDTypeDefinition xsdType = xsdElement.getTypeDefinition();
                tns = xsdType.getTargetNamespace();
            }
            if (ZosConnectXsdUtil.isJsonOutputTns((String)tns)) {
                retVal = true;
            }
        }
        return retVal;
    }

    public static boolean isHttpInputDesignator(MappingDesignator mappingDesignator) {
        boolean retVal = false;
        if (mappingDesignator != null) {
            while (mappingDesignator.getParent() != null) {
                mappingDesignator = mappingDesignator.getParent();
            }
            if (ZosConnectXsdUtil.isHttpInputTns((String)mappingDesignator.getInlinedXMLSchemaTNS())) {
                retVal = true;
            }
        }
        return retVal;
    }

    public static boolean isHttpOutputDesignator(MappingDesignator mappingDesignator) {
        boolean retVal = false;
        if (mappingDesignator != null) {
            while (mappingDesignator.getParent() != null) {
                mappingDesignator = mappingDesignator.getParent();
            }
            if (ZosConnectXsdUtil.isHttpOutputTns((String)mappingDesignator.getInlinedXMLSchemaTNS())) {
                retVal = true;
            }
        }
        return retVal;
    }

    public static EObject getRealModel(MappingIOEditPart mappingIOEditPart) {
        EObjectNode eNode = ZCeeMappingUtil.getFacadeModel(mappingIOEditPart);
        if (eNode == null) {
            return null;
        }
        return eNode.getObject();
    }

    public static EObjectNode getFacadeModel(MappingIOEditPart mappingIOEditPart) {
        if (mappingIOEditPart == null) {
            return null;
        }
        EObject obj = ((MappingIOType)mappingIOEditPart.getModel()).getModel();
        if (obj instanceof EObjectNode) {
            return (EObjectNode)obj;
        }
        return null;
    }

    public static XSDElementDeclaration getXSDElementDeclaration(EObject node) {
        XSDElementDeclaration retVal = null;
        if (node instanceof XMLDataContentNode) {
            retVal = ZCeeMappingUtil.getXSDElementDeclaration((XMLDataContentNode)node);
        } else if (node instanceof XMLTypeNode) {
            XMLTypeNode xmlTypeNode = (XMLTypeNode)node;
            retVal = ZCeeMappingUtil.getXSDElementDeclaration((XMLDataContentNode)xmlTypeNode.getParent());
        }
        return retVal;
    }

    public static XSDElementDeclaration getXSDElementDeclaration(XMLDataContentNode xmlDataContentNode) {
        XSDElementDeclaration retVal = null;
        EObject xmlObject = xmlDataContentNode.getObject();
        if (xmlObject instanceof XSDElementDeclaration) {
            retVal = (XSDElementDeclaration)xmlObject;
            retVal = retVal.getResolvedElementDeclaration();
        }
        return retVal;
    }

    public static XSDElementDeclaration getParentXSDElementDeclaration(EObject node) {
        XSDElementDeclaration retVal = null;
        if (node instanceof XMLDataContentNode) {
            XMLModelGroupNode parentXmlModelGroupNode;
            XMLDataContentNode childXmlNode = (XMLDataContentNode)node;
            if (childXmlNode.getParent() instanceof XMLModelGroupNode && (parentXmlModelGroupNode = (XMLModelGroupNode)childXmlNode.getParent()).getParent() instanceof XMLTypeNode) {
                XMLTypeNode xmlTypeNode = (XMLTypeNode)parentXmlModelGroupNode.getParent();
                retVal = ZCeeMappingUtil.getXSDElementDeclaration((EObject)xmlTypeNode);
            }
        } else if (node instanceof XMLTypeNode) {
            XMLTypeNode xmlTypeNode = (XMLTypeNode)node;
            retVal = ZCeeMappingUtil.getParentXSDElementDeclaration((EObject)((XMLDataContentNode)xmlTypeNode.getParent()));
        }
        return retVal;
    }

    public static boolean isJsonInputBodyNode(MappingDesignator inputDesignator) {
        boolean retVal = false;
        if (inputDesignator != null && inputDesignator.getObject() instanceof XMLDataContentNode) {
            XMLDataContentNode xmlDataNode = (XMLDataContentNode)inputDesignator.getObject();
            XSDElementDeclaration element = ZCeeMappingUtil.getXSDElementDeclaration(xmlDataNode);
            retVal = ZosConnectXsdUtil.isHttpInputBody((XSDElementDeclaration)element);
        }
        return retVal;
    }

    public static boolean isJsonOutputBodyNode(MappingDesignator outputDesignator) {
        boolean retVal = false;
        if (outputDesignator != null && outputDesignator.getObject() instanceof XMLDataContentNode) {
            XMLDataContentNode xmlDataNode = (XMLDataContentNode)outputDesignator.getObject();
            XSDElementDeclaration element = ZCeeMappingUtil.getXSDElementDeclaration(xmlDataNode);
            retVal = ZosConnectXsdUtil.isHttpOutputBody((XSDElementDeclaration)element);
        }
        return retVal;
    }

    public static boolean isJsonInputBodyRootElement(EObject node) {
        XMLDataContentNode xmlParentDataNode;
        XSDElementDeclaration xmlParentElement;
        XMLTypeNode xmlParentTypeNode;
        XMLModelGroupNode xmlGroupNode;
        XMLDataContentNode xmlChildDataNode;
        boolean retVal = false;
        if (node instanceof XMLDataContentNode && (xmlChildDataNode = (XMLDataContentNode)node).getParent() instanceof XMLModelGroupNode && (xmlGroupNode = (XMLModelGroupNode)xmlChildDataNode.getParent()).getParent() instanceof XMLTypeNode && (xmlParentTypeNode = (XMLTypeNode)xmlGroupNode.getParent()).getParent() instanceof XMLDataContentNode && ZosConnectXsdUtil.isHttpInputBody((XSDElementDeclaration)(xmlParentElement = ZCeeMappingUtil.getXSDElementDeclaration(xmlParentDataNode = (XMLDataContentNode)xmlParentTypeNode.getParent())))) {
            retVal = true;
        }
        return retVal;
    }

    public static boolean isSimpleNode(MappingDesignator designator) {
        boolean retVal = false;
        XSDElementDeclaration element = ZCeeMappingUtil.getXSDElementDeclaration(designator.getObject());
        if (element != null) {
            retVal = ZosConnectXsdUtil.isSimpleElement((XSDElementDeclaration)element);
        }
        return retVal;
    }

    public static boolean isComplexNode(MappingDesignator designator) {
        boolean retVal = false;
        XSDElementDeclaration element = ZCeeMappingUtil.getXSDElementDeclaration(designator.getObject());
        if (element != null) {
            retVal = ZosConnectXsdUtil.isComplexElement((XSDElementDeclaration)element);
        }
        return retVal;
    }

    public static MappingDesignator getDesignatorFromMapping(Mapping mapping, MappingDesignator designator) {
        if (mapping == null || designator == null) {
            return null;
        }
        String designatorRefName = ModelUtils.getRefName((MappingDesignator)designator);
        String designatorHttpIn = ZCeeMappingAnnotator.getHttpIn(designator);
        EList inputs = mapping.getInputs();
        MappingDesignator input = (MappingDesignator)ListUtilz.getFirstMember((List)inputs);
        String inputRefName = ModelUtils.getRefName((MappingDesignator)input);
        String inputHttpIn = ZCeeMappingAnnotator.getHttpIn(input);
        if (StringUtils.equals((CharSequence)inputRefName, (CharSequence)designatorRefName) && StringUtils.equals((CharSequence)inputHttpIn, (CharSequence)designatorHttpIn)) {
            return input;
        }
        EList outputs = mapping.getOutputs();
        MappingDesignator output = (MappingDesignator)ListUtilz.getFirstMember((List)outputs);
        String outputRefName = ModelUtils.getRefName((MappingDesignator)output);
        String outputHttpIn = ZCeeMappingAnnotator.getHttpIn(output);
        if (StringUtils.equals((CharSequence)outputRefName, (CharSequence)designatorRefName) && StringUtils.equals((CharSequence)outputHttpIn, (CharSequence)designatorHttpIn)) {
            return output;
        }
        return null;
    }

    public static Mapping getPassthroughMapping(MappingDesignator designator) {
        Mapping retVal = null;
        MappingRoot mappingRoot = ModelUtils.getMappingRoot((MappingDesignator)designator);
        if (mappingRoot != null) {
            List passthroughMappings = PassthroughUtils.getAllPassthroughMappings((MappingContainer)mappingRoot);
            retVal = (Mapping)ListUtilz.getFirstMember((List)passthroughMappings);
        }
        return retVal;
    }

    public static MappingGroup getPassthroughUpdatesGroup(MappingDesignator designator) {
        MappingGroup retVal = null;
        Mapping passthroughMapping = ZCeeMappingUtil.getPassthroughMapping(designator);
        if (passthroughMapping != null) {
            retVal = PassthroughUtils.getUpdatesGroup((Mapping)passthroughMapping);
        }
        return retVal;
    }

    public static List<Mapping> getMappingsInPassthroughUpdatesGroup(MappingGroup updatesGroup) {
        ArrayList<Mapping> retVal = new ArrayList<Mapping>();
        EList updates = updatesGroup.getNested();
        for (RefinableComponent update : updates) {
            if (PassthroughUtils.isPassthroughMapping((RefinableComponent)update) || !(update instanceof Mapping)) continue;
            Mapping mapping = (Mapping)update;
            retVal.add(mapping);
        }
        return retVal;
    }

    public static List<Mapping> getMappingsInGroup(MappingGroup updatesGroup) {
        ArrayList<Mapping> retVal = new ArrayList<Mapping>();
        EList updates = updatesGroup.getNested();
        for (RefinableComponent update : updates) {
            if (!(update instanceof Mapping)) continue;
            Mapping mapping = (Mapping)update;
            retVal.add(mapping);
        }
        return retVal;
    }

    public static List<MappingDesignator> getMappingDesignators(Mapping mapping) {
        ArrayList<MappingDesignator> retVal = new ArrayList<MappingDesignator>();
        EList inputs = mapping.getInputs();
        EList outputs = mapping.getOutputs();
        if (ListUtilz.notEmpty((List)inputs)) {
            retVal.addAll((Collection<MappingDesignator>)inputs);
        }
        if (ListUtilz.notEmpty((List)outputs)) {
            retVal.addAll((Collection<MappingDesignator>)outputs);
        }
        return retVal;
    }

    public static MappingDesignator getFirstInputDesignator(Mapping mapping) {
        return (MappingDesignator)ListUtilz.getFirstMember((List)mapping.getInputs());
    }

    public static MappingDesignator getFirstOutputDesignator(Mapping mapping) {
        return (MappingDesignator)ListUtilz.getFirstMember((List)mapping.getOutputs());
    }

    public static void updateMappingAnnotations(MappingDesignator designator) {
        MappingRoot mappingRoot = ModelUtils.getMappingRoot((MappingDesignator)designator);
        if (mappingRoot == null) {
            return;
        }
        List allMappings = ModelUtils.getAllNestedMappings((MappingContainer)mappingRoot);
        if (ListUtilz.isEmpty((List)allMappings)) {
            return;
        }
        for (Mapping nextMapping : allMappings) {
            MappingDesignator designatorClone = ZCeeMappingUtil.getDesignatorFromMapping(nextMapping, designator);
            if (designatorClone == null) continue;
            ZCeeMappingAnnotator.applyInlineXsdAnnotations(designatorClone);
        }
    }

    public static void setXsdSimpleTypeFromJsonPrimitiveType(XSDElementDeclaration element, JsonSchemaPrimitiveType elementType) {
        XSDSimpleTypeDefinition primitiveType = null;
        switch (elementType) {
            case STRING: {
                primitiveType = (XSDSimpleTypeDefinition)XSDUtils.getNamedType((XSDSchema)XSDUtil.getSchemaForSchema((String)"http://www.w3.org/2001/XMLSchema"), (String)"string");
                break;
            }
            case NUMBER: {
                primitiveType = (XSDSimpleTypeDefinition)XSDUtils.getNamedType((XSDSchema)XSDUtil.getSchemaForSchema((String)"http://www.w3.org/2001/XMLSchema"), (String)"decimal");
                break;
            }
            case INTEGER: {
                primitiveType = (XSDSimpleTypeDefinition)XSDUtils.getNamedType((XSDSchema)XSDUtil.getSchemaForSchema((String)"http://www.w3.org/2001/XMLSchema"), (String)"integer");
                break;
            }
            case BOOLEAN: {
                primitiveType = (XSDSimpleTypeDefinition)XSDUtils.getNamedType((XSDSchema)XSDUtil.getSchemaForSchema((String)"http://www.w3.org/2001/XMLSchema"), (String)"boolean");
                break;
            }
        }
        element.setTypeDefinition(primitiveType);
    }

    public static void setXmlTypeFromJsonPrimitiveType(XMLDataContentNode xmlContentNode, JsonSchemaPrimitiveType elementType) {
        XMLTypeNode primitiveType = null;
        switch (elementType) {
            case STRING: {
                primitiveType = XMLNodeFactory.createBuiltInTypeNode((String)"string", (String)"http://www.w3.org/2001/XMLSchema", (int)1);
                break;
            }
            case NUMBER: {
                primitiveType = XMLNodeFactory.createBuiltInTypeNode((String)"decimal", (String)"http://www.w3.org/2001/XMLSchema", (int)1);
                break;
            }
            case INTEGER: {
                primitiveType = XMLNodeFactory.createBuiltInTypeNode((String)"integer", (String)"http://www.w3.org/2001/XMLSchema", (int)1);
                break;
            }
            case BOOLEAN: {
                primitiveType = XMLNodeFactory.createBuiltInTypeNode((String)"boolean", (String)"http://www.w3.org/2001/XMLSchema", (int)1);
                break;
            }
            default: {
                primitiveType = xmlContentNode.getXSDType();
            }
        }
        primitiveType.setParent((EObjectNode)xmlContentNode);
        xmlContentNode.setType((TypeNode)primitiveType);
    }

    public static MethodValues getHttpMethodNameFromInlineSchema(InlinedXMLSchema inlineSchema) {
        Object[] tokens;
        String tns;
        MethodValues retVal = null;
        if (inlineSchema != null && !StringUtils.isBlank((CharSequence)(tns = inlineSchema.getTargetNamespace())) && ArrayUtilz.notEmpty((Object[])(tokens = tns.split("/")))) {
            retVal = MethodValues.fromValue((String)tokens[tokens.length - 1]);
        }
        return retVal;
    }

    public static String getDesignatorFullPath(MappingDesignator designator, String pathSeparator) {
        if (!(designator.getObject() instanceof ContentNode)) {
            return "";
        }
        ArrayList<XSDElementDeclaration> xsdEles = new ArrayList<XSDElementDeclaration>();
        EObjectNode objectNode = (EObjectNode)designator.getObject();
        boolean reachedBody = false;
        while (objectNode != null && !reachedBody) {
            XMLDataContentNode xmlNode;
            if (objectNode instanceof XMLDataContentNode && (xmlNode = (XMLDataContentNode)objectNode).getObject() instanceof XSDElementDeclaration) {
                XSDElementDeclaration xsdEle = (XSDElementDeclaration)xmlNode.getObject();
                if (ZosConnectXsdUtil.isHttpInputBody((XSDElementDeclaration)(xsdEle = xsdEle.getResolvedElementDeclaration())) || ZosConnectXsdUtil.isHttpOutputBody((XSDElementDeclaration)xsdEle)) {
                    reachedBody = true;
                } else {
                    xsdEles.add(0, xsdEle);
                }
            }
            objectNode = objectNode.getParent();
        }
        StringBuilder fullPath = new StringBuilder();
        int i = 0;
        while (i < xsdEles.size()) {
            XSDElementDeclaration xsdEle = (XSDElementDeclaration)xsdEles.get(i);
            fullPath.append(xsdEle.getName());
            if (i + 1 < xsdEles.size()) {
                fullPath.append(pathSeparator);
            }
            ++i;
        }
        return fullPath.toString();
    }

    public static String getDesignatorLocalName(MappingDesignator designator) {
        String retVal = ZCeeMappingUtil.getDesignatorFullPath(designator, "/");
        int lastSepNdx = retVal.lastIndexOf("/");
        if (lastSepNdx != -1) {
            retVal = retVal.substring(lastSepNdx + 1);
        }
        return retVal;
    }

    public static List<Mapping> getRemoveMappings(MappingRoot mappingRoot, ZCeeDesignatorGroup ... designatorIn) {
        return ZCeeMappingUtil.getRemoveMappings(ModelUtils.getAllNestedMappings((MappingContainer)mappingRoot), designatorIn);
    }

    public static List<Mapping> getRemoveMappings(List<Mapping> allNestedMappings, ZCeeDesignatorGroup ... designatorIn) {
        ArrayList<Mapping> removeMappings = new ArrayList<Mapping>();
        for (Mapping nestedMapping : allNestedMappings) {
            MappingDesignator output;
            if (!ZCeeMappingUtil.hasRemoveRefinement(nestedMapping) || !ZCeeMappingUtil.isDesignatorInGroup(output = (MappingDesignator)ListUtilz.getFirstMember((List)nestedMapping.getOutputs()), designatorIn)) continue;
            removeMappings.add(nestedMapping);
        }
        return removeMappings;
    }

    public static List<Mapping> getMoveMappings(MappingRoot mappingRoot, ZCeeDesignatorGroup ... designatorIn) {
        return ZCeeMappingUtil.getMoveMappings(ModelUtils.getAllNestedMappings((MappingContainer)mappingRoot), designatorIn);
    }

    public static List<Mapping> getMoveMappings(List<Mapping> allNestedMappings, ZCeeDesignatorGroup ... designatorIn) {
        ArrayList<Mapping> moveMappings = new ArrayList<Mapping>();
        for (Mapping nestedMapping : allNestedMappings) {
            if (!ModelUtils.hasMoveRefinement((Mapping)nestedMapping)) continue;
            MappingDesignator input = (MappingDesignator)ListUtilz.getFirstMember((List)nestedMapping.getInputs());
            MappingDesignator output = (MappingDesignator)ListUtilz.getFirstMember((List)nestedMapping.getOutputs());
            if (!ZCeeMappingUtil.isDesignatorInGroup(input, designatorIn) && !ZCeeMappingUtil.isDesignatorInGroup(output, designatorIn)) continue;
            moveMappings.add(nestedMapping);
        }
        return moveMappings;
    }

    public static List<Mapping> getAssignMappings(MappingRoot mappingRoot, ZCeeDesignatorGroup ... designatorIn) {
        return ZCeeMappingUtil.getAssignMappings(ModelUtils.getAllNestedMappings((MappingContainer)mappingRoot), designatorIn);
    }

    public static List<Mapping> getAssignMappings(List<Mapping> allNestedMappings, ZCeeDesignatorGroup ... designatorIn) {
        ArrayList<Mapping> assignMappings = new ArrayList<Mapping>();
        for (Mapping nestedMapping : allNestedMappings) {
            MappingDesignator output;
            if (!ModelUtils.hasAssignRefinement((Mapping)nestedMapping) || !ZCeeMappingUtil.isDesignatorInGroup(output = (MappingDesignator)ListUtilz.getFirstMember((List)nestedMapping.getOutputs()), designatorIn)) continue;
            assignMappings.add(nestedMapping);
        }
        return assignMappings;
    }

    public static boolean isDesignatorInGroup(MappingDesignator mappingDesignator, ZCeeDesignatorGroup ... designatorIn) {
        if (mappingDesignator == null || designatorIn == null) {
            return false;
        }
        boolean retVal = false;
        ZCeeDesignatorGroup[] zCeeDesignatorGroupArray = designatorIn;
        int n = designatorIn.length;
        int n2 = 0;
        while (n2 < n) {
            ZCeeDesignatorGroup in = zCeeDesignatorGroupArray[n2];
            switch (in) {
                case INPUT_HEADER: {
                    retVal = ZCeeMappingUtil.isInInputHeadersGroup(mappingDesignator);
                    break;
                }
                case INPUT_PATH_PARAMETER: {
                    retVal = ZCeeMappingUtil.isInInputPathParametersGroup(mappingDesignator);
                    break;
                }
                case INPUT_QUERY_PARAMETER: {
                    retVal = ZCeeMappingUtil.isInInputQueryParametersGroup(mappingDesignator);
                    break;
                }
                case INPUT_BODY: {
                    retVal = ZCeeMappingUtil.isJsonOutputFieldDesignator(mappingDesignator);
                    break;
                }
                case OUTPUT_HEADER: {
                    retVal = ZCeeMappingUtil.isInOutputHeadersGroup(mappingDesignator);
                    break;
                }
                case OUTPUT_BODY: {
                    retVal = ZCeeMappingUtil.isJsonInputFieldDesignator(mappingDesignator);
                    break;
                }
            }
            if (retVal) break;
            ++n2;
        }
        return retVal;
    }

    public static ZCeeDesignatorGroup getDesignatorGroup(MappingDesignator mappingDesignator) {
        if (mappingDesignator == null) {
            return null;
        }
        if (ZCeeMappingUtil.isInInputHeadersGroup(mappingDesignator)) {
            return ZCeeDesignatorGroup.INPUT_HEADER;
        }
        if (ZCeeMappingUtil.isInInputPathParametersGroup(mappingDesignator)) {
            return ZCeeDesignatorGroup.INPUT_PATH_PARAMETER;
        }
        if (ZCeeMappingUtil.isInInputQueryParametersGroup(mappingDesignator)) {
            return ZCeeDesignatorGroup.INPUT_QUERY_PARAMETER;
        }
        if (ZCeeMappingUtil.isJsonOutputFieldDesignator(mappingDesignator)) {
            return ZCeeDesignatorGroup.INPUT_BODY;
        }
        if (ZCeeMappingUtil.isInOutputHeadersGroup(mappingDesignator)) {
            return ZCeeDesignatorGroup.OUTPUT_HEADER;
        }
        if (ZCeeMappingUtil.isJsonInputFieldDesignator(mappingDesignator)) {
            return ZCeeDesignatorGroup.OUTPUT_BODY;
        }
        return ZCeeDesignatorGroup.UNMAPPABLE;
    }

    public static boolean hasRemovedParent(MappingDesignator mappingDesignator) {
        if (mappingDesignator == null) {
            return false;
        }
        boolean retVal = false;
        ZCeeDesignatorGroup designatorIn = ZCeeMappingUtil.getDesignatorGroup(mappingDesignator);
        List<Mapping> mappings = ZCeeMappingUtil.getRemoveMappings(ModelUtils.getMappingRoot((MappingDesignator)mappingDesignator), designatorIn);
        MappingDesignator designator = mappingDesignator.getParent();
        while (!retVal && designator != null && !ModelUtils.isMappingDeclarationDesignator((MappingDesignator)designator)) {
            Iterator<Mapping> mappingIt = mappings.iterator();
            while (!retVal && mappingIt.hasNext()) {
                Mapping mapping = mappingIt.next();
                MappingDesignator output = (MappingDesignator)ListUtilz.getFirstMember((List)mapping.getOutputs());
                if (output == null || output.getObject() == null || output.getObject() != designator.getObject()) continue;
                retVal = true;
            }
            designator = designator.getParent();
        }
        return retVal;
    }

    public static boolean hasMappedDescendant(MappingDesignator designator) {
        if (designator == null || designator.getObject() == null) {
            return false;
        }
        HasMappedDescendantVisitor visitor = new HasMappedDescendantVisitor(designator);
        XSDElementDeclaration xsdEle = ZCeeMappingUtil.getXSDElementDeclaration(designator.getObject());
        try {
            ZosConnectXsdWalker walker = new ZosConnectXsdWalker(xsdEle);
            walker.accept((IZosConnectXsdVisitor)visitor);
        }
        catch (Exception e) {
            ZCeeUILogger.error((Throwable)e);
        }
        return visitor.hasMappedDescendant();
    }

    public static boolean hasRemoveRefinement(Mapping mapping) {
        boolean result = false;
        if (mapping != null) {
            for (SemanticRefinement refinement : mapping.getRefinements()) {
                if (!(refinement instanceof RemoveRefinement)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public static boolean isInInputHeadersGroup(MappingDesignator mappingDesignator) {
        if (mappingDesignator == null) {
            return false;
        }
        boolean foundGroup = false;
        int groupSize = 0;
        while (!foundGroup && mappingDesignator.getParent() != null && !(mappingDesignator.getParent().getObject() instanceof XMLRootNode)) {
            foundGroup = ZosConnectXsdUtil.isHttpInputHeadersGroup((XSDElementDeclaration)ZCeeMappingUtil.getXSDElementDeclaration(mappingDesignator.getObject()));
            if (!foundGroup) {
                ++groupSize;
            }
            mappingDesignator = mappingDesignator.getParent();
        }
        return foundGroup && groupSize > 0;
    }

    public static boolean isInInputPathParametersGroup(MappingDesignator mappingDesignator) {
        if (mappingDesignator == null) {
            return false;
        }
        boolean foundGroup = false;
        int groupSize = 0;
        while (!foundGroup && mappingDesignator.getParent() != null && !(mappingDesignator.getParent().getObject() instanceof XMLRootNode)) {
            foundGroup = ZosConnectXsdUtil.isHttpInputPathParametersGroup((XSDElementDeclaration)ZCeeMappingUtil.getXSDElementDeclaration(mappingDesignator.getObject()));
            if (!foundGroup) {
                ++groupSize;
            }
            mappingDesignator = mappingDesignator.getParent();
        }
        return foundGroup && groupSize > 0;
    }

    public static boolean isInInputQueryParametersGroup(MappingDesignator mappingDesignator) {
        if (mappingDesignator == null) {
            return false;
        }
        boolean foundGroup = false;
        int groupSize = 0;
        while (!foundGroup && mappingDesignator.getParent() != null && !(mappingDesignator.getParent().getObject() instanceof XMLRootNode)) {
            foundGroup = ZosConnectXsdUtil.isHttpInputQueryParametersGroup((XSDElementDeclaration)ZCeeMappingUtil.getXSDElementDeclaration(mappingDesignator.getObject()));
            if (!foundGroup) {
                ++groupSize;
            }
            mappingDesignator = mappingDesignator.getParent();
        }
        return foundGroup && groupSize > 0;
    }

    public static boolean isInOutputHeadersGroup(MappingDesignator mappingDesignator) {
        if (mappingDesignator == null) {
            return false;
        }
        boolean foundGroup = false;
        int groupSize = 0;
        while (!foundGroup && mappingDesignator.getParent() != null && !(mappingDesignator.getParent().getObject() instanceof XMLRootNode)) {
            foundGroup = ZosConnectXsdUtil.isHttpOutputHeadersGroup((XSDElementDeclaration)ZCeeMappingUtil.getXSDElementDeclaration(mappingDesignator.getObject()));
            if (!foundGroup) {
                ++groupSize;
            }
            mappingDesignator = mappingDesignator.getParent();
        }
        return foundGroup && groupSize > 0;
    }

    public static boolean isNullable(MappingDesignator designator) {
        if (designator == null) {
            return false;
        }
        XSDElementDeclaration xsdEle = ZCeeMappingUtil.getXSDElementDeclaration(designator.getObject());
        if (xsdEle != null) {
            return xsdEle.isNillable();
        }
        return false;
    }

    public static boolean isRepeating(MappingDesignator designator) {
        if (designator == null) {
            return false;
        }
        boolean repeating = false;
        while (!repeating && designator != null && !ModelUtils.isMappingDeclarationDesignator((MappingDesignator)designator)) {
            XSDElementDeclaration xsdEle = ZCeeMappingUtil.getXSDElementDeclaration(designator.getObject());
            repeating = ZosConnectXsdUtil.isArrayElement((XSDElementDeclaration)xsdEle);
            designator = designator.getParent();
        }
        return repeating;
    }

    public static boolean hasRepeatingParent(MappingDesignator designator) {
        if (designator == null) {
            return false;
        }
        boolean repeatingParent = false;
        designator = designator.getParent();
        while (!repeatingParent && designator != null && !ModelUtils.isMappingDeclarationDesignator((MappingDesignator)designator)) {
            XSDElementDeclaration xsdEle = ZCeeMappingUtil.getXSDElementDeclaration(designator.getObject());
            repeatingParent = ZosConnectXsdUtil.isArrayElement((XSDElementDeclaration)xsdEle);
            designator = designator.getParent();
        }
        return repeatingParent;
    }

    public static int getMinRepetitons(MappingDesignator designator) {
        if (designator == null) {
            return 1;
        }
        int minRepetitions = 1;
        while (minRepetitions > 0 && designator != null && !ModelUtils.isMappingDeclarationDesignator((MappingDesignator)designator)) {
            XSDElementDeclaration xsdEle = ZCeeMappingUtil.getXSDElementDeclaration(designator.getObject());
            minRepetitions *= ZosConnectXsdUtil.getMinOccurs((XSDComponent)xsdEle);
            designator = designator.getParent();
        }
        return minRepetitions;
    }

    public static int getMaxRepetitons(MappingDesignator designator) {
        if (designator == null) {
            return 1;
        }
        int maxRepetitions = 1;
        while (maxRepetitions > 0 && designator != null && !ModelUtils.isMappingDeclarationDesignator((MappingDesignator)designator)) {
            XSDElementDeclaration xsdEle = ZCeeMappingUtil.getXSDElementDeclaration(designator.getObject());
            maxRepetitions *= ZosConnectXsdUtil.getMaxOccurs((EObject)xsdEle);
            designator = designator.getParent();
        }
        return maxRepetitions;
    }

    public static int getArrayDepth(MappingDesignator designator) {
        if (designator == null) {
            return 0;
        }
        int arrayDepth = 0;
        while (designator != null && !ModelUtils.isMappingDeclarationDesignator((MappingDesignator)designator)) {
            XSDElementDeclaration xsdEle = ZCeeMappingUtil.getXSDElementDeclaration(designator.getObject());
            if (ZosConnectXsdUtil.isArrayElement((XSDElementDeclaration)xsdEle)) {
                ++arrayDepth;
            }
            designator = designator.getParent();
        }
        return arrayDepth;
    }

    public static int getMinOccurs(MappingDesignator designator) {
        return ZosConnectXsdUtil.getMinOccurs((XSDComponent)ZCeeMappingUtil.getXsdElementDeclaration(designator));
    }

    public static int getMaxOccurs(MappingDesignator designator) {
        return ZosConnectXsdUtil.getMaxOccurs((EObject)ZCeeMappingUtil.getXsdElementDeclaration(designator));
    }

    /*
     * Unable to fully structure code
     */
    public static MappingDesignator getFirstParentDesignator(MappingDesignator designator, ZCeeDesignatorGroup designatorIn) {
        if (designator != null) ** GOTO lbl4
        return null;
lbl-1000:
        // 1 sources

        {
            designator = designator.getParent();
lbl4:
            // 2 sources

            ** while (designator.getParent() != null && ZCeeMappingUtil.isDesignatorInGroup((MappingDesignator)designator.getParent(), (ZCeeDesignatorGroup[])new ZCeeDesignatorGroup[]{designatorIn}))
        }
lbl5:
        // 1 sources

        return designator;
    }

    public static List<XSDElementDeclaration> getXSDElementsInStructOrder(MappingDesignator designator) {
        ArrayList<XSDElementDeclaration> xsdElements = new ArrayList<XSDElementDeclaration>();
        EObjectNode eObjectNode = (EObjectNode)designator.getObject();
        boolean reachedContainer = false;
        while (eObjectNode != null && !reachedContainer) {
            if (eObjectNode instanceof XMLDataContentNode) {
                XSDElementDeclaration xsdEle = ZCeeMappingUtil.getXSDElementDeclaration((EObject)eObjectNode);
                if (!ZosConnectXsdUtil.isHttpInputOrOutputBody((XSDElementDeclaration)xsdEle) && !ZosConnectXsdUtil.isHttpParametersGroup((XSDElementDeclaration)xsdEle)) {
                    xsdElements.add(0, xsdEle);
                } else {
                    reachedContainer = true;
                }
            }
            eObjectNode = eObjectNode.getParent();
        }
        return xsdElements;
    }

    public static String getDesignatorShape(MappingDesignator designator) {
        StringBuilder shapeBuf = new StringBuilder();
        List<XSDElementDeclaration> xsdElements = ZCeeMappingUtil.getXSDElementsInStructOrder(designator);
        MappingRoot mappingRoot = ModelUtils.getMappingRoot((MappingDesignator)designator);
        boolean isJsonWrapped = ZCeeMappingRootAnnotator.getJsonWrapped(mappingRoot);
        if (isJsonWrapped && xsdElements.size() > 1) {
            xsdElements.remove(0);
        }
        int depth = 0;
        for (XSDElementDeclaration nextElement : xsdElements) {
            shapeBuf.append(++depth);
            if (ZosConnectXsdUtil.isArrayElement((XSDElementDeclaration)nextElement)) {
                int minOccurs = XSDUtils.getMinOccurs((EObject)nextElement);
                int maxOccurs = XSDUtils.getMaxOccurs((EObject)nextElement);
                shapeBuf.append("[" + minOccurs + ".." + String.valueOf(maxOccurs == -1 ? "*" : Integer.valueOf(maxOccurs)) + "]");
            }
            shapeBuf.append(",");
        }
        return StringUtils.removeEnd((String)shapeBuf.toString(), (String)",");
    }

    public static MappingDesignator getMappingDesignator(MappingIOEditPart ioEditPart) {
        MappingDesignator designator = null;
        if (ioEditPart != null && ioEditPart.getModel() instanceof MappingIOType) {
            designator = ((MappingIOType)ioEditPart.getModel()).getDesignator();
        }
        return designator;
    }

    public static void updateMappingAnnotations(MappingRoot mappingRoot) {
        for (Mapping mapping : ModelUtils.getAllNestedMappings((MappingContainer)mappingRoot)) {
            if (!ModelUtils.hasMoveRefinement((Mapping)mapping) && !ModelUtils.hasAssignRefinement((Mapping)mapping) && !ZCeeMappingUtil.hasRemoveRefinement(mapping)) continue;
            for (MappingDesignator designator : ZCeeMappingUtil.getMappingDesignators(mapping)) {
                ZCeeMappingAnnotator.applyInlineXsdAnnotations(designator);
            }
        }
    }

    public static XSDElementDeclaration getXsdElementDeclaration(MappingDesignator designator) {
        XSDElementDeclaration retVal = null;
        if (designator != null && designator.getObject() != null) {
            retVal = ZCeeMappingUtil.getXSDElementDeclaration(designator.getObject());
        }
        return retVal;
    }

    public static XSDSimpleTypeDefinition getXsdSimpleType(MappingDesignator designator) {
        XSDSimpleTypeDefinition retVal = null;
        if (ZCeeMappingUtil.isSimpleNode(designator)) {
            XSDElementDeclaration xsdEle = ZCeeMappingUtil.getXSDElementDeclaration(designator.getObject());
            retVal = (XSDSimpleTypeDefinition)xsdEle.getType();
        }
        return retVal;
    }

    public static XSDSimpleTypeDefinition getXsdSimpleType(XMLTypeNode xmlTypeNode) {
        XSDSimpleTypeDefinition retVal = null;
        EObject xmlTypeNodeObject = xmlTypeNode.getObject();
        if (xmlTypeNodeObject instanceof XSDSimpleTypeDefinition) {
            retVal = (XSDSimpleTypeDefinition)xmlTypeNodeObject;
        }
        return retVal;
    }

    public static void setParameterArrayFacets(AbstractSerializableParameter<?> parameter, MappingDesignator designator) {
        ZCeeMappingUtil.clearParameterArrayFacets(parameter);
        if (JsonSchemaPrimitiveType.ARRAY.value().equals(parameter.getType())) {
            int minOccurs = ZCeeMappingUtil.getMinRepetitons(designator);
            int maxOccurs = ZCeeMappingUtil.getMaxRepetitons(designator);
            if (minOccurs > 0) {
                parameter.setMinItems(Integer.valueOf(minOccurs));
            }
            if (maxOccurs > 1) {
                parameter.setMaxItems(Integer.valueOf(maxOccurs));
            }
        }
    }

    public static void clearParameterArrayFacets(AbstractSerializableParameter<?> parameter) {
        parameter.setMinItems(null);
        parameter.setMaxItems(null);
    }

    public static void setPropertyArrayFacets(Property property, MappingDesignator designator) {
        ZCeeMappingUtil.clearPropertyArrayFacets(property);
        if (property instanceof ArrayProperty) {
            ArrayProperty arrayProperty = (ArrayProperty)property;
            int minOccurs = ZCeeMappingUtil.getMinRepetitons(designator);
            int maxOccurs = ZCeeMappingUtil.getMaxRepetitons(designator);
            if (minOccurs > 0) {
                arrayProperty.setMinItems(Integer.valueOf(minOccurs));
            }
            if (maxOccurs > 1) {
                arrayProperty.setMaxItems(Integer.valueOf(maxOccurs));
            }
        }
    }

    public static void clearPropertyArrayFacets(Property property) {
        if (property instanceof ArrayProperty) {
            ArrayProperty arrayProperty = (ArrayProperty)property;
            arrayProperty.setMinItems(null);
            arrayProperty.setMaxItems(null);
        }
    }

    public static List<String> getAllSupportedMappingObjectUris(MappingRoot mappingRoot) {
        ArrayList<String> objectUris = new ArrayList<String>();
        for (Mapping mapping : ModelUtils.getAllNestedMappings((MappingContainer)mappingRoot)) {
            String objectUri;
            if (!ModelUtils.hasMoveRefinement((Mapping)mapping) && !ModelUtils.hasAssignRefinement((Mapping)mapping) && !ZCeeMappingUtil.hasRemoveRefinement(mapping) || StringUtils.isBlank((CharSequence)(objectUri = URIUtilz.getEObjectURI((EObject)mapping)))) continue;
            objectUris.add(objectUri);
        }
        return objectUris;
    }

    public static String getTypeNameForMsgInsert(MappingDesignator designator) {
        String retVal = "";
        if (ZCeeMappingUtil.isInInputHeadersGroup(designator)) {
            retVal = Xlat.error((String)"IMPORT_EXISTING_SERVICE_INPUT_HEADER");
        } else if (ZCeeMappingUtil.isInInputPathParametersGroup(designator)) {
            retVal = Xlat.error((String)"IMPORT_EXISTING_SERVICE_PATH_PARM");
        } else if (ZCeeMappingUtil.isInInputQueryParametersGroup(designator)) {
            retVal = Xlat.error((String)"IMPORT_EXISTING_SERVICE_QRY_PARM");
        } else if (ZCeeMappingUtil.isJsonOutputFieldDesignator(designator)) {
            retVal = Xlat.error((String)"IMPORT_EXISTING_SERVICE_SERVICE_FLD");
        } else if (ZCeeMappingUtil.isJsonInputFieldDesignator(designator)) {
            retVal = Xlat.error((String)"IMPORT_EXISTING_SERVICE_SERVICE_FLD");
        } else if (ZCeeMappingUtil.isInOutputHeadersGroup(designator)) {
            retVal = Xlat.error((String)"IMPORT_EXISTING_SERVICE_OUTPUT_HEADER");
        }
        return retVal;
    }

    public static String getRefNameForMsgInsert(MappingDesignator designator) {
        String retVal = ModelUtils.getRefName((MappingDesignator)designator);
        if (retVal == null) {
            retVal = "";
        }
        if (ZCeeMappingUtil.isInInputHeadersGroup(designator)) {
            retVal = StringUtils.removeStart((String)retVal, (String)"Headers/");
        } else if (ZCeeMappingUtil.isInInputPathParametersGroup(designator)) {
            retVal = StringUtils.removeStart((String)retVal, (String)"PathParameters/");
        } else if (ZCeeMappingUtil.isInInputQueryParametersGroup(designator)) {
            retVal = StringUtils.removeStart((String)retVal, (String)"QueryParameters/");
        } else if (ZCeeMappingUtil.isJsonOutputFieldDesignator(designator)) {
            retVal = StringUtils.removeStart((String)retVal, (String)"Body/");
        } else if (ZCeeMappingUtil.isJsonInputFieldDesignator(designator)) {
            retVal = StringUtils.removeStart((String)retVal, (String)"Body/");
            retVal = StringUtils.removeStart((String)retVal, (String)(ZCeeMappingUtil.getJsonInputFieldRootElementName(designator) + "/"));
        } else if (ZCeeMappingUtil.isInOutputHeadersGroup(designator)) {
            retVal = StringUtils.removeStart((String)retVal, (String)"Headers/");
        }
        return retVal;
    }

    public static MappingResourceImpl loadMappingFile(IFile mappingFile) throws FileNotFoundException, IOException, CoreException {
        ResourceSet resourceSet = MappingSingleton.createMappingResourceSet(new HashMap());
        MappingResourceImpl resource = (MappingResourceImpl)resourceSet.createResource(URI.createPlatformResourceURI((String)mappingFile.getFullPath().toString()));
        resourceSet.getResources().add((Object)resource);
        HashMap loadOptions = new HashMap();
        for (Map.Entry option : resource.getDefaultLoadOptions().entrySet()) {
            loadOptions.put((String)option.getKey(), option.getValue());
        }
        File mappingFileNat = mappingFile.getLocation().toFile();
        FileInputStream mappingFileIS = new FileInputStream(mappingFileNat);
        ZCeeMappingLoad deserializer = new ZCeeMappingLoad();
        deserializer.load((Resource)resource, mappingFileIS, loadOptions);
        IOUtils.closeQuietly((InputStream)mappingFileIS);
        return resource;
    }

    public static void saveMappingFile(MappingResourceImpl resource, IFile mappingFile) throws FileNotFoundException, IOException {
        resource.setURI(URI.createPlatformResourceURI((String)mappingFile.getFullPath().toString()));
        HashMap saveOptions = new HashMap();
        for (Map.Entry option : resource.getDefaultSaveOptions().entrySet()) {
            saveOptions.put((String)option.getKey(), option.getValue());
        }
        File mappingFileNat = mappingFile.getLocation().toFile();
        FileOutputStream mappingFileOS = new FileOutputStream(mappingFileNat);
        ZCeeMappingSave serializer = new ZCeeMappingSave();
        serializer.save((Resource)resource, mappingFileOS, saveOptions);
        IOUtils.closeQuietly((OutputStream)mappingFileOS);
    }

    public static MappingRoot findMappingRoot(MappingResourceImpl resource) {
        if (resource != null) {
            for (Object content : resource.getContents()) {
                if (!(content instanceof MappingRoot)) continue;
                return (MappingRoot)content;
            }
        }
        return null;
    }

    public static MappingValidationManager getMappingValidationManager(MappingRoot mappingRoot) {
        MappingValidationManager validationManager = null;
        MappingEnvironment environment = MappingEnvironmentRegistry.getMappingEnvironment((MappingRoot)mappingRoot);
        if (environment != null) {
            validationManager = environment.getMappingEnvironmentValidationManager(mappingRoot);
        }
        return validationManager;
    }
}

