/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.mapping.util;

import com.ibm.msl.mapping.InlinedXMLSchema;
import com.ibm.msl.mapping.Mapping;
import com.ibm.msl.mapping.MappingRoot;
import com.ibm.msl.mapping.util.MappingResourceImpl;
import com.ibm.zosconnect.api.mapping.jsd.JsonSchemaPrimitiveTypeFormat;
import com.ibm.zosconnect.ui.common.exceptions.ZosConnectMappingException;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.common.util.xsd.ZosConnectXsdUtil;
import com.ibm.zosconnect.ui.common.util.xsd.walker.IZosConnectXsdVisitor;
import com.ibm.zosconnect.ui.common.util.xsd.walker.ZosConnectXsdCompareVisitor;
import com.ibm.zosconnect.ui.common.util.xsd.walker.ZosConnectXsdWalker;
import com.ibm.zosconnect.ui.common.validation.IMappingProblemProvider;
import com.ibm.zosconnect.ui.common.validation.MappingProblemTypes;
import com.ibm.zosconnect.ui.common.validation.MappingValidationProblem2;
import com.ibm.zosconnect.ui.mapping.util.ZCeeDesignatorGroup;
import com.ibm.zosconnect.ui.mapping.util.ZCeeMappingUtil;
import com.ibm.zosconnect.ui.mapping.util.ZCeeMappingValidatorUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;

public class ZCeeMappingComparator
implements IMappingProblemProvider {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private MappingRoot oldMappingRoot = null;
    private MappingRoot newMappingRoot = null;
    private MappingFileType filesType;
    private String filesTypeString;
    private XSDSchema oldJsonSchema = null;
    private XSDSchema newJsonSchema = null;
    private HashSet<String> missingFields = null;
    private HashSet<String> addedFields = null;
    private List<MappingValidationProblem2> errorProblems = new ArrayList<MappingValidationProblem2>();
    private List<MappingValidationProblem2> warningProblems = new ArrayList<MappingValidationProblem2>();
    private List<MappingValidationProblem2> otherProblems = new ArrayList<MappingValidationProblem2>();
    private IFile oldMappingFile = null;
    private Integer responseCode;

    public ZCeeMappingComparator(IFile oldFile, IFile newFile) throws FileNotFoundException, IOException, CoreException {
        this.oldMappingFile = oldFile;
        MappingResourceImpl mappingResource1 = ZCeeMappingUtil.loadMappingFile(oldFile);
        this.oldMappingRoot = ZCeeMappingUtil.findMappingRoot(mappingResource1);
        MappingResourceImpl mappingResource2 = ZCeeMappingUtil.loadMappingFile(newFile);
        this.newMappingRoot = ZCeeMappingUtil.findMappingRoot(mappingResource2);
    }

    public ZCeeMappingComparator(IFile oldFile, IFile newFile, Integer responseCode) throws FileNotFoundException, IOException, CoreException {
        this(oldFile, newFile);
        this.responseCode = responseCode;
    }

    public void compare() throws Exception {
        MappingFileType file1Type = this.determineMappingFileType(this.oldMappingRoot);
        MappingFileType file2Type = this.determineMappingFileType(this.newMappingRoot);
        if (file1Type == MappingFileType.REQUEST && file2Type == MappingFileType.RESPONSE || file1Type == MappingFileType.RESPONSE && file2Type == MappingFileType.REQUEST) {
            throw new ZosConnectMappingException(Xlat.error((String)"MISMATCHED_COMPARE_FILES"));
        }
        if (file1Type == MappingFileType.REQUEST) {
            XSDSchema nextSchema;
            this.filesType = MappingFileType.REQUEST;
            this.filesTypeString = Xlat.label((String)"IMPACT_ANALYSIS_PROBLEMS_REQUEST");
            for (InlinedXMLSchema inlineXmlSchema : this.oldMappingRoot.getInlinedXMLSchemas()) {
                nextSchema = inlineXmlSchema.getInlinedSchema();
                if (ZosConnectXsdUtil.isHttpInputTns((String)nextSchema.getTargetNamespace())) continue;
                if (ZosConnectXsdUtil.isJsonOutputTns((String)nextSchema.getTargetNamespace())) {
                    this.oldJsonSchema = nextSchema;
                    continue;
                }
                throw new ZosConnectMappingException(Xlat.error((String)"INVALID_MAPFILE_SCHEMA"));
            }
            for (InlinedXMLSchema inlineXmlSchema : this.newMappingRoot.getInlinedXMLSchemas()) {
                nextSchema = inlineXmlSchema.getInlinedSchema();
                if (ZosConnectXsdUtil.isHttpInputTns((String)nextSchema.getTargetNamespace())) continue;
                if (ZosConnectXsdUtil.isJsonOutputTns((String)nextSchema.getTargetNamespace())) {
                    this.newJsonSchema = nextSchema;
                    continue;
                }
                throw new ZosConnectMappingException(Xlat.error((String)"INVALID_MAPFILE_SCHEMA"));
            }
        } else if (file1Type == MappingFileType.RESPONSE) {
            XSDSchema nextSchema;
            this.filesType = MappingFileType.RESPONSE;
            this.filesTypeString = Xlat.label((String)"IMPACT_ANALYSIS_PROBLEMS_RESPONSE", (Object[])new Object[]{this.responseCode});
            for (InlinedXMLSchema inlineXmlSchema : this.oldMappingRoot.getInlinedXMLSchemas()) {
                nextSchema = inlineXmlSchema.getInlinedSchema();
                if (ZosConnectXsdUtil.isHttpOutputTns((String)nextSchema.getTargetNamespace())) continue;
                if (ZosConnectXsdUtil.isJsonInputTns((String)nextSchema.getTargetNamespace())) {
                    this.oldJsonSchema = nextSchema;
                    continue;
                }
                throw new ZosConnectMappingException(Xlat.error((String)"INVALID_MAPFILE_SCHEMA"));
            }
            for (InlinedXMLSchema inlineXmlSchema : this.newMappingRoot.getInlinedXMLSchemas()) {
                nextSchema = inlineXmlSchema.getInlinedSchema();
                if (ZosConnectXsdUtil.isHttpOutputTns((String)nextSchema.getTargetNamespace())) continue;
                if (ZosConnectXsdUtil.isJsonInputTns((String)nextSchema.getTargetNamespace())) {
                    this.newJsonSchema = nextSchema;
                    continue;
                }
                throw new ZosConnectMappingException(Xlat.error((String)"INVALID_MAPFILE_SCHEMA"));
            }
        }
        if (this.oldJsonSchema == null) {
            throw new ZosConnectMappingException(Xlat.error((String)"SCHEMA_NULL"));
        }
        if (this.newJsonSchema == null) {
            throw new ZosConnectMappingException(Xlat.error((String)"SCHEMA_NULL"));
        }
        this.compareJsonInlineSchemas();
        this.compareMoveMappings();
        this.compareAssignMappings();
        this.compareRemoveMappings();
    }

    private void compareJsonInlineSchemas() throws Exception {
        ZosConnectXsdWalker walker = new ZosConnectXsdWalker((XSDElementDeclaration)this.oldJsonSchema.getElementDeclarations().get(0));
        ZosConnectXsdCompareVisitor visitor = new ZosConnectXsdCompareVisitor();
        walker.accept((IZosConnectXsdVisitor)visitor);
        Map oldJsonSchemaEleMap = visitor.getXsdEleMap();
        Map oldJsonSchemaTypeMap = visitor.getXsdTypeMap();
        walker = new ZosConnectXsdWalker((XSDElementDeclaration)this.newJsonSchema.getElementDeclarations().get(0));
        visitor = new ZosConnectXsdCompareVisitor();
        walker.accept((IZosConnectXsdVisitor)visitor);
        Map newJsonSchemaEleMap = visitor.getXsdEleMap();
        Map newJsonSchemaTypeMap = visitor.getXsdTypeMap();
        this.missingFields = new HashSet(oldJsonSchemaTypeMap.keySet());
        this.missingFields.removeAll(newJsonSchemaTypeMap.keySet());
        this.addedFields = new HashSet(newJsonSchemaTypeMap.keySet());
        this.addedFields.removeAll(oldJsonSchemaTypeMap.keySet());
        for (String field : this.missingFields) {
            this.warningProblems.add(new MappingValidationProblem2(1, Xlat.error((String)"IMPORT_EXISTING_SERVICE_FLD_REMOVED_MSG", (String[])new String[]{field}), MappingProblemTypes.FIELD_REMOVED, this.oldMappingFile.getLocation(), this.filesTypeString));
        }
        for (String field : this.addedFields) {
            this.warningProblems.add(new MappingValidationProblem2(1, Xlat.error((String)"IMPORT_EXISTING_SERVICE_FLD_ADDED_MSG", (String[])new String[]{field}), MappingProblemTypes.FIELD_ADDED, this.oldMappingFile.getLocation(), this.filesTypeString));
        }
        HashSet intersectFields = new HashSet(oldJsonSchemaTypeMap.keySet());
        intersectFields.retainAll(newJsonSchemaTypeMap.keySet());
        for (String fieldName : intersectFields) {
            if (!(oldJsonSchemaTypeMap.get(fieldName) instanceof XSDSimpleTypeDefinition)) continue;
            XSDSimpleTypeDefinition oldSimpleType = (XSDSimpleTypeDefinition)oldJsonSchemaTypeMap.get(fieldName);
            XSDSimpleTypeDefinition newSimpleType = null;
            if (newJsonSchemaTypeMap.get(fieldName) instanceof XSDSimpleTypeDefinition) {
                String[] inputs;
                String newDataType;
                newSimpleType = (XSDSimpleTypeDefinition)newJsonSchemaTypeMap.get(fieldName);
                String oldDataType = oldSimpleType.getBaseType().getName();
                if (!oldDataType.equalsIgnoreCase(newDataType = newSimpleType.getBaseType().getName())) {
                    String[] inputs2 = new String[]{fieldName, oldDataType, newDataType};
                    this.warningProblems.add(new MappingValidationProblem2(1, Xlat.error((String)"IMPORT_EXISTING_SERVICE_FLDTYPE_CHANGED_MSG", (String[])inputs2), MappingProblemTypes.FIELD_DATA_TYPE_CHANGED, this.oldMappingFile.getLocation(), this.filesTypeString));
                }
                XSDElementDeclaration oldElement = (XSDElementDeclaration)oldJsonSchemaEleMap.get(fieldName);
                XSDElementDeclaration newElement = (XSDElementDeclaration)newJsonSchemaEleMap.get(fieldName);
                JsonSchemaPrimitiveTypeFormat oldTypeFormat = ZosConnectXsdUtil.getJsonSchemaPrimitiveTypeFormatAppInfo((XSDElementDeclaration)oldElement);
                JsonSchemaPrimitiveTypeFormat newTypeFormat = ZosConnectXsdUtil.getJsonSchemaPrimitiveTypeFormatAppInfo((XSDElementDeclaration)newElement);
                if (oldTypeFormat == null && newTypeFormat != null) {
                    inputs = new String[]{newTypeFormat.value(), fieldName};
                    this.warningProblems.add(new MappingValidationProblem2(1, Xlat.error((String)"IMPORT_EXISTING_SERVICE_FLDTYPEFMT_ADD", (String[])inputs), MappingProblemTypes.FIELD_DATA_TYPE_FORMAT_CHANGED, this.oldMappingFile.getLocation(), this.filesTypeString));
                    continue;
                }
                if (oldTypeFormat != null && newTypeFormat == null) {
                    inputs = new String[]{oldTypeFormat.value(), fieldName};
                    this.warningProblems.add(new MappingValidationProblem2(1, Xlat.error((String)"IMPORT_EXISTING_SERVICE_FLDTYPEFMT_REMOVE", (String[])inputs), MappingProblemTypes.FIELD_DATA_TYPE_FORMAT_CHANGED, this.oldMappingFile.getLocation(), this.filesTypeString));
                    continue;
                }
                if (oldTypeFormat == null || newTypeFormat == null || oldTypeFormat.equals((Object)newTypeFormat)) continue;
                inputs = new String[]{fieldName, oldTypeFormat.value(), newTypeFormat.value()};
                this.warningProblems.add(new MappingValidationProblem2(1, Xlat.error((String)"IMPORT_EXISTING_SERVICE_FLDTYPEFMT_CHANGED", (String[])inputs), MappingProblemTypes.FIELD_DATA_TYPE_FORMAT_CHANGED, this.oldMappingFile.getLocation(), this.filesTypeString));
                continue;
            }
            if (!(newJsonSchemaTypeMap.get(fieldName) instanceof XSDComplexTypeDefinition)) continue;
            String[] inputs = new String[]{fieldName};
            this.warningProblems.add(new MappingValidationProblem2(1, Xlat.error((String)"IMPORT_EXISTING_SERVICE_FLD_XSDTYPE_CHANGED", (String[])inputs), MappingProblemTypes.FIELD_DATA_TYPE_CHANGED, this.oldMappingFile.getLocation(), this.filesTypeString));
        }
    }

    private void compareMoveMappings() {
        if (this.filesType == MappingFileType.REQUEST) {
            List<Mapping> requestMoveMappings = ZCeeMappingUtil.getMoveMappings(this.newMappingRoot, ZCeeDesignatorGroup.INPUT_HEADER, ZCeeDesignatorGroup.INPUT_PATH_PARAMETER, ZCeeDesignatorGroup.INPUT_QUERY_PARAMETER);
            for (Mapping requestMoveMapping : requestMoveMappings) {
                ZCeeMappingValidatorUtil.validateMoveMapping(requestMoveMapping, (IResource)this.oldMappingFile, this.errorProblems, this.filesTypeString);
            }
        } else {
            List<Mapping> responseMoveMappings = ZCeeMappingUtil.getMoveMappings(this.newMappingRoot, ZCeeDesignatorGroup.OUTPUT_HEADER);
            for (Mapping responseMoveMapping : responseMoveMappings) {
                ZCeeMappingValidatorUtil.validateMoveMapping(responseMoveMapping, (IResource)this.oldMappingFile, this.errorProblems, this.filesTypeString);
            }
        }
    }

    private void compareAssignMappings() {
        if (this.filesType == MappingFileType.REQUEST) {
            List<Mapping> requestAssignMappings = ZCeeMappingUtil.getAssignMappings(this.newMappingRoot, ZCeeDesignatorGroup.INPUT_BODY);
            for (Mapping requestAssignMapping : requestAssignMappings) {
                ZCeeMappingValidatorUtil.validateAssignMapping(requestAssignMapping, (IResource)this.oldMappingFile, this.errorProblems, this.filesTypeString);
            }
        } else {
            List<Mapping> responseAssignMappings = ZCeeMappingUtil.getAssignMappings(this.newMappingRoot, ZCeeDesignatorGroup.OUTPUT_HEADER, ZCeeDesignatorGroup.OUTPUT_BODY);
            for (Mapping responseAssignMapping : responseAssignMappings) {
                ZCeeMappingValidatorUtil.validateAssignMapping(responseAssignMapping, (IResource)this.oldMappingFile, this.errorProblems, this.filesTypeString);
            }
        }
    }

    private void compareRemoveMappings() {
        if (this.filesType == MappingFileType.REQUEST) {
            List<Mapping> requestRemoveMappings = ZCeeMappingUtil.getRemoveMappings(this.newMappingRoot, ZCeeDesignatorGroup.INPUT_BODY);
            for (Mapping requestRemoveMapping : requestRemoveMappings) {
                ZCeeMappingValidatorUtil.validateRemoveMapping(requestRemoveMapping, (IResource)this.oldMappingFile, this.errorProblems, this.filesTypeString);
            }
        } else {
            List<Mapping> responseRemoveMappings = ZCeeMappingUtil.getRemoveMappings(this.newMappingRoot, ZCeeDesignatorGroup.OUTPUT_BODY);
            for (Mapping responseRemoveMapping : responseRemoveMappings) {
                ZCeeMappingValidatorUtil.validateRemoveMapping(responseRemoveMapping, (IResource)this.oldMappingFile, this.errorProblems, this.filesTypeString);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MappingFileType determineMappingFileType(MappingRoot mappingRoot) throws ZosConnectMappingException {
        MappingFileType retVal = null;
        XSDSchema firstSchema = null;
        XSDSchema secondSchema = null;
        InlinedXMLSchema inlineXmlSchema1 = (InlinedXMLSchema)mappingRoot.getInlinedXMLSchemas().get(0);
        firstSchema = inlineXmlSchema1.getInlinedSchema();
        InlinedXMLSchema inlineXmlSchema2 = (InlinedXMLSchema)mappingRoot.getInlinedXMLSchemas().get(1);
        secondSchema = inlineXmlSchema2.getInlinedSchema();
        if (firstSchema == null) throw new ZosConnectMappingException(Xlat.error((String)"SCHEMA_NULL"));
        if (secondSchema == null) throw new ZosConnectMappingException(Xlat.error((String)"SCHEMA_NULL"));
        if (ZosConnectXsdUtil.isHttpInputTns((String)firstSchema.getTargetNamespace())) {
            if (!ZosConnectXsdUtil.isJsonOutputTns((String)secondSchema.getTargetNamespace())) throw new ZosConnectMappingException(Xlat.error((String)"INVALID_MAPFILE_SCHEMA"));
            return MappingFileType.REQUEST;
        }
        if (ZosConnectXsdUtil.isHttpOutputTns((String)firstSchema.getTargetNamespace())) {
            if (!ZosConnectXsdUtil.isJsonInputTns((String)secondSchema.getTargetNamespace())) throw new ZosConnectMappingException(Xlat.error((String)"INVALID_MAPFILE_SCHEMA"));
            return MappingFileType.RESPONSE;
        }
        if (ZosConnectXsdUtil.isJsonInputTns((String)firstSchema.getTargetNamespace())) {
            if (!ZosConnectXsdUtil.isHttpOutputTns((String)secondSchema.getTargetNamespace())) throw new ZosConnectMappingException(Xlat.error((String)"INVALID_MAPFILE_SCHEMA"));
            return MappingFileType.RESPONSE;
        }
        if (!ZosConnectXsdUtil.isJsonOutputTns((String)firstSchema.getTargetNamespace())) return retVal;
        if (!ZosConnectXsdUtil.isHttpInputTns((String)secondSchema.getTargetNamespace())) throw new ZosConnectMappingException(Xlat.error((String)"INVALID_MAPFILE_SCHEMA"));
        return MappingFileType.REQUEST;
    }

    public List<MappingValidationProblem2> getErrorProblems() {
        return this.errorProblems;
    }

    public List<MappingValidationProblem2> getWarningProblems() {
        return this.warningProblems;
    }

    public List<MappingValidationProblem2> getOtherProblems() {
        return this.otherProblems;
    }

    private static enum MappingFileType {
        REQUEST,
        RESPONSE;

    }
}

