/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.mapping.util;

import com.ibm.msl.mapping.MappingDesignator;
import com.ibm.msl.mapping.xml.util.XSDUtils;
import com.ibm.zosconnect.api.mapping.annotations.ArrayFormat;
import com.ibm.zosconnect.api.mapping.annotations.HttpIn;
import com.ibm.zosconnect.api.mapping.annotations.ZosConnectMappingAnnotations;
import com.ibm.zosconnect.api.mapping.jsd.JsonSchemaPrimitiveTypeFormat;
import com.ibm.zosconnect.ui.common.util.xsd.IZosConnectXsdSimpleTypes;
import com.ibm.zosconnect.ui.common.util.xsd.ZosConnectXsdSimpleTypes;
import com.ibm.zosconnect.ui.common.util.xsd.ZosConnectXsdUtil;
import com.ibm.zosconnect.ui.mapping.util.ZCeeMappingUtil;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSimpleTypeDefinition;

public class ZCeeMappingAnnotator {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static IZosConnectXsdSimpleTypes xsdSimpleTypes = ZosConnectXsdSimpleTypes.getInstance();

    public static void applyInlineXsdAnnotations(MappingDesignator mappingDesignator) {
        ZCeeMappingAnnotator.annotateWithHttpIn(mappingDesignator);
        ZCeeMappingAnnotator.annotateWithXsdBuiltOrDerivedSimpleType(mappingDesignator);
        ZCeeMappingAnnotator.annotateWithJSONSchemaPrimitiveTypeFormat(mappingDesignator);
        ZCeeMappingAnnotator.annotateHeadersAndUriParamsWithRequired(mappingDesignator);
        ZCeeMappingAnnotator.annotateWithArrayFormat(mappingDesignator);
        ZCeeMappingAnnotator.annotateWithShape(mappingDesignator);
    }

    private static void annotateWithHttpIn(MappingDesignator mappingDesignator) {
        if (mappingDesignator == null || mappingDesignator.getObject() == null || !ZCeeMappingUtil.isSimpleNode(mappingDesignator)) {
            return;
        }
        ZCeeMappingAnnotator.unsetHttpIn(mappingDesignator);
        if (ZCeeMappingUtil.isJsonInputFieldDesignator(mappingDesignator)) {
            ZCeeMappingAnnotator.setHttpIn(mappingDesignator, HttpIn.BODY.value());
        } else if (ZCeeMappingUtil.isJsonOutputFieldDesignator(mappingDesignator)) {
            ZCeeMappingAnnotator.setHttpIn(mappingDesignator, HttpIn.BODY.value());
        } else {
            EObject xsdObject = mappingDesignator.getObject();
            XSDElementDeclaration xsdParentElement = ZCeeMappingUtil.getParentXSDElementDeclaration(xsdObject);
            if (xsdParentElement == null) {
                return;
            }
            if (ZosConnectXsdUtil.isHttpInputHeadersGroup((XSDElementDeclaration)xsdParentElement) || ZosConnectXsdUtil.isHttpOutputHeadersGroup((XSDElementDeclaration)xsdParentElement)) {
                ZCeeMappingAnnotator.setHttpIn(mappingDesignator, HttpIn.HEADER.value());
            } else if (ZosConnectXsdUtil.isHttpInputPathParametersGroup((XSDElementDeclaration)xsdParentElement)) {
                ZCeeMappingAnnotator.setHttpIn(mappingDesignator, HttpIn.PATH.value());
            } else if (ZosConnectXsdUtil.isHttpInputQueryParametersGroup((XSDElementDeclaration)xsdParentElement)) {
                ZCeeMappingAnnotator.setHttpIn(mappingDesignator, HttpIn.QUERY.value());
            }
        }
    }

    private static void annotateWithXsdBuiltOrDerivedSimpleType(MappingDesignator mappingDesignator) {
        if (mappingDesignator == null || mappingDesignator.getObject() == null || !ZCeeMappingUtil.isSimpleNode(mappingDesignator)) {
            return;
        }
        ZCeeMappingAnnotator.unsetXsdBuiltInOrDerivedType(mappingDesignator);
        XSDElementDeclaration xsdElement = ZCeeMappingUtil.getXSDElementDeclaration(mappingDesignator.getObject());
        XSDSimpleTypeDefinition xsdSimpleType = (XSDSimpleTypeDefinition)xsdElement.getType();
        int xsdSimpleTypeID = xsdSimpleTypes.getBuiltInOrDerivedTypeID(xsdSimpleType);
        String xsdSimpleTypeName = xsdSimpleTypes.getBuiltInOrDerivedTypeName(xsdSimpleTypeID);
        ZCeeMappingAnnotator.setXsdBuiltInOrDerivedType(mappingDesignator, xsdSimpleTypeName);
    }

    private static void annotateWithJSONSchemaPrimitiveTypeFormat(MappingDesignator mappingDesignator) {
        if (mappingDesignator == null || mappingDesignator.getObject() == null || !ZCeeMappingUtil.isSimpleNode(mappingDesignator)) {
            return;
        }
        ZCeeMappingAnnotator.unsetJSONSchemaPrimitiveTypeFormat(mappingDesignator);
        XSDElementDeclaration xsdElement = ZCeeMappingUtil.getXSDElementDeclaration(mappingDesignator.getObject());
        JsonSchemaPrimitiveTypeFormat typeFormat = ZosConnectXsdUtil.getJsonSchemaPrimitiveTypeFormatAppInfo((XSDElementDeclaration)xsdElement);
        if (typeFormat != null) {
            ZCeeMappingAnnotator.setJSONSchemaPrimitiveTypeFormat(mappingDesignator, typeFormat.value());
        }
    }

    private static void annotateHeadersAndUriParamsWithRequired(MappingDesignator mappingDesignator) {
        if (mappingDesignator == null || mappingDesignator.getObject() == null || !ZCeeMappingUtil.isSimpleNode(mappingDesignator)) {
            return;
        }
        ZCeeMappingAnnotator.unsetRequired(mappingDesignator);
        XSDElementDeclaration xsdElement = ZCeeMappingUtil.getXSDElementDeclaration(mappingDesignator.getObject());
        int minOccurs = XSDUtils.getMinOccurs((EObject)xsdElement);
        XSDElementDeclaration xsdParentElement = ZCeeMappingUtil.getParentXSDElementDeclaration(mappingDesignator.getObject());
        if ((ZosConnectXsdUtil.isHttpInputHeadersGroup((XSDElementDeclaration)xsdParentElement) || ZosConnectXsdUtil.isHttpOutputHeadersGroup((XSDElementDeclaration)xsdParentElement) || ZosConnectXsdUtil.isHttpInputPathParametersGroup((XSDElementDeclaration)xsdParentElement) || ZosConnectXsdUtil.isHttpInputQueryParametersGroup((XSDElementDeclaration)xsdParentElement)) && minOccurs == 0) {
            ZCeeMappingAnnotator.setRequired(mappingDesignator, false);
        }
    }

    private static void annotateWithArrayFormat(MappingDesignator mappingDesignator) {
        if (mappingDesignator == null || mappingDesignator.getObject() == null || !ZCeeMappingUtil.isSimpleNode(mappingDesignator)) {
            return;
        }
        ZCeeMappingAnnotator.unsetArrayFormat(mappingDesignator);
        boolean isRepeating = ZCeeMappingUtil.isRepeating(mappingDesignator);
        if (!isRepeating) {
            return;
        }
        XSDElementDeclaration xsdElement = ZCeeMappingUtil.getXSDElementDeclaration(mappingDesignator.getObject());
        ZCeeMappingAnnotator.setArrayFormat(mappingDesignator, ZosConnectXsdUtil.getArrayFormatAppInfo((XSDElementDeclaration)xsdElement));
    }

    private static void annotateWithShape(MappingDesignator mappingDesignator) {
        if (mappingDesignator == null || mappingDesignator.getObject() == null) {
            return;
        }
        ZCeeMappingAnnotator.unsetShape(mappingDesignator);
        ZCeeMappingAnnotator.setShape(mappingDesignator, ZCeeMappingUtil.getDesignatorShape(mappingDesignator));
    }

    public static String getHttpIn(MappingDesignator mappingDesignator) {
        String retVal = "";
        if (mappingDesignator != null) {
            mappingDesignator.getAnnotations().get((Object)ZosConnectMappingAnnotations.HTTP_IN.value());
        }
        return retVal;
    }

    public static void setHttpIn(MappingDesignator mappingDesignator, String value) {
        if (mappingDesignator != null) {
            mappingDesignator.getAnnotations().put((Object)ZosConnectMappingAnnotations.HTTP_IN.value(), (Object)value);
        }
    }

    public static void unsetHttpIn(MappingDesignator mappingDesignator) {
        if (mappingDesignator != null) {
            mappingDesignator.getAnnotations().remove((Object)ZosConnectMappingAnnotations.HTTP_IN.value());
        }
    }

    public static String getXsdBuiltInOrDerivedType(MappingDesignator mappingDesignator) {
        String retVal = "";
        if (mappingDesignator != null) {
            mappingDesignator.getAnnotations().get((Object)ZosConnectMappingAnnotations.XSD_BUILT_IN_OR_DERIVED_SIMPLE_TYPE.value());
        }
        return retVal;
    }

    public static void setXsdBuiltInOrDerivedType(MappingDesignator mappingDesignator, String value) {
        if (mappingDesignator != null) {
            mappingDesignator.getAnnotations().put((Object)ZosConnectMappingAnnotations.XSD_BUILT_IN_OR_DERIVED_SIMPLE_TYPE.value(), (Object)value);
        }
    }

    public static void unsetXsdBuiltInOrDerivedType(MappingDesignator mappingDesignator) {
        if (mappingDesignator != null) {
            mappingDesignator.getAnnotations().remove((Object)ZosConnectMappingAnnotations.XSD_BUILT_IN_OR_DERIVED_SIMPLE_TYPE.value());
        }
    }

    public static void setJSONSchemaPrimitiveTypeFormat(MappingDesignator mappingDesignator, String value) {
        if (mappingDesignator != null) {
            mappingDesignator.getAnnotations().put((Object)ZosConnectMappingAnnotations.JSON_SCHEMA_PRIMITIVE_TYPE_FORMAT.value(), (Object)value);
        }
    }

    public static void unsetJSONSchemaPrimitiveTypeFormat(MappingDesignator mappingDesignator) {
        if (mappingDesignator != null) {
            mappingDesignator.getAnnotations().remove((Object)ZosConnectMappingAnnotations.JSON_SCHEMA_PRIMITIVE_TYPE_FORMAT.value());
        }
    }

    public static ArrayFormat getArrayFormat(MappingDesignator mappingDesignator) {
        String arrayFormatStr;
        ArrayFormat retVal = null;
        if (mappingDesignator != null && StringUtils.isNotBlank((CharSequence)(arrayFormatStr = (String)mappingDesignator.getAnnotations().get((Object)ZosConnectMappingAnnotations.ARRAY_FORMAT.value())))) {
            retVal = ArrayFormat.fromValue((String)arrayFormatStr);
        }
        return retVal;
    }

    public static void setArrayFormat(MappingDesignator mappingDesignator, ArrayFormat arrayFormat) {
        if (mappingDesignator != null) {
            if (arrayFormat != null) {
                mappingDesignator.getAnnotations().put((Object)ZosConnectMappingAnnotations.ARRAY_FORMAT.value(), (Object)arrayFormat.value());
            } else {
                ZCeeMappingAnnotator.unsetArrayFormat(mappingDesignator);
            }
        }
    }

    public static void unsetArrayFormat(MappingDesignator mappingDesignator) {
        if (mappingDesignator != null) {
            mappingDesignator.getAnnotations().remove((Object)ZosConnectMappingAnnotations.ARRAY_FORMAT.value());
        }
    }

    public static String getShape(MappingDesignator mappingDesignator) {
        String retVal = null;
        if (mappingDesignator != null) {
            retVal = (String)mappingDesignator.getAnnotations().get((Object)ZosConnectMappingAnnotations.SHAPE.value());
        }
        return retVal;
    }

    public static void setShape(MappingDesignator mappingDesignator, String shape) {
        if (mappingDesignator != null) {
            if (StringUtils.isNotBlank((CharSequence)shape)) {
                mappingDesignator.getAnnotations().put((Object)ZosConnectMappingAnnotations.SHAPE.value(), (Object)shape);
            } else {
                ZCeeMappingAnnotator.unsetShape(mappingDesignator);
            }
        }
    }

    public static void unsetShape(MappingDesignator mappingDesignator) {
        if (mappingDesignator != null) {
            mappingDesignator.getAnnotations().remove((Object)ZosConnectMappingAnnotations.SHAPE.value());
        }
    }

    public static boolean isSetOmitFromIterface(MappingDesignator mappingDesignator) {
        String value;
        boolean retVal = false;
        if (mappingDesignator != null && (value = (String)mappingDesignator.getAnnotations().get((Object)ZosConnectMappingAnnotations.OMIT_FROM_INTERFACE.value())) != null) {
            retVal = true;
        }
        return retVal;
    }

    public static void setOmitFromIterface(MappingDesignator mappingDesignator, boolean value) {
        if (mappingDesignator != null) {
            mappingDesignator.getAnnotations().put((Object)ZosConnectMappingAnnotations.OMIT_FROM_INTERFACE.value(), (Object)String.valueOf(value));
        }
    }

    public static boolean getOmitFromInterface(MappingDesignator mappingDesignator) {
        boolean retVal = false;
        if (mappingDesignator != null) {
            retVal = BooleanUtils.toBoolean((String)((String)mappingDesignator.getAnnotations().get((Object)ZosConnectMappingAnnotations.OMIT_FROM_INTERFACE.value())));
        }
        return retVal;
    }

    public static void setRequired(MappingDesignator mappingDesignator, boolean value) {
        if (mappingDesignator != null) {
            mappingDesignator.getAnnotations().put((Object)ZosConnectMappingAnnotations.REQUIRED.value(), (Object)String.valueOf(value));
        }
    }

    public static boolean getRequired(MappingDesignator mappingDesignator) {
        boolean retVal = false;
        if (mappingDesignator != null) {
            retVal = BooleanUtils.toBoolean((String)((String)mappingDesignator.getAnnotations().get((Object)ZosConnectMappingAnnotations.REQUIRED.value())));
        }
        return retVal;
    }

    public static void unsetRequired(MappingDesignator mappingDesignator) {
        if (mappingDesignator != null) {
            mappingDesignator.getAnnotations().remove((Object)ZosConnectMappingAnnotations.REQUIRED.value());
        }
    }
}

