/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.mapping.util;

import com.ibm.msl.mapping.InlinedXMLSchema;
import com.ibm.msl.mapping.Mapping;
import com.ibm.msl.mapping.MappingDeclaration;
import com.ibm.msl.mapping.MappingDesignator;
import com.ibm.msl.mapping.MappingGroup;
import com.ibm.msl.mapping.MappingRoot;
import com.ibm.msl.mapping.api.utils.InputStreamUtils;
import com.ibm.msl.mapping.node.DataContentNode;
import com.ibm.msl.mapping.node.RootNode;
import com.ibm.msl.mapping.util.MappingResourceImpl;
import com.ibm.msl.mapping.util.ModelUtils;
import com.ibm.msl.mapping.xml.util.XSDUtils;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.FileUtilz;
import com.ibm.zosconnect.ui.common.util.URIUtilz;
import com.ibm.zosconnect.ui.common.util.xsd.ZosConnectXsdUtil;
import com.ibm.zosconnect.ui.mapping.util.ZCeeDesignatorGroup;
import com.ibm.zosconnect.ui.mapping.util.ZCeeMappingRootAnnotator;
import com.ibm.zosconnect.ui.mapping.util.ZCeeMappingUtil;
import com.ibm.zosconnect.ui.mapping.util.jsd2xsd.IJsd2XsdConverterVisitor;
import com.ibm.zosconnect.ui.mapping.util.jsd2xsd.Jsd2XsdConverter;
import com.ibm.zosconnect.ui.mapping.util.jsd2xsd.Jsd2XsdConverterFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.util.XSDResourceFactoryImpl;
import org.eclipse.xsd.util.XSDResourceImpl;

public class ZCeeInlineXmlSchemaUtil {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String TAG = ZCeeInlineXmlSchemaUtil.class.getName();

    public static InlinedXMLSchema getHttpInputInlineXmlSchema(MappingRoot mappingRoot) {
        for (InlinedXMLSchema inlineSchema : mappingRoot.getInlinedXMLSchemas()) {
            if (!ZosConnectXsdUtil.isHttpInputTns((String)inlineSchema.getTargetNamespace())) continue;
            return inlineSchema;
        }
        return null;
    }

    public static InlinedXMLSchema getHttpOutputInlineXmlSchema(MappingRoot mappingRoot) {
        for (InlinedXMLSchema inlineSchema : mappingRoot.getInlinedXMLSchemas()) {
            if (!ZosConnectXsdUtil.isHttpOutputTns((String)inlineSchema.getTargetNamespace())) continue;
            return inlineSchema;
        }
        return null;
    }

    public static InlinedXMLSchema getJsonInputInlineXmlSchema(MappingRoot mappingRoot) {
        for (InlinedXMLSchema inlineSchema : mappingRoot.getInlinedXMLSchemas()) {
            if (!ZosConnectXsdUtil.isJsonInputTns((String)inlineSchema.getTargetNamespace())) continue;
            return inlineSchema;
        }
        return null;
    }

    public static void updateJsonInputInlineXmlSchema(IFile mappingFile, File jsonSchemaFile, String serviceName) throws Exception {
        ZCeeUILogger.entering((String)TAG, (String)"updateJsonInputInlineXmlSchema(mappingFile={0},jsonSchemaFile={1},serviceName={2})", (Object[])new Object[]{mappingFile, jsonSchemaFile, serviceName});
        MappingResourceImpl mappingResource = ZCeeMappingUtil.loadMappingFile(mappingFile);
        MappingRoot mappingRoot = ZCeeMappingUtil.findMappingRoot(mappingResource);
        if (mappingRoot == null) {
            ZCeeUILogger.error((String)TAG, (Object[])new Object[]{"mappingRoot == null"});
            return;
        }
        InlinedXMLSchema jsonInputInlineXmlSchema = ZCeeInlineXmlSchemaUtil.getJsonInputInlineXmlSchema(mappingRoot);
        InlinedXMLSchema httpOutputInlinedXMLSchema = ZCeeInlineXmlSchemaUtil.getHttpOutputInlineXmlSchema(mappingRoot);
        if (jsonInputInlineXmlSchema == null) {
            ZCeeUILogger.error((String)TAG, (Object[])new Object[]{"jsonInputInlineXmlSchema == null"});
            return;
        }
        if (httpOutputInlinedXMLSchema == null) {
            ZCeeUILogger.error((String)TAG, (Object[])new Object[]{"httpOutputInlinedXMLSchema == null"});
            return;
        }
        XSDSchema oldJsonInputXmlSchema = jsonInputInlineXmlSchema.getInlinedSchema();
        Pair<Jsd2XsdConverter, XSDSchema> jsd2XsdResult = ZCeeInlineXmlSchemaUtil.getInlineXmlSchemaFromJsonSchema(mappingRoot, jsonSchemaFile, jsonInputInlineXmlSchema.getTargetNamespace(), serviceName);
        Jsd2XsdConverter jsd2Xsd = (Jsd2XsdConverter)jsd2XsdResult.getKey();
        XSDSchema newJsonInputXmlSchema = (XSDSchema)jsd2XsdResult.getValue();
        mappingRoot.eResource().getResourceSet().getResources().remove((Object)oldJsonInputXmlSchema.eResource());
        jsonInputInlineXmlSchema.setInlinedSchema(newJsonInputXmlSchema);
        mappingRoot.eResource().getResourceSet().getResources().add((Object)newJsonInputXmlSchema.eResource());
        if (jsd2Xsd.isGlobalElementGenerated()) {
            ZCeeMappingRootAnnotator.setJsonWrapped(mappingRoot, true);
            ZCeeMappingRootAnnotator.setJsonWrapperName(mappingRoot, jsd2Xsd.getGlobalElementName());
        } else {
            ZCeeMappingRootAnnotator.setJsonWrapped(mappingRoot, false);
            ZCeeMappingRootAnnotator.unsetJsonWrapperName(mappingRoot);
        }
        XSDElementDeclaration newJsonInputRootElement = (XSDElementDeclaration)XSDUtils.getGlobalElements((EObject)newJsonInputXmlSchema).get(0);
        XSDSchema httpOutputXmlSchema = httpOutputInlinedXMLSchema.getInlinedSchema();
        XSDComplexTypeDefinition httpBodyCType = (XSDComplexTypeDefinition)XSDUtils.getTypeDef((XSDSchema)httpOutputXmlSchema, (String)"BodyType");
        XSDModelGroup httpBodyGroup = XSDUtils.getModelGroup((XSDComplexTypeDefinition)httpBodyCType);
        XSDElementDeclaration httpBodyEleRef = (XSDElementDeclaration)XSDUtils.getElements((XSDModelGroup)httpBodyGroup).get(0);
        httpBodyEleRef.setResolvedElementDeclaration(newJsonInputRootElement);
        MappingDesignator jsonInputDesignator = (MappingDesignator)mappingRoot.getInputs().get(0);
        RootNode newJsonInputRootNode = ModelUtils.getNodeFactory((MappingDesignator)jsonInputDesignator).createRootNode((EObject)newJsonInputXmlSchema);
        jsonInputDesignator.setObject((EObject)newJsonInputRootNode);
        DataContentNode newJsonInputRootContentNode = (DataContentNode)newJsonInputRootNode.getChildren().get(0);
        MappingDeclaration mappingDeclaration = ModelUtils.getMappingDeclaration((EObject)jsonInputDesignator);
        MappingDesignator mappingDeclInputDesignator = (MappingDesignator)mappingDeclaration.getInputs().get(0);
        mappingDeclInputDesignator.setObject((EObject)newJsonInputRootContentNode);
        Mapping passthruMapping = ZCeeMappingUtil.getPassthroughMapping(jsonInputDesignator);
        MappingDesignator passthruOutputDesignator = (MappingDesignator)passthruMapping.getOutputs().get(0);
        passthruOutputDesignator.setObject((EObject)newJsonInputRootContentNode);
        MappingDesignator passthruInputDesignator = (MappingDesignator)passthruMapping.getInputs().get(0);
        passthruInputDesignator.setObject((EObject)newJsonInputRootContentNode);
        MappingGroup updatesGroup = ZCeeMappingUtil.getPassthroughUpdatesGroup(jsonInputDesignator);
        for (Mapping mapping : ZCeeMappingUtil.getMappingsInPassthroughUpdatesGroup(updatesGroup)) {
            MappingDesignator designator = ZCeeMappingUtil.getFirstOutputDesignator(mapping);
            MappingDesignator parentDesignator = ZCeeMappingUtil.getFirstParentDesignator(designator, ZCeeDesignatorGroup.OUTPUT_BODY);
            parentDesignator.setObject((EObject)newJsonInputRootContentNode);
        }
        ZCeeMappingUtil.saveMappingFile(mappingResource, mappingFile);
        mappingResource = ZCeeMappingUtil.loadMappingFile(mappingFile);
        mappingRoot = ZCeeMappingUtil.findMappingRoot(mappingResource);
        ZCeeMappingUtil.updateMappingAnnotations(mappingRoot);
        ZCeeMappingUtil.saveMappingFile(mappingResource, mappingFile);
        ZCeeUILogger.exiting((String)TAG, (String)"updateJsonInputInlineXmlSchema(IFile,File,String)", (Object[])new Object[0]);
    }

    public static InlinedXMLSchema getJsonOutputInlineXmlSchema(MappingRoot mappingRoot) {
        for (InlinedXMLSchema inlineSchema : mappingRoot.getInlinedXMLSchemas()) {
            if (!ZosConnectXsdUtil.isJsonOutputTns((String)inlineSchema.getTargetNamespace())) continue;
            return inlineSchema;
        }
        return null;
    }

    public static void updateJsonOutputInlineXmlSchema(IFile mappingFile, File jsonSchemaFile, String serviceName) throws Exception {
        ZCeeUILogger.entering((String)TAG, (String)"updateJsonOutputInlineXmlSchema(mappingFile={0},jsonSchemaFile={1},serviceName={2})", (Object[])new Object[]{mappingFile, jsonSchemaFile, serviceName});
        MappingResourceImpl mappingResource = ZCeeMappingUtil.loadMappingFile(mappingFile);
        MappingRoot mappingRoot = ZCeeMappingUtil.findMappingRoot(mappingResource);
        if (mappingRoot == null) {
            ZCeeUILogger.error((String)TAG, (Object[])new Object[]{"mappingRoot == null"});
            return;
        }
        InlinedXMLSchema jsonOutputInlineXmlSchema = ZCeeInlineXmlSchemaUtil.getJsonOutputInlineXmlSchema(mappingRoot);
        InlinedXMLSchema httpInputInlineXmlSchema = ZCeeInlineXmlSchemaUtil.getHttpInputInlineXmlSchema(mappingRoot);
        if (jsonOutputInlineXmlSchema == null) {
            ZCeeUILogger.error((String)TAG, (Object[])new Object[]{"jsonOutputInlineXmlSchema == null"});
            return;
        }
        if (httpInputInlineXmlSchema == null) {
            ZCeeUILogger.error((String)TAG, (Object[])new Object[]{"httpInputInlineXmlSchema == null"});
            return;
        }
        XSDSchema oldJsonOutputXmlSchema = jsonOutputInlineXmlSchema.getInlinedSchema();
        Pair<Jsd2XsdConverter, XSDSchema> jsd2XsdResult = ZCeeInlineXmlSchemaUtil.getInlineXmlSchemaFromJsonSchema(mappingRoot, jsonSchemaFile, jsonOutputInlineXmlSchema.getTargetNamespace(), serviceName);
        Jsd2XsdConverter jsd2Xsd = (Jsd2XsdConverter)jsd2XsdResult.getKey();
        XSDSchema newJsonOutputXmlSchema = (XSDSchema)jsd2XsdResult.getValue();
        mappingRoot.eResource().getResourceSet().getResources().remove((Object)oldJsonOutputXmlSchema.eResource());
        jsonOutputInlineXmlSchema.setInlinedSchema(newJsonOutputXmlSchema);
        mappingRoot.eResource().getResourceSet().getResources().add((Object)newJsonOutputXmlSchema.eResource());
        if (jsd2Xsd.isGlobalElementGenerated()) {
            ZCeeMappingRootAnnotator.setJsonWrapped(mappingRoot, true);
            ZCeeMappingRootAnnotator.setJsonWrapperName(mappingRoot, jsd2Xsd.getGlobalElementName());
        } else {
            ZCeeMappingRootAnnotator.setJsonWrapped(mappingRoot, false);
            ZCeeMappingRootAnnotator.unsetJsonWrapperName(mappingRoot);
        }
        XSDElementDeclaration rootElement = (XSDElementDeclaration)XSDUtils.getGlobalElements((EObject)newJsonOutputXmlSchema).get(0);
        XSDSchema httpInputXmlSchema = httpInputInlineXmlSchema.getInlinedSchema();
        XSDComplexTypeDefinition httpBodyCType = (XSDComplexTypeDefinition)XSDUtils.getTypeDef((XSDSchema)httpInputXmlSchema, (String)"BodyType");
        XSDModelGroup httpBodyGroup = XSDUtils.getModelGroup((XSDComplexTypeDefinition)httpBodyCType);
        XSDElementDeclaration httpBodyEleRef = (XSDElementDeclaration)XSDUtils.getElements((XSDModelGroup)httpBodyGroup).get(0);
        httpBodyEleRef.setResolvedElementDeclaration(rootElement);
        MappingDesignator jsonOutputDesignator = (MappingDesignator)mappingRoot.getOutputs().get(0);
        RootNode newJsonOutputRootNode = ModelUtils.getNodeFactory((MappingDesignator)jsonOutputDesignator).createRootNode((EObject)newJsonOutputXmlSchema);
        jsonOutputDesignator.setObject((EObject)newJsonOutputRootNode);
        DataContentNode newJsonOutputRootContentNode = (DataContentNode)newJsonOutputRootNode.getChildren().get(0);
        MappingDeclaration mappingDeclaration = ModelUtils.getMappingDeclaration((EObject)jsonOutputDesignator);
        MappingDesignator mappingDeclOutputDesignator = (MappingDesignator)mappingDeclaration.getOutputs().get(0);
        mappingDeclOutputDesignator.setObject((EObject)newJsonOutputRootContentNode);
        Mapping passthruMapping = ZCeeMappingUtil.getPassthroughMapping(jsonOutputDesignator);
        MappingDesignator passthruInputDesignator = (MappingDesignator)passthruMapping.getInputs().get(0);
        passthruInputDesignator.setObject((EObject)newJsonOutputRootContentNode);
        MappingDesignator passthruOutputDesignator = (MappingDesignator)passthruMapping.getOutputs().get(0);
        passthruOutputDesignator.setObject((EObject)newJsonOutputRootContentNode);
        ZCeeMappingUtil.saveMappingFile(mappingResource, mappingFile);
        mappingResource = ZCeeMappingUtil.loadMappingFile(mappingFile);
        mappingRoot = ZCeeMappingUtil.findMappingRoot(mappingResource);
        ZCeeMappingUtil.updateMappingAnnotations(mappingRoot);
        ZCeeMappingUtil.saveMappingFile(mappingResource, mappingFile);
        ZCeeUILogger.exiting((String)TAG, (String)"updateJsonOutputInlineXmlSchema(IFile,File,String)", (Object[])new Object[0]);
    }

    private static Pair<Jsd2XsdConverter, XSDSchema> getInlineXmlSchemaFromJsonSchema(MappingRoot mappingRoot, File jsonSchemaFile, String targetNamespace, final String serviceName) throws Exception {
        ZCeeUILogger.entering((String)TAG, (String)"getInlineXmlSchemaFromJsonSchema(mappingRoot={0},jsonSchemaFile={1},targetNamespace={2},serviceName={3})", (Object[])new Object[]{mappingRoot, jsonSchemaFile, targetNamespace, serviceName});
        XSDSchema xmlJsonSchema = null;
        Jsd2XsdConverterFactory factory = new Jsd2XsdConverterFactory();
        factory.setQNamePrefix("xsd");
        factory.setTargetNamespace(targetNamespace);
        factory.setTargetNamespacePrefix("tns");
        factory.setJsonFromFilePath(jsonSchemaFile.getAbsolutePath());
        File xmlSchemaTempFile = FileUtilz.getTempFile((String)"xsd");
        factory.setOutputFile(xmlSchemaTempFile);
        factory.setVisitor(new IJsd2XsdConverterVisitor(){

            @Override
            public String getWrapperObjectName() {
                return URIUtilz.encodeResourceName((String)serviceName);
            }
        });
        Jsd2XsdConverter js2xsd = factory.create();
        js2xsd.run();
        FileInputStream xmlSchemaTempFileIS = new FileInputStream(xmlSchemaTempFile);
        xmlJsonSchema = InputStreamUtils.loadXSDFromInputStream((ResourceSet)mappingRoot.eResource().getResourceSet(), (String)mappingRoot.eResource().getURI().toString(), (int)0, (InputStream)xmlSchemaTempFileIS);
        IOUtils.closeQuietly((InputStream)xmlSchemaTempFileIS);
        FileUtils.deleteQuietly((File)xmlSchemaTempFile);
        ZCeeUILogger.exiting((String)TAG, (String)"getInlineXmlSchemaFromJsonSchema(MappingRoot,File,String,String)", (Object[])new Object[0]);
        return Pair.of((Object)js2xsd, (Object)xmlJsonSchema);
    }

    public static XSDSchema getXmlSchemaFromJsonSchema(String jsonSchemaFilePath, final String serviceName) throws Exception {
        ZCeeUILogger.entering((String)TAG, (String)"getXmlSchemaFromJsonSchema(jsonSchemaFile={1},serviceName={3})", (Object[])new Object[]{jsonSchemaFilePath, serviceName});
        XSDSchema xmlJsonSchema = null;
        Jsd2XsdConverterFactory factory = new Jsd2XsdConverterFactory();
        factory.setQNamePrefix("xsd");
        factory.setTargetNamespace("http://www.ibm.com/zosConnect/2.0/mapping/JSON");
        factory.setTargetNamespacePrefix("tns");
        factory.setJsonFromFilePath(jsonSchemaFilePath);
        File xmlSchemaTempFile = FileUtilz.getTempFile((String)"xsd");
        factory.setOutputFile(xmlSchemaTempFile);
        factory.setVisitor(new IJsd2XsdConverterVisitor(){

            @Override
            public String getWrapperObjectName() {
                return serviceName;
            }
        });
        Jsd2XsdConverter js2xsd = factory.create();
        js2xsd.run();
        XSDResourceFactoryImpl rf = new XSDResourceFactoryImpl();
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("xsd", rf);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getLoadOptions().put(XSDResourceImpl.XSD_TRACK_LOCATION, Boolean.TRUE);
        FileInputStream xmlSchemaTempFileIS = new FileInputStream(xmlSchemaTempFile);
        xmlJsonSchema = InputStreamUtils.loadXSDFromInputStream((ResourceSet)resourceSet, (InputStream)xmlSchemaTempFileIS, (String)xmlSchemaTempFile.toURI().toString());
        FileUtils.deleteQuietly((File)xmlSchemaTempFile);
        ZCeeUILogger.exiting((String)TAG, (String)"getXmlSchemaFromJsonSchema(String,String)", (Object[])new Object[0]);
        return xmlJsonSchema;
    }
}

