/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.spi.common;

import com.ibm.propertygroup.ICustomProperty;
import com.ibm.propertygroup.internal.LogFacility;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import com.ibm.propertygroup.spi.BaseSingleValuedProperty;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class JavaProjectProperty
extends BaseSingleValuedProperty
implements ICustomProperty {
    public static final String BIDI_DELIMITERS = ".:/\\";
    protected int customPropertyFlag = 1024;

    public JavaProjectProperty(String propertyName, String displayName, String propertyDescription, BasePropertyGroup parentGroup) throws CoreException {
        super(propertyName, displayName, propertyDescription, IJavaProject.class, parentGroup);
        this.propertyFlag |= 0x104;
        this.setValidValues(this.getAllJavaProjects());
        this.propertyType.setBidiDelimiters(BIDI_DELIMITERS);
    }

    @Override
    public int getCustomPropertyFlag() {
        return this.customPropertyFlag;
    }

    public String[] getValidValuesAsStrings() {
        return this.validStringValues;
    }

    @Override
    public String getValueAsString() {
        if (this.value != null) {
            return ((IJavaProject)this.value).getProject().getName();
        }
        return null;
    }

    @Override
    public void setValidValues(Object[] values) throws CoreException {
        super.setValidValues(values);
        this.validStringValues = new String[values.length];
        int i = values.length;
        while (--i >= 0) {
            this.validStringValues[i] = ((IJavaProject)values[i]).getProject().getName();
        }
    }

    @Override
    public void setValueAsString(String _value) throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(_value);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        this.setValue(javaProject);
    }

    private IJavaProject[] getAllJavaProjects() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IJavaProject> javaProjects = new ArrayList<IJavaProject>(projects.length);
        int i = projects.length;
        while (--i >= 0) {
            try {
                if (!projects[i].exists() || !projects[i].isOpen() || !projects[i].hasNature("org.eclipse.jdt.core.javanature")) continue;
                javaProjects.add(JavaCore.create((IProject)projects[i]));
            }
            catch (CoreException e) {
                LogFacility.logErrorMessage(e.getStatus());
            }
        }
        IJavaProject[] returnedProjects = new IJavaProject[javaProjects.size()];
        javaProjects.toArray(returnedProjects);
        return returnedProjects;
    }
}

