/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.spi.common;

import com.ibm.propertygroup.ICustomProperty;
import com.ibm.propertygroup.internal.LogFacility;
import com.ibm.propertygroup.internal.messages.MessageResource;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import com.ibm.propertygroup.spi.BaseSingleValuedProperty;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;

public class JavaPackageProperty
extends BaseSingleValuedProperty
implements ICustomProperty {
    public static final String BIDI_DELIMITERS = ".";
    private IJavaProject javaProject;
    protected int customPropertyFlag = 512;

    public JavaPackageProperty(String propertyName, String displayName, String propertyDescription, BasePropertyGroup parentGroup) throws CoreException {
        super(propertyName, displayName, propertyDescription, IPackageFragment.class, parentGroup);
        this.propertyFlag |= 0x104;
        this.propertyType.setBidiDelimiters(BIDI_DELIMITERS);
    }

    @Override
    public int getCustomPropertyFlag() {
        return this.customPropertyFlag;
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    @Override
    public String getValueAsString() {
        if (this.value != null) {
            return ((IPackageFragment)this.value).getElementName();
        }
        return null;
    }

    public void setJavaProject(IJavaProject javaProject) throws CoreException {
        this.javaProject = javaProject;
        if (javaProject != null && javaProject.exists()) {
            try {
                Object[] packages = javaProject.getPackageFragments();
                this.setValidValues(packages);
                this.validStringValues = new String[packages.length];
                int i = packages.length;
                while (--i >= 0) {
                    this.validStringValues[i] = packages[i].getElementName();
                }
            }
            catch (JavaModelException e) {
                Status status = new Status(4, "com.ibm.propertygroup", 4, e.getLocalizedMessage() != null ? e.getLocalizedMessage() : "", (Throwable)e);
                LogFacility.logErrorMessage((IStatus)status);
                throw new CoreException((IStatus)status);
            }
            IPackageFragment packageFragment = (IPackageFragment)this.getValue();
            if (packageFragment != null && !packageFragment.getJavaProject().equals(javaProject)) {
                this.setValueAsString(packageFragment.getElementName());
            }
        }
    }

    @Override
    public void setValueAsString(String newValue) throws CoreException {
        if (this.javaProject == null) {
            Status status = new Status(4, "com.ibm.propertygroup", 4, MessageResource.ERR_NO_JAVA_PRJ, null);
            LogFacility.logErrorMessage((IStatus)status);
            throw new CoreException((IStatus)status);
        }
        IStatus status = JavaConventions.validatePackageName((String)newValue);
        IPackageFragmentRoot fragmentRoot = JavaPackageProperty.getSourcePackage(this.javaProject);
        if ((status.isOK() || status.getSeverity() == 2) && fragmentRoot != null) {
            IPackageFragment packageFragment = fragmentRoot.getPackageFragment(newValue);
            this.setValue(packageFragment);
            if (status.getSeverity() == 2) {
                throw new CoreException(status);
            }
        } else {
            throw new CoreException(status);
        }
    }

    public static IPackageFragmentRoot getSourcePackage(IJavaProject javaProject) {
        if (javaProject != null) {
            try {
                IPackageFragmentRoot[] fragmentRoots = javaProject.getPackageFragmentRoots();
                int i = 0;
                while (i < fragmentRoots.length) {
                    if (fragmentRoots[i].getKind() == 1) {
                        return fragmentRoots[i];
                    }
                    ++i;
                }
                return javaProject.getPackageFragmentRoot(javaProject.getCorrespondingResource());
            }
            catch (JavaModelException e) {
                LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            }
        }
        return null;
    }
}

