/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.spi;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UTF16;
import com.ibm.propertygroup.ISingleValuedProperty;
import com.ibm.propertygroup.PropertyChangeEvent;
import com.ibm.propertygroup.internal.LogFacility;
import com.ibm.propertygroup.internal.messages.MessageResource;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import com.ibm.propertygroup.spi.BaseSingleTypedProperty;
import com.ibm.propertygroup.spi.PropertyVetoException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class BaseSingleValuedProperty
extends BaseSingleTypedProperty
implements ISingleValuedProperty {
    protected String[] validStringValues;
    protected Object value = null;

    public BaseSingleValuedProperty(String propertyName, String displayName, String propertyDescription, Class propertyType, BasePropertyGroup parentGroup) throws CoreException {
        super(propertyName, displayName, propertyDescription, propertyType, parentGroup);
        this.propertyFlag |= 0x1101;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public String getValueAsString() {
        if (this.value != null) {
            return this.value.toString();
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    @Override
    public void setValue(Object newValue) throws CoreException {
        if (!this.isEnabled()) {
            Status status = new Status(4, "com.ibm.propertygroup", 4, MessageResource.ERR_PROPERTY_IS_DISABLED, null);
            LogFacility.logErrorMessage((IStatus)status);
            throw new CoreException((IStatus)status);
        }
        if (newValue != this.value && (newValue != null && !newValue.equals(this.value) || this.value != null && !this.value.equals(newValue))) {
            if (this.propertyType.isPrimitive() && newValue == null) {
                Status status = new Status(4, "com.ibm.propertygroup", 4, MessageResource.bind((String)MessageResource.ERR_PRIMITIVE_TYPE_CANNOT_BE_NULL, (Object)this.getDisplayName()), null);
                LogFacility.logErrorMessage((IStatus)status);
                throw new CoreException((IStatus)status);
            }
            if (newValue == null || this.propertyType.getType().isAssignableFrom(newValue.getClass())) {
                Object oldValue;
                block8: {
                    oldValue = this.getValue();
                    try {
                        this.vetoableChanges.fireVetoableChange(oldValue, newValue);
                    }
                    catch (PropertyVetoException ex) {
                        if (ex.getErrorCode() == 0) {
                            Status status = new Status(4, "com.ibm.propertygroup", 4, ex.getLocalizedMessage() != null ? ex.getLocalizedMessage() : "", (Throwable)ex);
                            throw new CoreException((IStatus)status);
                        }
                        if (ex.getErrorCode() != 1) break block8;
                        Status status = new Status(2, "com.ibm.propertygroup", 2, ex.getLocalizedMessage() != null ? ex.getLocalizedMessage() : "", (Throwable)ex);
                        this.value = newValue;
                        this.setSet(true);
                        this.propertyChanges.firePropertyValueChange(oldValue, newValue);
                        throw new CoreException((IStatus)status);
                    }
                }
                this.value = newValue;
                this.setSet(true);
                this.setValidNoNotify(true);
                this.propertyChanges.firePropertyValueChange(oldValue, newValue);
            } else {
                Status status = new Status(4, "com.ibm.propertygroup", 4, MessageResource.ERR_INVALID_OBJECT_TYPE, null);
                LogFacility.logErrorMessage((IStatus)status);
                throw new CoreException((IStatus)status);
            }
        }
    }

    @Override
    public void setValueAsString(String newValue) throws CoreException {
        if (!this.isEnabled()) {
            Status status = new Status(4, "com.ibm.propertygroup", 4, MessageResource.ERR_PROPERTY_IS_DISABLED, null);
            LogFacility.logErrorMessage((IStatus)status);
            throw new CoreException((IStatus)status);
        }
        if (this.propertyType.isPrimitive() && newValue == null) {
            Status status = new Status(4, "com.ibm.propertygroup", 4, MessageResource.bind((String)MessageResource.ERR_PRIMITIVE_TYPE_CANNOT_BE_NULL, (Object)this.getDisplayName()), null);
            LogFacility.logErrorMessage((IStatus)status);
            throw new CoreException((IStatus)status);
        }
        switch (this.propertyType.getPropertyTypeIdentifier()) {
            case 1: {
                this.setValue(new Boolean(newValue));
                break;
            }
            case 2: {
                try {
                    this.setValue(new Byte(newValue));
                    break;
                }
                catch (NumberFormatException e1) {
                    Status status = new Status(4, "com.ibm.propertygroup", 4, NLS.bind((String)MessageResource.ERR_INVALID_BYTE_STRING, (Object)newValue), (Throwable)e1);
                    throw new CoreException((IStatus)status);
                }
            }
            case 3: {
                if (newValue != null && newValue.length() == 1) {
                    int char32 = UTF16.charAt((String)newValue, (int)0);
                    this.setValue(new Character(UCharacter.toChars((int)char32)[0]));
                    break;
                }
                Status status = new Status(4, "com.ibm.propertygroup", 4, NLS.bind((String)MessageResource.ERR_INVALID_CHAR_STRING, (Object)newValue), null);
                throw new CoreException((IStatus)status);
            }
            case 4: {
                try {
                    this.setValue(new Double(newValue));
                    break;
                }
                catch (NumberFormatException e2) {
                    Status status = new Status(4, "com.ibm.propertygroup", 4, NLS.bind((String)MessageResource.ERR_INVALID_DOUBLE_STRING, (Object)newValue), (Throwable)e2);
                    throw new CoreException((IStatus)status);
                }
            }
            case 5: {
                try {
                    this.setValue(new Float(newValue));
                    break;
                }
                catch (NumberFormatException e3) {
                    Status status = new Status(4, "com.ibm.propertygroup", 4, NLS.bind((String)MessageResource.ERR_INVALID_FLOAT_STRING, (Object)newValue), (Throwable)e3);
                    throw new CoreException((IStatus)status);
                }
            }
            case 6: {
                try {
                    this.setValue(new Integer(newValue));
                    break;
                }
                catch (NumberFormatException e4) {
                    Status status = new Status(4, "com.ibm.propertygroup", 4, NLS.bind((String)MessageResource.ERR_INVALID_INT_STRING, (Object)newValue), (Throwable)e4);
                    throw new CoreException((IStatus)status);
                }
            }
            case 7: {
                try {
                    this.setValue(new Long(newValue));
                    break;
                }
                catch (NumberFormatException e5) {
                    Status status = new Status(4, "com.ibm.propertygroup", 4, NLS.bind((String)MessageResource.ERR_INVALID_LONG_STRING, (Object)newValue), (Throwable)e5);
                    throw new CoreException((IStatus)status);
                }
            }
            case 0: {
                this.setValue(newValue);
                break;
            }
            default: {
                Status status = new Status(4, "com.ibm.propertygroup", 4, MessageResource.ERR_SET_AS_STRING_NOT_SUPPORTED, null);
                LogFacility.logErrorMessage((IStatus)status);
                throw new CoreException((IStatus)status);
            }
        }
    }

    @Override
    public void unSet() {
        try {
            this.setValue(this.getPropertyType().getDefaultValue());
        }
        catch (CoreException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
        }
        this.setSet(false);
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
    }
}

