/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.spi;

import com.ibm.propertygroup.IMultiValuedProperty;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.ISingleTypedProperty;
import com.ibm.propertygroup.ISingleValuedProperty;
import com.ibm.propertygroup.PropertyChangeEvent;
import com.ibm.propertygroup.PropertyHelper;
import com.ibm.propertygroup.internal.LogFacility;
import com.ibm.propertygroup.spi.BasePropertyDescriptor;
import com.ibm.propertygroup.spi.BaseSingleValuedProperty;
import com.ibm.propertygroup.spi.PropertyVetoException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class BasePropertyGroup
extends BasePropertyDescriptor
implements IPropertyGroup {
    public static final String PG_OPENING_TAG = "<";
    public static final String PG_CLOSING_TAG = ">";
    public static final String PD_ENDING_TAG = "/";
    public static final String PROPERTY_NAME_VALUE_SEPARATOR = "\u21c2";
    public static final String PD_CHILDREN_SEPARATOR = "\u21c3";
    public static final String MVP_PROPERTY_VALUES_SEPARATOR = "\u21d5";
    public static final String PG_VERSION_ATTRIBUTE = " V_";
    private ArrayList<IPropertyDescriptor> properties = new ArrayList();
    private Map<String, IPropertyDescriptor> propertyNames = new HashMap<String, IPropertyDescriptor>();
    protected Object[] context = null;

    public BasePropertyGroup(String groupName, String displayName, String groupDescription) throws CoreException {
        super(groupName, displayName, groupDescription);
        this.propertyFlag |= 0x4000;
    }

    public void addProperty(IPropertyDescriptor property) {
        if (!this.properties.contains(property) && !this.propertyNames.keySet().contains(property.getName())) {
            this.properties.add(property);
            this.propertyNames.put(property.getName(), property);
            property.setParent(this);
            this.propertyChanges.firePropertyGroupAddChild(property);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        BasePropertyGroup clone = (BasePropertyGroup)super.clone();
        clone.properties = new ArrayList();
        clone.propertyNames = new HashMap<String, IPropertyDescriptor>();
        for (IPropertyDescriptor property : this.properties) {
            IPropertyDescriptor aProp = (IPropertyDescriptor)property.clone();
            aProp.setParent(clone);
            clone.addProperty(aProp);
        }
        return clone;
    }

    @Override
    public IPropertyDescriptor[] getProperties() {
        try {
            return this.properties.toArray(new IPropertyDescriptor[this.properties.size()]);
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            return new IPropertyDescriptor[0];
        }
    }

    @Override
    public IPropertyDescriptor getProperty(IPath path) {
        String firstSegment = path.segment(0);
        IPropertyDescriptor descriptor = this.propertyNames.get(firstSegment);
        if (descriptor != null) {
            if (descriptor instanceof IPropertyGroup) {
                if (path.segmentCount() > 1) {
                    return ((IPropertyGroup)descriptor).getProperty(path.removeFirstSegments(1));
                }
                return descriptor;
            }
            return descriptor;
        }
        return null;
    }

    @Override
    public IPropertyDescriptor getProperty(String propertyName) {
        IPropertyDescriptor descriptor = this.propertyNames.get(propertyName);
        return descriptor;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    public void remove(IPropertyDescriptor property) {
        if (property != null) {
            this.properties.remove(property);
            this.propertyNames.remove(property.getName());
            property.setParent(null);
            this.propertyChanges.firePropertyGroupRemoveChild(property);
        }
    }

    public void removeAll() {
        IPropertyDescriptor[] oldProperties = this.properties.toArray(new IPropertyDescriptor[0]);
        this.properties.clear();
        this.propertyNames.clear();
        int i = 0;
        while (i < oldProperties.length) {
            oldProperties[i].setParent(null);
            ++i;
        }
        this.propertyChanges.firePropertyGroupRemoveAll(oldProperties);
    }

    public void replaceAll(IPropertyDescriptor[] newProperties) {
        IPropertyDescriptor[] oldProperties = this.properties.toArray(new IPropertyDescriptor[0]);
        int i = 0;
        while (i < oldProperties.length) {
            oldProperties[i].setParent(null);
            ++i;
        }
        this.properties.clear();
        this.propertyNames.clear();
        int size = newProperties.length;
        int i2 = 0;
        while (i2 < size) {
            this.properties.add(newProperties[i2]);
            this.propertyNames.put(newProperties[i2].getName(), newProperties[i2]);
            newProperties[i2].setParent(this);
            ++i2;
        }
        this.propertyChanges.firePropertyGroupReplaceAll(oldProperties, newProperties);
    }

    @Override
    public void setEnabled(boolean enabled) {
        for (IPropertyDescriptor property : this.properties) {
            if (!(property instanceof BasePropertyDescriptor)) continue;
            ((BasePropertyDescriptor)property).setEnabled(enabled);
        }
        super.setEnabled(enabled);
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
    }

    @Override
    public Object[] getPropertyGroupContext() {
        return this.context;
    }

    @Override
    public void setPropertyGroupContext(Object[] context) {
        this.context = context;
    }

    @Override
    public String convertToString() {
        return this.getPropertyGroupAsString(this, null);
    }

    @Override
    public void populateFromString(String value) throws CoreException {
        this.populatePropertyGroupFromString(value, this);
    }

    public String getPropertyGroupAsString(IPropertyGroup grp, String version) {
        StringBuffer pgstring = new StringBuffer();
        pgstring.append(this.getPGOpeningTag(grp.getName(), version));
        IPropertyDescriptor[] children = grp.getProperties();
        int i = 0;
        while (i < children.length) {
            block13: {
                block12: {
                    if (!(children[i] instanceof ISingleTypedProperty)) break block12;
                    ISingleTypedProperty prop = (ISingleTypedProperty)children[i];
                    if (prop.getPropertyType().isSensitive() || !prop.isSet()) break block13;
                    if (prop instanceof ISingleValuedProperty) {
                        pgstring.append(prop.getName());
                        pgstring.append(PROPERTY_NAME_VALUE_SEPARATOR);
                        pgstring.append(this.getLocaleSensitivePropertyValue((ISingleValuedProperty)prop));
                        pgstring.append(PD_CHILDREN_SEPARATOR);
                    } else if (prop instanceof IMultiValuedProperty) {
                        pgstring.append(prop.getName());
                        pgstring.append(PROPERTY_NAME_VALUE_SEPARATOR);
                        pgstring.append(this.getMultiValues(prop));
                        pgstring.append(PD_CHILDREN_SEPARATOR);
                    }
                }
                if (PropertyHelper.isPropertyGroup(children[i])) {
                    String pgContents = ((IPropertyGroup)children[i]).convertToString();
                    if (pgContents != null && pgContents.length() > 0) {
                        StringBuffer defaultTag = this.getPGOpeningTag(children[i].getName(), version);
                        if (!pgContents.contains(defaultTag)) {
                            pgstring.append(defaultTag);
                        }
                        pgstring.append(pgContents);
                        StringBuffer endingTag = this.getPGClosingTag(children[i].getName());
                        if (!pgContents.contains(endingTag)) {
                            pgstring.append(endingTag);
                        }
                        pgstring.append(PD_CHILDREN_SEPARATOR);
                    } else {
                        pgstring.append(this.getPropertyGroupAsString((IPropertyGroup)children[i], version));
                    }
                }
            }
            ++i;
        }
        pgstring.append(this.getPGClosingTag(grp.getName()));
        return pgstring.toString();
    }

    public StringBuffer getMultiValues(IPropertyDescriptor propertyDescriptor) {
        String[] values = this.getLocaleSensitivePropertyMultiValue((IMultiValuedProperty)propertyDescriptor);
        StringBuffer pgstring = new StringBuffer();
        int i = 0;
        while (i < values.length) {
            pgstring.append(values[i]);
            if (i < values.length - 1) {
                pgstring.append(MVP_PROPERTY_VALUES_SEPARATOR);
            }
            ++i;
        }
        return pgstring;
    }

    public StringBuffer getPGOpeningTag(String name, String version) {
        StringBuffer pgstring = new StringBuffer();
        pgstring.append(PG_OPENING_TAG);
        pgstring.append(name);
        if (version != null) {
            pgstring.append(PG_VERSION_ATTRIBUTE + version);
        }
        pgstring.append(PG_CLOSING_TAG);
        return pgstring;
    }

    public StringBuffer getPGClosingTag(String name) {
        StringBuffer pgstring = new StringBuffer();
        pgstring.append(PG_OPENING_TAG);
        pgstring.append(PD_ENDING_TAG);
        pgstring.append(name);
        pgstring.append(PG_CLOSING_TAG);
        return pgstring;
    }

    public void populatePropertyGroupFromString(String grpString, IPropertyGroup grp) throws CoreException {
        if (grpString == null || "".equals(grpString)) {
            return;
        }
        IPropertyDescriptor[] children = grp.getProperties();
        int i = 0;
        while (i < children.length) {
            block14: {
                block15: {
                    boolean isEnabled;
                    block11: {
                        String value;
                        block16: {
                            block13: {
                                if (!(children[i] instanceof IPropertyGroup)) break block13;
                                String subGroup = this.extractGroupString(children[i].getName(), grpString);
                                if (!subGroup.equals(grpString)) {
                                    ((IPropertyGroup)children[i]).populateFromString(subGroup);
                                }
                                break block14;
                            }
                            if (!(children[i] instanceof ISingleValuedProperty)) break block15;
                            isEnabled = children[i].isEnabled();
                            if (isEnabled) break block16;
                            if (!(children[i] instanceof BaseSingleValuedProperty)) break block14;
                            ((BaseSingleValuedProperty)children[i]).setEnabled(true);
                        }
                        if ((value = this.extractSingleValuePropertyValue(children[i].getName(), this.extractGroupString(grp.getName(), grpString))) != null) {
                            try {
                                ((ISingleValuedProperty)children[i]).setValueAsString(value);
                            }
                            catch (CoreException exc) {
                                if (exc.getStatus().getCode() != 4) break block11;
                                throw exc;
                            }
                        }
                    }
                    if (isEnabled) break block14;
                    ((BaseSingleValuedProperty)children[i]).setEnabled(false);
                    break block14;
                }
                if (children[i] instanceof IMultiValuedProperty && children[i].isEnabled()) {
                    String[] values = this.extractMultiValuePropertyValue(children[i].getName(), this.extractGroupString(grp.getName(), grpString));
                    ((IMultiValuedProperty)children[i]).unSet();
                    int j = 0;
                    while (j < values.length) {
                        block12: {
                            if (values[j] != null && !values[j].equalsIgnoreCase("null")) {
                                try {
                                    ((IMultiValuedProperty)children[i]).addValue(values[j]);
                                }
                                catch (CoreException exc) {
                                    if (exc.getStatus().getCode() != 4) break block12;
                                    throw exc;
                                }
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    public String[] extractMultiValuePropertyValue(String propName, String grpString) {
        String extractedPropValue = this.extractSingleValuePropertyValue(propName, grpString);
        String[] propValues = extractedPropValue.split(MVP_PROPERTY_VALUES_SEPARATOR);
        propValues = this.handleLocaleSensitiveMultiValuedProperty(propName, propValues);
        return propValues;
    }

    public String extractSingleValuePropertyValue(String propName, String grpString) {
        int indexOfName = grpString.indexOf(propName);
        boolean foundMatch = false;
        if (indexOfName == -1) {
            return null;
        }
        if (indexOfName == 0) {
            foundMatch = true;
        }
        while (!foundMatch && indexOfName < grpString.length() - 1 && indexOfName > 0) {
            if (PD_CHILDREN_SEPARATOR.equalsIgnoreCase(grpString.substring(indexOfName - PD_CHILDREN_SEPARATOR.length(), indexOfName))) {
                foundMatch = true;
                continue;
            }
            indexOfName = grpString.indexOf(propName, indexOfName + propName.length());
        }
        if (indexOfName < 0) {
            return null;
        }
        int indexOfSeparator = grpString.indexOf(PD_CHILDREN_SEPARATOR, indexOfName);
        String truncatedPropString = grpString.substring(indexOfName + propName.length() + 1, indexOfSeparator);
        if (truncatedPropString.equalsIgnoreCase("null")) {
            return null;
        }
        return this.handleLocaleSensitiveProperty(propName, truncatedPropString);
    }

    public String extractGroupString(String name, String grpString) {
        StringBuffer searchText1 = new StringBuffer();
        searchText1.append(PG_OPENING_TAG);
        searchText1.append(name);
        String truncatedString = grpString;
        if (grpString.indexOf(searchText1.toString()) != -1) {
            truncatedString = truncatedString.substring(truncatedString.indexOf(searchText1.toString()) + searchText1.length());
            truncatedString = truncatedString.substring(truncatedString.indexOf(PG_CLOSING_TAG) + 1);
        }
        String searchText2 = this.getPGClosingTag(name).toString();
        String pgString = truncatedString;
        if (truncatedString.indexOf(searchText2) != -1) {
            pgString = truncatedString.substring(0, truncatedString.indexOf(searchText2));
        }
        return pgString;
    }

    public String getPropertyGroupVersion(String pgName, String pgContents) {
        StringBuffer pgstring = new StringBuffer();
        pgstring.append(PG_OPENING_TAG);
        pgstring.append(pgName);
        int nameTagIndex = pgContents.indexOf(pgName);
        if (nameTagIndex == -1) {
            return null;
        }
        int nextVersionTagIndex = pgContents.indexOf(PG_VERSION_ATTRIBUTE, nameTagIndex);
        int nextClosingTagIndex = pgContents.indexOf(PG_CLOSING_TAG, nameTagIndex);
        String version = pgContents.substring(nextVersionTagIndex + PG_VERSION_ATTRIBUTE.length(), nextClosingTagIndex);
        return version.trim();
    }

    public String handleLocaleSensitiveProperty(String propName, String propValue) {
        return propValue;
    }

    public String[] handleLocaleSensitiveMultiValuedProperty(String propName, String[] propValues) {
        return propValues;
    }

    public String getLocaleSensitivePropertyValue(ISingleValuedProperty prop) {
        return prop.getValueAsString();
    }

    public String[] getLocaleSensitivePropertyMultiValue(IMultiValuedProperty prop) {
        return prop.getValuesAsStrings();
    }
}

