/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.spi;

import com.ibm.propertygroup.IPropertyChangeListener;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.PropertyChangeEvent;
import com.ibm.propertygroup.internal.LogFacility;
import com.ibm.propertygroup.internal.messages.MessageResource;
import com.ibm.propertygroup.spi.IVetoableChangeListener;
import com.ibm.propertygroup.spi.PropertyChangeSupport;
import com.ibm.propertygroup.spi.PropertyVetoException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public abstract class BasePropertyDescriptor
implements IPropertyDescriptor,
IPropertyChangeListener,
IVetoableChangeListener {
    protected String description;
    protected String displayName;
    protected boolean isDescriptionSet = false;
    protected boolean isDisplayNameSet = false;
    protected boolean isNameSet = false;
    protected String name;
    protected String propertyID = "DEFAULT_PROPERTY_IDENTIFIER";
    protected boolean enabled = true;
    protected PropertyChangeSupport propertyChanges;
    protected int propertyFlag = 0;
    protected PropertyChangeSupport vetoableChanges;
    protected IPropertyDescriptor parent = null;

    public BasePropertyDescriptor(String propertyName, String displayName, String propertyDescription) throws CoreException {
        this.initialize(propertyName);
        if (propertyDescription != null) {
            this.setDescription(propertyDescription);
        }
        if (displayName == null) {
            this.setDisplayName(this.name);
        } else {
            this.setDisplayName(displayName);
        }
    }

    @Override
    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyChanges.addPropertyChangeListener(listener);
    }

    public void addVetoablePropertyChangeListener(IVetoableChangeListener listener) {
        this.vetoableChanges.addVetoableChangeListener(listener);
    }

    @Override
    public void assignID(String id) throws CoreException {
        if (!"DEFAULT_PROPERTY_IDENTIFIER".equals(this.propertyID)) {
            Status status = new Status(4, "com.ibm.propertygroup", 4, MessageResource.ERR_ID_SET, null);
            LogFacility.logErrorMessage((IStatus)status);
            throw new CoreException((IStatus)status);
        }
        this.propertyID = id;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        BasePropertyDescriptor clone = (BasePropertyDescriptor)super.clone();
        clone.propertyChanges = new PropertyChangeSupport(clone);
        clone.vetoableChanges = new PropertyChangeSupport(clone);
        return clone;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getID() {
        return this.propertyID;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getPropertyFlag() {
        return this.propertyFlag;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public abstract void propertyChange(PropertyChangeEvent var1);

    @Override
    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyChanges.removePropertyChangeListener(listener);
    }

    public void removeVetoablePropertyChangeListener(IVetoableChangeListener listener) {
        this.vetoableChanges.removeVetoableChangeListener(listener);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.propertyChanges.firePropertyEnabledChange(enabled);
    }

    @Override
    public abstract void vetoableChange(PropertyChangeEvent var1) throws PropertyVetoException;

    protected void setDescription(String description) {
        if (!this.isDescriptionSet) {
            this.description = description;
            this.isDescriptionSet = true;
        }
    }

    public void setDescription(String description, boolean force) {
        if (force) {
            this.description = description;
            this.isDescriptionSet = true;
        } else {
            this.setDescription(description);
        }
    }

    protected void setDisplayName(String displayName) {
        if (!this.isDisplayNameSet) {
            this.displayName = displayName;
            this.isDisplayNameSet = true;
        }
    }

    public void setDisplayName(String displayName, boolean force) {
        if (force) {
            this.displayName = displayName;
            this.isDisplayNameSet = true;
        } else {
            this.setDisplayName(displayName);
        }
    }

    protected void setName(String name) {
        if (!this.isNameSet) {
            this.name = name;
            this.isNameSet = true;
        }
    }

    void initialize(String propertyName) throws CoreException {
        if (propertyName == null) {
            Status status = new Status(4, "com.ibm.propertygroup", 4, MessageResource.ERR_PROP_NAME_NULL, null);
            LogFacility.logErrorMessage((IStatus)status);
            throw new CoreException((IStatus)status);
        }
        this.setName(propertyName);
        this.propertyChanges = new PropertyChangeSupport(this);
        this.vetoableChanges = new PropertyChangeSupport(this);
    }

    @Override
    public IPropertyDescriptor getParent() {
        return this.parent;
    }

    @Override
    public void setParent(IPropertyDescriptor parent) {
        this.parent = parent;
    }
}

