/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.framework.util;

import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.internal.LogFacility;
import com.ibm.adapter.framework.internal.MessageResource;
import javax.xml.namespace.QName;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;

public class QNameHelper {
    public static QName createQName(String qname) {
        int index = qname.indexOf(58);
        if (index > 0 && index < qname.length() - 1) {
            String namespace = qname.substring(0, index);
            namespace = namespace.replace('{', ' ');
            namespace = namespace.replace('}', ' ');
            namespace = namespace.trim();
            String localPart = qname.substring(index + 1);
            return QNameHelper.createQName(namespace, localPart);
        }
        LogFacility.Trace(MessageResource.bind((String)MessageResource.MSG_ERROR__INVALID_QNAME, (Object)qname), (short)30);
        return null;
    }

    public static QName createQName(String namespaceURI, String localPart) {
        QName name = new QName(namespaceURI, localPart);
        return name;
    }

    public static String getClassName(QName qName) throws BaseException {
        String className;
        IStatus status;
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        if ((status = JavaConventions.validateJavaTypeName((String)(className = qName.getLocalPart()))).getSeverity() != 4) {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            return className;
        }
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
        throw BaseException.createException(status.getMessage(), status.getException());
    }

    public static String getPackageName(QName qName) throws BaseException {
        String packageName;
        IStatus status;
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        if ((status = JavaConventions.validatePackageName((String)(packageName = qName.getNamespaceURI().replaceAll("/", ".")))).getSeverity() != 4) {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            return packageName;
        }
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
        throw BaseException.createException(status.getMessage(), status.getException());
    }

    public static String getQualifiedClassName(QName qName) throws BaseException {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(QNameHelper.getPackageName(qName));
        buffer.append('.');
        buffer.append(QNameHelper.getClassName(qName));
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
        return buffer.toString();
    }

    public static void validateQName(QName qname) throws BaseException {
        if (qname == null) {
            String message = MessageResource.MSG_ERROR__INVALID_INPUT__QNAME__NULL;
            throw BaseException.createException(message, null);
        }
        String namespaceURI = qname.getNamespaceURI();
        if (namespaceURI == null || namespaceURI.trim().length() == 0) {
            String message = MessageResource.MSG_ERROR__INVALID_INPUT__QNAME_NAMESPACE_URI__EMPTY;
            throw BaseException.createException(message, null);
        }
        String localPart = qname.getLocalPart();
        if (localPart == null || localPart.trim().length() == 0) {
            String message = MessageResource.MSG_ERROR__INVALID_INPUT__QNAME_LOCAL_PART__EMPTY;
            throw BaseException.createException(message, null);
        }
    }
}

