/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.framework.ui;

import com.ibm.adapter.framework.ui.ITreeImageProvider;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class ImageProviderRegistry {
    private static ImageProviderRegistry global_ = null;
    private static HashMap providerMap_ = null;
    public static final String EXTENSION_POINT_ID = "com.ibm.adapter.framework.TreeImageProvider";
    public static final String SEARCH_TREE_CLASS = "SearchTreeClass";
    public static final String IMAGE_PROVIDER_CLASS = "ImageProviderClass";

    private ImageProviderRegistry() {
        this.initializeFromExtensions();
    }

    public static ImageProviderRegistry instance() {
        if (global_ == null) {
            global_ = new ImageProviderRegistry();
        }
        return global_;
    }

    private void initializeFromExtensions() {
        providerMap_ = new HashMap();
        IConfigurationElement[] extensionPoints = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int i = 0;
        while (i < extensionPoints.length) {
            IConfigurationElement treeProvider = extensionPoints[i];
            String searchTreeClassName = treeProvider.getAttribute(SEARCH_TREE_CLASS);
            providerMap_.put(searchTreeClassName, treeProvider);
            ++i;
        }
    }

    public ITreeImageProvider getImageProviderForSearchTree(String searchTreeClassName) {
        IConfigurationElement config = (IConfigurationElement)providerMap_.get(searchTreeClassName);
        if (config == null) {
            return null;
        }
        ITreeImageProvider provider = null;
        try {
            provider = (ITreeImageProvider)config.createExecutableExtension(IMAGE_PROVIDER_CLASS);
        }
        catch (CoreException coreException) {
            return null;
        }
        return provider;
    }
}

