/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.framework.spi.registry;

import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.IDiscoveryAgent;
import com.ibm.adapter.framework.IResourceWriter;
import com.ibm.adapter.framework.internal.LogFacility;
import com.ibm.adapter.framework.internal.MessageResource;
import com.ibm.adapter.framework.registry.IConfiguration;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;

public class ConfigurationImpl
implements IConfiguration {
    protected QName configurationName;
    protected String description;
    protected IDiscoveryAgent discoveryAgent;
    protected String displayName;
    protected IResourceWriter resourceWriter;
    protected ArrayList discoveryAgentConfigurationProperties = new ArrayList();
    protected ArrayList resourceWriterConfigurationProperties = new ArrayList();

    public ConfigurationImpl(QName name, IDiscoveryAgent discoveryAgent, IResourceWriter resourceWriter, String displayName, String description) {
        this.configurationName = name;
        this.discoveryAgent = discoveryAgent;
        this.resourceWriter = resourceWriter;
        this.displayName = displayName;
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public QName getName() {
        return this.configurationName;
    }

    @Override
    public IDiscoveryAgent createDiscoveryAgent() {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            IDiscoveryAgent agent = this.discoveryAgent.newInstance();
            if (agent != null) {
                if (LogFacility.trace) {
                    Iterator i = this.discoveryAgentConfigurationProperties.iterator();
                    while (i.hasNext()) {
                        String name = i.next().toString();
                        LogFacility.Trace(MessageResource.bind((String)MessageResource.Registry__MSG_CONFIGURE_DISCOVERY_AGENT, (Object)name), (short)10);
                    }
                }
                try {
                    if (!this.discoveryAgentConfigurationProperties.isEmpty()) {
                        this.discoveryAgent.setConfiguration(this.discoveryAgentConfigurationProperties.toArray(new String[0]));
                    }
                }
                catch (BaseException e) {
                    LogFacility.logInfoMessage(e.getStatus());
                }
            }
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            return agent;
        }
        catch (BaseException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), (Throwable)((Object)e));
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            return null;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            return null;
        }
    }

    @Override
    public IResourceWriter createResourceWriter() {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            IResourceWriter writer = this.resourceWriter.newInstance();
            if (this.resourceWriter != null) {
                if (LogFacility.trace) {
                    Iterator i = this.resourceWriterConfigurationProperties.iterator();
                    while (i.hasNext()) {
                        String name = i.next().toString();
                        LogFacility.Trace(MessageResource.bind((String)MessageResource.Registry__MSG_CONFIGURE_RESOURCE_WRITER, (Object)name), (short)10);
                    }
                }
                try {
                    if (!this.resourceWriterConfigurationProperties.isEmpty()) {
                        this.resourceWriter.setConfiguration(this.resourceWriterConfigurationProperties.toArray(new String[0]));
                    }
                }
                catch (BaseException e) {
                    LogFacility.logInfoMessage(e.getStatus());
                }
            }
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            return writer;
        }
        catch (BaseException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), (Throwable)((Object)e));
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            return null;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            return null;
        }
    }

    public void addDiscoveryAgentConfigurationProperty(String name) {
        this.discoveryAgentConfigurationProperties.add(name);
    }

    public void addResourceWriterConfigurationProperty(String name) {
        this.resourceWriterConfigurationProperties.add(name);
    }
}

