/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.framework.spi;

import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.IResultNode;
import com.ibm.adapter.framework.IResultNodeSelection;
import com.ibm.adapter.framework.internal.LogFacility;
import com.ibm.adapter.framework.internal.MessageResource;
import com.ibm.adapter.framework.spi.BaseResultNode;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.ISingleValuedProperty;
import java.util.ArrayList;

public abstract class BaseResultNodeSelection
implements IResultNodeSelection {
    protected IPropertyGroup activeSelectionProperties;
    protected ArrayList internalSelection = new ArrayList();
    protected IPropertyGroup selectionProperties;

    @Override
    public void add(IResultNode node) throws BaseException {
        String errorMsg = this.acceptAddition(node);
        if (errorMsg != null) {
            BaseException e = BaseException.createException(errorMsg, null);
            LogFacility.logErrorMessage(e.getStatus());
            throw e;
        }
        this.internalSelection.add(node);
    }

    protected abstract String acceptAddition(IResultNode var1);

    @Override
    public void applySelectionProperties(IPropertyGroup properties) throws BaseException {
        if (this.selectionProperties != null) {
            if (!this.compareProperties(this.selectionProperties, properties)) {
                BaseException e = BaseException.createException(MessageResource.MSG_ERROR__PROPERTIES_NOT_MATCHED, null);
                LogFacility.logErrorMessage(e.getStatus());
                throw e;
            }
        } else {
            BaseException e = BaseException.createException(MessageResource.MSG_ERROR__SELECTION_PROPERTIES_NOT_ALLOWED, null);
            LogFacility.logErrorMessage(e.getStatus());
            throw e;
        }
        this.activeSelectionProperties = properties;
    }

    @Override
    public IPropertyGroup createSelectionProperties() {
        try {
            if (this.activeSelectionProperties != null) {
                return (IPropertyGroup)this.activeSelectionProperties.clone();
            }
            if (this.selectionProperties != null) {
                return (IPropertyGroup)this.selectionProperties.clone();
            }
            return null;
        }
        catch (CloneNotSupportedException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            return null;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            return null;
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            return null;
        }
    }

    @Override
    public IResultNode[] getSelection() {
        return this.internalSelection.toArray(new IResultNode[0]);
    }

    @Override
    public void remove(IResultNode node) {
        this.internalSelection.remove(node);
    }

    private boolean compareProperties(IPropertyGroup baseProperties, IPropertyGroup secondaryProperties) {
        IPropertyDescriptor[] secondary;
        IPropertyDescriptor[] base = baseProperties.getProperties();
        if (base.length != (secondary = secondaryProperties.getProperties()).length) {
            return false;
        }
        int i = base.length;
        while (--i >= 0) {
            if (base[i] instanceof IPropertyGroup) {
                if (secondary[i] instanceof IPropertyGroup) {
                    if (this.compareProperties((IPropertyGroup)base[i], (IPropertyGroup)secondary[i])) continue;
                    return false;
                }
                return false;
            }
            if (!(base[i] instanceof ISingleValuedProperty)) continue;
            if (secondary[i] instanceof ISingleValuedProperty) {
                if (((ISingleValuedProperty)base[i]).getPropertyType() == ((ISingleValuedProperty)secondary[i]).getPropertyType() && base[i].getName().equals(secondary[i].getName())) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean canAdd(IResultNode[] nodes) {
        if (nodes == null) {
            return false;
        }
        int i = 0;
        while (i < nodes.length) {
            if (!this.canAdd(nodes[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public IPropertyGroup edit(IResultNode node) {
        BaseResultNode rn;
        IPropertyGroup pg;
        if (node instanceof BaseResultNode && (pg = (rn = (BaseResultNode)node).getActiveConfigurationParameters()) != null) {
            try {
                IPropertyGroup result = (IPropertyGroup)pg.clone();
                return result;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return pg;
            }
        }
        return null;
    }

    @Override
    public String getMessage() {
        return null;
    }

    @Override
    public boolean isSelectionComplete() {
        return true;
    }
}

