/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.framework.spi;

import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.IPublishingObject;
import com.ibm.adapter.framework.internal.LogFacility;
import com.ibm.propertygroup.IPropertyGroup;

public abstract class BasePublishingObject
implements IPublishingObject {
    protected String name;
    protected String description;
    protected IPropertyGroup currentConfigurationParameters;
    protected IPropertyGroup configurationParameters;
    protected IPropertyGroup displayProperties;

    @Override
    public IPropertyGroup createConfigurationParameters() {
        try {
            if (this.currentConfigurationParameters != null) {
                return (IPropertyGroup)this.currentConfigurationParameters.clone();
            }
            if (this.configurationParameters != null) {
                return (IPropertyGroup)this.configurationParameters.clone();
            }
            return null;
        }
        catch (CloneNotSupportedException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            return null;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            return null;
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            return null;
        }
    }

    @Override
    public void applyConfigurationParameters(IPropertyGroup parameters) throws BaseException {
        this.currentConfigurationParameters = parameters;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public IPropertyGroup getDisplayProperties() {
        return this.displayProperties;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setConfigurationParameters(IPropertyGroup configurationParameters) {
        this.configurationParameters = configurationParameters;
    }

    protected void setDescription(String description) {
        this.description = description;
    }

    protected void setDisplayProperties(IPropertyGroup displayProperties) {
        this.displayProperties = displayProperties;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public IPropertyGroup getActiveConfigurationParameters() {
        return this.currentConfigurationParameters;
    }
}

