/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.framework.internal.registry;

import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.IDiscoveryAgent;
import com.ibm.adapter.framework.IDiscoveryAgentMetaData;
import com.ibm.adapter.framework.IEnvironment;
import com.ibm.adapter.framework.IImportResult;
import com.ibm.adapter.framework.IPublishingSet;
import com.ibm.adapter.framework.IResourceWriter;
import com.ibm.adapter.framework.IResultNodeSelection;
import com.ibm.adapter.framework.ISearchTree;
import com.ibm.adapter.framework.internal.LogFacility;
import com.ibm.adapter.framework.internal.MessageResource;
import com.ibm.adapter.framework.internal.build.IBuildAgent;
import com.ibm.adapter.framework.internal.build.IServiceBuilder;
import com.ibm.adapter.framework.internal.build.registry.BuildAgent;
import com.ibm.adapter.framework.internal.build.registry.BuildAgentRegObject;
import com.ibm.adapter.framework.internal.build.registry.BuildConfigurationImpl;
import com.ibm.adapter.framework.internal.build.registry.IBuildConfiguration;
import com.ibm.adapter.framework.internal.build.registry.IBuildRegistry;
import com.ibm.adapter.framework.internal.build.spi.BaseBuildAgent;
import com.ibm.adapter.framework.internal.registry.BuildConfigurationRegObject;
import com.ibm.adapter.framework.internal.registry.ClassificationHelper;
import com.ibm.adapter.framework.internal.registry.ConfigurationRegObject;
import com.ibm.adapter.framework.internal.registry.DiscoveryAgentRegObject;
import com.ibm.adapter.framework.internal.registry.RegistryConstants;
import com.ibm.adapter.framework.internal.registry.ResourceWriterRegObject;
import com.ibm.adapter.framework.registry.Configuration;
import com.ibm.adapter.framework.registry.DiscoveryAgent;
import com.ibm.adapter.framework.registry.IConfiguration;
import com.ibm.adapter.framework.registry.IContextHandler;
import com.ibm.adapter.framework.registry.IRegistryObject;
import com.ibm.adapter.framework.registry.ResourceWriter;
import com.ibm.adapter.framework.spi.BaseDiscoveryAgent;
import com.ibm.adapter.framework.spi.BaseDiscoveryAgentMetaData;
import com.ibm.adapter.framework.spi.BaseResourceWriter;
import com.ibm.adapter.framework.spi.registry.ConfigurationImpl;
import com.ibm.adapter.framework.spi.registry.IRegistry;
import com.ibm.adapter.framework.spi.registry.IRegistryListener;
import com.ibm.adapter.framework.spi.registry.RegistryEvent;
import com.ibm.adapter.framework.util.QNameHelper;
import com.ibm.propertygroup.IPropertyGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;

public final class Registry
implements IBuildRegistry,
com.ibm.adapter.framework.registry.IRegistry,
IRegistry,
RegistryConstants {
    private static Registry _instance;
    private static ThreadCount threadCount;
    private Map _discoveryAgentRegistry = Collections.synchronizedMap(new HashMap());
    private Map _buildAgentRegistry = Collections.synchronizedMap(new HashMap());
    private Map _configurationRegistry = Collections.synchronizedMap(new HashMap());
    private Map _resourceWriterRegistry = Collections.synchronizedMap(new HashMap());
    private Vector registryListeners = new Vector();
    private Vector contextHandlers = new Vector();

    static {
        threadCount = new ThreadCount();
    }

    public static Registry getRegistry() {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        if (_instance == null) {
            Registry.initializeInstance();
        }
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
        return _instance;
    }

    private static synchronized void initializeInstance() {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        if (_instance == null) {
            _instance = new Registry();
        }
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
    }

    private Registry() {
        this.initialize();
    }

    @Override
    public Configuration[] getAllConfigurations() throws BaseException {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            Collection configurations = this._configurationRegistry.values();
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            if (!configurations.isEmpty()) {
                return configurations.toArray(new Configuration[0]);
            }
            return null;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            return null;
        }
    }

    @Override
    public Configuration[] getAllConfigurations(IPath[] classifiers, boolean exactMatch) throws BaseException {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            Collection configurations = this._configurationRegistry.values();
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            ArrayList<Configuration> filteredObjects = new ArrayList<Configuration>();
            if (classifiers == null) {
                classifiers = ClassificationHelper.UNCLASSIFIED_PATH;
            }
            if (configurations != null) {
                Iterator i = configurations.iterator();
                while (i.hasNext()) {
                    boolean found = true;
                    Configuration c = (Configuration)i.next();
                    int filtersIndex = classifiers.length;
                    while (--filtersIndex >= 0 && found) {
                        if (c.containsClassifier(classifiers[filtersIndex], exactMatch)) continue;
                        found = false;
                        break;
                    }
                    if (!found) continue;
                    filteredObjects.add(c);
                }
                return filteredObjects.toArray(new Configuration[0]);
            }
            return null;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            return null;
        }
    }

    @Override
    public IContextHandler[] getAllContextHandlers() throws BaseException {
        if (!this.contextHandlers.isEmpty()) {
            return this.contextHandlers.toArray(new IContextHandler[0]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DiscoveryAgent getDiscoveryAgent(QName agentName) throws BaseException {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            QNameHelper.validateQName(agentName);
            Collection agents = this._discoveryAgentRegistry.values();
            Map map = this._discoveryAgentRegistry;
            synchronized (map) {
                for (DiscoveryAgent agent : agents) {
                    if (!agentName.equals(agent.getMetaData().getAgentName())) continue;
                    if (LogFacility.trace) {
                        LogFacility.TrcExit();
                    }
                    return agent;
                }
            }
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            return null;
        }
        catch (BaseException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), (Throwable)((Object)e));
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            throw e;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            throw BaseException.createException(e.getLocalizedMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BuildAgent getBuildAgent(QName buildAgentName) throws BaseException {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            QNameHelper.validateQName(buildAgentName);
            Collection agents = this._buildAgentRegistry.values();
            Map map = this._buildAgentRegistry;
            synchronized (map) {
                for (BuildAgent agent : agents) {
                    if (!buildAgentName.equals(agent.getName())) continue;
                    if (LogFacility.trace) {
                        LogFacility.TrcExit();
                    }
                    return agent;
                }
            }
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            return null;
        }
        catch (BaseException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), (Throwable)((Object)e));
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            throw e;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            throw BaseException.createException(e.getLocalizedMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Configuration getConfiguration(QName configurationName) throws BaseException {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            QNameHelper.validateQName(configurationName);
            Collection ics = this._configurationRegistry.values();
            Map map = this._configurationRegistry;
            synchronized (map) {
                for (Configuration config : ics) {
                    if (!configurationName.equals(config.getName())) continue;
                    if (LogFacility.trace) {
                        LogFacility.TrcExit();
                    }
                    return config;
                }
            }
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            return null;
        }
        catch (BaseException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), (Throwable)((Object)e));
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            throw e;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            throw BaseException.createException(e.getLocalizedMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceWriter getResourceWriter(QName resourceWriterName) throws BaseException {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            QNameHelper.validateQName(resourceWriterName);
            Collection writers = this._resourceWriterRegistry.values();
            Map map = this._resourceWriterRegistry;
            synchronized (map) {
                for (ResourceWriter writer : writers) {
                    if (!resourceWriterName.equals(writer.getName())) continue;
                    if (LogFacility.trace) {
                        LogFacility.TrcExit();
                    }
                    return writer;
                }
            }
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            return null;
        }
        catch (BaseException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), (Throwable)((Object)e));
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            throw e;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            throw BaseException.createException(e.getLocalizedMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerBuildAgent(IBuildAgent buildAgent, IPath[] classifications) throws BaseException {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            QName agentName = buildAgent.getName();
            Map map = this._buildAgentRegistry;
            synchronized (map) {
                if (!this._buildAgentRegistry.containsKey(agentName)) {
                    if (classifications == null) {
                        classifications = ClassificationHelper.UNCLASSIFIED_PATH;
                    }
                } else {
                    String message = MessageResource.bind((String)MessageResource.MSG_ERROR__BUILD_AGENT__ALREADY_REGISTERED, (Object)agentName.toString());
                    BaseException e = BaseException.createException(message, null);
                    LogFacility.logErrorMessage(e.getStatus());
                    throw e;
                }
                BuildAgentRegObject registryObj = new BuildAgentRegObject(buildAgent, classifications);
                this._buildAgentRegistry.put(agentName, registryObj);
                this.fireEvent(new RegistryEvent(0, 8, registryObj));
            }
            if (LogFacility.trace) {
                LogFacility.Trace(MessageResource.bind((String)MessageResource.Registry__MSG_REGISTERED_BUILD_AGENT, (Object)agentName.toString()), (short)10);
            }
        }
        catch (BaseException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), (Throwable)((Object)e));
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (LogFacility.trace) {
                LogFacility.Trace(MessageResource.Registry__MSG_ERROR_REGISTERING_BUILD_AGENT, (short)10);
            }
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            throw BaseException.createException(e.getLocalizedMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerDiscoveryAgent(IDiscoveryAgent newAgent, IPath[] classifications) throws BaseException {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            IDiscoveryAgentMetaData metaData = newAgent.getMetaData();
            QName agentName = metaData.getAgentName();
            Map map = this._discoveryAgentRegistry;
            synchronized (map) {
                if (!this._discoveryAgentRegistry.containsKey(agentName)) {
                    if (classifications == null) {
                        classifications = ClassificationHelper.UNCLASSIFIED_PATH;
                    }
                } else {
                    String message = MessageResource.bind((String)MessageResource.MSG_ERROR__DISCOVERY_AGENT__ALREADY_REGISTERED, (Object)agentName.toString());
                    BaseException e = BaseException.createException(message, null);
                    LogFacility.logErrorMessage(e.getStatus());
                    throw e;
                }
                DiscoveryAgentRegObject registryObj = new DiscoveryAgentRegObject(newAgent, classifications);
                this._discoveryAgentRegistry.put(agentName, registryObj);
                this.fireEvent(new RegistryEvent(0, 1, registryObj));
            }
            if (LogFacility.trace) {
                LogFacility.Trace(MessageResource.bind((String)MessageResource.Registry__MSG_REGISTERED_DISCOVERY_AGENT, (Object)agentName.toString()), (short)10);
            }
        }
        catch (BaseException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), (Throwable)((Object)e));
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (LogFacility.trace) {
                LogFacility.Trace(MessageResource.Registry__MSG_ERROR_REGISTERING_DISCOVERY_AGENT, (short)10);
            }
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            throw BaseException.createException(e.getLocalizedMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerConfiguration(IConfiguration configuration, IPath[] classifications) throws BaseException {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            QName configurationName = configuration.getName();
            Map map = this._configurationRegistry;
            synchronized (map) {
                if (!this._configurationRegistry.containsKey(configurationName)) {
                    if (classifications == null) {
                        classifications = ClassificationHelper.UNCLASSIFIED_PATH;
                    }
                } else {
                    String message = MessageResource.bind((String)MessageResource.MSG_ERROR__IMPORT_CONFIGURATION__ALREADY_REGISTERED, (Object)configurationName.toString());
                    BaseException e = BaseException.createException(message, null);
                    LogFacility.logErrorMessage(e.getStatus());
                    throw e;
                }
                Configuration registryObj = null;
                registryObj = configuration instanceof IBuildConfiguration ? new BuildConfigurationRegObject((IBuildConfiguration)configuration, classifications) : new ConfigurationRegObject(configuration, classifications);
                this._configurationRegistry.put(configurationName, registryObj);
                this.fireEvent(new RegistryEvent(0, 4, registryObj));
            }
            if (LogFacility.trace) {
                LogFacility.Trace(MessageResource.bind((String)MessageResource.Registry__MSG_REGISTERED_CONFIGURATION, (Object)configurationName.toString()), (short)10);
            }
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
        catch (BaseException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), (Throwable)((Object)e));
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (LogFacility.trace) {
                LogFacility.Trace(MessageResource.Registry__MSG_ERROR_REGISTERING_CONFIGURATION, (short)10);
            }
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            throw BaseException.createException(e.getLocalizedMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerResourceWriter(IResourceWriter newResourceWriter, IPath[] classifications) throws BaseException {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            QName workspaceName = newResourceWriter.getName();
            Map map = this._resourceWriterRegistry;
            synchronized (map) {
                if (!this._resourceWriterRegistry.containsKey(workspaceName)) {
                    if (classifications == null) {
                        classifications = ClassificationHelper.UNCLASSIFIED_PATH;
                    }
                } else {
                    String message = MessageResource.bind((String)MessageResource.MSG_ERROR__WORKSPACE_RESOURCE_WRITER__ALREADY_REGISTERED, (Object)workspaceName.toString());
                    BaseException e = BaseException.createException(message, null);
                    LogFacility.logErrorMessage(e.getStatus());
                    throw e;
                }
                ResourceWriterRegObject registryObj = new ResourceWriterRegObject(newResourceWriter, classifications);
                this._resourceWriterRegistry.put(workspaceName, registryObj);
                this.fireEvent(new RegistryEvent(0, 2, registryObj));
            }
            if (LogFacility.trace) {
                LogFacility.Trace(MessageResource.bind((String)MessageResource.Registry__MSG_REGISTERED_RESOURCE_WRITER, (Object)workspaceName.toString()), (short)10);
            }
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
        catch (BaseException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), (Throwable)((Object)e));
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            throw e;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            if (LogFacility.trace) {
                LogFacility.Trace(MessageResource.Registry__MSG_ERROR_REGISTERING_RESOURCE_WRITER, (short)10);
            }
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            throw BaseException.createException(e.getLocalizedMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDiscoveryAgent(QName agentName) throws BaseException {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            if (LogFacility.trace) {
                LogFacility.Trace(MessageResource.bind((String)MessageResource.Registry__MSG_REMOVING_DISCOVERY_AGENT, (Object)agentName.toString()), (short)10);
            }
            Map map = this._discoveryAgentRegistry;
            synchronized (map) {
                if (this._discoveryAgentRegistry.containsKey(agentName)) {
                    IRegistryObject registryObj = (IRegistryObject)this._discoveryAgentRegistry.get(agentName);
                    this._discoveryAgentRegistry.remove(agentName);
                    this.fireEvent(new RegistryEvent(1, 1, registryObj));
                    if (LogFacility.trace) {
                        LogFacility.Trace(MessageResource.bind((String)MessageResource.Registry__MSG_REMOVED_DISCOVERY_AGENT, (Object)agentName.toString()), (short)10);
                    }
                } else if (LogFacility.trace) {
                    LogFacility.Trace(MessageResource.bind((String)MessageResource.Registry__MSG_ERROR_REMOVING_DISCOVERY_AGENT, (Object)agentName.toString()), (short)10);
                }
            }
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            throw BaseException.createException(e.getLocalizedMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConfiguration(QName configurationName) throws BaseException {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            if (LogFacility.trace) {
                LogFacility.Trace(MessageResource.bind((String)MessageResource.Registry__MSG_REMOVING_CONFIGURATION, (Object)configurationName.toString()), (short)10);
            }
            Map map = this._configurationRegistry;
            synchronized (map) {
                if (this._configurationRegistry.containsKey(configurationName)) {
                    IRegistryObject registryObj = (IRegistryObject)this._configurationRegistry.get(configurationName);
                    this._configurationRegistry.remove(configurationName);
                    this.fireEvent(new RegistryEvent(1, 4, registryObj));
                    if (LogFacility.trace) {
                        LogFacility.Trace(MessageResource.bind((String)MessageResource.Registry__MSG_REMOVED_CONFIGURATION, (Object)configurationName.toString()), (short)10);
                    }
                } else if (LogFacility.trace) {
                    LogFacility.Trace(MessageResource.bind((String)MessageResource.Registry__MSG_ERROR_REMOVING_CONFIGURATION, (Object)configurationName.toString()), (short)10);
                }
            }
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            throw BaseException.createException(e.getLocalizedMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeResourceWriter(QName resourceWriterName) throws BaseException {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            if (LogFacility.trace) {
                LogFacility.Trace(MessageResource.bind((String)MessageResource.Registry__MSG_REMOVING_RESOURCE_WRITER, (Object)resourceWriterName.toString()), (short)10);
            }
            Map map = this._resourceWriterRegistry;
            synchronized (map) {
                if (this._resourceWriterRegistry.containsKey(resourceWriterName)) {
                    IRegistryObject registryObj = (IRegistryObject)this._resourceWriterRegistry.get(resourceWriterName);
                    this._resourceWriterRegistry.remove(resourceWriterName);
                    this.fireEvent(new RegistryEvent(1, 2, registryObj));
                    if (LogFacility.trace) {
                        LogFacility.Trace(MessageResource.bind((String)MessageResource.Registry__MSG_REMOVED_RESOURCE_WRITER, (Object)resourceWriterName.toString()), (short)10);
                    }
                } else if (LogFacility.trace) {
                    LogFacility.Trace(MessageResource.bind((String)MessageResource.Registry__MSG_ERROR_REMOVING_RESOURCE_WRITER, (Object)resourceWriterName.toString()), (short)10);
                }
            }
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            throw BaseException.createException(e.getLocalizedMessage(), e);
        }
    }

    private void initialize() {
        String displayName;
        String description;
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        IConfigurationElement[] registryListenerExtensionPoints = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.adapter.framework.RegistryListener");
        int i = 0;
        while (i < registryListenerExtensionPoints.length) {
            try {
                IConfigurationElement registryListener = registryListenerExtensionPoints[i];
                if (LogFacility.trace) {
                    LogFacility.Trace(MessageResource.bind((String)MessageResource.Registry__MSG_REGISTERING_REGISTRY_LISTENER, (Object)registryListener.getAttribute("class")), (short)10);
                }
                IRegistryListener listener = (IRegistryListener)registryListener.createExecutableExtension("class");
                this.addRegistryListener(listener);
                if (LogFacility.trace) {
                    LogFacility.Trace(MessageResource.bind((String)MessageResource.Registry__MSG_REGISTERED_REGISTRY_LISTENER, (Object)registryListener.getAttribute("class")), (short)10);
                }
            }
            catch (CoreException e) {
                LogFacility.logErrorMessage(e.getStatus());
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            }
            ++i;
        }
        IConfigurationElement[] contextHandlerExtensionPoints = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.adapter.framework.ContextHandler");
        int i2 = 0;
        while (i2 < contextHandlerExtensionPoints.length) {
            try {
                IConfigurationElement contextHandlerElement = contextHandlerExtensionPoints[i2];
                if (LogFacility.trace) {
                    LogFacility.Trace(MessageResource.bind((String)MessageResource.Registry__MSG_REGISTERING_CONTEXT_HANDLER, (Object)contextHandlerElement.getAttribute("class")), (short)10);
                }
                IContextHandler contextHandler = (IContextHandler)contextHandlerElement.createExecutableExtension("class");
                this.addContextHandler(contextHandler);
                if (LogFacility.trace) {
                    LogFacility.Trace(MessageResource.bind((String)MessageResource.Registry__MSG_REGISTERED_CONTEXT_HANDLER, (Object)contextHandlerElement.getAttribute("class")), (short)10);
                }
            }
            catch (CoreException e) {
                LogFacility.logErrorMessage(e.getStatus());
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            }
            ++i2;
        }
        IConfigurationElement[] discoveryAgentExtensionPoints = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.adapter.framework.DiscoveryAgent");
        int i3 = 0;
        while (i3 < discoveryAgentExtensionPoints.length) {
            try {
                IConfigurationElement agent = discoveryAgentExtensionPoints[i3];
                String name = agent.getAttribute("QName");
                QName agentQName = QNameHelper.createQName(name);
                String importType = agent.getAttribute("ImportType");
                int importTypeConstant = 0;
                if ("ENDPOINT".equals(importType)) {
                    importTypeConstant = 0;
                } else if ("DATA_TYPE".equals(importType)) {
                    importTypeConstant = 3;
                }
                description = agent.getAttribute("Description");
                displayName = agent.getAttribute("DisplayName");
                BaseDiscoveryAgentMetaData metaData = new BaseDiscoveryAgentMetaData(agentQName, displayName, description, importTypeConstant);
                DiscoveryAgentProxy discoveryAgentProxy = new DiscoveryAgentProxy();
                discoveryAgentProxy.setMetaData(metaData);
                discoveryAgentProxy.setConfiguartionElement(agent);
                IPath[] classifications = ClassificationHelper.UNCLASSIFIED_PATH;
                IConfigurationElement[] classificationElements = agent.getChildren("Classification");
                if (classificationElements != null && classificationElements.length > 0) {
                    classifications = new IPath[classificationElements.length];
                    int j = 0;
                    while (j < classificationElements.length) {
                        String path = classificationElements[j].getValue();
                        if (path != null) {
                            classifications[j] = new Path(path);
                        }
                        ++j;
                    }
                }
                this.registerDiscoveryAgent(discoveryAgentProxy, classifications);
                if (LogFacility.trace) {
                    LogFacility.Trace(MessageResource.bind((String)MessageResource.Registry__MSG_LOADED_DISCOVERY_AGENT_EXT_PT, (Object)name), (short)10);
                }
            }
            catch (Throwable ex) {
                LogFacility.logErrorMessage(ex.getLocalizedMessage(), ex);
            }
            ++i3;
        }
        IConfigurationElement[] buildAgentExtensionPoints = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.adapter.framework.BuildAgent");
        int i4 = 0;
        while (i4 < buildAgentExtensionPoints.length) {
            try {
                IConfigurationElement agent = buildAgentExtensionPoints[i4];
                String name = agent.getAttribute("QName");
                QName agentQName = QNameHelper.createQName(name);
                String description2 = agent.getAttribute("Description");
                String displayName2 = agent.getAttribute("DisplayName");
                BuildAgentProxy buildAgentProxy = new BuildAgentProxy(agentQName, description2, displayName2);
                buildAgentProxy.setConfiguartionElement(agent);
                IPath[] classifications = ClassificationHelper.UNCLASSIFIED_PATH;
                IConfigurationElement[] classificationElements = agent.getChildren("Classification");
                if (classificationElements != null && classificationElements.length > 0) {
                    classifications = new IPath[classificationElements.length];
                    int j = 0;
                    while (j < classificationElements.length) {
                        String path = classificationElements[j].getValue();
                        if (path != null) {
                            classifications[j] = new Path(path);
                        }
                        ++j;
                    }
                }
                this.registerBuildAgent(buildAgentProxy, classifications);
                if (LogFacility.trace) {
                    LogFacility.Trace(MessageResource.bind((String)MessageResource.Registry__MSG_LOADED_DISCOVERY_AGENT_EXT_PT, (Object)name), (short)10);
                }
            }
            catch (Throwable ex) {
                LogFacility.logErrorMessage(ex.getLocalizedMessage(), ex);
            }
            ++i4;
        }
        IConfigurationElement[] writerExtensionPoints = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.adapter.framework.ResourceWriter");
        int i5 = 0;
        while (i5 < writerExtensionPoints.length) {
            try {
                IConfigurationElement resourceWriter = writerExtensionPoints[i5];
                String name = resourceWriter.getAttribute("QName");
                QName resourceWriterQName = QNameHelper.createQName(name);
                description = resourceWriter.getAttribute("Description");
                displayName = resourceWriter.getAttribute("DisplayName");
                ResourceWriterProxy resourceWriterProxy = new ResourceWriterProxy(resourceWriterQName, displayName, description);
                resourceWriterProxy.setConfiguartionElement(resourceWriter);
                IPath[] classifications = ClassificationHelper.UNCLASSIFIED_PATH;
                IConfigurationElement[] classificationElements = resourceWriter.getChildren("Classification");
                if (classificationElements != null && classificationElements.length > 0) {
                    classifications = new IPath[classificationElements.length];
                    int j = 0;
                    while (j < classificationElements.length) {
                        String path = classificationElements[j].getValue();
                        if (path != null) {
                            classifications[j] = new Path(path);
                        }
                        ++j;
                    }
                }
                this.registerResourceWriter(resourceWriterProxy, classifications);
                if (LogFacility.trace) {
                    LogFacility.Trace(MessageResource.bind((String)MessageResource.Registry__MSG_LOADED_RESOURCE_WRITER_EXT_PT, (Object)name), (short)10);
                }
            }
            catch (Throwable ex) {
                LogFacility.logErrorMessage(ex.getLocalizedMessage(), ex);
            }
            ++i5;
        }
        IConfigurationElement[] configurationExtensionPoints = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.adapter.framework.Configuration");
        int i6 = 0;
        while (i6 < configurationExtensionPoints.length) {
            try {
                String name;
                IConfigurationElement[] rwConfigElements;
                String name2;
                IConfiguration config;
                ResourceWriter resolvedWriter;
                IConfigurationElement configuration = configurationExtensionPoints[i6];
                String configurationName = configuration.getAttribute("QName");
                QName configurationQName = QNameHelper.createQName(configurationName);
                String resourceWriter = configuration.getAttribute("ResourceWriter");
                QName resourceWriterQName = QNameHelper.createQName(resourceWriter);
                String description3 = configuration.getAttribute("Description");
                String displayName3 = configuration.getAttribute("DisplayName");
                IPath[] classifications = ClassificationHelper.UNCLASSIFIED_PATH;
                IConfigurationElement[] classificationElements = configuration.getChildren("Classification");
                if (classificationElements != null && classificationElements.length > 0) {
                    classifications = new IPath[classificationElements.length];
                    int j = 0;
                    while (j < classificationElements.length) {
                        String path = classificationElements[j].getValue();
                        if (path != null) {
                            classifications[j] = new Path(path);
                        }
                        ++j;
                    }
                }
                if ("Configuration".equals(configuration.getName())) {
                    String discoveryAgent = configuration.getAttribute("DiscoveryAgent");
                    QName discoveryAgentQName = QNameHelper.createQName(discoveryAgent);
                    DiscoveryAgent resolvedAgent = this.getDiscoveryAgent(discoveryAgentQName);
                    resolvedWriter = this.getResourceWriter(resourceWriterQName);
                    config = null;
                    if (resolvedWriter != null && resolvedAgent != null) {
                        config = new ConfigurationImpl(configurationQName, resolvedAgent, resolvedWriter, displayName3, description3);
                    }
                    if (config != null) {
                        IConfigurationElement[] daConfigElements = configuration.getChildren("DiscoveryAgentConfiguration");
                        if (daConfigElements != null) {
                            int j = 0;
                            while (j < daConfigElements.length) {
                                name2 = daConfigElements[j].getAttribute("name");
                                if (name2 != null) {
                                    ((ConfigurationImpl)config).addDiscoveryAgentConfigurationProperty(name2);
                                }
                                ++j;
                            }
                        }
                        if ((rwConfigElements = configuration.getChildren("ResourceWriter")) != null) {
                            int j = 0;
                            while (j < rwConfigElements.length) {
                                name = rwConfigElements[j].getAttribute("name");
                                if (name != null) {
                                    ((ConfigurationImpl)config).addResourceWriterConfigurationProperty(name);
                                }
                                ++j;
                            }
                        }
                        this.registerConfiguration(config, classifications);
                        if (LogFacility.trace) {
                            LogFacility.Trace(MessageResource.bind((String)MessageResource.Registry__MSG_LOADED_CONFIGURATION_EXT_PT, (Object)configuration), (short)10);
                        }
                    } else if (LogFacility.trace) {
                        LogFacility.Trace(MessageResource.bind((String)MessageResource.Registry__MSG_REMOVED_UNRESOLVED_CONFIGURATION, (Object)configuration), (short)10);
                    }
                } else if ("BuildConfiguration".equals(configuration.getName())) {
                    String buildAgent = configuration.getAttribute("BuildAgent");
                    QName buildAgentQName = QNameHelper.createQName(buildAgent);
                    BuildAgent resolvedBuildAgent = this.getBuildAgent(buildAgentQName);
                    resolvedWriter = this.getResourceWriter(resourceWriterQName);
                    config = null;
                    if (resolvedWriter != null && resolvedBuildAgent != null) {
                        config = new BuildConfigurationImpl(configurationQName, resolvedBuildAgent, resolvedWriter, displayName3, description3);
                    }
                    if (config != null) {
                        IConfigurationElement[] baConfigElements = configuration.getChildren("BuildAgentConfiguration");
                        if (baConfigElements != null) {
                            int j = 0;
                            while (j < baConfigElements.length) {
                                name2 = baConfigElements[j].getAttribute("name");
                                if (name2 != null) {
                                    ((BuildConfigurationImpl)config).addBuildAgentConfigurationProperty(name2);
                                }
                                ++j;
                            }
                        }
                        if ((rwConfigElements = configuration.getChildren("ResourceWriter")) != null) {
                            int j = 0;
                            while (j < rwConfigElements.length) {
                                name = rwConfigElements[j].getAttribute("name");
                                if (name != null) {
                                    ((BuildConfigurationImpl)config).addResourceWriterConfigurationProperty(name);
                                }
                                ++j;
                            }
                        }
                        this.registerConfiguration(config, classifications);
                        if (LogFacility.trace) {
                            LogFacility.Trace(MessageResource.bind((String)MessageResource.Registry__MSG_LOADED_CONFIGURATION_EXT_PT, (Object)configuration), (short)10);
                        }
                    } else if (LogFacility.trace) {
                        LogFacility.Trace(MessageResource.bind((String)MessageResource.Registry__MSG_REMOVED_UNRESOLVED_CONFIGURATION, (Object)configuration), (short)10);
                    }
                }
            }
            catch (Throwable ex) {
                LogFacility.logErrorMessage(ex.getLocalizedMessage(), ex);
            }
            ++i6;
        }
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRegistryListener(IRegistryListener listener) {
        Vector vector = this.registryListeners;
        synchronized (vector) {
            this.registryListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRegistryListener(IRegistryListener listener) {
        Vector vector = this.registryListeners;
        synchronized (vector) {
            this.registryListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addContextHandler(IContextHandler contextHandler) {
        Vector vector = this.contextHandlers;
        synchronized (vector) {
            this.contextHandlers.add(contextHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeContextHandler(IContextHandler contextHandler) {
        Vector vector = this.contextHandlers;
        synchronized (vector) {
            this.contextHandlers.remove(contextHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireEvent(RegistryEvent event) {
        block17: {
            if (LogFacility.trace) {
                LogFacility.TrcEntry();
            }
            try {
                Vector targets = null;
                Registry registry = this;
                synchronized (registry) {
                    if (this.registryListeners != null) {
                        targets = (Vector)this.registryListeners.clone();
                    }
                }
                if (targets == null) break block17;
                int i = 0;
                while (i < targets.size()) {
                    block18: {
                        if (LogFacility.trace) {
                            LogFacility.Trace(MessageResource.bind((String)MessageResource.Registry__MSG_NOTIFY_LISTENER, targets.elementAt(i)).toString(), (short)10);
                        }
                        IRegistryListener target = (IRegistryListener)targets.elementAt(i);
                        try {
                            IRegistryObject registryObject;
                            if (event.getRegistryObject() == null) break block18;
                            IRegistryObject iRegistryObject = registryObject = event.getRegistryObject();
                            synchronized (iRegistryObject) {
                                try {
                                    target.registryChanged(event);
                                }
                                catch (Throwable e) {
                                    LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                                }
                            }
                        }
                        catch (Throwable e) {
                            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                        }
                    }
                    ++i;
                }
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            }
        }
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBuildAgent(QName buildAgentName) throws BaseException {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            if (LogFacility.trace) {
                LogFacility.Trace(MessageResource.bind((String)MessageResource.Registry__MSG_REMOVING_BUILD_AGENT, (Object)buildAgentName.toString()), (short)10);
            }
            Map map = this._buildAgentRegistry;
            synchronized (map) {
                if (this._buildAgentRegistry.containsKey(buildAgentName)) {
                    IRegistryObject registryObj = (IRegistryObject)this._buildAgentRegistry.get(buildAgentName);
                    this._buildAgentRegistry.remove(buildAgentName);
                    this.fireEvent(new RegistryEvent(1, 8, registryObj));
                    if (LogFacility.trace) {
                        LogFacility.Trace(MessageResource.bind((String)MessageResource.Registry__MSG_REMOVED_BUILD_AGENT, (Object)buildAgentName.toString()), (short)10);
                    }
                } else if (LogFacility.trace) {
                    LogFacility.Trace(MessageResource.bind((String)MessageResource.Registry__MSG_ERROR_REMOVING_BUILD_AGENT, (Object)buildAgentName.toString()), (short)10);
                }
            }
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            throw BaseException.createException(e.getLocalizedMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void waitForRegistryProcessing() {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        long startTime = System.currentTimeMillis();
        ThreadCount threadCount = Registry.threadCount;
        synchronized (threadCount) {
            while (Registry.threadCount.count() > 0) {
                try {
                    long currentTime = System.currentTimeMillis();
                    if (currentTime - startTime > 120000L) {
                        LogFacility.logErrorMessage("MessageResource.MSG_ERROR__REGISTRY_TIMEOUT", null);
                        return;
                    }
                    if (Registry.threadCount.containsThread(Thread.currentThread().getName())) {
                        Registry.threadCount.removeThread(Thread.currentThread().getName());
                    }
                    Registry.threadCount.wait(100L);
                }
                catch (InterruptedException e) {
                    LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                }
            }
        }
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
    }

    public class BuildAgentProxy
    extends BaseBuildAgent {
        private IConfigurationElement _buildConfiguartionElement;
        private IBuildAgent _buildAgent;

        public BuildAgentProxy(QName name, String description, String displayName) {
            this.setName(name);
            this.setDescription(description);
            this.setDisplayName(displayName);
        }

        void setConfiguartionElement(IConfigurationElement configuartionElement) {
            this._buildConfiguartionElement = configuartionElement;
        }

        public IBuildAgent getBuildAgent() {
            try {
                if (this._buildAgent == null) {
                    this._buildAgent = (IBuildAgent)this._buildConfiguartionElement.createExecutableExtension("class");
                }
            }
            catch (Throwable e) {
                if (e instanceof CoreException) {
                    LogFacility.logErrorMessage(((CoreException)e).getStatus());
                }
                LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            }
            return this._buildAgent;
        }

        @Override
        public String getDescription() {
            try {
                if (this._buildAgent == null) {
                    return super.getDescription();
                }
                return this.getBuildAgent().getDescription();
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
                return null;
            }
        }

        @Override
        public String getDisplayName() {
            try {
                if (this._buildAgent == null) {
                    return super.getDisplayName();
                }
                return this.getBuildAgent().getDisplayName();
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
                return null;
            }
        }

        @Override
        public QName getName() {
            try {
                if (this._buildAgent == null) {
                    return super.getName();
                }
                return this.getBuildAgent().getName();
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
                return null;
            }
        }

        @Override
        public void close() throws BaseException {
            block3: {
                if (LogFacility.trace) {
                    LogFacility.TrcEntry();
                }
                try {
                    this.getBuildAgent().close();
                }
                catch (RuntimeException e) {
                    LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                    if (!LogFacility.trace) break block3;
                    LogFacility.TrcExit();
                }
            }
        }

        @Override
        public String[] getConfiguration() {
            if (LogFacility.trace) {
                LogFacility.TrcEntry();
            }
            try {
                return this.getBuildAgent().getConfiguration();
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
                return null;
            }
        }

        @Override
        public IPropertyGroup getInitializeProperties() throws BaseException {
            if (LogFacility.trace) {
                LogFacility.TrcEntry();
            }
            try {
                return this.getBuildAgent().getInitializeProperties();
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
                return null;
            }
        }

        @Override
        public IServiceBuilder getServiceBuilder(IImportResult result) {
            block5: {
                if (LogFacility.trace) {
                    LogFacility.TrcEntry();
                }
                try {
                    return this.getBuildAgent().getServiceBuilder(result);
                }
                catch (RuntimeException e) {
                    LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                    if (LogFacility.trace) {
                        LogFacility.TrcExit();
                    }
                }
                catch (BaseException e) {
                    LogFacility.logErrorMessage(e.getLocalizedMessage(), (Throwable)((Object)e));
                    if (!LogFacility.trace) break block5;
                    LogFacility.TrcExit();
                }
            }
            return null;
        }

        @Override
        public String[] getSupportedConfiguration() {
            if (LogFacility.trace) {
                LogFacility.TrcEntry();
            }
            try {
                return this.getBuildAgent().getSupportedConfiguration();
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
                return null;
            }
        }

        @Override
        public IImportResult initialize(IEnvironment environment, IPropertyGroup initializeProperties) throws BaseException {
            if (LogFacility.trace) {
                LogFacility.TrcEntry();
            }
            try {
                return this.getBuildAgent().initialize(environment, initializeProperties);
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
                return null;
            }
        }

        @Override
        public void initializeContext(Object[] context) throws BaseException {
            block3: {
                if (LogFacility.trace) {
                    LogFacility.TrcEntry();
                }
                try {
                    this.getBuildAgent().initializeContext(context);
                }
                catch (RuntimeException e) {
                    LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                    if (!LogFacility.trace) break block3;
                    LogFacility.TrcExit();
                }
            }
        }

        @Override
        public IBuildAgent newInstance() throws BaseException {
            if (LogFacility.trace) {
                LogFacility.TrcEntry();
            }
            try {
                return this.getBuildAgent().newInstance();
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
                return null;
            }
        }

        @Override
        public void setConfiguration(String[] capabilities) throws BaseException {
            block3: {
                if (LogFacility.trace) {
                    LogFacility.TrcEntry();
                }
                try {
                    this.getBuildAgent().setConfiguration(capabilities);
                }
                catch (RuntimeException e) {
                    LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                    if (!LogFacility.trace) break block3;
                    LogFacility.TrcExit();
                }
            }
        }
    }

    public class DiscoveryAgentProxy
    extends BaseDiscoveryAgent {
        private IConfigurationElement _configuartionElement;
        private IDiscoveryAgent _discoveryAgent;

        @Override
        public void close() throws BaseException {
            block3: {
                if (LogFacility.trace) {
                    LogFacility.TrcEntry();
                }
                try {
                    this.getDiscoveryAgent().close();
                }
                catch (RuntimeException e) {
                    LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                    if (!LogFacility.trace) break block3;
                    LogFacility.TrcExit();
                }
            }
        }

        @Override
        public IPropertyGroup getInitializeProperties() throws BaseException {
            try {
                return this.getDiscoveryAgent().getInitializeProperties();
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
                return null;
            }
        }

        @Override
        public IDiscoveryAgentMetaData getMetaData() {
            try {
                if (this._discoveryAgent == null) {
                    return super.getMetaData();
                }
                return this.getDiscoveryAgent().getMetaData();
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                return null;
            }
        }

        @Override
        public ISearchTree getSearchTree() throws BaseException {
            try {
                return this.getDiscoveryAgent().getSearchTree();
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                return null;
            }
        }

        @Override
        public void initialize(IEnvironment environment, IPropertyGroup initializeProperties) throws BaseException {
            try {
                this.getDiscoveryAgent().initialize(environment, initializeProperties);
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            }
        }

        @Override
        public IDiscoveryAgent newInstance() throws BaseException {
            try {
                return this.getDiscoveryAgent().newInstance();
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                return null;
            }
        }

        @Override
        public IImportResult performImport(IEnvironment environment, IResultNodeSelection selection) throws BaseException {
            try {
                return this.getDiscoveryAgent().performImport(environment, selection);
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                return null;
            }
        }

        IDiscoveryAgent getDiscoveryAgent() {
            try {
                if (this._discoveryAgent == null) {
                    this._discoveryAgent = (IDiscoveryAgent)this._configuartionElement.createExecutableExtension("class");
                }
            }
            catch (Throwable e) {
                if (e instanceof CoreException) {
                    LogFacility.logErrorMessage(((CoreException)e).getStatus());
                }
                LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            }
            return this._discoveryAgent;
        }

        @Override
        public String[] getSupportedConfiguration() {
            try {
                return this.getDiscoveryAgent().getSupportedConfiguration();
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                return null;
            }
        }

        @Override
        public String[] getConfiguration() {
            try {
                return this.getDiscoveryAgent().getConfiguration();
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                return null;
            }
        }

        @Override
        public void setConfiguration(String[] capabilities) throws BaseException {
            try {
                this.getDiscoveryAgent().setConfiguration(capabilities);
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            }
        }

        @Override
        public void initializeContext(Object[] context) throws BaseException {
            try {
                this.getDiscoveryAgent().initializeContext(context);
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            }
        }

        void setConfiguartionElement(IConfigurationElement configuartionElement) {
            this._configuartionElement = configuartionElement;
        }
    }

    public class ResourceWriterProxy
    extends BaseResourceWriter {
        private IResourceWriter _resourceWriter;
        private IConfigurationElement _configuartionElement;

        public ResourceWriterProxy(QName name, String displayName, String description) {
            super(name, displayName, description);
        }

        @Override
        public IPublishingSet createPublishingSet(IImportResult result) throws BaseException {
            try {
                return this.getResourceWriter().createPublishingSet(result);
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
                return null;
            }
        }

        @Override
        public URI performWrite(IEnvironment environment, IPublishingSet publishingSet) throws BaseException {
            try {
                return this.getResourceWriter().performWrite(environment, publishingSet);
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
                return null;
            }
        }

        @Override
        public String getDescription() {
            try {
                if (this._resourceWriter == null) {
                    return super.getDescription();
                }
                return this.getResourceWriter().getDescription();
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
                return null;
            }
        }

        @Override
        public String getDisplayName() {
            try {
                if (this._resourceWriter == null) {
                    return super.getDisplayName();
                }
                return this.getResourceWriter().getDisplayName();
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
                return null;
            }
        }

        @Override
        public IPropertyGroup getInitializeProperties() throws BaseException {
            try {
                return this.getResourceWriter().getInitializeProperties();
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
                return null;
            }
        }

        @Override
        public QName getName() {
            try {
                if (this._resourceWriter == null) {
                    return super.getName();
                }
                return this.getResourceWriter().getName();
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
                return null;
            }
        }

        @Override
        public void initialize(IEnvironment environment, IPropertyGroup propertyGroup) throws BaseException {
            block2: {
                try {
                    this.getResourceWriter().initialize(environment, propertyGroup);
                }
                catch (RuntimeException e) {
                    LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                    if (!LogFacility.trace) break block2;
                    LogFacility.TrcExit();
                }
            }
        }

        @Override
        public IResourceWriter newInstance() throws BaseException {
            try {
                return this.getResourceWriter().newInstance();
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
                return null;
            }
        }

        @Override
        public void close() throws BaseException {
            block3: {
                if (LogFacility.trace) {
                    LogFacility.TrcEntry();
                }
                try {
                    this.getResourceWriter().close();
                }
                catch (RuntimeException e) {
                    LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                    if (!LogFacility.trace) break block3;
                    LogFacility.TrcExit();
                }
            }
        }

        IResourceWriter getResourceWriter() {
            block6: {
                try {
                    if (this._resourceWriter != null) break block6;
                    try {
                        this._resourceWriter = (IResourceWriter)this._configuartionElement.createExecutableExtension("class");
                    }
                    catch (Throwable e) {
                        if (e instanceof CoreException) {
                            LogFacility.logErrorMessage(((CoreException)e).getStatus());
                            break block6;
                        }
                        LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                    }
                }
                catch (RuntimeException e) {
                    LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                    if (LogFacility.trace) {
                        LogFacility.TrcExit();
                    }
                    return null;
                }
            }
            return this._resourceWriter;
        }

        void setConfiguartionElement(IConfigurationElement configuartionElement) {
            this._configuartionElement = configuartionElement;
        }

        @Override
        public String[] getSupportedConfiguration() {
            try {
                return this.getResourceWriter().getSupportedConfiguration();
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                return null;
            }
        }

        public String[] getConfiguration(String name) {
            try {
                return this.getResourceWriter().getConfiguration();
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                return null;
            }
        }

        @Override
        public void setConfiguration(String[] capabilities) throws BaseException {
            try {
                this.getResourceWriter().setConfiguration(capabilities);
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            }
        }

        @Override
        public void initializeContext(Object[] context) throws BaseException {
            try {
                this.getResourceWriter().initializeContext(context);
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            }
        }
    }

    private static final class ThreadCount {
        private ArrayList threads = new ArrayList();

        private ThreadCount() {
        }

        public void addThread(String threadID) {
            this.threads.add(threadID);
        }

        public void removeThread(String threadID) {
            this.threads.remove(threadID);
        }

        public boolean containsThread(String threadID) {
            return this.threads.contains(threadID);
        }

        public int count() {
            return this.threads.size();
        }
    }
}

