/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.framework.internal.registry;

import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.internal.registry.Classification;
import com.ibm.adapter.framework.internal.registry.ClassificationHelper;
import com.ibm.adapter.framework.internal.registry.IClassifiedObject;
import com.ibm.adapter.framework.persistence.IPersistenceAgent;
import com.ibm.adapter.framework.persistence.ISession;
import com.ibm.adapter.framework.persistence.ISessionSummary;
import com.ibm.adapter.framework.spi.persistence.BasePersistenceAgent;
import com.ibm.propertygroup.IPropertyGroup;
import javax.xml.namespace.QName;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;

public class PersistenceAgentRegObject
extends BasePersistenceAgent
implements IClassifiedObject {
    private Classification[] classificationObjects;
    private IPath[] path_classification;
    private IPersistenceAgent wrappedPersistenceAgent;

    PersistenceAgentRegObject(IPersistenceAgent persistenceAgent, IPath[] classifications) {
        this.wrappedPersistenceAgent = persistenceAgent;
        this.path_classification = classifications;
        this.classificationObjects = ClassificationHelper.createClassification(classifications);
    }

    @Override
    public Classification[] getClassificationObjects() {
        return this.classificationObjects;
    }

    @Override
    public boolean containsClassifier(IPath classifier, boolean exactMatch) {
        if (this.classificationObjects != null) {
            int j = this.classificationObjects.length;
            while (--j >= 0) {
                if (this.classificationObjects[j] == null || !ClassificationHelper.containsClassifier(this.classificationObjects[j], classifier, exactMatch)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public IPath[] getClassification() {
        return this.path_classification;
    }

    @Override
    public void close() throws BaseException {
        this.wrappedPersistenceAgent.close();
    }

    @Override
    public QName getName() {
        return this.wrappedPersistenceAgent.getName();
    }

    @Override
    public IPropertyGroup getQueryProperties() {
        return this.wrappedPersistenceAgent.getQueryProperties();
    }

    @Override
    public IPropertyGroup getSaveProperties() {
        return this.wrappedPersistenceAgent.getSaveProperties();
    }

    @Override
    public void load(ISessionSummary summary) throws BaseException {
        this.wrappedPersistenceAgent.load(summary);
    }

    @Override
    public IPersistenceAgent newInstance() throws BaseException {
        return this.wrappedPersistenceAgent.newInstance();
    }

    @Override
    public ISessionSummary[] query(IPropertyGroup queryProperties) throws BaseException {
        return this.wrappedPersistenceAgent.query(queryProperties);
    }

    @Override
    public ISessionSummary[] resurrectSessionSummary(URI identifier) throws BaseException {
        return this.wrappedPersistenceAgent.resurrectSessionSummary(identifier);
    }

    @Override
    public void save(ISession session, IPropertyGroup saveProperties) throws BaseException {
        this.wrappedPersistenceAgent.save(session, saveProperties);
    }

    @Override
    public void save(ISessionSummary sessionSummary) throws BaseException {
        this.wrappedPersistenceAgent.save(sessionSummary);
    }

    public IPersistenceAgent getWrappedObject() {
        return this.wrappedPersistenceAgent;
    }
}

