/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.framework.internal.registry;

import com.ibm.adapter.framework.IDiscoveryAgent;
import com.ibm.adapter.framework.IResourceWriter;
import com.ibm.adapter.framework.internal.registry.Classification;
import com.ibm.adapter.framework.internal.registry.ClassificationHelper;
import com.ibm.adapter.framework.internal.registry.IClassifiedObject;
import com.ibm.adapter.framework.registry.Configuration;
import com.ibm.adapter.framework.registry.IConfiguration;
import javax.xml.namespace.QName;
import org.eclipse.core.runtime.IPath;

class ConfigurationRegObject
extends Configuration
implements IClassifiedObject {
    private Classification[] classificationObjects;
    private IPath[] path_classification;
    private IConfiguration wrappedConfiguration;

    ConfigurationRegObject(IConfiguration configuration, IPath[] classifications) {
        this.wrappedConfiguration = configuration;
        this.path_classification = classifications;
        this.classificationObjects = ClassificationHelper.createClassification(classifications);
    }

    @Override
    public String getDescription() {
        return this.wrappedConfiguration.getDescription();
    }

    @Override
    public String getDisplayName() {
        return this.wrappedConfiguration.getDisplayName();
    }

    @Override
    public QName getName() {
        return this.wrappedConfiguration.getName();
    }

    @Override
    public IPath[] getClassification() {
        return this.path_classification;
    }

    @Override
    public boolean containsClassifier(IPath classifier, boolean exactMatch) {
        if (this.classificationObjects != null) {
            int j = this.classificationObjects.length;
            while (--j >= 0) {
                if (this.classificationObjects[j] == null || !ClassificationHelper.containsClassifier(this.classificationObjects[j], classifier, exactMatch)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Classification[] getClassificationObjects() {
        return this.classificationObjects;
    }

    @Override
    public IDiscoveryAgent createDiscoveryAgent() {
        return this.wrappedConfiguration.createDiscoveryAgent();
    }

    @Override
    public IResourceWriter createResourceWriter() {
        return this.wrappedConfiguration.createResourceWriter();
    }

    public IConfiguration getWrappedObject() {
        return this.wrappedConfiguration;
    }
}

