/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.framework.internal.registry;

import com.ibm.adapter.framework.internal.LogFacility;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class Concept {
    public static final String UNCLASSIFIED = "UNCLASSIFIED";
    private String identifier;
    private Concept parent;
    private Map children = new HashMap();

    public String getIdentifier() {
        return this.identifier;
    }

    public Concept(String identifier) {
        this.identifier = identifier;
    }

    public Concept[] getChildren() {
        try {
            if (this.children.values() != null) {
                return this.children.values().toArray(new Concept[0]);
            }
            return null;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            return null;
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            return null;
        }
    }

    public Concept getChildConcept(IPath concept) {
        try {
            if (concept != null) {
                String identifier = concept.segment(0);
                Concept child = (Concept)this.children.get(identifier);
                if (child != null) {
                    if (concept.segmentCount() == 1) {
                        return child;
                    }
                    return child.getChildConcept(concept.removeFirstSegments(1));
                }
                return null;
            }
            return null;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            return null;
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            return null;
        }
    }

    public void addChildConcept(Concept concept) {
        try {
            Concept child = (Concept)this.children.get(concept.getIdentifier());
            if (child == null) {
                this.children.put(concept.getIdentifier(), concept);
                concept.setParentConcept(this);
            } else {
                Concept[] children = concept.getChildren();
                int i = children.length;
                while (--i >= 0) {
                    child.addChildConcept(children[i]);
                }
            }
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
        }
    }

    public void removeChildConcept(IPath concept) {
        try {
            Concept child = this.getChildConcept(concept);
            if (child != null && child.getParentConcept() != null) {
                child.getParentConcept().removeChildConcept(child.getIdentifier());
            }
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
        }
    }

    private void removeChildConcept(String identifier) {
        try {
            this.children.remove(identifier);
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
        }
    }

    public IPath getPath() {
        try {
            Path path = new Path(this.getIdentifier());
            if (this.parent != null) {
                path = this.parent.getPath().append((IPath)path);
            }
            return path;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            return null;
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            return null;
        }
    }

    public Concept getParentConcept() {
        return this.parent;
    }

    private void setParentConcept(Concept parent) {
        this.parent = parent;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Concept)) {
            return false;
        }
        Concept tmpConcept = (Concept)obj;
        if (this.identifier == null ^ tmpConcept.identifier == null) {
            return false;
        }
        if (this.identifier != null && !this.identifier.equals(tmpConcept.identifier)) {
            return false;
        }
        if (this.parent == null ^ tmpConcept.parent == null) {
            return false;
        }
        if (this.parent != null && !this.parent.equals(tmpConcept.parent)) {
            return false;
        }
        if (this.children == null ^ tmpConcept.children == null) {
            return false;
        }
        return this.children == null || this.children.equals(tmpConcept.children);
    }
}

