/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.framework.internal.registry;

import com.ibm.adapter.framework.internal.LogFacility;
import com.ibm.adapter.framework.internal.registry.Concept;
import org.eclipse.core.runtime.IPath;

public class Classification {
    public static final Classification UNCLASSIFIED = new Classification(new Concept("UNCLASSIFIED"));
    private Concept concept;

    public Classification(Concept concept) {
        this.concept = concept;
    }

    public Concept getConcept() {
        return this.concept;
    }

    public boolean containsConcept(IPath conceptPath) {
        block4: {
            block5: {
                block6: {
                    if (conceptPath == null || conceptPath.segmentCount() <= 0) break block4;
                    String identifier = conceptPath.segment(0);
                    if (!identifier.equals(this.concept.getIdentifier())) break block5;
                    if (conceptPath.segmentCount() != 1) break block6;
                    return true;
                }
                try {
                    IPath childPath = conceptPath.removeFirstSegments(1);
                    Concept childConcept = this.concept.getChildConcept(childPath);
                    return childConcept != null;
                }
                catch (RuntimeException e) {
                    LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                    return false;
                }
                catch (Throwable e) {
                    LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                    return false;
                }
            }
            return false;
        }
        return false;
    }

    public IPath getPath() {
        try {
            if (this.concept != null) {
                return this.concept.getPath();
            }
            return UNCLASSIFIED.getPath();
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            return null;
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Classification)) {
            return false;
        }
        Classification tmpClass = (Classification)obj;
        if (this.concept == null ^ tmpClass.concept == null) {
            return false;
        }
        return this.concept == null || this.concept.equals(tmpClass.concept);
    }

    public Concept getChildConcept(IPath concept) {
        try {
            if (concept != null) {
                String identifier = concept.segment(0);
                if (this.getConcept().getIdentifier().equals(identifier)) {
                    if (concept.segmentCount() == 1) {
                        return this.getConcept();
                    }
                    return this.getConcept().getChildConcept(concept.removeFirstSegments(1));
                }
                return null;
            }
            return null;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            return null;
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            return null;
        }
    }
}

