/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.asi.internal;

import com.ibm.adapter.asi.internal.ASIPlugin;
import java.io.File;
import java.util.Calendar;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.XMLFormatter;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public abstract class AbstractLogFacility {
    public static final short ERROR = 60;
    public static final short WARNING = 30;
    public static final short INFO = 10;
    public static final boolean debug;
    public static final ILog logger;
    public static final Logger traceLogger;
    public static final String lineSeparator;
    private static final String logFileName = ".log";
    private static String logFileDirectoryName;
    private static final String EMPTY_STRING = "";
    private static final String SPACED_STRING = " ";
    private static final String BEGIN_COMMENT = "-->";
    private static final String END_COMMENT = "<--";
    private static FileHandler loggingFileHandler;
    private static String logFile;
    private static final ThreadLocal sequenceNumber;

    static {
        lineSeparator = System.getProperty("line.separator", "\n");
        sequenceNumber = new ThreadLocal();
        logger = ASIPlugin.getDefault().getLog();
        debug = ASIPlugin.getDefault().isDebugging();
        if (debug) {
            IProduct product = Platform.getProduct();
            if (product != null) {
                IPath path = Platform.getStateLocation((Bundle)ASIPlugin.getDefault().getBundle());
                logFileDirectoryName = path.toOSString();
                File logDirectory = new File(logFileDirectoryName);
                if (!logDirectory.exists()) {
                    logDirectory.mkdirs();
                }
                logFile = String.valueOf(logFileDirectoryName) + File.separator + logFileName;
                traceLogger = Logger.getLogger("com.ibm.adapter.asi");
                Handler[] handlers = traceLogger.getHandlers();
                if (handlers != null) {
                    int i = handlers.length;
                    while (--i >= 0) {
                        traceLogger.removeHandler(handlers[i]);
                    }
                }
                traceLogger.setUseParentHandlers(false);
                traceLogger.setLevel(Level.ALL);
                try {
                    loggingFileHandler = new FileHandler(logFile, true);
                    loggingFileHandler.setFormatter(new XMLFormatter());
                    loggingFileHandler.setLevel(Level.ALL);
                    traceLogger.addHandler(loggingFileHandler);
                }
                catch (Throwable e) {
                    logger.log((IStatus)new Status(4, "com.ibm.adapter.asi", 4, e.getLocalizedMessage() == null ? EMPTY_STRING : e.getLocalizedMessage(), e));
                }
            } else {
                traceLogger = null;
            }
        } else {
            traceLogger = null;
        }
    }

    public static final void closeLogFiles() {
        try {
            if (loggingFileHandler != null) {
                loggingFileHandler.close();
                File logFile = new File(String.valueOf(logFileDirectoryName) + File.separator + logFileName);
                if (logFile.exists()) {
                    logFile.renameTo(new File(String.valueOf(logFileDirectoryName) + File.separator + Calendar.getInstance().getTime().getTime() + logFileName));
                }
            }
        }
        catch (Throwable throwable) {}
    }

    public static final void logErrorMessage(IStatus status) {
        if (logger != null) {
            logger.log(status);
        }
        if (traceLogger != null) {
            Exception e = new Exception();
            StackTraceElement[] stack = e.getStackTrace();
            LogRecord logRec = AbstractLogFacility.createLogRecord(stack[1], status.getMessage(), Level.SEVERE);
            if (status.getException() != null) {
                logRec.setThrown(status.getException());
            }
            traceLogger.log(logRec);
        }
    }

    public static final void logErrorMessage(String message, Throwable exception) {
        Throwable e = null;
        if (logger != null) {
            if (message != null) {
                logger.log((IStatus)new Status(4, "com.ibm.adapter.asi", 4, message, exception));
            } else if (exception != null) {
                if (exception.getMessage() != null) {
                    logger.log((IStatus)new Status(4, "com.ibm.adapter.asi", 4, exception.getMessage(), exception));
                } else {
                    logger.log((IStatus)new Status(4, "com.ibm.adapter.asi", 4, EMPTY_STRING, exception));
                }
            }
        }
        if (traceLogger != null) {
            if (e == null) {
                e = new Exception();
            }
            StackTraceElement[] stack = e.getStackTrace();
            LogRecord logRec = AbstractLogFacility.createLogRecord(stack[1], message, Level.SEVERE);
            if (exception != null) {
                logRec.setThrown(exception);
            }
            traceLogger.log(logRec);
        }
    }

    public static final void logInfoMessage(IStatus status) {
        Throwable e = null;
        if (logger != null) {
            logger.log(status);
        }
        if (traceLogger != null) {
            if (e == null) {
                e = new Exception();
            }
            StackTraceElement[] stack = e.getStackTrace();
            LogRecord logRec = AbstractLogFacility.createLogRecord(stack[1], status.getMessage(), Level.INFO);
            if (status.getException() != null) {
                logRec.setThrown(status.getException());
            }
            traceLogger.log(logRec);
        }
    }

    public static final void logInfoMessage(String message) {
        Throwable e = null;
        if (logger != null && message != null) {
            logger.log((IStatus)new Status(1, "com.ibm.adapter.asi", 0, message, null));
        }
        if (traceLogger != null) {
            if (e == null) {
                e = new Exception();
            }
            StackTraceElement[] stack = e.getStackTrace();
            LogRecord logRec = AbstractLogFacility.createLogRecord(stack[1], message, Level.INFO);
            traceLogger.log(logRec);
        }
    }

    public static final void Trace(String message, short severity) {
        if (traceLogger != null) {
            Throwable e = new Throwable();
            StackTraceElement[] stack = e.getStackTrace();
            Level level = Level.FINEST;
            switch (severity) {
                case 60: {
                    level = Level.SEVERE;
                    break;
                }
                case 30: {
                    level = Level.WARNING;
                    break;
                }
                case 10: {
                    level = Level.INFO;
                    break;
                }
                default: {
                    level = Level.FINEST;
                }
            }
            LogRecord logRec = AbstractLogFacility.createLogRecord(stack[1], message, level);
            traceLogger.log(logRec);
        }
    }

    public static final void TrcEntry() {
        if (traceLogger != null) {
            Exception e = new Exception();
            StackTraceElement[] stack = e.getStackTrace();
            String message = new StringBuffer("-->METHOD ENTRY: ").append(stack[1].getMethodName()).toString();
            LogRecord logRec = AbstractLogFacility.createLogRecord(stack[1], message, Level.INFO);
            traceLogger.log(logRec);
        }
    }

    public static final void TrcExit() {
        if (traceLogger != null) {
            Throwable e = new Throwable();
            StackTraceElement[] stack = e.getStackTrace();
            String message = new StringBuffer("<--METHOD EXIT: ").append(stack[1].getMethodName()).toString();
            LogRecord logRec = AbstractLogFacility.createLogRecord(stack[1], message, Level.INFO);
            traceLogger.log(logRec);
        }
    }

    private static final LogRecord createLogRecord(StackTraceElement stackElement, String message, Level level) {
        if (message != null) {
            message = message.replaceAll("<", "&lt;");
            message = message.replaceAll("\"", "&quot;");
        }
        LogRecord logRec = new LogRecord(level, message);
        Integer sequence = (Integer)sequenceNumber.get();
        int i = 0;
        if (sequence == null) {
            sequenceNumber.set(new Integer(i));
        } else {
            i = sequence;
            sequenceNumber.set(new Integer(++i));
        }
        logRec.setSequenceNumber(i);
        logRec.setMillis(System.currentTimeMillis());
        logRec.setThreadID((int)Thread.currentThread().getId());
        String application = new StringBuffer().append(stackElement.getClassName()).append(".").append(stackElement.getMethodName()).append("(").append(stackElement.getFileName()).append(":").append(stackElement.getLineNumber()).append(")").toString();
        application = application.replaceAll("<", "&lt;");
        logRec.setSourceClassName(stackElement.getClassName());
        logRec.setSourceMethodName(application);
        return logRec;
    }

    public static String getLogFile() {
        return logFile;
    }
}

