/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.wizards.pages;

import com.ibm.zosconnect.ui.common.exceptions.ZosConnectInvalidInputException;
import com.ibm.zosconnect.ui.common.util.SWTResourceManager;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.common.util.swt.VerifyListener2;
import com.ibm.zosconnect.ui.common.util.xml.Xml10Validator;
import com.ibm.zosconnect.ui.common.validation.PosixPortableValidator;
import com.ibm.zosconnect.ui.util.PathValidator;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class NewApiProjectPage
extends WizardPage {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Text txtApiName;
    private Text txtApiProjectName;
    private Text txtApiDescription;
    private StyledText txtApiBasePath;
    private boolean userChangedApiName = false;
    private boolean userChangedApiBasePath = false;

    public NewApiProjectPage() {
        super("NewApiProjectPage");
        this.setTitle(Xlat.label((String)"NEWAPI_WIZARD_TITLE"));
        this.setDescription(Xlat.description((String)"NEWAPI_WIZARD_DESC"));
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        GridLayout gl_container = new GridLayout(1, false);
        container.setLayout((Layout)gl_container);
        Composite compApiProperties = new Composite(container, 0);
        compApiProperties.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        GridLayout gl_compApiProperties = new GridLayout(1, false);
        gl_compApiProperties.marginWidth = 0;
        compApiProperties.setLayout((Layout)gl_compApiProperties);
        Label lblApiProjectName = new Label(compApiProperties, 0);
        lblApiProjectName.setFont(SWTResourceManager.getFont((String)"Segoe UI Semibold", (int)9, (int)0));
        GridData gd_lblApiProjectName = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblApiProjectName.verticalIndent = 5;
        lblApiProjectName.setLayoutData((Object)gd_lblApiProjectName);
        lblApiProjectName.setText(Xlat.label((String)"NEWAPI_LABEL_PROJECT_NAME") + Xlat.colon());
        this.txtApiProjectName = new Text(compApiProperties, 2048);
        GridData gd_txtApiProjectName = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txtApiProjectName.widthHint = 425;
        this.txtApiProjectName.setLayoutData((Object)gd_txtApiProjectName);
        this.txtApiProjectName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                String newApiName = StringUtils.lowerCase((String)StringUtils.replacePattern((String)XSwt.getTrimText((Text)NewApiProjectPage.this.txtApiProjectName), (String)"\\s+", (String)"-"));
                if (!NewApiProjectPage.this.userChangedApiName) {
                    XSwt.setText((Text)NewApiProjectPage.this.txtApiName, (String)newApiName);
                }
                if (!NewApiProjectPage.this.userChangedApiBasePath) {
                    Object newBasePath = newApiName;
                    if (!((String)newBasePath).startsWith("/")) {
                        newBasePath = "/" + (String)newBasePath;
                    }
                    NewApiProjectPage.this.txtApiBasePath.setText((String)newBasePath);
                }
                NewApiProjectPage.this.validatePage();
            }
        });
        this.txtApiProjectName.setFocus();
        this.txtApiProjectName.setToolTipText(Xlat.description((String)"API_PROJECT_NAME_TOOLTIP"));
        this.txtApiProjectName.addVerifyListener((VerifyListener)new VerifyListener2((Control)compApiProperties){

            public void verifyText(VerifyEvent event, Control owner) throws Exception {
                event.text = Xml10Validator.removeInvalidChar((String)event.text, (boolean)true);
            }
        });
        Label lblApiName = new Label(compApiProperties, 0);
        lblApiName.setFont(SWTResourceManager.getFont((String)"Segoe UI Semibold", (int)9, (int)0));
        lblApiName.setText(Xlat.label((String)"APIEDIT_LABEL_TITLE") + Xlat.colon());
        this.txtApiName = new Text(compApiProperties, 2048);
        GridData gd_txtApiName = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txtApiName.widthHint = 425;
        this.txtApiName.setLayoutData((Object)gd_txtApiName);
        this.txtApiName.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                NewApiProjectPage.this.userChangedApiName = true;
                NewApiProjectPage.this.validatePage();
            }
        });
        this.txtApiName.setToolTipText(Xlat.description((String)"API_NAME_TOOLTIP"));
        this.txtApiName.addVerifyListener((VerifyListener)new VerifyListener2((Control)compApiProperties){

            public void verifyText(VerifyEvent event, Control owner) throws Exception {
                event.text = Xml10Validator.removeInvalidChar((String)event.text, (boolean)true);
            }
        });
        Label lblApiBasePath = new Label(compApiProperties, 0);
        lblApiBasePath.setText(Xlat.label((String)"APIEDIT_LABEL_BASE_PATH") + Xlat.colon());
        lblApiBasePath.setFont(SWTResourceManager.getFont((String)"Segoe UI Semibold", (int)9, (int)0));
        this.txtApiBasePath = new StyledText(compApiProperties, 2052);
        this.txtApiBasePath.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtApiBasePath.setText("/NewAPI");
        this.txtApiBasePath.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                NewApiProjectPage.this.userChangedApiBasePath = true;
                NewApiProjectPage.this.validatePage();
            }
        });
        this.txtApiBasePath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                NewApiProjectPage.this.validatePage();
            }
        });
        XSwt.addTabTraverseListener((Control)this.txtApiBasePath);
        this.txtApiBasePath.setToolTipText(Xlat.description((String)"API_BASE_PATH_TOOLTIP"));
        this.txtApiBasePath.addVerifyListener((VerifyListener)new VerifyListener2((Control)compApiProperties){

            public void verifyText(VerifyEvent event, Control owner) throws Exception {
                event.text = Xml10Validator.removeInvalidChar((String)event.text, (boolean)true);
            }
        });
        Label lblApiDescription = new Label(container, 0);
        lblApiDescription.setFont(SWTResourceManager.getFont((String)"Segoe UI Semibold", (int)9, (int)0));
        GridData gd_lblApiDescription = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblApiDescription.verticalIndent = 5;
        lblApiDescription.setLayoutData((Object)gd_lblApiDescription);
        lblApiDescription.setText(Xlat.label((String)"APIEDIT_LABEL_DESCRIPTION") + Xlat.colon());
        this.txtApiDescription = new Text(container, 2626);
        GridData gd_txtApiDescription = new GridData(4, 4, true, true, 1, 1);
        gd_txtApiDescription.widthHint = 425;
        gd_txtApiDescription.heightHint = 125;
        this.txtApiDescription.setLayoutData((Object)gd_txtApiDescription);
        XSwt.addTabTraverseListener((Control)this.txtApiDescription);
        this.txtApiDescription.addVerifyListener((VerifyListener)new VerifyListener2((Control)container){

            public void verifyText(VerifyEvent event, Control owner) throws Exception {
                event.text = Xml10Validator.removeInvalidChar((String)event.text, (boolean)false);
            }
        });
        this.validatePage();
        this.setPageComplete(false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, "com.ibm.zosconnect.ui.newprojectwizard");
    }

    private void validatePage() {
        try {
            PathValidator.validateHighlightBasePathSyntax(this.txtApiBasePath);
            this.validateProjectName(this.getApiProjectName());
            this.validateApiName(this.getApiTitle());
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
        catch (ZosConnectInvalidInputException e) {
            this.setErrorMessage(e.getMessage());
            this.setPageComplete(false);
        }
    }

    private void validateProjectName(String projName) throws ZosConnectInvalidInputException {
        if ((projName = projName.trim()) != null && !projName.isEmpty()) {
            IStatus nameStatus = ResourcesPlugin.getWorkspace().validateName(projName, 4);
            if (!nameStatus.isOK()) {
                throw new ZosConnectInvalidInputException(nameStatus.getMessage());
            }
            IProject handle = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
            if (handle.exists()) {
                throw new ZosConnectInvalidInputException(Xlat.error((String)"EXIST_PROJ_NAME_ERROR"));
            }
        } else {
            throw new ZosConnectInvalidInputException(Xlat.error((String)"EMPTY_PROJ_NAME_ERROR"));
        }
        if (!this.userChangedApiName && projName.contains(" ")) {
            this.setMessage(Xlat.error((String)"API_REPLACE_SPACES_WARNING"), 2);
        } else {
            this.setMessage(null);
        }
    }

    private void validateApiName(String apiName) throws ZosConnectInvalidInputException {
        if (StringUtils.isBlank((CharSequence)apiName)) {
            throw new ZosConnectInvalidInputException(Xlat.error((String)"EMPTY_API_NAME_ERROR"));
        }
        String posixErr = PosixPortableValidator.validate((String)apiName, (PosixPortableValidator.MessageInsertType)PosixPortableValidator.MessageInsertType.API);
        if (posixErr != null) {
            throw new ZosConnectInvalidInputException(posixErr);
        }
    }

    public String getApiTitle() {
        return XSwt.getTrimText((Text)this.txtApiName);
    }

    public String getApiBasePath() {
        return XSwt.getTrimText((StyledText)this.txtApiBasePath);
    }

    public String getApiProjectName() {
        return XSwt.getTrimText((Text)this.txtApiProjectName);
    }

    public String getApiDescription() {
        return XSwt.getTrimText((Text)this.txtApiDescription);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.txtApiProjectName.setFocus();
        }
        super.setVisible(visible);
    }
}

