/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.wizards;

import com.ibm.zosconnect.api.ZosConnectApi;
import com.ibm.zosconnect.ui.common.logger.ZCeeErrorDialog;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.controllers.api.ApiModelController;
import com.ibm.zosconnect.ui.controllers.api.ApiProjectController;
import com.ibm.zosconnect.ui.controllers.api.OpenApi2xController;
import com.ibm.zosconnect.ui.controllers.visitors.OpenApi2xVisitor;
import com.ibm.zosconnect.ui.wizards.pages.NewApiProjectPage;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class NewApiProjectWizard
extends BasicNewProjectResourceWizard {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private NewApiProjectPage page1;

    public NewApiProjectWizard() {
        this.setWindowTitle("New z/OS Connect API");
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page1 = new NewApiProjectPage();
        this.addPage((IWizardPage)this.page1);
    }

    public boolean performFinish() {
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)new WorkspaceModifyOperation(){

                public void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        ApiProjectController apiProjectController = ApiProjectController.createNewApiProject((String)NewApiProjectWizard.this.page1.getApiProjectName());
                        IProject apiProject = apiProjectController.getProject();
                        ZosConnectApi newApi = ApiModelController.createNewApi((String)NewApiProjectWizard.this.page1.getApiTitle(), (String)NewApiProjectWizard.this.page1.getApiBasePath(), (String)NewApiProjectWizard.this.page1.getApiDescription());
                        ApiModelController apiModelController = new ApiModelController(newApi, apiProjectController);
                        IFile newApiFile = apiProject.getFile("package.xml");
                        apiModelController.marshall(newApiFile, monitor);
                        apiProjectController.setApiModelController(apiModelController);
                        OpenApi2xController apiDocsController = new OpenApi2xController(apiProjectController, apiModelController);
                        apiDocsController.generateSwagger(new OpenApi2xVisitor());
                        IWorkbench workbench = PlatformUI.getWorkbench();
                        IEditorRegistry editorRegistry = workbench.getEditorRegistry();
                        IEditorDescriptor editorDescriptor = editorRegistry.findEditor("com.ibm.zosconnect.ui.apieditor");
                        if (editorDescriptor == null) {
                            editorDescriptor = editorRegistry.getDefaultEditor(newApiFile.getName());
                        }
                        IWorkbenchPage workbenchPage = workbench.getActiveWorkbenchWindow().getActivePage();
                        workbenchPage.openEditor((IEditorInput)new FileEditorInput(newApiFile), editorDescriptor.getId());
                        IViewPart view = workbenchPage.findView("org.eclipse.ui.navigator.ProjectExplorer");
                        if (view == null) {
                            view = workbenchPage.showView("org.eclipse.ui.navigator.ProjectExplorer");
                        }
                        ((ISetSelectionTarget)view).selectReveal((ISelection)new StructuredSelection((Object)newApiFile));
                    }
                    catch (Exception e) {
                        ZCeeUILogger.error((String)e.getMessage(), (Throwable)e, (Object[])new Object[0]);
                        ZCeeErrorDialog.openError((Exception)e);
                    }
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            ZCeeUILogger.error((Throwable)e);
            ZCeeErrorDialog.openError((Exception)e);
        }
        return true;
    }
}

