/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.validation;

import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.common.validation.ApiProjectValidationError;
import com.ibm.zosconnect.ui.common.validation.IApiCapabilitiesValidator;
import com.ibm.zosconnect.ui.controllers.api.ApiCapabilityValidatorExtension;
import com.ibm.zosconnect.ui.controllers.api.ApiProjectController;
import com.ibm.zosconnect.ui.programinterface.controllers.model.utilities.ProjectTreeFileHelper;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class ApiProjectValidator {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2018. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final String className = this.getClass().getName();
    private static final String CAPABILITIES_FILE = ".capabilities";
    private IProject project;
    private ApiProjectController apiProjectController;
    private List<ApiProjectValidationError> errors;
    private static final String NL = System.getProperty("line.separator");

    public ApiProjectValidator(IProject project, ApiProjectController apiProjectController) {
        this.project = project;
        this.apiProjectController = apiProjectController;
    }

    public List<ApiProjectValidationError> validateCapabilitiesFile() throws CoreException, IOException {
        String methodName = "validateCapabilitiesFile";
        ZCeeUILogger.entering((String)this.className, (String)"validateCapabilitiesFile", (Object[])new Object[0]);
        this.resetErrors();
        HashSet<String> allCapabilities = this.getApiExtensionCapabilities();
        Properties properties = ProjectTreeFileHelper.getProjectCapabilities((IProject)this.project);
        if (properties != null) {
            Enumeration<?> capabilities = properties.propertyNames();
            while (capabilities.hasMoreElements()) {
                String currCapabilityStr = (String)capabilities.nextElement();
                if (allCapabilities.contains(currCapabilityStr)) continue;
                this.addErrorIfFound(new ApiProjectValidationError((IResource)this.project, Xlat.error((String)"UNKNOWN_CAPABILITY", (String[])new String[]{currCapabilityStr}), true));
            }
        }
        ZCeeUILogger.exiting((String)this.className, (String)"validateCapabilitiesFile", (Object[])new Object[0]);
        return this.errors;
    }

    private HashSet<String> getApiExtensionCapabilities() {
        String methodName = "getApiExtensionCapabilities";
        ZCeeUILogger.entering((String)this.className, (String)"getApiExtensionCapabilities", (Object[])new Object[0]);
        HashSet<String> allCapabilities = new HashSet<String>();
        ApiCapabilityValidatorExtension capabilityValidatorExtension = this.apiProjectController.getApiCapabilityExtension().capabilityExtensionValidator();
        if (capabilityValidatorExtension != null) {
            String idPrefix = capabilityValidatorExtension.getId();
            String capabilitiesStr = capabilityValidatorExtension.getSupportedCapabilities();
            String[] capArray = capabilitiesStr.split("\\s*,\\s*");
            int i = 0;
            while (i < capArray.length) {
                allCapabilities.add(idPrefix + "." + capArray[i]);
                ++i;
            }
        }
        ZCeeUILogger.exiting((String)this.className, (String)"getApiExtensionCapabilities", (Object[])new Object[0]);
        return allCapabilities;
    }

    public void updateProjectCapabilities() throws CoreException, IOException {
        String methodName = "updateProjectCapabilities";
        ZCeeUILogger.entering((String)this.className, (String)"updateProjectCapabilities", (Object[])new Object[0]);
        ArrayList projectCapabilities = new ArrayList();
        ApiCapabilityValidatorExtension capabilityValidatorExtension = this.apiProjectController.getApiCapabilityExtension().capabilityExtensionValidator();
        if (capabilityValidatorExtension != null) {
            IFile capabilitiesFile;
            IApiCapabilitiesValidator capabilityValidator = capabilityValidatorExtension.getValidatorClass();
            ArrayList usedCapabilities = capabilityValidator.getExploitedCapabilityList(this.project);
            if (usedCapabilities != null && !usedCapabilities.isEmpty()) {
                projectCapabilities.addAll(usedCapabilities);
            }
            if ((capabilitiesFile = this.project.getFile(CAPABILITIES_FILE)).exists()) {
                capabilitiesFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
            if (!projectCapabilities.isEmpty()) {
                this.apiProjectController.createFileInProject(CAPABILITIES_FILE);
                ZCeeUILogger.info((String)"Writing capabilities to file {0}", (Object[])new Object[]{capabilitiesFile.getName()});
                FileWriter writer = new FileWriter(capabilitiesFile.getLocation().toFile());
                for (String str : projectCapabilities) {
                    writer.write(StringUtils.appendIfMissing((String)str, (CharSequence)NL, (CharSequence[])new CharSequence[0]));
                }
                writer.close();
            }
        }
        ZCeeUILogger.exiting((String)this.className, (String)"updateProjectCapabilities", (Object[])new Object[0]);
    }

    private void resetErrors() {
        String methodName = "resetErrors";
        ZCeeUILogger.entering((String)this.className, (String)"resetErrors", (Object[])new Object[0]);
        this.errors = new ArrayList<ApiProjectValidationError>();
        ZCeeUILogger.exiting((String)this.className, (String)"resetErrors", (Object[])new Object[0]);
    }

    private boolean addErrorIfFound(ApiProjectValidationError apiProjectValidationError) {
        if (apiProjectValidationError != null) {
            this.errors.add(apiProjectValidationError);
            return true;
        }
        return false;
    }
}

