/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.validation;

import com.ibm.zosconnect.api.mapping.service.ResponseMessageType;
import com.ibm.zosconnect.ui.builder.ApiProjectBuilderModel;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.validation.IApiCapabilitiesValidator;
import com.ibm.zosconnect.ui.controllers.api.ApiModelController;
import com.ibm.zosconnect.ui.controllers.api.ApiProjectController;
import com.ibm.zosconnect.ui.controllers.api.ServiceArchiveController;
import com.ibm.zosconnect.ui.controllers.api.ServiceMappingController;
import io.swagger.models.Model;
import io.swagger.models.properties.Property;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.core.resources.IProject;

public class ApiCapabilitiesValidator
implements IApiCapabilitiesValidator {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2018. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String VALIDATOR_ID = "ibm.apis.";
    public static final String MULTIPLE_RESPONSE_CODES = "ibm.apis.multipleResponseCodes";
    public static final String CONTACT_INFO = "ibm.apis.contactInfo";
    public static final String FORMAT_DATE = "ibm.apis.formatDate";
    private static final String STRING = "string";
    private static final String DATE = "date";

    public ArrayList<String> getExploitedCapabilityList(IProject project) {
        ArrayList<String> usedCapabilities = new ArrayList<String>();
        try {
            ApiProjectBuilderModel model = new ApiProjectBuilderModel(project);
            if (this.usesMultipleResponseCodes(model)) {
                usedCapabilities.add(MULTIPLE_RESPONSE_CODES);
            }
            if (this.usesContactInfo(model)) {
                usedCapabilities.add(CONTACT_INFO);
            }
            if (this.usesFormatDate(model)) {
                usedCapabilities.add(FORMAT_DATE);
            }
        }
        catch (Exception e) {
            ZCeeUILogger.error((Throwable)e);
        }
        return usedCapabilities;
    }

    private boolean usesFormatDate(ApiProjectBuilderModel model) throws Exception {
        ApiProjectController apiProjectController = model.getApiProjectController();
        for (ServiceMappingController servMapCtrl : apiProjectController.getAllServiceMappingControllers()) {
            ServiceArchiveController srvArchCtrl = servMapCtrl.getServiceArchiveController();
            if (srvArchCtrl == null) continue;
            Model schemaModel = srvArchCtrl.getRequestSchemaModel();
            int i = 0;
            while (i < 2) {
                if (schemaModel != null) {
                    LinkedHashMap leafProperties = ServiceArchiveController.getLeafProperties((Model)schemaModel);
                    for (Property currProp : leafProperties.values()) {
                        if (currProp.getType() == null || currProp.getFormat() == null || !currProp.getType().equals(STRING) || !currProp.getFormat().equals(DATE)) continue;
                        return true;
                    }
                }
                schemaModel = srvArchCtrl.getResponseSchemaModel();
                ++i;
            }
        }
        return false;
    }

    private boolean usesContactInfo(ApiProjectBuilderModel model) throws Exception {
        ApiModelController modelController = model.getApiModelController();
        if (modelController.getContactName() != null && !modelController.getContactName().isEmpty()) {
            return true;
        }
        if (modelController.getContactURL() != null && !modelController.getContactURL().isEmpty()) {
            return true;
        }
        return modelController.getContactEmail() != null && !modelController.getContactEmail().isEmpty();
    }

    private boolean usesMultipleResponseCodes(ApiProjectBuilderModel model) throws Exception {
        for (ServiceMappingController servMapCtrl : model.getApiProjectController().getAllServiceMappingControllers()) {
            List responseMessages = servMapCtrl.getResponseMessages();
            if (responseMessages != null && responseMessages.size() > 1) {
                return true;
            }
            if (responseMessages.size() != 1 || 200 == ((ResponseMessageType)responseMessages.get(0)).getCode()) continue;
            return true;
        }
        return false;
    }
}

